/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.attach.panels.components;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListDataListener;
import org.netbeans.modules.profiler.api.JavaPlatform;
import org.netbeans.modules.profiler.attach.panels.components.ResizableHintPanel;
import org.netbeans.modules.profiler.attach.providers.TargetPlatform;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class JavaPlatformPanelComponent
extends JPanel {
    private final String NO_SUPPORTED_JVM_MSG = NbBundle.getMessage(JavaPlatformPanelComponent.class, (String)"JavaPlatformPanelComponent_NoSupportedJvmFoundString");
    public static final String JAVA_PLATFORM_PROPERTY = "jvmPlatform";
    private final TargetPlatform.TargetPlatformFilter defaultPlatformFilter;
    private TargetPlatform.TargetPlatformFilter platformFilter = this.defaultPlatformFilter = new TargetPlatform.TargetPlatformFilter(){

        @Override
        public boolean isSupported(TargetPlatform targetPlatform) {
            return true;
        }
    };
    private TargetPlatform selectedPlatform = null;
    private List lastPlatformList = new Vector();
    private JvmComboBoxModel jvmModel = new JvmComboBoxModelProxy();
    private final JvmComboBoxModel emptyModel = new JvmComboBoxModelEmpty();
    private JButton buttonManage;
    private JComboBox comboJvm;
    private ResizableHintPanel hintPanel;
    private JPanel jPanel1;

    public JavaPlatformPanelComponent() {
        this.initComponents();
    }

    private void initComponents() {
        this.hintPanel = new ResizableHintPanel();
        this.jPanel1 = new JPanel();
        this.comboJvm = new JComboBox();
        this.buttonManage = new JButton();
        ResourceBundle resourceBundle = ResourceBundle.getBundle("org/netbeans/modules/profiler/attach/panels/components/Bundle");
        this.setBorder(BorderFactory.createTitledBorder(null, resourceBundle.getString("SELECT_PLATFORM"), 0, 0, UIManager.getFont("TitledBorder.font").deriveFont(1)));
        this.hintPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.hintPanel.setForeground(UIManager.getDefaults().getColor("TextField.inactiveForeground"));
        this.hintPanel.setHint(NbBundle.getMessage(JavaPlatformPanelComponent.class, (String)"PLATFORMS_HINT"));
        this.jPanel1.setLayout(new GridBagLayout());
        this.comboJvm.setModel(this.jvmModel);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.7;
        this.jPanel1.add((Component)this.comboJvm, gridBagConstraints);
        this.comboJvm.getAccessibleContext().setAccessibleName(NbBundle.getMessage(JavaPlatformPanelComponent.class, (String)"JavaPlatformPanelComponent.comboJvm.AccessibleContext.accessibleName"));
        this.comboJvm.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(JavaPlatformPanelComponent.class, (String)"JavaPlatformPanelComponent.comboJvm.AccessibleContext.accessibleDescription"));
        Mnemonics.setLocalizedText((AbstractButton)this.buttonManage, (String)resourceBundle.getString("MANAGE_PLATFORMS"));
        this.buttonManage.setMaximumSize(new Dimension(156, 24));
        this.buttonManage.setMinimumSize(new Dimension(156, 24));
        this.buttonManage.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JavaPlatformPanelComponent.this.buttonManageActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.3;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.jPanel1.add((Component)this.buttonManage, gridBagConstraints);
        this.buttonManage.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(JavaPlatformPanelComponent.class, (String)"JavaPlatformPanelComponent.buttonManage.AccessibleContext.accessibleDescription"));
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.hintPanel, GroupLayout.Alignment.TRAILING, -1, 469, Short.MAX_VALUE).addComponent(this.jPanel1, GroupLayout.Alignment.TRAILING, -1, 469, Short.MAX_VALUE)).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this.jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.hintPanel, -1, 130, Short.MAX_VALUE).addContainerGap()));
    }

    private void buttonManageActionPerformed(ActionEvent actionEvent) {
        JavaPlatform.showCustomizer();
        TargetPlatform targetPlatform = JavaPlatformPanelComponent.findNewItem(this.lastPlatformList, TargetPlatform.getPlatformList(this.getPlatformFilter(), false));
        this.refresh(targetPlatform);
    }

    public String getTitle() {
        return ((TitledBorder)this.getBorder()).getTitle();
    }

    public void setTitle(String string) {
        ((TitledBorder)this.getBorder()).setTitle(string);
    }

    public String getHint() {
        return this.hintPanel.getHint();
    }

    public void setHint(String string) {
        this.hintPanel.setHint(string);
    }

    public Color getHintForeground() {
        return this.hintPanel.getForeground();
    }

    public void setHintForeground(Color color) {
        this.hintPanel.setForeground(color);
    }

    public Color getHintBackground() {
        return this.hintPanel.getBackground();
    }

    public void setHintBackground(Color color) {
        this.hintPanel.setBackground(color);
    }

    public TargetPlatform getSelectedPlatform() {
        if (!this.jvmModel.isEmpty()) {
            return (TargetPlatform)this.jvmModel.getSelectedItem();
        }
        return null;
    }

    public void setSelectedPlatform(TargetPlatform targetPlatform) {
        this.selectedPlatform = targetPlatform;
    }

    public TargetPlatform.TargetPlatformFilter getPlatformFilter() {
        if (this.platformFilter == null) {
            this.platformFilter = this.defaultPlatformFilter;
        }
        return this.platformFilter;
    }

    public void setPlatformFilter(TargetPlatform.TargetPlatformFilter targetPlatformFilter) {
        this.platformFilter = targetPlatformFilter;
    }

    public void refresh() {
        this.refresh(null);
    }

    public void refresh(TargetPlatform targetPlatform) {
        List list = TargetPlatform.getPlatformList(this.getPlatformFilter(), false);
        this.comboJvm.setModel(this.emptyModel);
        this.jvmModel.setJvmList((Vector)list);
        this.comboJvm.setModel(this.jvmModel);
        if (targetPlatform != null && list.contains(targetPlatform)) {
            this.jvmModel.setSelectedItem(targetPlatform);
        }
        this.lastPlatformList = list;
    }

    private static TargetPlatform findNewItem(List list, List list2) {
        if (list == null || list2 == null) {
            return null;
        }
        if (list2.size() == 0) {
            return null;
        }
        for (Object e : list2) {
            if (list.contains(e)) continue;
            return (TargetPlatform)e;
        }
        return null;
    }

    private class JvmComboBoxModelImpl
    implements JvmComboBoxModel {
        private List platformList = null;
        private TargetPlatform defaultPlatform;
        private DefaultComboBoxModel delegate = null;
        private boolean isSelectionMade = false;

        private JvmComboBoxModelImpl() {
        }

        private DefaultComboBoxModel getDelegate() {
            if (this.delegate == null) {
                this.delegate = new DefaultComboBoxModel();
            }
            return this.delegate;
        }

        @Override
        public Object getElementAt(int n) {
            return this.getDelegate().getElementAt(n);
        }

        @Override
        public Object getSelectedItem() {
            return this.getDelegate().getSelectedItem();
        }

        @Override
        public int getSize() {
            return this.getDelegate().getSize();
        }

        @Override
        public void setSelectedItem(Object object) {
            this.getDelegate().setSelectedItem(object);
            JavaPlatformPanelComponent.this.firePropertyChange(JavaPlatformPanelComponent.JAVA_PLATFORM_PROPERTY, null, this.getDelegate().getSelectedItem());
            JavaPlatformPanelComponent.this.selectedPlatform = (TargetPlatform)object;
        }

        @Override
        public void setJvmList(Vector vector) {
            Object object = this.getDelegate().getSelectedItem();
            this.delegate = new DefaultComboBoxModel(vector);
            if (object == null || !vector.contains(object)) {
                boolean bl = false;
                for (TargetPlatform targetPlatform : vector) {
                    if (!targetPlatform.isDefault()) continue;
                    this.setSelectedItem(targetPlatform);
                    bl = true;
                    break;
                }
                if (!bl && vector.size() > 0) {
                    this.setSelectedItem(vector.get(0));
                }
            } else {
                this.setSelectedItem(object);
            }
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public void removeListDataListener(ListDataListener listDataListener) {
            this.getDelegate().removeListDataListener(listDataListener);
        }

        @Override
        public void addListDataListener(ListDataListener listDataListener) {
            this.getDelegate().addListDataListener(listDataListener);
        }
    }

    private class JvmComboBoxModelEmpty
    extends AbstractListModel
    implements JvmComboBoxModel {
        private JvmComboBoxModelEmpty() {
        }

        @Override
        public void setSelectedItem(Object object) {
        }

        @Override
        public Object getElementAt(int n) {
            return JavaPlatformPanelComponent.this.NO_SUPPORTED_JVM_MSG;
        }

        @Override
        public int getSize() {
            return 1;
        }

        @Override
        public Object getSelectedItem() {
            return JavaPlatformPanelComponent.this.NO_SUPPORTED_JVM_MSG;
        }

        @Override
        public void setJvmList(Vector vector) {
            JavaPlatformPanelComponent.this.firePropertyChange(JavaPlatformPanelComponent.JAVA_PLATFORM_PROPERTY, JavaPlatformPanelComponent.this.selectedPlatform, null);
        }

        @Override
        public boolean isEmpty() {
            return true;
        }
    }

    private class JvmComboBoxModelProxy
    implements JvmComboBoxModel {
        private final JvmComboBoxModel empty;
        private final JvmComboBoxModel normal;
        private JvmComboBoxModel proxied;

        public JvmComboBoxModelProxy() {
            this.empty = new JvmComboBoxModelEmpty();
            this.normal = new JvmComboBoxModelImpl();
            this.proxied = this.empty;
        }

        @Override
        public void addListDataListener(ListDataListener listDataListener) {
            this.proxied.addListDataListener(listDataListener);
        }

        @Override
        public Object getElementAt(int n) {
            return this.proxied.getElementAt(n);
        }

        @Override
        public Object getSelectedItem() {
            return this.proxied.getSelectedItem();
        }

        @Override
        public int getSize() {
            return this.proxied.getSize();
        }

        @Override
        public void removeListDataListener(ListDataListener listDataListener) {
            this.proxied.removeListDataListener(listDataListener);
        }

        @Override
        public void setSelectedItem(Object object) {
            this.proxied.setSelectedItem(object);
        }

        @Override
        public void setJvmList(Vector vector) {
            this.proxied = vector != null && vector.size() > 0 ? this.normal : this.empty;
            this.proxied.setJvmList(vector);
        }

        @Override
        public boolean isEmpty() {
            return this.proxied.isEmpty();
        }
    }

    private static interface JvmComboBoxModel
    extends ComboBoxModel {
        public void setJvmList(Vector var1);

        public boolean isEmpty();
    }
}

