/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.ui.sampler;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanServerConnection;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.netbeans.core.ui.sampler.SamplesOutputStream;

abstract class Sampler
implements Runnable,
ActionListener {
    private static final int SAMPLER_RATE = 10;
    private static final double MAX_AVERAGE = 30.0;
    private static final double MAX_STDDEVIATION = 40.0;
    private static final int MAX_SAMPLING_TIME = 300;
    private static final int MIN_SAMPLES = 50;
    private static final int MAX_SAMPLES = 30000;
    private final String name;
    private Timer timer;
    private ByteArrayOutputStream out;
    private SamplesOutputStream samplesStream;
    private long startTime;
    private long nanoTimeCorrection;
    private long samples;
    private long laststamp;
    private double max;
    private double min = 9.223372036854776E18;
    private double sum;
    private double devSquaresSum;
    private volatile boolean stopped;
    private volatile boolean running;

    Sampler(String string) {
        this.name = string;
    }

    protected abstract ThreadMXBean getThreadMXBean();

    protected abstract void saveSnapshot(byte[] var1) throws IOException;

    protected abstract void printStackTrace(Throwable var1);

    protected abstract void openProgress(int var1);

    protected abstract void closeProgress();

    protected abstract void progress(int var1);

    private void updateStats(long l) {
        if (this.laststamp != 0L) {
            double d = (double)(l - this.laststamp) / 1000000.0;
            ++this.samples;
            this.sum += d;
            this.devSquaresSum += (d - 10.0) * (d - 10.0);
            if (d > this.max) {
                this.max = d;
            } else if (d < this.min) {
                this.min = d;
            }
        }
        this.laststamp = l;
    }

    @Override
    public synchronized void run() {
        assert (!this.running);
        this.running = true;
        final ThreadMXBean threadMXBean = this.getThreadMXBean();
        this.out = new ByteArrayOutputStream(65536);
        try {
            this.samplesStream = new SamplesOutputStream(this.out, this, 30000);
        }
        catch (IOException iOException) {
            this.printStackTrace(iOException);
            return;
        }
        this.startTime = System.currentTimeMillis();
        this.nanoTimeCorrection = this.startTime * 1000000L - System.nanoTime();
        this.timer = new Timer(this.name);
        this.timer.scheduleAtFixedRate(new TimerTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Sampler sampler = Sampler.this;
                synchronized (sampler) {
                    if (Sampler.this.stopped) {
                        return;
                    }
                    try {
                        ThreadInfo[] threadInfoArray = threadMXBean.dumpAllThreads(false, false);
                        long l = System.nanoTime() + Sampler.this.nanoTimeCorrection;
                        Sampler.this.samplesStream.writeSample(threadInfoArray, l, Thread.currentThread().getId());
                        Sampler.this.updateStats(l);
                    }
                    catch (Throwable throwable) {
                        Sampler.this.printStackTrace(throwable);
                    }
                }
            }
        }, 10L, 10L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void actionPerformed(ActionEvent actionEvent) {
        try {
            Object[] objectArray;
            assert (this.running);
            assert (!this.stopped);
            this.stopped = true;
            this.timer.cancel();
            if ("cancel".equals(actionEvent.getActionCommand()) || this.samples < 1L) {
                return;
            }
            double d = this.sum / (double)this.samples;
            double d2 = Math.sqrt(this.devSquaresSum / (double)this.samples);
            boolean bl = "write".equals(actionEvent.getActionCommand());
            if (bl) {
                objectArray = new Object[]{this.startTime, "Samples", this.samples, "Average", d, "Minimum", this.min, "Maximum", this.max, "Std. deviation", d2};
                Logger.getLogger("org.netbeans.ui.performance").log(Level.CONFIG, "Snapshot statistics", objectArray);
                if (d > 30.0 || d2 > 40.0 || this.samples < 50L) {
                    return;
                }
            }
            this.samplesStream.close();
            this.samplesStream = null;
            if (bl) {
                objectArray = (Object[])actionEvent.getSource();
                objectArray.write(this.out.toByteArray());
                objectArray.close();
                return;
            }
            this.saveSnapshot(this.out.toByteArray());
        }
        catch (Exception exception) {
            this.printStackTrace(exception);
        }
        finally {
            this.out = null;
            this.samplesStream = null;
        }
    }

    public static void main(String ... stringArray) throws Exception {
        if (stringArray.length != 2) {
            System.out.println("Usage: <port> <snapshot.npss>");
            System.out.println();
            System.out.println("First of all start your application with following parameters:");
            System.out.println("  -Dcom.sun.management.jmxremote.authenticate=false");
            System.out.println("  -Dcom.sun.management.jmxremote.ssl=false");
            System.out.println("  -Dcom.sun.management.jmxremote.port=<port>");
            System.out.println("Then you can start this sampler with correct port and file to write snapshot to.");
            System.exit(1);
        }
        String string = stringArray[0];
        try {
            string = "service:jmx:rmi:///jndi/rmi://localhost:" + Integer.parseInt(stringArray[0]) + "/jmxrmi";
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        System.err.println("Connecting to " + string);
        JMXServiceURL jMXServiceURL = new JMXServiceURL(string);
        JMXConnector jMXConnector = null;
        Throwable throwable = null;
        for (int i = 0; i < 100; ++i) {
            try {
                jMXConnector = JMXConnectorFactory.connect(jMXServiceURL, null);
                break;
            }
            catch (IOException iOException) {
                throwable = iOException;
                System.err.println("Connection failed. Will retry in 300ms.");
                Thread.sleep(300L);
                continue;
            }
        }
        if (jMXConnector == null) {
            throwable.printStackTrace();
            System.err.println("Cannot connect to " + string);
            System.exit(3);
        }
        MBeanServerConnection mBeanServerConnection = jMXConnector.getMBeanServerConnection();
        final ThreadMXBean threadMXBean = ManagementFactory.newPlatformMXBeanProxy(mBeanServerConnection, "java.lang:type=Threading", ThreadMXBean.class);
        final File file = new File(stringArray[1]);
        class CLISampler
        extends Sampler {
            CLISampler() {
                super("");
            }

            @Override
            protected ThreadMXBean getThreadMXBean() {
                return threadMXBean;
            }

            @Override
            protected void saveSnapshot(byte[] byArray) throws IOException {
                FileOutputStream fileOutputStream = new FileOutputStream(file);
                fileOutputStream.write(byArray);
                fileOutputStream.close();
            }

            @Override
            protected void printStackTrace(Throwable throwable) {
                throwable.printStackTrace();
                System.exit(2);
            }

            @Override
            protected void openProgress(int n) {
            }

            @Override
            protected void closeProgress() {
            }

            @Override
            protected void progress(int n) {
                System.out.print("#");
                System.out.flush();
            }
        }
        CLISampler cLISampler = new CLISampler();
        cLISampler.run();
        System.out.println("Press enter to generate sample into " + file);
        System.in.read();
        cLISampler.actionPerformed(new ActionEvent(cLISampler, 0, ""));
        System.out.println();
        System.out.println("Sample written to " + file);
        System.exit(0);
    }
}

