/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.startup;

import java.io.IOException;
import java.text.Collator;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.TreeSet;
import org.netbeans.InvalidException;
import org.netbeans.Module;
import org.openide.modules.Dependency;
import org.openide.modules.SpecificationVersion;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public final class NbProblemDisplayer {
    private NbProblemDisplayer() {
    }

    public static String messageForProblem(Module module, Object object) {
        return NbProblemDisplayer.messageForProblem(module, object, true);
    }

    static String messageForProblem(Module module, Object object, boolean bl) {
        if (object instanceof InvalidException) {
            String string = Exceptions.findLocalizedMessage((Throwable)((InvalidException)((Object)object)));
            return string != null ? string : object.toString();
        }
        Dependency dependency = (Dependency)object;
        switch (dependency.getType()) {
            case 1: {
                Module module2;
                String string = (String)module.getLocalizedAttribute("OpenIDE-Module-Module-Dependency-Message");
                if (string != null) {
                    return string;
                }
                String string2 = dependency.getName();
                int n = string2.lastIndexOf(47);
                if (n != -1) {
                    string2 = string2.substring(0, n);
                }
                if ((module2 = module.getManager().get(string2)) != null && module2.getCodeName().equals(dependency.getName())) {
                    switch (dependency.getComparison()) {
                        case 3: {
                            return NbBundle.getMessage(NbProblemDisplayer.class, (String)"MSG_problem_other_disabled", (Object)NbProblemDisplayer.label(module2, bl));
                        }
                        case 2: {
                            String string3;
                            String string4 = dependency.getVersion();
                            String string5 = string3 = module2.getImplementationVersion() != null ? module2.getImplementationVersion() : NbBundle.getMessage(NbProblemDisplayer.class, (String)"LBL_no_impl_version");
                            if (string4.equals(string3)) {
                                return NbBundle.getMessage(NbProblemDisplayer.class, (String)"MSG_problem_other_disabled", (Object)NbProblemDisplayer.label(module2, bl));
                            }
                            return NbBundle.getMessage(NbProblemDisplayer.class, (String)"MSG_problem_other_wrong_version", (Object)NbProblemDisplayer.label(module2, bl), (Object)string4, (Object)string3);
                        }
                        case 1: {
                            SpecificationVersion specificationVersion;
                            SpecificationVersion specificationVersion2 = new SpecificationVersion(dependency.getVersion());
                            SpecificationVersion specificationVersion3 = specificationVersion = module2.getSpecificationVersion() != null ? module2.getSpecificationVersion() : new SpecificationVersion("0");
                            if (specificationVersion.compareTo((Object)specificationVersion2) >= 0) {
                                return NbBundle.getMessage(NbProblemDisplayer.class, (String)"MSG_problem_other_disabled", (Object)NbProblemDisplayer.label(module2, bl));
                            }
                            return NbBundle.getMessage(NbProblemDisplayer.class, (String)"MSG_problem_other_too_old", (Object)NbProblemDisplayer.label(module2, bl), (Object)specificationVersion2, (Object)specificationVersion);
                        }
                    }
                    throw new IllegalStateException();
                }
                return NbBundle.getMessage(NbProblemDisplayer.class, (String)"MSG_problem_other_needed_not_found", (Object)dependency.getName());
            }
            case 5: 
            case 6: {
                String string = (String)module.getLocalizedAttribute("OpenIDE-Module-Requires-Message");
                if (string != null) {
                    return string;
                }
                for (Module module3 : module.getManager().getModules()) {
                    if (!module3.provides(dependency.getName())) continue;
                    return NbBundle.getMessage(NbProblemDisplayer.class, (String)"MSG_problem_require_disabled", (Object)dependency.getName());
                }
                return NbBundle.getMessage(NbProblemDisplayer.class, (String)"MSG_problem_require_not_found", (Object)dependency.getName());
            }
            case 2: {
                String string = (String)module.getLocalizedAttribute("OpenIDE-Module-Package-Dependency-Message");
                if (string != null) {
                    return string;
                }
                String string6 = dependency.getName();
                int n = string6.lastIndexOf(91);
                if (n == 0) {
                    return NbBundle.getMessage(NbProblemDisplayer.class, (String)"MSG_problem_class_not_loaded", (Object)string6.substring(1, string6.length() - 1));
                }
                if (n != -1) {
                    return NbBundle.getMessage(NbProblemDisplayer.class, (String)"MSG_problem_package_not_loaded_or_old", (Object)string6.substring(0, n));
                }
                return NbBundle.getMessage(NbProblemDisplayer.class, (String)"MSG_problem_package_not_loaded_or_old", (Object)string6);
            }
            case 3: {
                if (dependency.getName().equals("Java") && dependency.getComparison() == 1) {
                    return NbBundle.getMessage(NbProblemDisplayer.class, (String)"MSG_problem_java_too_old", (Object)dependency.getVersion(), (Object)Dependency.JAVA_SPEC);
                }
                return dependency.toString();
            }
        }
        throw new IllegalArgumentException(dependency.toString());
    }

    private static String label(Module module, boolean bl) {
        if (bl) {
            return module.getDisplayName();
        }
        return module.getCodeNameBase();
    }

    static void problemMessagesForModules(Appendable appendable, Collection<? extends Module> collection, boolean bl) {
        try {
            HashSet<String> hashSet = new HashSet<String>();
            for (Module object : collection) {
                hashSet.add(object.getCodeName());
            }
            HashSet hashSet2 = new HashSet();
            for (Module module : collection) {
                TreeSet<Object> treeSet = new TreeSet<Object>(Collator.getInstance());
                Iterator iterator = module.getProblems().iterator();
                if (iterator.hasNext()) {
                    while (iterator.hasNext()) {
                        Dependency dependency;
                        Object object = iterator.next();
                        if (object instanceof Dependency && bl && (dependency = (Dependency)object).getType() == 1 && hashSet.contains(dependency.getName())) {
                            hashSet2.add(module.getCodeName());
                            continue;
                        }
                        treeSet.add(NbProblemDisplayer.label(module, bl) + " - " + NbProblemDisplayer.messageForProblem(module, object, bl));
                    }
                } else {
                    throw new IllegalStateException("Module " + module + " could not be installed but had no problems");
                }
                for (String string : treeSet) {
                    appendable.append("\n\t").append(string);
                }
            }
            if (!hashSet2.isEmpty()) {
                appendable.append("\n\t").append(NbBundle.getMessage(NbProblemDisplayer.class, (String)"MSG_also_dep_modules", (Object)hashSet2.size()));
            }
        }
        catch (IOException iOException) {
            throw (IllegalStateException)new IllegalStateException().initCause(iOException);
        }
    }
}

