/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import java.io.IOException;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Map;
import sun.nio.ch.AllocatedNativeObject;
import sun.nio.ch.FileDispatcherImpl;

class DevPollArrayWrapper {
    static final short POLLIN = 1;
    static final short POLLPRI = 2;
    static final short POLLOUT = 4;
    static final short POLLRDNORM = 64;
    static final short POLLWRNORM = 4;
    static final short POLLRDBAND = 128;
    static final short POLLWRBAND = 256;
    static final short POLLNORM = 64;
    static final short POLLERR = 8;
    static final short POLLHUP = 16;
    static final short POLLNVAL = 32;
    static final short POLLREMOVE = 2048;
    static final short POLLCONN = 4;
    static final short SIZE_POLLFD = 8;
    static final short FD_OFFSET = 0;
    static final short EVENT_OFFSET = 4;
    static final short REVENT_OFFSET = 6;
    static final byte IGNORE = -1;
    static final int OPEN_MAX = DevPollArrayWrapper.fdLimit();
    static final int NUM_POLLFDS = Math.min(OPEN_MAX - 1, 8192);
    private final int INITIAL_PENDING_UPDATE_SIZE = 64;
    private final int MAX_UPDATE_ARRAY_SIZE = Math.min(OPEN_MAX, 65536);
    private final AllocatedNativeObject pollArray;
    private final long pollArrayAddress;
    private int wfd;
    private int outgoingInterruptFD;
    private int incomingInterruptFD;
    private int interruptedIndex;
    int updated;
    private final Object updateLock = new Object();
    private int updateCount;
    private int[] updateDescriptors = new int[64];
    private final byte[] eventsLow = new byte[this.MAX_UPDATE_ARRAY_SIZE];
    private Map<Integer, Byte> eventsHigh;
    private final BitSet registered = new BitSet();
    boolean interrupted = false;

    DevPollArrayWrapper() {
        int n = NUM_POLLFDS * 8;
        this.pollArray = new AllocatedNativeObject(n, true);
        this.pollArrayAddress = this.pollArray.address();
        this.wfd = this.init();
        if (OPEN_MAX > this.MAX_UPDATE_ARRAY_SIZE) {
            this.eventsHigh = new HashMap<Integer, Byte>();
        }
    }

    void initInterrupt(int n, int n2) {
        this.outgoingInterruptFD = n2;
        this.incomingInterruptFD = n;
        this.register(this.wfd, n, 1);
    }

    void putReventOps(int n, int n2) {
        int n3 = 8 * n + 6;
        this.pollArray.putShort(n3, (short)n2);
    }

    int getEventOps(int n) {
        int n2 = 8 * n + 4;
        return this.pollArray.getShort(n2);
    }

    int getReventOps(int n) {
        int n2 = 8 * n + 6;
        return this.pollArray.getShort(n2);
    }

    int getDescriptor(int n) {
        int n2 = 8 * n + 0;
        return this.pollArray.getInt(n2);
    }

    private void setUpdateEvents(int n, byte by) {
        if (n < this.MAX_UPDATE_ARRAY_SIZE) {
            this.eventsLow[n] = by;
        } else {
            this.eventsHigh.put(n, by);
        }
    }

    private byte getUpdateEvents(int n) {
        if (n < this.MAX_UPDATE_ARRAY_SIZE) {
            return this.eventsLow[n];
        }
        Byte by = this.eventsHigh.get(n);
        return by;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setInterest(int n, int n2) {
        Object object = this.updateLock;
        synchronized (object) {
            byte by;
            int n3 = this.updateDescriptors.length;
            if (this.updateCount == n3) {
                by = n3 + 64;
                int[] nArray = new int[by];
                System.arraycopy(this.updateDescriptors, 0, nArray, 0, n3);
                this.updateDescriptors = nArray;
            }
            this.updateDescriptors[this.updateCount++] = n;
            by = (byte)n2;
            assert (by == n2 && by != -1);
            this.setUpdateEvents(n, by);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void release(int n) {
        Object object = this.updateLock;
        synchronized (object) {
            this.setUpdateEvents(n, (byte)-1);
            if (this.registered.get(n)) {
                this.register(this.wfd, n, 2048);
                this.registered.clear(n);
            }
        }
    }

    void closeDevPollFD() throws IOException {
        FileDispatcherImpl.closeIntFD(this.wfd);
        this.pollArray.free();
    }

    int poll(long l) throws IOException {
        this.updateRegistrations();
        this.updated = this.poll0(this.pollArrayAddress, NUM_POLLFDS, l, this.wfd);
        for (int i = 0; i < this.updated; ++i) {
            if (this.getDescriptor(i) != this.incomingInterruptFD) continue;
            this.interruptedIndex = i;
            this.interrupted = true;
            break;
        }
        return this.updated;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateRegistrations() throws IOException {
        Object object = this.updateLock;
        synchronized (object) {
            int n = 0;
            for (int i = 0; i < this.updateCount; ++i) {
                int n2 = this.updateDescriptors[i];
                short s = this.getUpdateEvents(n2);
                boolean bl = this.registered.get(n2);
                if (s != -1) {
                    if (s == 0) {
                        if (bl) {
                            s = 2048;
                            this.registered.clear(n2);
                        } else {
                            s = -1;
                        }
                    } else if (!bl) {
                        this.registered.set(n2);
                    }
                }
                if (s == -1) continue;
                if (bl && s != 2048) {
                    this.putPollFD(this.pollArray, n, n2, (short)2048);
                    ++n;
                }
                this.putPollFD(this.pollArray, n, n2, s);
                if (++n >= NUM_POLLFDS - 1) {
                    this.registerMultiple(this.wfd, this.pollArray.address(), n);
                    n = 0;
                }
                this.setUpdateEvents(n2, (byte)-1);
            }
            if (n > 0) {
                this.registerMultiple(this.wfd, this.pollArray.address(), n);
            }
            this.updateCount = 0;
        }
    }

    private void putPollFD(AllocatedNativeObject allocatedNativeObject, int n, int n2, short s) {
        int n3 = 8 * n;
        allocatedNativeObject.putInt(n3 + 0, n2);
        allocatedNativeObject.putShort(n3 + 4, s);
        allocatedNativeObject.putShort(n3 + 6, (short)0);
    }

    public void interrupt() {
        DevPollArrayWrapper.interrupt(this.outgoingInterruptFD);
    }

    public int interruptedIndex() {
        return this.interruptedIndex;
    }

    boolean interrupted() {
        return this.interrupted;
    }

    void clearInterrupted() {
        this.interrupted = false;
    }

    private native int init();

    private native void register(int var1, int var2, int var3);

    private native void registerMultiple(int var1, long var2, int var4) throws IOException;

    private native int poll0(long var1, int var3, long var4, int var6);

    private static native void interrupt(int var0);

    private static native int fdLimit();
}

