/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows.actions;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.SwingUtilities;
import org.netbeans.core.windows.ModeImpl;
import org.netbeans.core.windows.Switches;
import org.netbeans.core.windows.WindowManagerImpl;
import org.netbeans.core.windows.actions.ActionUtils;
import org.netbeans.core.windows.actions.CloseModeAction;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public final class MinimizeModeAction
extends AbstractAction
implements PropertyChangeListener {
    private ModeImpl mode;

    public MinimizeModeAction() {
        this.putValue("Name", NbBundle.getMessage(CloseModeAction.class, (String)"CTL_MinimizeModeAction"));
        TopComponent.getRegistry().addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)TopComponent.getRegistry()));
        WindowManager.getDefault().addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)WindowManager.getDefault()));
        if (SwingUtilities.isEventDispatchThread()) {
            this.updateEnabled();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MinimizeModeAction.this.updateEnabled();
                }
            });
        }
    }

    public MinimizeModeAction(ModeImpl modeImpl) {
        this.putValue("Name", NbBundle.getMessage(ActionUtils.class, (String)"CTL_MinimizeModeAction"));
        this.mode = modeImpl;
        this.setEnabled(Switches.isModeSlidingEnabled() && modeImpl.getKind() == 0 && modeImpl.getState() == 0);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        TopComponent topComponent;
        ModeImpl modeImpl = this.mode;
        if (modeImpl == null && null != (topComponent = TopComponent.getRegistry().getActivated())) {
            modeImpl = (ModeImpl)WindowManagerImpl.getInstance().findMode(topComponent);
        }
        if (modeImpl != null) {
            WindowManagerImpl.getInstance().userMinimizedMode(modeImpl);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("activated".equals(propertyChangeEvent.getPropertyName()) || "modes".equals(propertyChangeEvent.getPropertyName())) {
            this.updateEnabled();
        }
    }

    private void updateEnabled() {
        TopComponent topComponent;
        ModeImpl modeImpl = this.mode;
        if (modeImpl == null && null != (topComponent = TopComponent.getRegistry().getActivated())) {
            modeImpl = (ModeImpl)WindowManagerImpl.getInstance().findMode(topComponent);
        }
        if (null == modeImpl) {
            this.setEnabled(false);
            return;
        }
        this.setEnabled(Switches.isModeSlidingEnabled() && modeImpl.getKind() == 0 && modeImpl.getState() == 0);
    }

    @Override
    public void putValue(String string, Object object) {
        if ("AcceleratorKey".equals(string)) {
            ActionUtils.putSharedAccelerator("MinimizeMode", object);
        } else {
            super.putValue(string, object);
        }
    }

    @Override
    public Object getValue(String string) {
        if ("AcceleratorKey".equals(string)) {
            return ActionUtils.getSharedAccelerator("MinimizeMode");
        }
        return super.getValue(string);
    }
}

