/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.panel;

import com.sun.deploy.config.Config;
import com.sun.deploy.panel.CertificatesDialog;
import com.sun.deploy.panel.SecurityLevelPanel;
import com.sun.deploy.panel.SecurityProperties;
import com.sun.deploy.resources.ResourceManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;

public class SecurityPanel
extends JPanel
implements SecurityProperties.JavaEnableListener {
    private JCheckBox enableBrowserCheckbox;
    private JLabel disabledForUserOnlyLabel;

    public SecurityPanel() {
        this.initComponents();
        SecurityProperties.addJavaEnableListener(this);
    }

    public final void initComponents() {
        this.setLayout(new BorderLayout());
        this.setBorder(new EmptyBorder(new Insets(5, 5, 5, 5)));
        Box box = Box.createVerticalBox();
        box.add(this.createEnableJavaInBrowser());
        box.add(this.createSecurityLevelPanel());
        JPanel jPanel = this.createCertificationPanel();
        box.add(jPanel);
        this.add((Component)box, "North");
        this.enableBrowserCheckbox.setEnabled(!Config.get().isPropertyLocked("deployment.webjava.enabled"));
    }

    private void certsBtnActionPerformed(ActionEvent actionEvent) {
        CertificatesDialog certificatesDialog = new CertificatesDialog((Frame)((JFrame)this.getTopLevelAncestor()), true);
        certificatesDialog.setLocationRelativeTo(this);
        certificatesDialog.setVisible(true);
    }

    private String getMessage(String string) {
        return ResourceManager.getMessage(string);
    }

    private JPanel createSecurityLevelPanel() {
        return new SecurityLevelPanel();
    }

    private JPanel createCertificationPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout(2));
        JButton jButton = new JButton(this.getMessage("security.certificates.button.text"));
        jButton.setMnemonic(ResourceManager.getMnemonic("security.certificates.button.text"));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SecurityPanel.this.certsBtnActionPerformed(actionEvent);
            }
        });
        jButton.setToolTipText(this.getMessage("security.certs_btn.tooltip"));
        jPanel2.add(jButton);
        jPanel.add((Component)jPanel2, "South");
        return jPanel;
    }

    private void decreaseFont(JComponent jComponent, int n) {
        Font font = jComponent.getFont();
        jComponent.setFont(new Font(font.getName(), font.getStyle(), font.getSize() - n));
    }

    private JComponent createEnableJavaInBrowser() {
        Box box = Box.createHorizontalBox();
        this.enableBrowserCheckbox = new JCheckBox(ResourceManager.getMessage("deployment.security.enable.java.browser"));
        this.enableBrowserCheckbox.setMnemonic(ResourceManager.getAcceleratorKey("deployment.security.enable.java.browser"));
        this.enableBrowserCheckbox.setSelected(SecurityProperties.isJavaInBrowserEnabled());
        this.enableBrowserCheckbox.addActionListener(new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl = SecurityPanel.this.enableBrowserCheckbox.isSelected();
                SecurityProperties.enableJavaInBrowser(bl);
                SecurityPanel.this.setTextForUserDisabledLabel();
            }
        });
        box.add(this.enableBrowserCheckbox);
        this.disabledForUserOnlyLabel = new JLabel("");
        this.decreaseFont(this.disabledForUserOnlyLabel, 2);
        this.setTextForUserDisabledLabel();
        box.add(this.disabledForUserOnlyLabel);
        box.add(Box.createHorizontalGlue());
        return box;
    }

    private void setTextForUserDisabledLabel() {
        if (SecurityProperties.isJavaInBrowserDisabledForUser()) {
            this.disabledForUserOnlyLabel.setText(ResourceManager.getMessage("deployment.security.java.browser.user.disabled"));
        } else {
            this.disabledForUserOnlyLabel.setText("");
        }
    }

    public void javaEnableChanged(SecurityProperties.JavaEnableEvent javaEnableEvent) {
        this.setTextForUserDisabledLabel();
        this.enableBrowserCheckbox.setSelected(javaEnableEvent.isEnabled());
    }
}

