/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.tools.packager.bundlers;

import com.sun.javafx.tools.packager.Log;
import java.io.File;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RelativeFileSet {
    private File basedir;
    Set<String> files = new HashSet<String>();

    public RelativeFileSet(File base, Set<File> files) {
        this.basedir = base;
        String baseAbsolute = this.basedir.getAbsolutePath();
        for (File f : files) {
            String absolute = f.getAbsolutePath();
            if (!absolute.startsWith(baseAbsolute)) {
                throw new RuntimeException("File " + f.getAbsolutePath() + " does not belong to " + baseAbsolute);
            }
            if (absolute.equals(baseAbsolute)) continue;
            this.files.add(absolute.substring(baseAbsolute.length() + 1));
        }
    }

    public boolean contains(String[] requiredFiles) {
        boolean result = true;
        for (String fname : requiredFiles) {
            if (this.files.contains(fname)) continue;
            Log.debug("  Runtime does not contain [" + fname + "]");
            result = false;
        }
        return result;
    }

    public File getBaseDirectory() {
        return this.basedir;
    }

    public Set<String> getIncludedFiles() {
        return this.files;
    }

    public void dump() {
        Log.verbose("\n=========\nBasedir: " + this.basedir + "\n");
        for (String fname : this.files) {
            Log.verbose("  " + fname);
        }
        Log.verbose("\n========");
    }
}

