/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.tools.packager.bundlers;

import com.sun.javafx.tools.packager.Log;
import com.sun.javafx.tools.packager.bundlers.BundleParams;
import com.sun.javafx.tools.packager.bundlers.Bundler;
import com.sun.javafx.tools.packager.bundlers.IOUtils;
import com.sun.javafx.tools.packager.bundlers.LinuxAppBundler;
import com.sun.javafx.tools.resource.linux.LinuxResources;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;

public class LinuxRPMBundler
extends Bundler {
    LinuxAppBundler appBundler = new LinuxAppBundler();
    BundleParams params;
    private File configRoot = null;
    File imageDir = null;
    private boolean menuShortcut = false;
    private boolean desktopShortcut = false;
    private static final String DEFAULT_ICON = "javalogo_white_32.png";
    private static final String DEFAULT_SPEC_TEMPLATE = "template.spec";
    private static final String DEFAULT_DESKTOP_FILE_TEMPLATE = "template.desktop";
    private static final String TOOL_RPMBUILD = "rpmbuild";

    public LinuxRPMBundler() {
        this.baseResourceLoader = LinuxResources.class;
    }

    protected void setBuildRoot(File dir) {
        super.setBuildRoot(dir);
        this.configRoot = new File(dir, "linux");
        this.configRoot.mkdirs();
        this.appBundler.setBuildRoot(dir);
    }

    public void setVerbose(boolean m) {
        super.setVerbose(m);
        this.appBundler.setVerbose(m);
    }

    private boolean testTool(String toolName, String minVersion) {
        try {
            ProcessBuilder pb = new ProcessBuilder(toolName, "--version");
            IOUtils.exec(pb, Log.isDebug(), true);
        }
        catch (Exception e) {
            Log.verbose("Test for [" + toolName + "]. Result: " + e.getMessage());
            return false;
        }
        return true;
    }

    boolean validate(BundleParams p) throws Bundler.UnsupportedPlatformException, Bundler.ConfigException {
        if (p.type != Bundler.BundleType.ALL && p.type != Bundler.BundleType.INSTALLER || p.bundleFormat != null && !"rpm".equals(p.bundleFormat)) {
            return false;
        }
        this.appBundler.doValidate(p);
        if (!this.testTool(TOOL_RPMBUILD, "4")) {
            throw new Bundler.ConfigException("Can not find rpmbuild.", "  Install packages needed to build RPM.");
        }
        return true;
    }

    private boolean prepareProto() {
        return this.appBundler.doBundle(this.params, this.imageDir, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean bundle(BundleParams p, File outdir) {
        this.imageDir = new File(this.imagesRoot, "linux-rpm.image");
        try {
            this.params = p;
            this.imageDir.mkdirs();
            this.menuShortcut = this.params.needMenu;
            this.desktopShortcut = this.params.needShortcut;
            if (!this.menuShortcut && !this.desktopShortcut) {
                Log.verbose("At least one type of shortcut is required. Enabling menu shortcut.");
                this.menuShortcut = true;
            }
            if (this.prepareProto() && this.prepareProjectConfig()) {
                boolean bl = this.buildRPM(outdir);
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (IOException ex) {
            ex.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (this.verbose) {
                    this.saveConfigFiles();
                }
                if (this.imageDir != null && !Log.isDebug()) {
                    IOUtils.deleteRecursive(this.imageDir);
                } else if (this.imageDir != null) {
                    Log.info("Kept working directory for debug: " + this.imageDir.getAbsolutePath());
                }
            }
            catch (FileNotFoundException ex) {
                return false;
            }
        }
    }

    protected void saveConfigFiles() {
        try {
            if (this.getConfig_SpecFile().exists()) {
                IOUtils.copyFile(this.getConfig_SpecFile(), new File(this.configRoot, this.getConfig_SpecFile().getName()));
            }
            if (this.getConfig_DesktopShortcutFile().exists()) {
                IOUtils.copyFile(this.getConfig_DesktopShortcutFile(), new File(this.configRoot, this.getConfig_DesktopShortcutFile().getName()));
            }
            if (this.getConfig_IconFile().exists()) {
                IOUtils.copyFile(this.getConfig_IconFile(), new File(this.configRoot, this.getConfig_IconFile().getName()));
            }
            Log.info("  Config files are saved to " + this.configRoot.getAbsolutePath() + ". Use them to customize package.");
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    public String toString() {
        return "RPM bundler";
    }

    private String getLicenseFileString() {
        StringBuilder sb = new StringBuilder();
        for (String f : this.params.licenseFile) {
            if (sb.length() != 0) {
                sb.append("\n");
            }
            sb.append("%doc /opt/");
            sb.append(this.getBundleName());
            sb.append("/app/");
            sb.append(f);
        }
        return sb.toString();
    }

    private String getBundleName() {
        String nm = this.params.name != null ? this.params.name : this.params.getMainClassName();
        nm = nm.replaceAll(" ", "");
        return nm;
    }

    private String getVersion() {
        if (this.params.appVersion != null) {
            return this.params.appVersion;
        }
        return "1.0";
    }

    private boolean prepareProjectConfig() throws IOException {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("APPLICATION_NAME", this.getBundleName());
        data.put("APPLICATION_VENDOR", this.params.vendor != null ? this.params.vendor : "Unknown");
        data.put("APPLICATION_VERSION", this.getVersion());
        data.put("APPLICATION_LAUNCHER_FILENAME", LinuxAppBundler.getLauncher(this.imageDir, this.params).getName());
        data.put("APPLICATION_DESKTOP_SHORTCUT", this.desktopShortcut ? "returnTrue" : "returnFalse");
        data.put("APPLICATION_MENU_SHORTCUT", this.menuShortcut ? "returnTrue" : "returnFalse");
        data.put("DEPLOY_BUNDLE_CATEGORY", this.params.applicationCategory != null ? this.params.applicationCategory : "Applications;");
        data.put("APPLICATION_DESCRIPTION", this.params.description != null ? this.params.description : this.params.name);
        data.put("APPLICATION_SUMMARY", this.params.title != null ? this.params.title : this.params.name);
        data.put("APPLICATION_LICENSE_TYPE", this.params.licenseType != null ? this.params.licenseType : "unknown");
        data.put("APPLICATION_LICENSE_FILE", this.getLicenseFileString());
        BufferedWriter w = new BufferedWriter(new FileWriter(this.getConfig_SpecFile()));
        String content = this.preprocessTextResource(LinuxAppBundler.LINUX_BUNDLER_PREFIX + this.getConfig_SpecFile().getName(), "RPM spec file", DEFAULT_SPEC_TEMPLATE, data);
        w.write(content);
        ((Writer)w).close();
        w = new BufferedWriter(new FileWriter(this.getConfig_DesktopShortcutFile()));
        content = this.preprocessTextResource(LinuxAppBundler.LINUX_BUNDLER_PREFIX + this.getConfig_DesktopShortcutFile().getName(), "Menu shortcut descriptor", DEFAULT_DESKTOP_FILE_TEMPLATE, data);
        w.write(content);
        ((Writer)w).close();
        File iconTarget = this.getConfig_IconFile();
        if (this.params.icon == null) {
            this.fetchResource(LinuxAppBundler.LINUX_BUNDLER_PREFIX + iconTarget.getName(), "menu icon", DEFAULT_ICON, iconTarget);
        } else {
            this.fetchResource(LinuxAppBundler.LINUX_BUNDLER_PREFIX + iconTarget.getName(), "menu icon", this.params.icon, iconTarget);
        }
        return true;
    }

    private File getConfig_DesktopShortcutFile() {
        return new File(LinuxAppBundler.getLauncher(this.imageDir, this.params).getParentFile(), this.getBundleName() + ".desktop");
    }

    private File getConfig_IconFile() {
        return new File(LinuxAppBundler.getLauncher(this.imageDir, this.params).getParentFile(), this.getBundleName() + ".png");
    }

    private File getConfig_SpecFile() {
        return new File(this.imageDir, this.getBundleName() + ".spec");
    }

    private boolean buildRPM(File outdir) throws IOException {
        Log.verbose("Generating RPM for installer to: " + outdir.getAbsolutePath());
        File broot = new File(this.buildRoot, "rmpbuildroot");
        outdir.mkdirs();
        ProcessBuilder pb = new ProcessBuilder(TOOL_RPMBUILD, "-bb", this.getConfig_SpecFile().getAbsolutePath(), "--define", "%_sourcedir " + this.imageDir.getAbsolutePath(), "--define", "%_rpmdir " + outdir.getAbsolutePath(), "--define", "%_topdir " + broot.getAbsolutePath());
        pb = pb.directory(this.imageDir);
        IOUtils.exec(pb, this.verbose);
        IOUtils.deleteRecursive(broot);
        Log.info("Package (.rpm) saved to: " + outdir.getAbsolutePath());
        return true;
    }
}

