/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.tools.packager;

import com.sun.javafx.tools.ant.Callback;
import com.sun.javafx.tools.ant.Utils;
import com.sun.javafx.tools.packager.CreateBSSParams;
import com.sun.javafx.tools.packager.CreateJarParams;
import com.sun.javafx.tools.packager.DeployParams;
import com.sun.javafx.tools.packager.HtmlParam;
import com.sun.javafx.tools.packager.JarSignature;
import com.sun.javafx.tools.packager.Log;
import com.sun.javafx.tools.packager.MakeAllParams;
import com.sun.javafx.tools.packager.PackagerException;
import com.sun.javafx.tools.packager.Param;
import com.sun.javafx.tools.packager.SignJarParams;
import com.sun.javafx.tools.packager.TemplatePlaceholders;
import com.sun.javafx.tools.packager.bundlers.BundleParams;
import com.sun.javafx.tools.packager.bundlers.Bundler;
import com.sun.javafx.tools.resource.DeployResource;
import com.sun.javafx.tools.resource.PackagerResource;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Writer;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.CodeSigner;
import java.security.InvalidKeyException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.SignatureException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertPath;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import sun.misc.BASE64Encoder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PackagerLib {
    public static final String JAVAFX_VERSION = "2.2";
    private static final ResourceBundle bundle = ResourceBundle.getBundle("com/sun/javafx/tools/packager/Bundle");
    private static String dtFX = "dtjava.js";
    private static String webfilesDir = "web-files";
    private static String EMBEDDED_DT = "./" + webfilesDir + "/" + dtFX;
    private static String PUBLIC_DT = "http://java.com/js/dtjava.js";
    private CreateJarParams createJarParams;
    private DeployParams deployParams;
    private CreateBSSParams createBssParams;
    private File tmpDir;
    private File bssTmpDir;
    private boolean isSignedJNLP;
    private static String[] launcherFiles = new String[]{"com/javafx/main/Main.class", "com/javafx/main/Main$1.class", "com/javafx/main/Main$2.class", "com/javafx/main/NoJavaFXFallback.class"};
    private static String prefix_in_antjar = "/resources/classes/";
    private ClassLoader classLoader;
    public static final String MANIFEST_JAVAFX_MAIN = "JavaFX-Application-Class";
    private Set<String> alreadyAddedEntries = new HashSet<String>();
    private static String[] webFiles = new String[]{"javafx-loading-100x100.gif", dtFX, "javafx-loading-25x25.gif", "error.png", "upgrade_java.png", "javafx-chrome.png", "get_java.png", "upgrade_javafx.png", "get_javafx.png"};
    private static String prefixWebFiles = "/resources/web-files/";

    private ClassLoader getClassLoader() throws PackagerException {
        if (this.classLoader == null) {
            try {
                URL[] urls = new URL[]{new URL(this.getJfxrtPath())};
                this.classLoader = URLClassLoader.newInstance(urls);
            }
            catch (MalformedURLException ex) {
                throw new PackagerException(ex, "ERR_CantFindRuntime", new String[0]);
            }
        }
        return this.classLoader;
    }

    public void packageAsJar(CreateJarParams createJarParams) throws PackagerException {
        if (createJarParams == null) {
            throw new IllegalArgumentException("Parameters must not be null");
        }
        this.createJarParams = createJarParams;
        File applicationJar = new File(createJarParams.outdir, createJarParams.outfile.endsWith(".jar") ? createJarParams.outfile : createJarParams.outfile + ".jar");
        File parentFile = applicationJar.getParentFile();
        if (parentFile != null) {
            parentFile.mkdirs();
        }
        Manifest m = new Manifest();
        Attributes attr = m.getMainAttributes();
        attr.put(Attributes.Name.MANIFEST_VERSION, "1.0");
        attr.put(new Attributes.Name("Created-By"), "JavaFX Packager");
        if (createJarParams.manifestAttrs != null) {
            for (Map.Entry<String, String> e : createJarParams.manifestAttrs.entrySet()) {
                attr.put(new Attributes.Name(e.getKey()), e.getValue());
            }
        }
        if (createJarParams.embedLauncher) {
            try {
                this.tmpDir = File.createTempFile("fxjar", "");
            }
            catch (IOException ex) {
                throw new PackagerException(ex, "ERR_CreatingTempFileFailed", new String[0]);
            }
            this.tmpDir.delete();
            this.tmpDir.mkdirs();
            for (String cls : launcherFiles) {
                this.extractEmbeddedClass(this.tmpDir, cls);
            }
            attr.put(Attributes.Name.MAIN_CLASS, "com/javafx/main/Main");
            attr.put(new Attributes.Name(MANIFEST_JAVAFX_MAIN), createJarParams.applicationClass);
            attr.put(new Attributes.Name("JavaFX-Version"), createJarParams.fxVersion);
            if (createJarParams.preloader != null) {
                attr.put(new Attributes.Name("JavaFX-Preloader-Class"), createJarParams.preloader);
            }
            if (createJarParams.classpath != null) {
                String cp = createJarParams.classpath;
                cp = cp.replace(';', ' ').replace(',', ' ');
                attr.put(new Attributes.Name("JavaFX-Class-Path"), cp);
            }
            if (createJarParams.fallbackClass != null && !createJarParams.defaultFallbackApp.equals(createJarParams.fallbackClass)) {
                attr.put(new Attributes.Name("JavaFX-Fallback-Class"), createJarParams.fallbackClass);
            }
            if (createJarParams.arguments != null) {
                int idx = 1;
                for (String arg : createJarParams.arguments) {
                    attr.put(new Attributes.Name("JavaFX-Argument-" + idx), this.encodeAsBase64(arg.getBytes()));
                    ++idx;
                }
            }
            if (createJarParams.params != null) {
                int idx = 1;
                for (Param p : createJarParams.params) {
                    if (p.name == null) continue;
                    attr.put(new Attributes.Name("JavaFX-Parameter-Name-" + idx), this.encodeAsBase64(p.name.getBytes()));
                    if (p.value != null) {
                        attr.put(new Attributes.Name("JavaFX-Parameter-Value-" + idx), this.encodeAsBase64(p.value.getBytes()));
                    }
                    ++idx;
                }
            }
        } else {
            attr.put(Attributes.Name.MAIN_CLASS, createJarParams.applicationClass);
        }
        if (createJarParams.css2bin) {
            try {
                this.bssTmpDir = File.createTempFile("bssfiles", "");
            }
            catch (IOException ex) {
                throw new PackagerException(ex, "ERR_CreatingTempFileFailed", new String[0]);
            }
            this.bssTmpDir.delete();
        }
        if (applicationJar.exists() && !applicationJar.delete()) {
            throw new PackagerException("ERR_CantDeleteFile", createJarParams.outfile);
        }
        try {
            this.jar(m, createJarParams.resources, new JarOutputStream(new FileOutputStream(applicationJar)), Filter.ALL);
        }
        catch (IOException ex) {
            throw new PackagerException(ex, "ERR_CreatingJarFailed", createJarParams.outfile);
        }
        PackagerLib.deleteDirectory(this.bssTmpDir);
        PackagerLib.deleteDirectory(this.tmpDir);
        this.createJarParams = null;
    }

    private String readTextFile(File in) throws PackagerException {
        StringBuilder sb = new StringBuilder();
        InputStreamReader isr = null;
        try {
            int len;
            char[] buf = new char[16384];
            isr = new InputStreamReader(new FileInputStream(in));
            while ((len = isr.read(buf)) > 0) {
                sb.append(buf, sb.length(), len);
            }
        }
        catch (IOException ex) {
            throw new PackagerException(ex, "ERR_FileReadFailed", in.getAbsolutePath());
        }
        finally {
            if (isr != null) {
                try {
                    isr.close();
                }
                catch (IOException ex) {}
            }
        }
        return sb.toString();
    }

    private String processTemplate(String inpText, Map<TemplatePlaceholders, String> templateStrings) {
        String corePattern = "(#[\\w\\.\\(\\)]+#)";
        String prefixGeneric = "[\\/\\*-<\\!]*[ \\t]*";
        String suffixGeneric = "[ \\t]*[\\*\\/>-]*";
        Pattern mainPattern = Pattern.compile(prefixGeneric + corePattern + suffixGeneric);
        Matcher m = mainPattern.matcher(inpText);
        StringBuffer result = new StringBuffer();
        while (m.find()) {
            String idPart;
            String match = m.group();
            String coreMatch = m.group(1);
            boolean inComment = match.startsWith("<!--") && match.endsWith("-->") || match.startsWith("//") || match.startsWith("/*") && match.endsWith(" */");
            String coreReplacement = null;
            String[] parts = coreMatch.substring(1, coreMatch.length() - 1).split("[\\(\\)]");
            String rulePart = parts[0];
            String string = idPart = parts.length == 1 ? null : parts[1];
            if (templateStrings.containsKey((Object)TemplatePlaceholders.fromString(rulePart)) && (idPart == null || idPart.equals(this.deployParams.appId))) {
                coreReplacement = templateStrings.get((Object)TemplatePlaceholders.fromString(rulePart));
            }
            if (coreReplacement == null) continue;
            if (inComment || coreMatch.length() == match.length()) {
                m.appendReplacement(result, coreReplacement);
                continue;
            }
            int pp = match.indexOf(coreMatch);
            String v = match.substring(0, pp) + coreReplacement + match.substring(pp + coreMatch.length());
            m.appendReplacement(result, v);
        }
        m.appendTail(result);
        return result.toString();
    }

    public void generateDeploymentPackages(DeployParams deployParams) throws PackagerException {
        if (deployParams == null) {
            throw new IllegalArgumentException("Parameters must not be null.");
        }
        this.deployParams = deployParams;
        boolean templateOn = !deployParams.templates.isEmpty();
        EnumMap<TemplatePlaceholders, String> templateStrings = null;
        if (templateOn) {
            templateStrings = new EnumMap<TemplatePlaceholders, String>(TemplatePlaceholders.class);
        }
        try {
            PrintStream jnlp_ps;
            String jnlp_filename_webstart = deployParams.outfile + ".jnlp";
            String jnlp_filename_browser = deployParams.isSwingApp ? deployParams.outfile + "_browser.jnlp" : jnlp_filename_webstart;
            String html_filename = deployParams.outfile + ".html";
            File odir = deployParams.outdir;
            odir.mkdirs();
            if (deployParams.includeDT) {
                this.extractWebFiles();
            }
            ByteArrayOutputStream jnlp_bos_webstart = new ByteArrayOutputStream();
            ByteArrayOutputStream jnlp_bos_browser = new ByteArrayOutputStream();
            if (deployParams.isSwingApp) {
                jnlp_ps = new PrintStream(jnlp_bos_webstart);
                this.generateJNLP(jnlp_ps, jnlp_filename_webstart, Mode.SwingAPP);
                jnlp_ps.close();
                this.save(jnlp_filename_webstart, jnlp_bos_webstart.toByteArray());
                jnlp_ps = new PrintStream(jnlp_bos_browser);
                this.generateJNLP(jnlp_ps, jnlp_filename_browser, Mode.APPLET);
                jnlp_ps.close();
                this.save(jnlp_filename_browser, jnlp_bos_browser.toByteArray());
            } else {
                jnlp_ps = new PrintStream(jnlp_bos_browser);
                this.generateJNLP(jnlp_ps, jnlp_filename_browser, Mode.FX);
                jnlp_ps.close();
                this.save(jnlp_filename_browser, jnlp_bos_browser.toByteArray());
                jnlp_bos_webstart = jnlp_bos_browser;
            }
            if (!deployParams.isExtension) {
                ByteArrayOutputStream html_bos = new ByteArrayOutputStream();
                PrintStream html_ps = new PrintStream(html_bos);
                this.generateHTML(html_ps, jnlp_bos_browser.toByteArray(), jnlp_filename_browser, jnlp_bos_webstart.toByteArray(), jnlp_filename_webstart, templateStrings, deployParams.isSwingApp);
                html_ps.close();
                if (templateOn) {
                    for (DeployParams.Template t : deployParams.templates) {
                        File out = t.out;
                        if (out == null) {
                            System.out.println("Perform inplace substitution for " + t.in.getAbsolutePath());
                            out = t.in;
                        }
                        this.save(out, this.processTemplate(this.readTextFile(t.in), templateStrings).getBytes());
                    }
                } else {
                    this.save(html_filename, html_bos.toByteArray());
                }
            }
            for (DeployResource resource : deployParams.resources) {
                PackagerLib.copyFiles(resource, deployParams.outdir);
            }
        }
        catch (Exception ex) {
            throw new PackagerException(ex, "ERR_DeployFailed", new String[0]);
        }
        BundleParams bp = deployParams.getBundleParams();
        if (bp != null) {
            this.generateNativeBundles(deployParams.outdir, bp, deployParams.verbose);
        }
        this.deployParams = null;
    }

    private void generateNativeBundles(File outdir, BundleParams bp, boolean verbose) {
        outdir = new File(outdir, "bundles");
        Log.info("Using base JDK at: " + bp.getRuntime().getBaseDirectory().getAbsolutePath());
        if (Log.isDebug()) {
            bp.getRuntime().dump();
        }
        List<Bundler> bundlers = Bundler.get(bp, Log.isDebug() || verbose);
        for (Bundler b : bundlers) {
            b.bundle(bp, outdir);
        }
    }

    private static void copyFiles(DeployResource resource, File outdir) throws IOException, PackagerException {
        if (resource.getFile().isDirectory()) {
            File baseDir = resource.getBaseDir();
            for (File file : resource.getFile().listFiles()) {
                PackagerLib.copyFiles(new DeployResource(baseDir, file), outdir);
            }
        } else {
            File srcFile = resource.getFile();
            if (srcFile.exists() && srcFile.isFile()) {
                File destFile = new File(outdir, resource.getRelativePath());
                if (!srcFile.getCanonicalFile().equals(destFile.getCanonicalFile())) {
                    PackagerLib.copyFileToOutDir(new FileInputStream(srcFile), destFile);
                } else {
                    Log.verbose("Skip jar copy to itself: " + resource.getRelativePath());
                }
            }
        }
    }

    public void generateBSS(CreateBSSParams params) throws PackagerException {
        if (params == null) {
            throw new IllegalArgumentException("Parameters must not be null.");
        }
        this.createBssParams = params;
        this.createBinaryCss(this.createBssParams.resources, this.createBssParams.outdir);
        this.createBssParams = null;
    }

    public void signJar(SignJarParams params) throws PackagerException {
        try {
            JarSignature signature = this.retrieveSignature(params);
            for (PackagerResource pr : params.resources) {
                this.signFile(pr, signature, params.outdir, params.verbose);
            }
        }
        catch (Exception ex) {
            throw new PackagerException("ERR_SignFailed");
        }
    }

    private JarSignature retrieveSignature(SignJarParams params) throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException, IOException, CertificateException, InvalidKeyException {
        if (params.keyPass == null) {
            params.keyPass = params.storePass;
        }
        KeyStore store = KeyStore.getInstance(params.storeType);
        store.load(new FileInputStream(params.keyStore), params.storePass.toCharArray());
        Certificate[] chain = store.getCertificateChain(params.alias);
        X509Certificate[] certChain = new X509Certificate[chain.length];
        for (int i = 0; i < chain.length; ++i) {
            certChain[i] = (X509Certificate)chain[i];
        }
        PrivateKey privateKey = (PrivateKey)store.getKey(params.alias, params.keyPass.toCharArray());
        return JarSignature.create(privateKey, certChain);
    }

    private void signFile(PackagerResource pr, JarSignature signature, File outdir, boolean verbose) throws NoSuchAlgorithmException, IOException, SignatureException {
        if (pr.getFile().isDirectory()) {
            for (File innerFile : pr.getFile().listFiles()) {
                this.signFile(new PackagerResource(pr.getBaseDir(), innerFile), signature, outdir, verbose);
            }
        } else {
            File destJar;
            File jar = pr.getFile();
            File parent = jar.getParentFile();
            String name = "bsigned_" + jar.getName();
            File signedJar = new File(parent, name);
            System.out.println("Signing (BLOB) " + jar.getPath());
            this.signAsBLOB(jar, signedJar, signature);
            if (outdir != null) {
                destJar = new File(outdir, pr.getRelativePath());
            } else {
                jar.delete();
                destJar = jar;
            }
            destJar.delete();
            destJar.getParentFile().mkdirs();
            signedJar.renameTo(destJar);
            if (verbose) {
                System.out.println("Signed as " + destJar.getPath());
            }
        }
    }

    private void signAsBLOB(final File jar, File signedJar, JarSignature signature) throws IOException, NoSuchAlgorithmException, SignatureException {
        if (signature == null) {
            throw new IllegalStateException("Should retrieve signature first");
        }
        JarSignature.InputStreamSource in = new JarSignature.InputStreamSource(){

            public InputStream getInputStream() throws IOException {
                return new FileInputStream(jar);
            }
        };
        if (!signedJar.isFile()) {
            signedJar.createNewFile();
        }
        FileOutputStream fos = new FileOutputStream(signedJar);
        signature.signJarAsBLOB(in, new ZipOutputStream(fos));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void makeAll(MakeAllParams makeAllParams) throws PackagerException {
        String exe = System.getProperty("os.name").startsWith("Windows") ? ".exe" : "";
        String jHome = System.getenv("JAVA_HOME");
        if (jHome == null) {
            jHome = System.getProperty("java.home");
        }
        if (jHome == null) {
            throw new PackagerException("ERR_MissingJavaHome");
        }
        File javac = new File(new File(jHome), "bin/javac" + exe);
        String jfxHome = System.getenv("JAVAFX_HOME");
        if (jfxHome == null) {
            jfxHome = System.getProperty("javafx.home");
        }
        if (jfxHome == null) {
            throw new PackagerException("ERR_MissingJavaFxHome");
        }
        String srcDirName = "src";
        String compiledDirName = "compiled";
        String distDirName = "dist";
        String outfileName = "dist";
        String jarName = "dist.jar";
        File distDir = new File("dist");
        File compiledDir = new File("compiled");
        compiledDir.mkdir();
        try {
            int ret;
            File tmpFile = File.createTempFile("javac", "sources", new File("."));
            tmpFile.deleteOnExit();
            FileWriter sources = new FileWriter(tmpFile);
            try {
                PackagerLib.scanAndCopy(new PackagerResource(new File("src"), "."), sources, compiledDir);
            }
            finally {
                sources.close();
            }
            if (makeAllParams.verbose) {
                System.out.println("Executing javac:");
                System.out.format("%s %s %s %s %s %s %s %s %s %s\n", javac.getAbsolutePath(), "-target", "1.5", "-source", "1.5", "-d", "compiled", "-cp", jfxHome + "/../rt/lib/jfxrt.jar", "@" + tmpFile.getAbsolutePath());
            }
            if ((ret = PackagerLib.execute(javac.getAbsolutePath(), "-target", "1.5", "-source", "1.5", "-d", "compiled", "-cp", jfxHome + "/../rt/lib/jfxrt.jar", "@" + tmpFile.getAbsolutePath())) != 0) {
                throw new PackagerException("ERR_JavacFailed", Integer.toString(ret));
            }
        }
        catch (Exception e) {
            throw new PackagerException(e, "ERR_MakeAllJavacFailed", new String[0]);
        }
        CreateJarParams cjp = new CreateJarParams();
        cjp.applicationClass = makeAllParams.appClass;
        cjp.preloader = makeAllParams.preloader;
        cjp.classpath = makeAllParams.classpath;
        cjp.css2bin = false;
        cjp.outdir = distDir;
        cjp.outfile = "dist.jar";
        cjp.addResource(compiledDir, ".");
        this.packageAsJar(cjp);
        DeployParams dp = new DeployParams();
        dp.applicationClass = makeAllParams.appClass;
        dp.appName = makeAllParams.appName;
        dp.description = "Application description";
        dp.height = makeAllParams.height;
        dp.width = makeAllParams.width;
        dp.vendor = "Application vendor";
        dp.outdir = distDir;
        dp.outfile = "dist";
        dp.addResource(distDir, "dist.jar");
        dp.setBundleType(Bundler.BundleType.ALL);
        this.generateDeploymentPackages(dp);
        PackagerLib.deleteDirectory(compiledDir);
    }

    private static int execute(Object ... args) throws IOException, InterruptedException {
        ArrayList<String> argsList = new ArrayList<String>();
        for (Object a : args) {
            if (a instanceof List) {
                argsList.addAll((List)a);
                continue;
            }
            if (!(a instanceof String)) continue;
            argsList.add((String)a);
        }
        Process p = Runtime.getRuntime().exec(argsList.toArray(new String[argsList.size()]));
        final BufferedReader in = new BufferedReader(new InputStreamReader(p.getInputStream()));
        Thread t = new Thread(new Runnable(){

            public void run() {
                try {
                    String line;
                    while ((line = in.readLine()) != null) {
                        System.out.println(line);
                    }
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
            }
        });
        t.setDaemon(true);
        t.start();
        final BufferedReader err = new BufferedReader(new InputStreamReader(p.getErrorStream()));
        t = new Thread(new Runnable(){

            public void run() {
                try {
                    String line;
                    while ((line = err.readLine()) != null) {
                        System.err.println(line);
                    }
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
            }
        });
        t.setDaemon(true);
        t.start();
        return p.waitFor();
    }

    private static void scanAndCopy(PackagerResource dir, Writer out, File outdir) throws PackagerException {
        if (!dir.getFile().exists()) {
            throw new PackagerException("ERR_MissingDirectory", dir.getFile().getName());
        }
        if (dir.getFile().listFiles() == null || dir.getFile().listFiles().length == 0) {
            throw new PackagerException("ERR_EmptySourceDirectory", dir.getFile().getName());
        }
        try {
            for (File f : dir.getFile().listFiles()) {
                if (f.isDirectory()) {
                    PackagerLib.scanAndCopy(new PackagerResource(dir.getBaseDir(), f), out, outdir);
                    continue;
                }
                if (f.getName().endsWith(".java")) {
                    out.write('\'' + f.getAbsolutePath().replace('\\', '/') + "'\n");
                    continue;
                }
                PackagerLib.copyFileToOutDir(new FileInputStream(f), new File(outdir.getPath() + File.separator + dir.getRelativePath() + File.separator + f.getName()));
            }
        }
        catch (IOException ex) {
            throw new PackagerException("ERR_FileCopyFailed", dir.getFile().getName());
        }
    }

    private String getJvmArguments(boolean includeProperties) {
        StringBuilder sb = new StringBuilder();
        for (String v : this.deployParams.jvmargs) {
            sb.append(v);
            sb.append(" ");
        }
        if (includeProperties) {
            for (String k : this.deployParams.properties.keySet()) {
                sb.append("-D");
                sb.append(k);
                sb.append("=");
                sb.append(this.deployParams.properties.get(k));
                sb.append(" ");
            }
        }
        if (sb.length() > 0) {
            return sb.toString();
        }
        return null;
    }

    private void generateJNLP(PrintStream out, String jnlp_filename, Mode m) throws IOException, CertificateEncodingException {
        out.println("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
        out.println("<jnlp spec=\"1.0\" xmlns:jfx=\"http://javafx.com\" href=\"" + jnlp_filename + "\">");
        out.println("  <information>");
        out.println("    <title>" + (this.deployParams.title != null ? this.deployParams.title : "Sample JavaFX Application") + "</title>");
        out.println("    <vendor>" + (this.deployParams.vendor != null ? this.deployParams.vendor : "Unknown vendor") + "</vendor>");
        out.println("    <description>" + (this.deployParams.description != null ? this.deployParams.description : "Sample JavaFX 2.0 application.") + "</description>");
        for (DeployParams.Icon i : this.deployParams.icons) {
            if (i.mode != DeployParams.RunMode.WEBSTART && i.mode != DeployParams.RunMode.ALL) continue;
            out.println("    <icon href=\"" + i.href + "\" " + (i.kind != null ? " kind=\"" + i.kind + "\"" : "") + (i.width != -1 ? " width=\"" + i.width + "\"" : "") + (i.height != -1 ? " height=\"" + i.height + "\"" : "") + (i.depth != -1 ? " depth=\"" + i.depth + "\"" : "") + "/>");
        }
        if (this.deployParams.offlineAllowed && !this.deployParams.isExtension) {
            out.println("    <offline-allowed/>");
        }
        out.println("  </information>");
        if (!this.deployParams.isExtension) {
            out.println("  <resources>");
            out.println("    <jfx:javafx-runtime version=\"" + this.deployParams.fxPlatform + "\" href=\"http://javadl.sun.com/webapps/download/GetFile/javafx-latest/windows-i586/javafx2.jnlp\"/>");
            out.println("  </resources>");
        }
        boolean openTag = false;
        boolean needToCloseResourceTag = false;
        if (!this.deployParams.isExtension) {
            out.println("  <resources>");
            openTag = true;
            needToCloseResourceTag = true;
            String vmargs = this.getJvmArguments(false);
            vmargs = vmargs == null ? "" : " java-vm-args=\"" + vmargs + "\" ";
            out.println("    <j2se version=\"" + this.deployParams.jrePlatform + "\"" + vmargs + " href=\"http://java.sun.com/products/autodl/j2se\"/>");
            for (String k : this.deployParams.properties.keySet()) {
                out.println("    <property name=\"" + k + "\" value=\"" + this.deployParams.properties.get(k) + "\"/>");
            }
        }
        String currentOS = null;
        String currentArch = null;
        String pendingPrint = null;
        for (DeployResource resource : this.deployParams.resources) {
            File srcFile;
            if (!openTag || currentOS == null && resource.getOs() != null || currentOS != null && !currentOS.equals(resource.getOs()) || currentArch == null && resource.getArch() != null || currentArch != null && !currentArch.equals(resource.getArch())) {
                pendingPrint = openTag ? "  </resources>\n" : "";
                currentOS = resource.getOs();
                currentArch = resource.getArch();
                pendingPrint = pendingPrint + "  <resources" + (currentOS != null ? " os=\"" + currentOS + "\"" : "") + (currentArch != null ? " arch=\"" + currentArch + "\"" : "") + ">";
            }
            if (!(srcFile = resource.getFile()).exists() || !srcFile.isFile()) continue;
            String relativePath = resource.getRelativePath();
            DeployResource.Type type = resource.getType();
            switch (type) {
                case jar: {
                    if (pendingPrint != null) {
                        out.print(pendingPrint);
                        pendingPrint = null;
                        needToCloseResourceTag = true;
                    }
                    out.print("    <jar href=\"" + relativePath + "\" size=\"" + srcFile.length() + "\"");
                    out.print(" download=\"" + resource.getMode() + "\" ");
                    out.println("/>");
                    break;
                }
                case jnlp: {
                    if (pendingPrint != null) {
                        out.print(pendingPrint);
                        pendingPrint = null;
                        needToCloseResourceTag = true;
                    }
                    out.println("    <extension href=\"" + relativePath + "\"/>");
                    break;
                }
                case nativelib: {
                    if (pendingPrint != null) {
                        out.print(pendingPrint);
                        needToCloseResourceTag = true;
                        pendingPrint = null;
                    }
                    out.println("    <nativelib href=\"" + relativePath + "\"/>");
                }
            }
        }
        if (needToCloseResourceTag) {
            out.println("  </resources>");
        }
        if (this.deployParams.allPermissions) {
            out.println("<security>");
            out.println("  <all-permissions/>");
            this.processEmbeddedCertificates(out);
            out.println("</security>");
        }
        if (this.deployParams.needShortcut) {
            out.println("  <shortcut><desktop/></shortcut>");
        }
        if (!this.deployParams.isExtension) {
            if (m == Mode.APPLET) {
                out.print("  <applet-desc  width=\"" + this.deployParams.width + "\" height=\"" + this.deployParams.height + "\"");
                out.print(" main-class=\"" + this.deployParams.applicationClass + "\" ");
                out.println(" name=\"" + this.deployParams.appName + "\" >");
                if (this.deployParams.params != null) {
                    for (Param p : this.deployParams.params) {
                        out.println("    <param name=\"" + p.name + "\"" + (p.value != null ? " value=\"" + p.value + "\"" : "") + "/>");
                    }
                }
                out.println("  </applet-desc>");
            } else if (m == Mode.SwingAPP) {
                out.print("  <application-desc main-class=\"" + this.deployParams.applicationClass + "\" ");
                out.println(" name=\"" + this.deployParams.appName + "\" >");
                if (this.deployParams.arguments != null) {
                    for (String a : this.deployParams.arguments) {
                        out.println("    <argument>" + a + "</argument>");
                    }
                }
                out.println("  </application-desc>");
            } else {
                if (this.deployParams.fallbackApp != null) {
                    out.print("  <applet-desc  width=\"" + this.deployParams.width + "\" height=\"" + this.deployParams.height + "\"");
                    out.print(" main-class=\"" + this.deployParams.fallbackApp + "\" ");
                    out.println(" name=\"" + this.deployParams.appName + "\" >");
                    out.println("    <param name=\"requiredFXVersion\" value=\"" + this.deployParams.fxPlatform + "\"/>");
                    out.println("  </applet-desc>");
                }
                out.print("  <jfx:javafx-desc  width=\"" + this.deployParams.width + "\" height=\"" + this.deployParams.height + "\"");
                out.print(" main-class=\"" + this.deployParams.applicationClass + "\" ");
                out.print(" name=\"" + this.deployParams.appName + "\" ");
                if (this.deployParams.preloader != null) {
                    out.print(" preloader-class=\"" + this.deployParams.preloader + "\"");
                }
                if ((this.deployParams.params == null || this.deployParams.params.isEmpty()) && (this.deployParams.arguments == null || this.deployParams.arguments.isEmpty())) {
                    out.println("/>");
                } else {
                    out.println(">");
                    if (this.deployParams.params != null) {
                        for (Param p : this.deployParams.params) {
                            out.println("    <fx:param name=\"" + p.name + "\"" + (p.value != null ? " value=\"" + p.value + "\"" : "") + "/>");
                        }
                    }
                    if (this.deployParams.arguments != null) {
                        for (String a : this.deployParams.arguments) {
                            out.println("    <fx:argument>" + a + "</fx:argument>");
                        }
                    }
                    out.println("  </jfx:javafx-desc>");
                }
            }
        } else {
            out.println("<component-desc/>");
        }
        out.println("  <update check=\"" + this.deployParams.updateMode + "\"/>");
        out.println("</jnlp>");
    }

    private void addToList(List<String> l, String name, String value, boolean isString) {
        String s = isString ? "'" : "";
        String v = name + " : " + s + value + s;
        l.add(v);
    }

    private String listToString(List<String> lst, String offset) {
        StringBuilder b = new StringBuilder();
        if (lst == null || lst.isEmpty()) {
            return offset + "{}";
        }
        b.append(offset).append("{\n");
        boolean first = true;
        for (String s : lst) {
            if (!first) {
                b.append(",\n");
            }
            first = false;
            b.append(offset).append("    ");
            b.append(s);
        }
        b.append("\n");
        b.append(offset).append("}");
        return b.toString();
    }

    private String encodeAsBase64(byte[] inp) {
        BASE64Encoder encoder = new BASE64Encoder();
        return encoder.encode(inp);
    }

    private void generateHTML(PrintStream out, byte[] jnlp_bytes_browser, String jnlpfile_browser, byte[] jnlp_bytes_webstart, String jnlpfile_webstart, Map<TemplatePlaceholders, String> templateStrings, boolean swingMode) {
        String poff = "    ";
        String poff2 = poff + poff;
        String poff3 = poff2 + poff;
        StringBuilder out_embed_dynamic = new StringBuilder();
        StringBuilder out_embed_onload = new StringBuilder();
        StringBuilder out_launch_code = new StringBuilder();
        String appletParams = this.getAppletParameters();
        String jnlp_content_browser = null;
        String jnlp_content_webstart = null;
        if (this.deployParams.embedJNLP) {
            jnlp_content_browser = this.encodeAsBase64(jnlp_bytes_browser).replaceAll("\\r|\\n", "");
            jnlp_content_webstart = this.encodeAsBase64(jnlp_bytes_webstart).replaceAll("\\r|\\n", "");
        }
        out.println("<html><head>");
        String dtURL = this.deployParams.includeDT ? EMBEDDED_DT : PUBLIC_DT;
        String includeDtString = "<SCRIPT src=\"" + dtURL + "\"></SCRIPT>";
        if (templateStrings != null) {
            templateStrings.put(TemplatePlaceholders.SCRIPT_URL, dtURL);
            templateStrings.put(TemplatePlaceholders.SCRIPT_CODE, includeDtString);
        }
        out.println("  " + includeDtString);
        String webstartError = "System is not setup to launch JavaFX applications. Make sure that you have a recent Java runtime, then install JavaFX Runtime 2.0 and check that JavaFX is enabled in the Java Control Panel.";
        ArrayList<String> w_app = new ArrayList<String>();
        ArrayList<String> w_platform = new ArrayList<String>();
        ArrayList<String> w_callback = new ArrayList<String>();
        this.addToList(w_app, "url", jnlpfile_webstart, true);
        if (jnlp_content_webstart != null) {
            this.addToList(w_app, "jnlp_content", jnlp_content_webstart, true);
        }
        this.addToList(w_platform, "javafx", this.deployParams.fxPlatform, true);
        String vmargs = this.getJvmArguments(true);
        if (vmargs != null) {
            this.addToList(w_platform, "jvmargs", vmargs, true);
        }
        if (!"".equals(appletParams)) {
            this.addToList(w_app, "params", "{" + appletParams + "}", false);
        }
        if (this.deployParams.callbacks != null && !this.deployParams.callbacks.isEmpty()) {
            for (Callback cb : this.deployParams.callbacks) {
                this.addToList(w_callback, cb.getName(), cb.getCmd(), false);
            }
        }
        out_launch_code.append(poff2).append("dtjava.launch(");
        out_launch_code.append(this.listToString(w_app, poff3)).append(",\n");
        out_launch_code.append(this.listToString(w_platform, poff3)).append(",\n");
        out_launch_code.append(this.listToString(w_callback, poff3)).append("\n");
        out_launch_code.append(poff2).append(");\n");
        out.println("<script>");
        out.println(poff + "function launchApplication(jnlpfile) {");
        out.print(out_launch_code.toString());
        out.println(poff2 + "return false;");
        out.println(poff + "}");
        out.println("</script>");
        if (templateStrings != null) {
            templateStrings.put(TemplatePlaceholders.LAUNCH_CODE, out_launch_code.toString());
        }
        String appId = this.deployParams.appId;
        String placeholder = this.deployParams.placeholder;
        if (placeholder == null) {
            placeholder = "'javafx-app-placeholder'";
        }
        ArrayList<String> p_app = new ArrayList<String>();
        ArrayList<String> p_platform = new ArrayList<String>();
        ArrayList<String> p_callback = new ArrayList<String>();
        if (appId != null) {
            this.addToList(p_app, "id", appId, true);
        }
        if (this.deployParams.isSwingApp) {
            this.addToList(p_app, "toolkit", "swing", true);
        }
        this.addToList(p_app, "url", jnlpfile_browser, true);
        this.addToList(p_app, "placeholder", placeholder, false);
        if (this.deployParams.embeddedWidth != null && this.deployParams.embeddedHeight != null) {
            this.addToList(p_app, "width", "" + this.deployParams.embeddedWidth, true);
            this.addToList(p_app, "height", "" + this.deployParams.embeddedHeight, true);
        } else {
            this.addToList(p_app, "width", "" + this.deployParams.width, false);
            this.addToList(p_app, "height", "" + this.deployParams.height, false);
        }
        if (jnlp_content_browser != null) {
            this.addToList(p_app, "jnlp_content", jnlp_content_browser, true);
        }
        this.addToList(p_platform, "javafx", this.deployParams.fxPlatform, true);
        if (vmargs != null) {
            this.addToList(p_platform, "jvmargs", vmargs, true);
        }
        if (this.deployParams.callbacks != null && !this.deployParams.callbacks.isEmpty()) {
            for (Callback cb : this.deployParams.callbacks) {
                this.addToList(p_callback, cb.getName(), cb.getCmd(), false);
            }
        }
        if (!"".equals(appletParams)) {
            this.addToList(p_app, "params", "{" + appletParams + "}", false);
        }
        if (swingMode) {
            boolean needOnGetSplashImpl = true;
            if (this.deployParams.callbacks != null) {
                for (Callback c : this.deployParams.callbacks) {
                    if (!"onGetSplash".equals(c.getName())) continue;
                    needOnGetSplashImpl = false;
                }
            }
            if (needOnGetSplashImpl) {
                this.addToList(p_callback, "onGetSplash", "function() {}", false);
            }
        }
        out_embed_dynamic.append("dtjava.embed(\n");
        out_embed_dynamic.append(this.listToString(p_app, poff3)).append(",\n");
        out_embed_dynamic.append(this.listToString(p_platform, poff3)).append(",\n");
        out_embed_dynamic.append(this.listToString(p_callback, poff3)).append("\n");
        out_embed_dynamic.append(poff2).append(");\n");
        String embedFuncName = "javafxEmbed" + (this.deployParams.appId != null ? "_" + this.deployParams.appId : "");
        out_embed_onload.append("\n<script>\n");
        out_embed_onload.append(poff).append("function ").append(embedFuncName).append("() {\n");
        out_embed_onload.append(poff2);
        out_embed_onload.append((CharSequence)out_embed_dynamic);
        out_embed_onload.append(poff).append("}\n");
        out_embed_onload.append(poff).append("<!-- Embed FX application into web page once page is loaded -->\n");
        out_embed_onload.append(poff).append("dtjava.addOnloadCallback(").append(embedFuncName).append(");\n");
        out_embed_onload.append("</script>\n");
        if (templateStrings != null) {
            templateStrings.put(TemplatePlaceholders.EMBED_CODE_ONLOAD, out_embed_onload.toString());
            templateStrings.put(TemplatePlaceholders.EMBED_CODE_DYNAMIC, out_embed_dynamic.toString());
        }
        out.println(out_embed_onload.toString());
        out.println("</head><body>");
        out.println("<h2>Test page for <b>" + this.deployParams.appName + "</b></h2>");
        String launchString = "return launchApplication('" + jnlpfile_webstart + "');";
        out.println("  <b>Webstart:</b> <a href='" + jnlpfile_webstart + "' onclick=\"" + launchString + "\">" + "click to launch this app as webstart</a><br><hr><br>");
        out.println("");
        out.println("  <!-- Applet will be inserted here -->");
        out.println("  <div id=" + placeholder + "></div>");
        out.println("</body></html>");
    }

    private void save(String fname, byte[] content) throws IOException {
        File odir = this.deployParams.outdir;
        this.save(new File(odir, fname), content);
    }

    private void save(File f, byte[] content) throws IOException {
        if (f.exists()) {
            f.delete();
        }
        FileOutputStream fos = new FileOutputStream(f);
        fos.write(content);
        fos.close();
    }

    private static void copyFileToOutDir(InputStream is, File fout) throws PackagerException {
        FileOutputStream out = null;
        File outDir = fout.getParentFile();
        try {
            int len;
            if (!outDir.exists() && !outDir.mkdirs()) {
                throw new PackagerException("ERR_CreatingDirFailed", outDir.getPath());
            }
            out = new FileOutputStream(fout);
            byte[] buf = new byte[16384];
            while ((len = is.read(buf)) > 0) {
                ((OutputStream)out).write(buf, 0, len);
            }
        }
        catch (IOException ex) {
            throw new PackagerException(ex, "ERR_FileCopyFailed", outDir.getPath());
        }
        finally {
            try {
                is.close();
            }
            catch (IOException ex) {}
            if (out != null) {
                try {
                    ((OutputStream)out).close();
                }
                catch (IOException ex) {}
            }
        }
    }

    private String getAppletParameters() {
        String result = "";
        if (this.deployParams.htmlParams != null) {
            for (HtmlParam p : this.deployParams.htmlParams) {
                if (!result.isEmpty()) {
                    result = result + ", ";
                }
                String escape = p.needEscape ? "\"" : "";
                result = result + "\"" + p.name + "\": " + escape + p.value + escape;
            }
        }
        return result;
    }

    void extractEmbeddedClass(File root, String name) throws PackagerException {
        String nm = prefix_in_antjar + name;
        InputStream is = PackagerLib.class.getResourceAsStream(nm);
        if (is == null) {
            System.err.println("Internal error. Missing embedded resource [" + nm + "]");
        } else {
            PackagerLib.copyFileToOutDir(is, new File(root, name));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jar(Manifest manifest, List<PackagerResource> files, JarOutputStream jar, Filter filter) throws IOException, PackagerException {
        try {
            jar.putNextEntry(new ZipEntry("META-INF/"));
            jar.closeEntry();
            jar.putNextEntry(new ZipEntry("META-INF/MANIFEST.MF"));
            manifest.write(jar);
            jar.closeEntry();
            this.alreadyAddedEntries.add("META-INF/");
            for (PackagerResource pr : files) {
                this.jar(pr.getFile(), jar, filter, pr.getBaseDir().getAbsolutePath().length() + 1);
            }
            if (this.createJarParams.embedLauncher) {
                this.jar(this.tmpDir, jar, Filter.ALL, this.tmpDir.getAbsolutePath().length() + 1);
            }
        }
        finally {
            jar.close();
            this.alreadyAddedEntries.clear();
        }
    }

    private void createParentEntries(String relativePath, JarOutputStream jar) throws IOException {
        String[] pathComponents = relativePath.split("/");
        StringBuilder pathSB = new StringBuilder();
        for (int i = 0; i < pathComponents.length - 1; ++i) {
            pathSB.append(pathComponents[i]).append("/");
            if (!this.alreadyAddedEntries.contains(pathSB.toString())) {
                jar.putNextEntry(new ZipEntry(pathSB.toString()));
                jar.closeEntry();
            }
            this.alreadyAddedEntries.add(pathSB.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jar(File f, JarOutputStream jar, Filter filter, int cut) throws IOException, PackagerException {
        if (!f.exists()) {
            throw new FileNotFoundException("Input folder does not exist [" + f.getAbsolutePath() + "]");
        }
        if (f.isDirectory()) {
            for (File innerFile : f.listFiles()) {
                this.jar(innerFile, jar, filter, cut);
            }
        } else if (filter == Filter.ALL || filter == Filter.CLASSES_ONLY && f.getName().endsWith(".class") || filter == Filter.RESOURCES && this.isResource(f.getAbsolutePath())) {
            String absPath = f.getAbsolutePath();
            if (absPath.endsWith("META-INF\\MANIFEST.MF") || absPath.endsWith("META-INF/MANIFEST.MF")) {
                return;
            }
            this.createParentEntries(absPath.substring(cut).replace('\\', '/'), jar);
            if (this.createJarParams.css2bin && f.getName().endsWith(".css")) {
                int startOfExt = absPath.lastIndexOf(".") + 1;
                String bssFileName = absPath.substring(cut, startOfExt).concat("bss");
                File bssFile = new File(this.bssTmpDir, bssFileName);
                bssFile.getParentFile().mkdirs();
                this.createBinaryCss(absPath, bssFile.getAbsolutePath());
                jar.putNextEntry(new ZipEntry(bssFileName.replace('\\', '/')));
                f = bssFile;
            } else {
                jar.putNextEntry(new ZipEntry(absPath.substring(cut).replace('\\', '/')));
            }
            byte[] b = new byte[65000];
            FileInputStream in = new FileInputStream(f);
            try {
                int i;
                while ((i = in.read(b)) > 0) {
                    jar.write(b, 0, i);
                }
            }
            finally {
                in.close();
            }
            jar.closeEntry();
        }
    }

    private void createBinaryCss(List<PackagerResource> cssResources, File outdir) throws PackagerException {
        for (PackagerResource cssRes : cssResources) {
            String relPath = cssRes.getRelativePath();
            this.createBinaryCss(cssRes.getFile(), outdir, relPath);
        }
    }

    private void createBinaryCss(File f, File outdir, String relPath) throws PackagerException {
        if (f.isDirectory()) {
            for (File innerFile : f.listFiles()) {
                this.createBinaryCss(innerFile, outdir, relPath + '/' + innerFile.getName());
            }
        } else if (f.getName().endsWith(".css")) {
            String cssFileName = f.getAbsolutePath();
            String bssFileName = new File(outdir.getAbsolutePath(), PackagerLib.replaceExtensionByBSS(relPath)).getAbsolutePath();
            this.createBinaryCss(cssFileName, bssFileName);
        }
    }

    private String getJfxrtPath() throws PackagerException {
        Class<PackagerLib> theClass = PackagerLib.class;
        String theClassFile = "PackagerLib.class";
        String classUrl = theClass.getResource(theClassFile).toString();
        if (!classUrl.startsWith("jar:file:") || classUrl.indexOf("!") == -1) {
            throw new PackagerException("ERR_CantFindRuntime");
        }
        classUrl = classUrl.substring(0, classUrl.lastIndexOf("!"));
        int lastIndexOfSlash = Math.max(classUrl.lastIndexOf("/"), classUrl.lastIndexOf("\\"));
        String jfxrtPath = classUrl.substring(0, lastIndexOfSlash) + "/../rt/lib/jfxrt.jar!/";
        return jfxrtPath;
    }

    private Class loadClassFromRuntime(String className) throws PackagerException {
        try {
            ClassLoader cl = this.getClassLoader();
            return cl.loadClass(className);
        }
        catch (ClassNotFoundException ex) {
            throw new PackagerException(ex, "ERR_CantFindRuntime", new String[0]);
        }
    }

    private void createBinaryCss(String cssFile, String binCssFile) throws PackagerException {
        Class clazz;
        String ifname = cssFile;
        String ofname = binCssFile != null ? binCssFile : PackagerLib.replaceExtensionByBSS(ifname);
        File of = new File(ofname);
        File parentFile = of.getParentFile();
        if (parentFile != null) {
            parentFile.mkdirs();
        }
        try {
            clazz = Class.forName("com.sun.javafx.css.parser.Css2Bin");
        }
        catch (ClassNotFoundException e) {
            clazz = this.loadClassFromRuntime("com.sun.javafx.css.parser.Css2Bin");
        }
        try {
            Method m = clazz.getMethod("convertToBinary", String.class, String.class);
            m.invoke(null, ifname, ofname);
        }
        catch (Exception ex) {
            Throwable causeEx = ex.getCause();
            String cause = causeEx != null ? causeEx.getMessage() : bundle.getString("ERR_UnknownReason");
            throw new PackagerException(ex, "ERR_BSSConversionFailed", cssFile, cause);
        }
    }

    private static String replaceExtensionByBSS(String cssName) {
        return cssName.substring(0, cssName.lastIndexOf(".") + 1).concat("bss");
    }

    private boolean isResource(String name) {
        if (name.endsWith(".class")) {
            return false;
        }
        if (name.endsWith(".java")) {
            return false;
        }
        if (name.endsWith(".fx")) {
            return false;
        }
        if (name.endsWith(".cvsignore")) {
            return false;
        }
        if (name.endsWith(".hgignore")) {
            return false;
        }
        if (name.endsWith("vssver.scc")) {
            return false;
        }
        if (name.endsWith(".DS_Store")) {
            return false;
        }
        if (name.endsWith("~")) {
            return false;
        }
        if ((name = name.replace('\\', '/')).indexOf("/CVS/") >= 0) {
            return false;
        }
        if (name.indexOf("/.svn/") >= 0) {
            return false;
        }
        if (name.indexOf("/.hg/") >= 0) {
            return false;
        }
        if (name.indexOf("/.#") >= 0) {
            return false;
        }
        if (name.indexOf("/._") >= 0) {
            return false;
        }
        if (name.endsWith("#") && name.indexOf("/#") >= 0) {
            return false;
        }
        if (name.endsWith("%") && name.indexOf("/%") >= 0) {
            return false;
        }
        return !name.endsWith("MANIFEST.MF");
    }

    private void extractWebFiles() throws PackagerException {
        this.doExtractWebFiles(webFiles);
    }

    private void doExtractWebFiles(String[] lst) throws PackagerException {
        File f = new File(this.deployParams.outdir, webfilesDir);
        f.mkdirs();
        for (String s : lst) {
            InputStream is = PackagerLib.class.getResourceAsStream(prefixWebFiles + s);
            if (is == null) {
                System.err.println("Internal error. Missing resources [" + prefixWebFiles + s + "]");
                continue;
            }
            PackagerLib.copyFileToOutDir(is, new File(f, s));
        }
    }

    private static boolean deleteDirectory(File dir) {
        if (dir == null || !dir.exists()) {
            return false;
        }
        if (dir.isDirectory()) {
            for (String file : dir.list()) {
                PackagerLib.deleteDirectory(new File(dir, file));
            }
        }
        return dir.delete();
    }

    private void processEmbeddedCertificates(PrintStream out) throws CertificateEncodingException, IOException {
        if (this.deployParams.embedCertificates) {
            String signed;
            Set<CertPath> certPaths = this.collectCertPaths();
            String string = signed = this.isSignedJNLP ? " signedjnlp=\"true\">" : ">";
            if (certPaths != null && !certPaths.isEmpty()) {
                out.println("  <jfx:details" + signed);
                for (CertPath cp : certPaths) {
                    String base64 = Utils.getBase64Encoded(cp);
                    out.println("     <jfx:certificate-path>" + base64 + "</jfx:certificate-path>");
                }
                out.println("  </jfx:details>");
            }
        }
    }

    private Set<CertPath> collectCertPaths() throws IOException {
        HashSet<CertPath> result = new HashSet<CertPath>();
        for (DeployResource resource : this.deployParams.resources) {
            File srcFile = resource.getFile();
            if (!srcFile.exists() || !srcFile.isFile() || !srcFile.getName().toLowerCase().endsWith("jar")) continue;
            result.addAll(this.extractCertPaths(srcFile));
        }
        return result;
    }

    private Set<CertPath> extractCertPaths(File jar) throws IOException {
        HashSet<CertPath> result = new HashSet<CertPath>();
        JarFile jf = new JarFile(jar);
        Utils.readAllFully(jf);
        boolean blobSigned = false;
        Enumeration<JarEntry> entries = jf.entries();
        while (entries.hasMoreElements()) {
            JarEntry je = entries.nextElement();
            String entryName = je.getName();
            CodeSigner[] signers = null;
            if (entryName.equalsIgnoreCase(JarSignature.BLOB_SIGNATURE)) {
                byte[] raw = Utils.getBytes(jf.getInputStream(je));
                try {
                    JarSignature js = JarSignature.load(raw);
                    blobSigned = true;
                    signers = js.getCodeSigners();
                }
                catch (Exception ex) {
                    throw new IOException(ex);
                }
            } else {
                signers = je.getCodeSigners();
            }
            result.addAll(PackagerLib.extractCertPaths(signers));
            if (entryName.equalsIgnoreCase("JNLP-INF/APPLICATION.JNLP")) {
                this.isSignedJNLP = true;
            }
            if (!blobSigned || !this.isSignedJNLP) continue;
            break;
        }
        return result;
    }

    private static Collection<CertPath> extractCertPaths(CodeSigner[] signers) {
        ArrayList<CertPath> result = new ArrayList<CertPath>();
        if (signers != null) {
            for (CodeSigner cs : signers) {
                CertPath cp = cs.getSignerCertPath();
                if (cp == null) continue;
                result.add(cp);
            }
        }
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Mode {
        FX,
        APPLET,
        SwingAPP;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Filter {
        ALL,
        CLASSES_ONLY,
        RESOURCES;

    }
}

