/*
 * Decompiled with CFR 0.152.
 */
package org.openide.loaders;

import java.awt.EventQueue;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.openide.loaders.DataNodeUtils;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.ChangeableDataFilter;
import org.openide.loaders.DataFilter;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.loaders.DataObjectPool;
import org.openide.loaders.FolderChildrenPair;
import org.openide.loaders.FolderList;
import org.openide.loaders.FolderOrder;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;
import org.openide.util.Task;
import org.openide.util.WeakListeners;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;

final class FolderChildren
extends Children.Keys<FolderChildrenPair>
implements PropertyChangeListener,
ChangeListener,
FileChangeListener {
    private FolderList folder;
    private final DataFilter filter;
    private PropertyChangeListener listener;
    private FileChangeListener fcListener;
    private ChangeListener changeListener;
    private final Logger err;
    private volatile Task refTask = Task.EMPTY;
    private static final boolean DELAYED_CREATION_ENABLED = !"false".equals(System.getProperty("org.openide.loaders.FolderChildren.delayedCreation"));

    public FolderChildren(DataFolder dataFolder) {
        this(dataFolder, DataFilter.ALL);
    }

    public FolderChildren(DataFolder dataFolder, DataFilter dataFilter) {
        super(true);
        String string = dataFolder.getPrimaryFile().isRoot() ? "org.openide.loaders.FolderChildren" : "org.openide.loaders.FolderChildren." + dataFolder.getPrimaryFile().getPath().replace('/', '.');
        this.err = Logger.getLogger(string);
        this.folder = FolderList.find(dataFolder.getPrimaryFile(), true);
        this.filter = dataFilter;
        this.listener = WeakListeners.propertyChange((PropertyChangeListener)this, (Object)this.folder);
        this.fcListener = FileUtil.weakFileChangeListener((FileChangeListener)this, (Object)this.folder.getPrimaryFile());
    }

    DataFilter getFilter() {
        return this.filter;
    }

    static void waitRefresh() {
        DataNodeUtils.reqProcessor().post((Runnable)Task.EMPTY, 0, 1).waitFinished();
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.err.log(Level.FINE, "Got a change {0}", propertyChangeEvent.getPropertyName());
        this.refreshChildren(RefreshMode.SHALLOW);
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        this.refreshChildren(RefreshMode.DEEP);
    }

    private void refreshChildren(RefreshMode refreshMode) {
        class R
        implements Runnable {
            RefreshMode op;

            R() {
            }

            @Override
            public void run() {
                if (this.op == RefreshMode.DEEP) {
                    this.op = RefreshMode.DEEP_LATER;
                    Children.MUTEX.postWriteRequest((Runnable)this);
                    return;
                }
                FolderChildren.this.err.log(Level.FINE, "refreshChildren {0}", (Object)this.op);
                try {
                    if (this.op == RefreshMode.CLEAR) {
                        FolderChildren.this.setKeys(Collections.emptyList());
                        return;
                    }
                    FileObject[] fileObjectArray = FolderChildren.this.folder.getPrimaryFile().getChildren();
                    FolderOrder folderOrder = FolderOrder.findFor(FolderChildren.this.folder.getPrimaryFile());
                    Arrays.sort(fileObjectArray, folderOrder);
                    ArrayList<FolderChildrenPair> arrayList = new ArrayList<FolderChildrenPair>(fileObjectArray.length);
                    for (FileObject fileObject : FileUtil.getOrder(Arrays.asList(fileObjectArray), (boolean)false)) {
                        DataFilter.FileBased fileBased;
                        if (FolderChildren.this.filter instanceof DataFilter.FileBased && !(fileBased = (DataFilter.FileBased)FolderChildren.this.filter).acceptFileObject(fileObject)) continue;
                        arrayList.add(new FolderChildrenPair(fileObject));
                    }
                    if (this.op == RefreshMode.DEEP_LATER) {
                        FolderChildren.this.setKeys(Collections.emptyList());
                        FolderChildren.this.setKeys(arrayList);
                        return;
                    }
                    if (this.op == RefreshMode.SHALLOW) {
                        FolderChildren.this.setKeys(arrayList);
                        return;
                    }
                    throw new IllegalStateException("Unknown op: " + (Object)((Object)this.op));
                }
                finally {
                    FolderChildren.this.err.log(Level.FINE, "refreshChildren {0}, done", (Object)this.op);
                }
            }
        }
        R r = new R();
        if (refreshMode == RefreshMode.SHALLOW_IMMEDIATE) {
            this.refTask.waitFinished();
            r.op = RefreshMode.SHALLOW;
            r.run();
        } else {
            r.op = refreshMode;
            this.refTask = DataNodeUtils.reqProcessor().post((Runnable)r);
        }
    }

    protected Node[] createNodes(FolderChildrenPair folderChildrenPair) {
        Node[] nodeArray;
        boolean bl = DELAYED_CREATION_ENABLED && EventQueue.isDispatchThread() && !folderChildrenPair.primaryFile.isFolder();
        Object object = bl ? new DelayedNode(folderChildrenPair) : this.createNode(folderChildrenPair);
        if (object == null) {
            nodeArray = null;
        } else {
            Node[] nodeArray2 = new Node[1];
            nodeArray = nodeArray2;
            nodeArray2[0] = object;
        }
        return nodeArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final Node createNode(FolderChildrenPair folderChildrenPair) {
        Node node;
        long l;
        block7: {
            l = System.currentTimeMillis();
            node = null;
            try {
                FileObject fileObject = folderChildrenPair.primaryFile;
                DataObject dataObject = DataObject.find(fileObject);
                if (!dataObject.isValid() || !fileObject.equals(dataObject.getPrimaryFile()) || this.filter != null && !this.filter.acceptDataObject(dataObject)) break block7;
                node = dataObject.getClonedNodeDelegate(this.filter);
                if (dataObject.isValid()) break block7;
                node = null;
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                try {
                    Logger.getLogger(FolderChildren.class.getName()).log(Level.FINE, null, dataObjectNotFoundException);
                }
                catch (Throwable throwable) {
                    long l2 = System.currentTimeMillis() - l;
                    if (this.err.isLoggable(Level.FINE)) {
                        this.err.log(Level.FINE, "createNodes: {0} took: {1} ms", new Object[]{folderChildrenPair, l2});
                        this.err.log(Level.FINE, "  returning: {0}", node);
                    }
                    throw throwable;
                }
                long l3 = System.currentTimeMillis() - l;
                if (this.err.isLoggable(Level.FINE)) {
                    this.err.log(Level.FINE, "createNodes: {0} took: {1} ms", new Object[]{folderChildrenPair, l3});
                    this.err.log(Level.FINE, "  returning: {0}", node);
                }
            }
        }
        long l4 = System.currentTimeMillis() - l;
        if (this.err.isLoggable(Level.FINE)) {
            this.err.log(Level.FINE, "createNodes: {0} took: {1} ms", new Object[]{folderChildrenPair, l4});
            this.err.log(Level.FINE, "  returning: {0}", node);
        }
        return node;
    }

    public Node[] getNodes(boolean bl) {
        Node[] nodeArray;
        boolean bl2;
        do {
            if (bl) {
                this.waitOptimalResult();
            }
            nodeArray = this.getNodes();
            bl2 = true;
            for (Node node : nodeArray) {
                if (!(node instanceof DelayedNode)) continue;
                DelayedNode delayedNode = (DelayedNode)node;
                if (!FolderChildren.checkChildrenMutex() || !delayedNode.waitFinished()) continue;
                bl2 = false;
            }
        } while (!bl2);
        return nodeArray;
    }

    public Node findChild(String string) {
        if (FolderChildren.checkChildrenMutex()) {
            this.getNodesCount(true);
        }
        return super.findChild(string);
    }

    private void waitOptimalResult() {
        if (FolderChildren.checkChildrenMutex()) {
            this.err.fine("waitOptimalResult");
            if (!this.isInitialized()) {
                this.refreshChildren(RefreshMode.SHALLOW);
            }
            this.folder.waitProcessingFinished();
            this.refTask.waitFinished();
            this.err.fine("waitOptimalResult: waitProcessingFinished");
        } else {
            Logger.getLogger(FolderChildren.class.getName()).log(Level.WARNING, null, new IllegalStateException("getNodes(true) called while holding the Children.MUTEX"));
        }
    }

    public int getNodesCount(boolean bl) {
        if (bl) {
            this.waitOptimalResult();
        }
        return this.getNodesCount();
    }

    static boolean checkChildrenMutex() {
        return !Children.MUTEX.isReadAccess() && !Children.MUTEX.isWriteAccess();
    }

    protected void addNotify() {
        this.err.fine("addNotify begin");
        this.folder.addPropertyChangeListener(this.listener);
        this.folder.getPrimaryFile().addFileChangeListener(this.fcListener);
        if (this.filter instanceof ChangeableDataFilter) {
            ChangeableDataFilter changeableDataFilter = (ChangeableDataFilter)this.filter;
            this.changeListener = WeakListeners.change((ChangeListener)this, (Object)changeableDataFilter);
            changeableDataFilter.addChangeListener(this.changeListener);
        }
        this.refreshChildren(RefreshMode.SHALLOW);
        this.err.fine("addNotify end");
    }

    protected void removeNotify() {
        this.err.fine("removeNotify begin");
        this.folder.getPrimaryFile().removeFileChangeListener(this.fcListener);
        this.folder.removePropertyChangeListener(this.listener);
        if (this.filter instanceof ChangeableDataFilter) {
            ((ChangeableDataFilter)this.filter).removeChangeListener(this.changeListener);
            this.changeListener = null;
        }
        List list = Collections.emptyList();
        this.setKeys(list);
        this.err.fine("removeNotify end");
    }

    public String toString() {
        return this.folder != null ? this.folder.getPrimaryFile().toString() : super.toString();
    }

    public void fileAttributeChanged(FileAttributeEvent fileAttributeEvent) {
        if ("NetBeansAttrAssignedLoader".equals(fileAttributeEvent.getName())) {
            DataObjectPool.checkAttributeChanged(fileAttributeEvent);
            this.refreshKey(new FolderChildrenPair(fileAttributeEvent.getFile()));
            this.refreshChildren(RefreshMode.SHALLOW_IMMEDIATE);
        }
    }

    public void fileChanged(FileEvent fileEvent) {
    }

    public void fileDataCreated(FileEvent fileEvent) {
        this.refreshChildren(RefreshMode.SHALLOW);
    }

    public void fileDeleted(FileEvent fileEvent) {
        this.refreshChildren(RefreshMode.SHALLOW);
    }

    public void fileFolderCreated(FileEvent fileEvent) {
        this.refreshChildren(RefreshMode.SHALLOW);
    }

    public void fileRenamed(FileRenameEvent fileRenameEvent) {
        this.refreshChildren(RefreshMode.SHALLOW);
    }

    private final class DelayedNode
    extends FilterNode
    implements Runnable,
    InstanceContent.Convertor<DelayedNode, DataObject> {
        private final FolderChildrenPair pair;
        private volatile RequestProcessor.Task task;

        public DelayedNode(FolderChildrenPair folderChildrenPair) {
            this(folderChildrenPair, new InstanceContent());
        }

        private DelayedNode(FolderChildrenPair folderChildrenPair, InstanceContent instanceContent) {
            this(folderChildrenPair, new AbstractNode(FilterNode.Children.LEAF, (Lookup)new AbstractLookup((AbstractLookup.Content)instanceContent)));
            instanceContent.add((Object)folderChildrenPair.primaryFile);
            instanceContent.add((Object)this, (InstanceContent.Convertor)this);
        }

        private DelayedNode(FolderChildrenPair folderChildrenPair, AbstractNode abstractNode) {
            super((Node)abstractNode);
            this.pair = folderChildrenPair;
            abstractNode.setName(folderChildrenPair.primaryFile.getNameExt());
            abstractNode.setIconBaseWithExtension("org/openide/loaders/unknown.gif");
            this.task = DataNodeUtils.reqProcessor().post((Runnable)this);
        }

        @Override
        public void run() {
            Node node = FolderChildren.this.createNode(this.pair);
            if (node != null) {
                this.changeOriginal(node, !node.isLeaf());
            } else {
                FolderChildren.this.refreshKey(this.pair);
            }
            this.task = null;
        }

        public final boolean waitFinished() {
            RequestProcessor.Task task = this.task;
            if (task == null) {
                return false;
            }
            task.waitFinished();
            return true;
        }

        public DataObject convert(DelayedNode delayedNode) {
            if (EventQueue.isDispatchThread()) {
                FolderChildren.this.err.log(Level.WARNING, "Attempt to obtain DataObject for {0} from EDT", this.pair.primaryFile);
                boolean bl = false;
                if (!$assertionsDisabled) {
                    bl = true;
                    if (!true) {
                        throw new AssertionError();
                    }
                }
                if (bl) {
                    FolderChildren.this.err.log(Level.INFO, "Ineffective since #199391 was implemented", new Exception("Find for " + this.pair.primaryFile));
                }
            }
            try {
                return DataObject.find(this.pair.primaryFile);
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                FolderChildren.this.err.log(Level.INFO, "Cannot convert " + this.pair.primaryFile, dataObjectNotFoundException);
                return null;
            }
        }

        public Class<? extends DataObject> type(DelayedNode delayedNode) {
            return DataObject.class;
        }

        public String id(DelayedNode delayedNode) {
            return this.type(delayedNode).getName();
        }

        public String displayName(DelayedNode delayedNode) {
            return this.id(delayedNode);
        }
    }

    private static enum RefreshMode {
        SHALLOW,
        SHALLOW_IMMEDIATE,
        DEEP,
        DEEP_LATER,
        CLEAR;

    }
}

