/*
 * Decompiled with CFR 0.152.
 */
package com.javafx.tools.doclets.formats.html;

import com.javafx.tools.doclets.formats.html.ConfigurationImpl;
import com.javafx.tools.doclets.formats.html.SubWriterHolderWriter;
import com.javafx.tools.doclets.formats.html.markup.HtmlConstants;
import com.javafx.tools.doclets.formats.html.markup.HtmlStyle;
import com.javafx.tools.doclets.formats.html.markup.HtmlTag;
import com.javafx.tools.doclets.formats.html.markup.HtmlTree;
import com.javafx.tools.doclets.formats.html.markup.RawHtml;
import com.javafx.tools.doclets.formats.html.markup.StringContent;
import com.javafx.tools.doclets.internal.toolkit.Content;
import com.javafx.tools.doclets.internal.toolkit.util.ClassUseMapper;
import com.javafx.tools.doclets.internal.toolkit.util.DirectoryManager;
import com.javafx.tools.doclets.internal.toolkit.util.DocletAbortException;
import com.javafx.tools.doclets.internal.toolkit.util.Util;
import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.Doc;
import com.sun.javadoc.PackageDoc;
import java.io.IOException;
import java.util.Iterator;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;

public class PackageUseWriter
extends SubWriterHolderWriter {
    final PackageDoc pkgdoc;
    final SortedMap<String, Set<ClassDoc>> usingPackageToUsedClasses = new TreeMap<String, Set<ClassDoc>>();

    public PackageUseWriter(ConfigurationImpl configuration, ClassUseMapper mapper, String filename, PackageDoc pkgdoc) throws IOException {
        super(configuration, DirectoryManager.getDirectoryPath(pkgdoc), filename, DirectoryManager.getRelativePath(pkgdoc.name()));
        this.pkgdoc = pkgdoc;
        ClassDoc[] content = pkgdoc.allClasses();
        for (int i = 0; i < content.length; ++i) {
            ClassDoc usedClass = content[i];
            Set<ClassDoc> usingClasses = mapper.classToClass.get(usedClass.qualifiedName());
            if (usingClasses == null) continue;
            for (ClassDoc usingClass : usingClasses) {
                PackageDoc usingPackage = usingClass.containingPackage();
                TreeSet<ClassDoc> usedClasses = (TreeSet<ClassDoc>)this.usingPackageToUsedClasses.get(usingPackage.name());
                if (usedClasses == null) {
                    usedClasses = new TreeSet<ClassDoc>();
                    this.usingPackageToUsedClasses.put(Util.getPackageName(usingPackage), usedClasses);
                }
                usedClasses.add(usedClass);
            }
        }
    }

    public static void generate(ConfigurationImpl configuration, ClassUseMapper mapper, PackageDoc pkgdoc) {
        String filename = "package-use.html";
        try {
            PackageUseWriter pkgusegen = new PackageUseWriter(configuration, mapper, filename, pkgdoc);
            pkgusegen.generatePackageUseFile();
            pkgusegen.close();
        }
        catch (IOException exc) {
            configuration.standardmessage.error("doclet.exception_encountered", exc.toString(), filename);
            throw new DocletAbortException();
        }
    }

    protected void generatePackageUseFile() throws IOException {
        Content body = this.getPackageUseHeader();
        HtmlTree div = new HtmlTree(HtmlTag.DIV);
        div.addStyle(HtmlStyle.contentContainer);
        if (this.usingPackageToUsedClasses.isEmpty()) {
            div.addContent(this.getResource("doclet.ClassUse_No.usage.of.0", this.pkgdoc.name()));
        } else {
            this.addPackageUse(div);
        }
        body.addContent(div);
        this.addNavLinks(false, body);
        this.addBottom(body);
        this.printHtmlDocument(null, true, body);
    }

    protected void addPackageUse(Content contentTree) throws IOException {
        HtmlTree ul = new HtmlTree(HtmlTag.UL);
        ul.addStyle(HtmlStyle.blockList);
        if (this.configuration.packages.length > 1) {
            this.addPackageList(ul);
        }
        this.addClassList(ul);
        contentTree.addContent(ul);
    }

    protected void addPackageList(Content contentTree) throws IOException {
        HtmlTree table = HtmlTree.TABLE(0, 3, 0, this.useTableSummary, this.getTableCaption(this.configuration().getText("doclet.ClassUse_Packages.that.use.0", this.getPackageLinkString(this.pkgdoc, Util.getPackageName(this.pkgdoc), false))));
        ((Content)table).addContent(this.getSummaryTableHeader(this.packageTableHeader, "col"));
        HtmlTree tbody = new HtmlTree(HtmlTag.TBODY);
        Iterator<String> it = this.usingPackageToUsedClasses.keySet().iterator();
        int i = 0;
        while (it.hasNext()) {
            PackageDoc pkg = this.configuration.root.packageNamed(it.next());
            HtmlTree tr = new HtmlTree(HtmlTag.TR);
            if (i % 2 == 0) {
                tr.addStyle(HtmlStyle.altColor);
            } else {
                tr.addStyle(HtmlStyle.rowColor);
            }
            this.addPackageUse(pkg, tr);
            ((Content)tbody).addContent(tr);
            ++i;
        }
        ((Content)table).addContent(tbody);
        HtmlTree li = HtmlTree.LI(HtmlStyle.blockList, table);
        contentTree.addContent(li);
    }

    protected void addClassList(Content contentTree) throws IOException {
        String[] classTableHeader = new String[]{this.configuration.getText("doclet.0_and_1", this.configuration.getText("doclet.Class"), this.configuration.getText("doclet.Description"))};
        for (String packageName : this.usingPackageToUsedClasses.keySet()) {
            PackageDoc usingPackage = this.configuration.root.packageNamed(packageName);
            HtmlTree li = new HtmlTree(HtmlTag.LI);
            li.addStyle(HtmlStyle.blockList);
            if (usingPackage != null) {
                li.addContent(this.getMarkerAnchor(usingPackage.name()));
            }
            String tableSummary = this.configuration.getText("doclet.Use_Table_Summary", this.configuration.getText("doclet.classes"));
            HtmlTree table = HtmlTree.TABLE(0, 3, 0, tableSummary, this.getTableCaption(this.configuration().getText("doclet.ClassUse_Classes.in.0.used.by.1", this.getPackageLinkString(this.pkgdoc, Util.getPackageName(this.pkgdoc), false), this.getPackageLinkString(usingPackage, Util.getPackageName(usingPackage), false))));
            ((Content)table).addContent(this.getSummaryTableHeader(classTableHeader, "col"));
            HtmlTree tbody = new HtmlTree(HtmlTag.TBODY);
            Iterator itc = ((Set)this.usingPackageToUsedClasses.get(packageName)).iterator();
            int i = 0;
            while (itc.hasNext()) {
                HtmlTree tr = new HtmlTree(HtmlTag.TR);
                if (i % 2 == 0) {
                    tr.addStyle(HtmlStyle.altColor);
                } else {
                    tr.addStyle(HtmlStyle.rowColor);
                }
                this.addClassRow((ClassDoc)itc.next(), packageName, tr);
                ((Content)tbody).addContent(tr);
                ++i;
            }
            ((Content)table).addContent(tbody);
            li.addContent(table);
            contentTree.addContent(li);
        }
    }

    protected void addClassRow(ClassDoc usedClass, String packageName, Content contentTree) {
        String path = this.pathString(usedClass, "class-use/" + usedClass.name() + ".html");
        HtmlTree td = HtmlTree.TD(HtmlStyle.colOne, this.getHyperLink(path, packageName, new StringContent(usedClass.name())));
        this.addIndexComment((Doc)usedClass, td);
        contentTree.addContent(td);
    }

    protected void addPackageUse(PackageDoc pkg, Content contentTree) throws IOException {
        HtmlTree tdFirst = HtmlTree.TD(HtmlStyle.colFirst, this.getHyperLink("", Util.getPackageName(pkg), new RawHtml(Util.getPackageName(pkg))));
        contentTree.addContent(tdFirst);
        HtmlTree tdLast = new HtmlTree(HtmlTag.TD);
        tdLast.addStyle(HtmlStyle.colLast);
        if (pkg != null && pkg.name().length() != 0) {
            this.addSummaryComment((Doc)pkg, tdLast);
        } else {
            tdLast.addContent(this.getSpace());
        }
        contentTree.addContent(tdLast);
    }

    protected Content getPackageUseHeader() {
        String packageText = this.configuration.getText("doclet.Package");
        String name = this.pkgdoc.name();
        String title = this.configuration.getText("doclet.Window_ClassUse_Header", packageText, name);
        HtmlTree bodyTree = this.getBody(true, this.getWindowTitle(title));
        this.addTop(bodyTree);
        this.addNavLinks(true, bodyTree);
        Content headContent = this.getResource("doclet.ClassUse_Title", packageText, name);
        HtmlTree heading = HtmlTree.HEADING(HtmlConstants.TITLE_HEADING, true, HtmlStyle.title, headContent);
        HtmlTree div = HtmlTree.DIV(HtmlStyle.header, heading);
        ((Content)bodyTree).addContent(div);
        return bodyTree;
    }

    protected Content getNavLinkPackage() {
        Content linkContent = this.getHyperLink("package-summary.html", "", this.packageLabel);
        HtmlTree li = HtmlTree.LI(linkContent);
        return li;
    }

    protected Content getNavLinkClassUse() {
        HtmlTree li = HtmlTree.LI(HtmlStyle.navBarCell1Rev, this.useLabel);
        return li;
    }

    protected Content getNavLinkTree() {
        Content linkContent = this.getHyperLink("package-tree.html", "", this.treeLabel);
        HtmlTree li = HtmlTree.LI(linkContent);
        return li;
    }
}

