/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.ui.options.filetypes;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.prefs.Preferences;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.LayoutStyle;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.core.ui.options.filetypes.FileAssociationsModel;
import org.netbeans.core.ui.options.filetypes.FileAssociationsOptionsPanelController;
import org.netbeans.core.ui.options.filetypes.IgnoredFilesPreferences;
import org.netbeans.core.ui.options.filetypes.NewExtensionPanel;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;

final class FileAssociationsPanel
extends JPanel {
    private final FileAssociationsOptionsPanelController controller;
    private final String chooseExtensionItem;
    private NewExtensionPanel newExtensionPanel;
    private FileAssociationsModel model;
    private DocumentListener patternListener;
    private JCheckBox autoScan;
    private JButton btnDefault;
    private JButton btnDefaultIgnored;
    private JButton btnNew;
    private JButton btnRemove;
    private JComboBox cbExtension;
    private JComboBox cbType;
    private JScrollPane jScrollPane1;
    private JLabel lblAssociatedAlso;
    private JLabel lblAssociatedAlsoExt;
    private JLabel lblExtension;
    private JLabel lblFileAssociations;
    private JLabel lblFilesIgnored;
    private JLabel lblPattern;
    private JLabel lblType;
    private JSeparator sepFileAssociations;
    private JSeparator setFilesIgnored;
    private JTextArea txtPattern;
    private JLabel txtPatternError;

    FileAssociationsPanel(FileAssociationsOptionsPanelController fileAssociationsOptionsPanelController) {
        this.controller = fileAssociationsOptionsPanelController;
        this.initComponents();
        this.chooseExtensionItem = NbBundle.getMessage(FileAssociationsPanel.class, (String)"FileAssociationsPanel.cbExtension.choose");
        this.patternListener = new PatternDocumentListener();
    }

    private void initComponents() {
        this.lblExtension = new JLabel();
        this.cbExtension = new JComboBox();
        this.btnNew = new JButton();
        this.btnRemove = new JButton();
        this.lblType = new JLabel();
        this.cbType = new JComboBox();
        this.btnDefault = new JButton();
        this.lblAssociatedAlso = new JLabel();
        this.lblAssociatedAlsoExt = new JLabel();
        this.sepFileAssociations = new JSeparator();
        this.lblFileAssociations = new JLabel();
        this.lblFilesIgnored = new JLabel();
        this.setFilesIgnored = new JSeparator();
        this.lblPattern = new JLabel();
        this.btnDefaultIgnored = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.txtPattern = new JTextArea();
        this.txtPatternError = new JLabel();
        this.autoScan = new JCheckBox();
        this.lblExtension.setLabelFor(this.cbExtension);
        Mnemonics.setLocalizedText((JLabel)this.lblExtension, (String)NbBundle.getMessage(FileAssociationsPanel.class, (String)"FileAssociationsPanel.lblExtension.text"));
        this.cbExtension.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FileAssociationsPanel.this.cbExtensionActionPerformed(actionEvent);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.btnNew, (String)NbBundle.getMessage(FileAssociationsPanel.class, (String)"FileAssociationsPanel.btnNew.text"));
        this.btnNew.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FileAssociationsPanel.this.btnNewActionPerformed(actionEvent);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.btnRemove, (String)NbBundle.getMessage(FileAssociationsPanel.class, (String)"FileAssociationsPanel.btnRemove.text"));
        this.btnRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FileAssociationsPanel.this.btnRemoveActionPerformed(actionEvent);
            }
        });
        this.lblType.setLabelFor(this.cbType);
        Mnemonics.setLocalizedText((JLabel)this.lblType, (String)NbBundle.getMessage(FileAssociationsPanel.class, (String)"FileAssociationsPanel.lblType.text"));
        this.cbType.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FileAssociationsPanel.this.cbTypeActionPerformed(actionEvent);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.btnDefault, (String)NbBundle.getMessage(FileAssociationsPanel.class, (String)"FileAssociationsPanel.btnDefault.text"));
        this.btnDefault.setToolTipText(NbBundle.getMessage(FileAssociationsPanel.class, (String)"FileAssociationsPanel.btnDefault.tooltip"));
        this.btnDefault.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FileAssociationsPanel.this.btnDefaultActionPerformed(actionEvent);
            }
        });
        this.lblAssociatedAlso.setLabelFor(this.lblAssociatedAlsoExt);
        Mnemonics.setLocalizedText((JLabel)this.lblAssociatedAlso, (String)NbBundle.getMessage(FileAssociationsPanel.class, (String)"FileAssociationsPanel.lblAssociatedAlso.text"));
        this.lblAssociatedAlso.setEnabled(false);
        this.lblAssociatedAlsoExt.setEnabled(false);
        this.lblAssociatedAlsoExt.setPreferredSize(new Dimension(200, 14));
        Mnemonics.setLocalizedText((JLabel)this.lblFileAssociations, (String)NbBundle.getMessage(FileAssociationsPanel.class, (String)"FileAssociationsPanel.lblFileAssociations.text"));
        Mnemonics.setLocalizedText((JLabel)this.lblFilesIgnored, (String)NbBundle.getMessage(FileAssociationsPanel.class, (String)"FileAssociationsPanel.lblFilesIgnored.text"));
        this.lblPattern.setLabelFor(this.txtPattern);
        Mnemonics.setLocalizedText((JLabel)this.lblPattern, (String)NbBundle.getMessage(FileAssociationsPanel.class, (String)"FileAssociationsPanel.lblPattern.text"));
        this.lblPattern.setToolTipText(NbBundle.getMessage(FileAssociationsPanel.class, (String)"FileAssociationsPanel.lblPattern.tooltip"));
        Mnemonics.setLocalizedText((AbstractButton)this.btnDefaultIgnored, (String)NbBundle.getMessage(FileAssociationsPanel.class, (String)"FileAssociationsPanel.btnDefaultIgnored.text"));
        this.btnDefaultIgnored.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FileAssociationsPanel.this.btnDefaultIgnoredActionPerformed(actionEvent);
            }
        });
        this.jScrollPane1.setHorizontalScrollBarPolicy(31);
        this.jScrollPane1.setVerticalScrollBarPolicy(21);
        this.txtPattern.setLineWrap(true);
        this.jScrollPane1.setViewportView(this.txtPattern);
        this.txtPattern.getAccessibleContext().setAccessibleParent(this);
        this.txtPatternError.setForeground(Color.red);
        this.txtPatternError.setVerticalAlignment(1);
        this.txtPatternError.setFocusable(false);
        Mnemonics.setLocalizedText((AbstractButton)this.autoScan, (String)NbBundle.getMessage(FileAssociationsPanel.class, (String)"FileAssociationsPanel.autoScan.text", (Object[])new Object[0]));
        this.autoScan.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FileAssociationsPanel.this.autoScanActionPerformed(actionEvent);
            }
        });
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addComponent(this.lblFileAssociations).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.sepFileAssociations, -1, 613, Short.MAX_VALUE)).addGroup(groupLayout.createSequentialGroup().addGap(10, 10, 10).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblExtension).addComponent(this.lblType)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addComponent(this.lblAssociatedAlso).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblAssociatedAlsoExt, -1, 364, Short.MAX_VALUE)).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.cbExtension, 0, 337, Short.MAX_VALUE).addComponent(this.cbType, 0, 337, Short.MAX_VALUE)).addGap(10, 10, 10).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addComponent(this.btnNew).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnRemove)).addComponent(this.btnDefault))))).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(10, 10, 10).addComponent(this.lblPattern)).addGroup(groupLayout.createSequentialGroup().addComponent(this.autoScan, -1, 584, Short.MAX_VALUE).addGap(44, 44, 44))).addGap(41, 41, 41).addComponent(this.txtPatternError, -1, 75, Short.MAX_VALUE)).addGroup(groupLayout.createSequentialGroup().addComponent(this.lblFilesIgnored).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addComponent(this.jScrollPane1).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.btnDefaultIgnored)).addComponent(this.setFilesIgnored, -1, 565, Short.MAX_VALUE)))).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.sepFileAssociations, -2, -1, -2).addComponent(this.lblFileAssociations)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btnNew).addComponent(this.cbExtension, -2, -1, -2).addComponent(this.btnRemove).addComponent(this.lblExtension)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cbType, -2, -1, -2).addComponent(this.btnDefault).addComponent(this.lblType)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblAssociatedAlso).addComponent(this.lblAssociatedAlsoExt, -2, -1, -2)).addGap(23, 23, 23).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.setFilesIgnored, -2, -1, -2).addComponent(this.lblFilesIgnored)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblPattern).addComponent(this.btnDefaultIgnored).addComponent(this.jScrollPane1, -2, 45, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addComponent(this.txtPatternError, -1, 129, Short.MAX_VALUE).addGap(16, 16, 16)).addGroup(groupLayout.createSequentialGroup().addGap(20, 20, 20).addComponent(this.autoScan)))));
        this.lblExtension.getAccessibleContext().setAccessibleName(NbBundle.getMessage(FileAssociationsPanel.class, (String)"FileAssociationsPanel.lblExtension.AN"));
        this.lblExtension.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FileAssociationsPanel.class, (String)"FileAssociationsPanel.lblExtension.AD"));
        this.btnNew.getAccessibleContext().setAccessibleName(NbBundle.getMessage(FileAssociationsPanel.class, (String)"FileAssociationsPanel.btnNew.AN"));
        this.btnNew.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FileAssociationsPanel.class, (String)"FileAssociationsPanel.btnNew.AD"));
        this.btnRemove.getAccessibleContext().setAccessibleName(NbBundle.getMessage(FileAssociationsPanel.class, (String)"FileAssociationsPanel.btnRemove.AN"));
        this.btnRemove.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FileAssociationsPanel.class, (String)"FileAssociationsPanel.btnRemove.AD"));
        this.lblType.getAccessibleContext().setAccessibleName(NbBundle.getMessage(FileAssociationsPanel.class, (String)"FileAssociationsPanel.lblType.AN"));
        this.lblType.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FileAssociationsPanel.class, (String)"FileAssociationsPanel.lblType.AD"));
        this.btnDefault.getAccessibleContext().setAccessibleName(NbBundle.getMessage(FileAssociationsPanel.class, (String)"FileAssociationsPanel.btnDefault.AN"));
        this.btnDefault.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FileAssociationsPanel.class, (String)"FileAssociationsPanel.btnDefault.AD"));
        this.lblAssociatedAlso.getAccessibleContext().setAccessibleName(NbBundle.getMessage(FileAssociationsPanel.class, (String)"FileAssociationsPanel.lblAssociatedAlso.AN"));
        this.lblAssociatedAlso.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FileAssociationsPanel.class, (String)"FileAssociationsPanel.lblAssociatedAlso.AD"));
        this.lblPattern.getAccessibleContext().setAccessibleName(NbBundle.getMessage(FileAssociationsPanel.class, (String)"FileAssociationsPanel.lblPattern.AN"));
        this.lblPattern.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FileAssociationsPanel.class, (String)"FileAssociationsPanel.lblPattern.AD"));
        this.btnDefaultIgnored.getAccessibleContext().setAccessibleName(NbBundle.getMessage(FileAssociationsPanel.class, (String)"FileAssociationsPanel.btnDefaultIgnored.AN"));
        this.btnDefaultIgnored.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FileAssociationsPanel.class, (String)"FileAssociationsPanel.btnDefaultIgnored.AD"));
        this.txtPatternError.getAccessibleContext().setAccessibleName(NbBundle.getMessage(FileAssociationsPanel.class, (String)"FileAssociationsPanel.txtPatternError.AN"));
        this.txtPatternError.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FileAssociationsPanel.class, (String)"FileAssociationsPanel.txtPatternError.AD"));
    }

    private void cbExtensionActionPerformed(ActionEvent actionEvent) {
        if (this.cbExtension.getSelectedItem() == null || this.chooseExtensionItem.equals(this.cbExtension.getSelectedItem().toString())) {
            return;
        }
        String string = this.cbExtension.getSelectedItem().toString();
        if (this.cbExtension.getItemAt(0).equals(this.chooseExtensionItem)) {
            this.cbExtension.removeItem(this.chooseExtensionItem);
        }
        this.cbType.setEnabled(!string.equalsIgnoreCase("xml"));
        this.cbType.setSelectedItem(this.model.getMimeItem(string));
        this.btnRemove.setEnabled(this.model.canBeRemoved(string));
    }

    private void cbTypeActionPerformed(ActionEvent actionEvent) {
        String string;
        if (this.cbType.getSelectedItem() == null || this.chooseExtensionItem.equals(this.cbExtension.getSelectedItem().toString())) {
            return;
        }
        String string2 = this.cbExtension.getSelectedItem().toString();
        if (this.model.setMimeType(string2, string = ((FileAssociationsModel.MimeItem)this.cbType.getSelectedItem()).getMimeType())) {
            this.controller.changed();
        }
        this.btnDefault.setEnabled(this.model.canBeRestored(string2));
        this.lblAssociatedAlsoExt.setText(this.model.getAssociatedAlso(string2, string));
    }

    private void btnDefaultActionPerformed(ActionEvent actionEvent) {
        String string = this.cbExtension.getSelectedItem().toString();
        this.model.setDefault(string);
        this.btnDefault.setEnabled(false);
        this.cbType.setSelectedItem(this.model.getMimeItem(string));
        this.controller.changed();
    }

    private void btnNewActionPerformed(ActionEvent actionEvent) {
        if (this.newExtensionPanel == null) {
            this.newExtensionPanel = new NewExtensionPanel();
        }
        this.newExtensionPanel.setModel(this.model);
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)this.newExtensionPanel, NbBundle.getMessage(NewExtensionPanel.class, (String)"NewExtensionPanel.title"));
        this.newExtensionPanel.addExtensionListener(dialogDescriptor);
        DialogDisplayer.getDefault().createDialog(dialogDescriptor).setVisible(true);
        if (DialogDescriptor.OK_OPTION.equals(dialogDescriptor.getValue())) {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (int i = 0; i < this.cbExtension.getItemCount(); ++i) {
                arrayList.add(this.cbExtension.getItemAt(i).toString());
            }
            if (arrayList.remove(this.chooseExtensionItem)) {
                this.cbType.setEnabled(true);
            }
            arrayList.add(this.newExtensionPanel.getExtension());
            Collections.sort(arrayList, String.CASE_INSENSITIVE_ORDER);
            this.cbExtension.removeAllItems();
            for (String string : arrayList) {
                this.cbExtension.addItem(string);
            }
            this.cbExtension.setSelectedItem(this.newExtensionPanel.getExtension());
        }
    }

    private void btnRemoveActionPerformed(ActionEvent actionEvent) {
        String string = this.cbExtension.getSelectedItem().toString();
        this.model.remove(string);
        int n = this.cbExtension.getSelectedIndex();
        this.cbExtension.removeItem(string);
        if (this.cbExtension.getItemCount() > 0) {
            this.cbExtension.setSelectedIndex(Math.max(0, --n));
        }
        this.controller.changed();
    }

    private void btnDefaultIgnoredActionPerformed(ActionEvent actionEvent) {
        this.txtPattern.setText("^(CVS|SCCS|vssver.?\\.scc|#.*#|%.*%|_svn)$|~$|^\\.(?!htaccess$).*$");
    }

    private void autoScanActionPerformed(ActionEvent actionEvent) {
        this.controller.changed();
    }

    void load() {
        this.cbExtension.removeAllItems();
        this.cbType.removeAllItems();
        this.cbType.setEnabled(false);
        this.btnDefault.setEnabled(false);
        this.btnRemove.setEnabled(false);
        this.lblAssociatedAlsoExt.setText(null);
        this.model = new FileAssociationsModel();
        this.cbExtension.addItem(this.chooseExtensionItem);
        for (String object : this.model.getExtensions()) {
            this.cbExtension.addItem(object);
        }
        for (FileAssociationsModel.MimeItem mimeItem : this.model.getMimeItems()) {
            this.cbType.addItem(mimeItem);
        }
        this.txtPattern.getDocument().removeDocumentListener(this.patternListener);
        this.txtPattern.setText(IgnoredFilesPreferences.getIgnoredFiles());
        this.txtPattern.getDocument().addDocumentListener(this.patternListener);
        this.btnDefaultIgnored.setEnabled(!"^(CVS|SCCS|vssver.?\\.scc|#.*#|%.*%|_svn)$|~$|^\\.(?!htaccess$).*$".equals(this.txtPattern.getText()));
        boolean bl = NbPreferences.root().node("org/openide/actions/FileSystemRefreshAction").getBoolean("manual", false);
        this.autoScan.setSelected(!bl);
    }

    void store() {
        this.model.store();
        IgnoredFilesPreferences.setIgnoredFiles(this.txtPattern.getText());
        Preferences preferences = NbPreferences.root().node("org/openide/actions/FileSystemRefreshAction");
        boolean bl = preferences.getBoolean("manual", false);
        if (bl == this.autoScan.isSelected()) {
            preferences.putBoolean("manual", !bl);
        }
    }

    boolean valid() {
        return IgnoredFilesPreferences.isValid(this.txtPattern.getText());
    }

    private class PatternDocumentListener
    implements DocumentListener {
        private PatternDocumentListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            this.patternChanged();
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            this.patternChanged();
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
        }

        private void patternChanged() {
            FileAssociationsPanel.this.controller.changed();
            FileAssociationsPanel.this.btnDefaultIgnored.setEnabled(!"^(CVS|SCCS|vssver.?\\.scc|#.*#|%.*%|_svn)$|~$|^\\.(?!htaccess$).*$".equals(FileAssociationsPanel.this.txtPattern.getText()));
            if (IgnoredFilesPreferences.getSyntaxError() != null) {
                FileAssociationsPanel.this.txtPatternError.setText("<html><pre>" + IgnoredFilesPreferences.getSyntaxError() + "</pre></html>");
            } else {
                FileAssociationsPanel.this.txtPatternError.setText(null);
            }
        }
    }
}

