/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.common.filters;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.ResourceBundle;

public final class FilterSet {
    private static final ResourceBundle bundle = ResourceBundle.getBundle("org.netbeans.lib.profiler.common.filters.Bundle");
    public static final String DEFAULT_FILTERSET_NAME = bundle.getString("FilterSet_DefaultFilterSetName");
    public static final String PROP_FILTER_TYPE_VALUE = "profiler.filter.set";
    public static final boolean FILTER_SET_EXCLUSIVE = false;
    public static final boolean FILTER_SET_INCLUSIVE = true;
    private String filterSetName;
    private String[] activeGlobalFilters;
    private boolean filterSetType;

    public FilterSet() {
        this(DEFAULT_FILTERSET_NAME);
    }

    public FilterSet(String string) {
        this(string, false, new String[0]);
    }

    public FilterSet(String string, boolean bl, String[] stringArray) {
        this.setFilterSetName(string);
        this.setFilterSetType(bl);
        this.activeGlobalFilters = stringArray;
    }

    public FilterSet(FilterSet filterSet) {
        this.setValuesFrom(filterSet);
    }

    public int getActiveGlobalFilterIndex(String string) {
        for (int i = 0; i < this.activeGlobalFilters.length; ++i) {
            if (!this.activeGlobalFilters[i].equals(string)) continue;
            return i;
        }
        return -1;
    }

    public void setActiveGlobalFilters(String[] stringArray) {
        if (stringArray == null) {
            return;
        }
        this.activeGlobalFilters = stringArray;
    }

    public String[] getActiveGlobalFilters() {
        return this.activeGlobalFilters;
    }

    public void setExclusive() {
        this.filterSetType = false;
    }

    public boolean isExclusive() {
        return !this.filterSetType;
    }

    public void setFilterSetName(String string) {
        if (string == null) {
            return;
        }
        this.filterSetName = string;
    }

    public String getFilterSetName() {
        return this.filterSetName;
    }

    public void setFilterSetType(boolean bl) {
        this.filterSetType = bl;
    }

    public boolean getFilterSetType() {
        return this.filterSetType;
    }

    public void setInclusive() {
        this.filterSetType = true;
    }

    public boolean isInclusive() {
        return this.filterSetType;
    }

    public void setValuesFrom(FilterSet filterSet) {
        if (filterSet == null) {
            return;
        }
        this.setFilterSetName(filterSet.getFilterSetName());
        this.setFilterSetType(filterSet.getFilterSetType());
        int n = filterSet.getActiveGlobalFilters().length;
        this.activeGlobalFilters = new String[n];
        for (int i = 0; i < n; ++i) {
            this.activeGlobalFilters[i] = filterSet.getActiveGlobalFilters()[i];
        }
    }

    public void addActiveGlobalFilter(String string) {
        int n = this.activeGlobalFilters.length;
        String[] stringArray = new String[n + 1];
        System.arraycopy(this.activeGlobalFilters, 0, stringArray, 0, n);
        stringArray[n] = string;
        this.activeGlobalFilters = stringArray;
    }

    public void clear() {
        this.setFilterSetName(DEFAULT_FILTERSET_NAME);
        this.setFilterSetType(false);
        this.activeGlobalFilters = new String[0];
    }

    public boolean containsActiveGlobalFilter(String string) {
        return this.getActiveGlobalFilterIndex(string) != -1;
    }

    public String debug() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("FilterSet name: " + this.filterSetName);
        stringBuffer.append("\n");
        stringBuffer.append("  Type: " + (!this.filterSetType ? "Exclusive" : "Inclusive"));
        stringBuffer.append("\n");
        for (int i = 0; i < this.activeGlobalFilters.length; ++i) {
            stringBuffer.append("  GlobalFilter " + i + ": " + this.activeGlobalFilters[i]);
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof FilterSet)) {
            return false;
        }
        FilterSet filterSet = (FilterSet)object;
        if (!this.filterSetName.equals(filterSet.filterSetName)) {
            return false;
        }
        if (this.filterSetType != filterSet.filterSetType) {
            return false;
        }
        if (this.activeGlobalFilters.length != filterSet.activeGlobalFilters.length) {
            return false;
        }
        for (int i = 0; i < this.activeGlobalFilters.length; ++i) {
            if (this.activeGlobalFilters[i].equals(filterSet.activeGlobalFilters[i])) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int n = 7;
        n = 97 * n + (this.filterSetName != null ? this.filterSetName.hashCode() : 0);
        n = 97 * n + Arrays.deepHashCode(this.activeGlobalFilters);
        n = 97 * n + (this.filterSetType ? 1 : 0);
        return n;
    }

    public FilterSet load(Map map, int n) {
        return this.load(map, n, "");
    }

    public FilterSet load(Map map, String string) {
        if (!FilterSet.getProperty(map, string + "profiler.filter.type", "").equals(PROP_FILTER_TYPE_VALUE)) {
            throw new RuntimeException("Trying to load incompatible filter");
        }
        return this.load(map, -1, string);
    }

    public FilterSet load(Map map, int n, String string) {
        String string2;
        String string3 = "FilterSet-" + (n == -1 ? "" : Integer.valueOf(n).toString() + "-");
        this.filterSetName = FilterSet.getProperty(map, string + string3 + "name", DEFAULT_FILTERSET_NAME);
        this.filterSetType = Boolean.valueOf(FilterSet.getProperty(map, string + string3 + "type", "false"));
        ArrayList<String> arrayList = new ArrayList<String>();
        while ((string2 = (String)map.get(string + string3 + "active_filter-" + arrayList.size())) != null) {
            arrayList.add(string2);
        }
        this.activeGlobalFilters = new String[arrayList.size()];
        for (int i = 0; i < arrayList.size(); ++i) {
            this.activeGlobalFilters[i] = (String)arrayList.get(i);
        }
        return this;
    }

    public void removeActiveGlobalFilter(String string) {
        int n = this.getActiveGlobalFilterIndex(string);
        if (n == -1) {
            return;
        }
        int n2 = this.activeGlobalFilters.length;
        String[] stringArray = new String[n2 - 1];
        if (n > 0) {
            System.arraycopy(this.activeGlobalFilters, 0, stringArray, 0, n);
        }
        if (n < n2 - 1) {
            System.arraycopy(this.activeGlobalFilters, n + 1, stringArray, n, n2 - n - 1);
        }
        this.activeGlobalFilters = stringArray;
    }

    public void store(Map map, int n) {
        this.store(map, n, "");
    }

    public void store(Map map, String string) {
        map.put(string + "profiler.filter.type", PROP_FILTER_TYPE_VALUE);
        this.store(map, -1, string);
    }

    public void store(Map map, int n, String string) {
        String string2 = "FilterSet-" + (n == -1 ? "" : Integer.valueOf(n).toString() + "-");
        map.put(string + string2 + "name", this.filterSetName);
        map.put(string + string2 + "type", Boolean.toString(this.filterSetType));
        for (int i = 0; i < this.activeGlobalFilters.length; ++i) {
            map.put(string + string2 + "active_filter-" + i, this.activeGlobalFilters[i]);
        }
    }

    public String toString() {
        return this.getFilterSetName();
    }

    private static String getProperty(Map map, Object object, String string) {
        Object v = map.get(object);
        return v != null ? (String)v : string;
    }
}

