/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.heapwalk;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.text.MessageFormat;
import java.util.Date;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import org.netbeans.lib.profiler.utils.StringUtils;
import org.netbeans.modules.profiler.ResultsManager;
import org.netbeans.modules.profiler.api.icons.Icons;
import org.netbeans.modules.profiler.heapwalk.HeapFragmentWalker;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public class CompareSnapshotsHelper {
    private static final String SELECT_DIALOG_CAPTION = NbBundle.getMessage(CompareSnapshotsHelper.class, (String)"CompareSnapshotsHelper_SelectDialogCaption");
    private static final String OPEN_CHOOSER_CAPTION = NbBundle.getMessage(CompareSnapshotsHelper.class, (String)"CompareSnapshotsHelper_OpenChooserCaption");
    private static final String OPEN_CHOOSER_FILTER = NbBundle.getMessage(CompareSnapshotsHelper.class, (String)"CompareSnapshotsHelper_OpenChooserFilter");
    private static final String NO_COMPARABLE_SNAPSHOTS_FOUND_MSG = NbBundle.getMessage(CompareSnapshotsHelper.class, (String)"CompareSnapshotsHelper_NoComparableSnapshotsFoundMsg");
    private static final String COMPARING_SAME_SNAPSHOTS_MSG = NbBundle.getMessage(CompareSnapshotsHelper.class, (String)"CompareSnapshotsHelper_ComparingSameSnapshotsMsg");
    private static final String INVALID_FILE_MSG = NbBundle.getMessage(CompareSnapshotsHelper.class, (String)"CompareSnapshotsHelper_InvalidFileMsg");
    private static final String ENTER_FILE_MSG = NbBundle.getMessage(CompareSnapshotsHelper.class, (String)"CompareSnapshotsHelper_EnterFileMsg");
    private static final String OK_BUTTON_TEXT = NbBundle.getMessage(CompareSnapshotsHelper.class, (String)"CompareSnapshotsHelper_OkButtonText");
    private static final String SELECT_SNAPSHOT_STRING = NbBundle.getMessage(CompareSnapshotsHelper.class, (String)"CompareSnapshotsHelper_SelectSnapshotString");
    private static final String FROM_PROJECT_RADIO_TEXT = NbBundle.getMessage(CompareSnapshotsHelper.class, (String)"CompareSnapshotsHelper_FromProjectRadioText");
    private static final String FROM_CURRENT_LOCATION_RADIO_TEXT = NbBundle.getMessage(CompareSnapshotsHelper.class, (String)"CompareSnapshotsHelper_FromCurrentLocationRadioText");
    private static final String FROM_FILE_RADIO_TEXT = NbBundle.getMessage(CompareSnapshotsHelper.class, (String)"CompareSnapshotsHelper_FromFileRadioText");
    private static final String BROWSE_BUTTON_TEXT = NbBundle.getMessage(CompareSnapshotsHelper.class, (String)"CompareSnapshotsHelper_BrowseButtonText");
    private static final String BROWSE_BUTTON_ACCESS_DESCR = NbBundle.getMessage(CompareSnapshotsHelper.class, (String)"CompareSnapshotsHelper_BrowseButtonAccessDescr");
    private static final String SNAPSHOTS_LIST_ACCESS_DESCR = NbBundle.getMessage(CompareSnapshotsHelper.class, (String)"CompareSnapshotsHelper_SnapshotsListAccessDescr");
    private static final String HEAP_SNAPSHOT_DISPLAYNAME = NbBundle.getMessage(CompareSnapshotsHelper.class, (String)"CompareSnapshotsHelper_HeapSnapshotDisplayName");
    private static final Icon memoryIcon = Icons.getIcon((String)"ProfilerIcons.Memory");
    private static JFileChooser snapshotFileChooser;
    private HeapFragmentWalker heapWalker;
    private SelectSecondSnapshotPanel secondSnapshotSelector;

    private CompareSnapshotsHelper(HeapFragmentWalker heapFragmentWalker) {
        this.heapWalker = heapFragmentWalker;
    }

    public static File selectSnapshot(HeapFragmentWalker heapFragmentWalker) {
        CompareSnapshotsHelper compareSnapshotsHelper = new CompareSnapshotsHelper(heapFragmentWalker);
        SelectSecondSnapshotPanel selectSecondSnapshotPanel = compareSnapshotsHelper.getSecondSnapshotSelector();
        selectSecondSnapshotPanel.populateSnapshotsList();
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)selectSecondSnapshotPanel, SELECT_DIALOG_CAPTION, true, new Object[]{selectSecondSnapshotPanel.getOKButton(), DialogDescriptor.CANCEL_OPTION}, DialogDescriptor.OK_OPTION, 0, null, null);
        Object object = DialogDisplayer.getDefault().notify((NotifyDescriptor)dialogDescriptor);
        File file = null;
        if (object.equals(selectSecondSnapshotPanel.getOKButton())) {
            file = selectSecondSnapshotPanel.getSnapshot();
        }
        return file;
    }

    private static JFileChooser getSnapshotFileChooser() {
        if (snapshotFileChooser == null) {
            snapshotFileChooser = new JFileChooser();
            snapshotFileChooser.setAcceptAllFileFilterUsed(false);
            snapshotFileChooser.setFileSelectionMode(0);
            snapshotFileChooser.setMultiSelectionEnabled(false);
            snapshotFileChooser.setDialogType(0);
            snapshotFileChooser.setDialogTitle(OPEN_CHOOSER_CAPTION);
            snapshotFileChooser.setFileFilter(new FileFilter(){

                @Override
                public boolean accept(File file) {
                    return file.isDirectory() || ResultsManager.checkHprofFile((File)file);
                }

                @Override
                public String getDescription() {
                    return OPEN_CHOOSER_FILTER;
                }
            });
        }
        return snapshotFileChooser;
    }

    private SelectSecondSnapshotPanel getSecondSnapshotSelector() {
        if (this.secondSnapshotSelector == null) {
            this.secondSnapshotSelector = new SelectSecondSnapshotPanel();
        }
        return this.secondSnapshotSelector;
    }

    private class SelectSecondSnapshotPanel
    extends JPanel {
        private JButton externalFileButton;
        private JButton okButton;
        private JLabel externalFileHintLabel;
        private JLabel projectSnapshotsHintLabel;
        private JLabel selectSnapshotLabel;
        private JList projectSnapshotsList;
        private JRadioButton fromFileRadio;
        private JRadioButton fromProjectRadio;
        private JTextField externalFileField;

        public SelectSecondSnapshotPanel() {
            this.initComponents();
        }

        public JButton getOKButton() {
            return this.okButton;
        }

        public File getSnapshot() {
            if (this.fromProjectRadio.isSelected()) {
                Object e = this.projectSnapshotsList.getSelectedValue();
                if (e == null || !(e instanceof FileObject)) {
                    return null;
                }
                return FileUtil.toFile((FileObject)((FileObject)e));
            }
            if (this.fromFileRadio.isSelected()) {
                File file;
                String string = this.externalFileField.getText();
                if (string.length() > 0 && (file = new File(string)).exists() && file.isFile()) {
                    return file;
                }
                return null;
            }
            return null;
        }

        public void populateSnapshotsList() {
            DefaultListModel defaultListModel = (DefaultListModel)this.projectSnapshotsList.getModel();
            defaultListModel.removeAllElements();
            final Lookup.Provider provider = CompareSnapshotsHelper.this.heapWalker.getHeapDumpProject();
            File file = CompareSnapshotsHelper.this.heapWalker.getHeapDumpFile();
            final File file2 = file != null ? file.getParentFile() : null;
            FileObject[] fileObjectArray = ResultsManager.getDefault().listSavedHeapdumps(provider, file2);
            FileObject fileObject = file != null ? FileUtil.toFileObject((File)file) : null;
            for (int i = 0; i < fileObjectArray.length; ++i) {
                if (fileObject != null && fileObjectArray[i].equals(fileObject)) continue;
                defaultListModel.addElement(fileObjectArray[i]);
            }
            if (defaultListModel.getSize() == 0) {
                defaultListModel.addElement(NO_COMPARABLE_SNAPSHOTS_FOUND_MSG);
                this.fromFileRadio.setSelected(true);
                this.externalFileField.addHierarchyListener(new HierarchyListener(){

                    @Override
                    public void hierarchyChanged(HierarchyEvent hierarchyEvent) {
                        if ((hierarchyEvent.getChangeFlags() & 4L) != 0L && SelectSecondSnapshotPanel.this.externalFileField.isShowing()) {
                            SelectSecondSnapshotPanel.this.externalFileField.removeHierarchyListener(this);
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    SelectSecondSnapshotPanel.this.externalFileField.requestFocusInWindow();
                                }
                            });
                        }
                    }
                });
            } else {
                this.projectSnapshotsList.setSelectedIndex(0);
                this.projectSnapshotsList.addHierarchyListener(new HierarchyListener(){

                    @Override
                    public void hierarchyChanged(HierarchyEvent hierarchyEvent) {
                        if ((hierarchyEvent.getChangeFlags() & 4L) != 0L && SelectSecondSnapshotPanel.this.externalFileField.isShowing()) {
                            SelectSecondSnapshotPanel.this.projectSnapshotsList.removeHierarchyListener(this);
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    SelectSecondSnapshotPanel.this.projectSnapshotsList.requestFocusInWindow();
                                }
                            });
                        }
                    }
                });
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (provider != null) {
                        Mnemonics.setLocalizedText((AbstractButton)SelectSecondSnapshotPanel.this.fromProjectRadio, (String)FROM_PROJECT_RADIO_TEXT);
                        SelectSecondSnapshotPanel.this.fromProjectRadio.setToolTipText(null);
                    } else {
                        Mnemonics.setLocalizedText((AbstractButton)SelectSecondSnapshotPanel.this.fromProjectRadio, (String)FROM_CURRENT_LOCATION_RADIO_TEXT);
                        SelectSecondSnapshotPanel.this.fromProjectRadio.setToolTipText(file2 != null ? file2.getAbsolutePath() : null);
                    }
                }
            });
        }

        private void initComponents() {
            this.okButton = new JButton(OK_BUTTON_TEXT);
            this.setLayout(new GridBagLayout());
            ButtonGroup buttonGroup = new ButtonGroup();
            this.selectSnapshotLabel = new JLabel(SELECT_SNAPSHOT_STRING);
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.fill = 0;
            gridBagConstraints.insets = new Insets(15, 10, 8, 10);
            this.add((Component)this.selectSnapshotLabel, gridBagConstraints);
            this.fromProjectRadio = new JRadioButton();
            Mnemonics.setLocalizedText((AbstractButton)this.fromProjectRadio, (String)FROM_PROJECT_RADIO_TEXT);
            buttonGroup.add(this.fromProjectRadio);
            this.fromProjectRadio.getAccessibleContext().setAccessibleDescription(SELECT_SNAPSHOT_STRING + FROM_PROJECT_RADIO_TEXT);
            this.fromProjectRadio.setSelected(true);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.fill = 0;
            gridBagConstraints.insets = new Insets(0, 15, 0, 10);
            this.add((Component)this.fromProjectRadio, gridBagConstraints);
            this.projectSnapshotsList = new JList(new DefaultListModel());
            this.projectSnapshotsList.getAccessibleContext().setAccessibleName(SNAPSHOTS_LIST_ACCESS_DESCR);
            this.projectSnapshotsList.setVisibleRowCount(5);
            this.projectSnapshotsList.setSelectionMode(0);
            JScrollPane jScrollPane = new JScrollPane(this.projectSnapshotsList, 20, 31);
            jScrollPane.setPreferredSize(new Dimension(1, jScrollPane.getPreferredSize().height));
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 2;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.anchor = 18;
            gridBagConstraints.fill = 1;
            gridBagConstraints.insets = new Insets(0, 15 + new JRadioButton((String)"").getPreferredSize().width, 5, 10);
            this.add((Component)jScrollPane, gridBagConstraints);
            this.projectSnapshotsHintLabel = new JLabel(" ");
            this.projectSnapshotsHintLabel.setForeground(Color.darkGray);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 3;
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.fill = 0;
            gridBagConstraints.insets = new Insets(0, 15 + new JRadioButton((String)"").getPreferredSize().width, 5, 10);
            this.add((Component)this.projectSnapshotsHintLabel, gridBagConstraints);
            this.fromFileRadio = new JRadioButton(FROM_FILE_RADIO_TEXT);
            Mnemonics.setLocalizedText((AbstractButton)this.fromFileRadio, (String)FROM_FILE_RADIO_TEXT);
            buttonGroup.add(this.fromFileRadio);
            this.fromProjectRadio.getAccessibleContext().setAccessibleDescription(SELECT_SNAPSHOT_STRING + FROM_FILE_RADIO_TEXT);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 4;
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.fill = 0;
            gridBagConstraints.insets = new Insets(5, 15, 0, 10);
            this.add((Component)this.fromFileRadio, gridBagConstraints);
            this.externalFileField = new JTextField();
            this.externalFileField.setPreferredSize(new Dimension(250, this.externalFileField.getPreferredSize().height));
            this.externalFileField.setEnabled(false);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 5;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = new Insets(0, 15 + new JRadioButton((String)"").getPreferredSize().width, 5, 5);
            this.add((Component)this.externalFileField, gridBagConstraints);
            this.externalFileButton = new JButton();
            Mnemonics.setLocalizedText((AbstractButton)this.externalFileButton, (String)BROWSE_BUTTON_TEXT);
            this.externalFileButton.getAccessibleContext().setAccessibleDescription(BROWSE_BUTTON_ACCESS_DESCR);
            this.externalFileButton.setEnabled(false);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 2;
            gridBagConstraints.gridy = 5;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.fill = 0;
            gridBagConstraints.insets = new Insets(0, 5, 5, 10);
            this.add((Component)this.externalFileButton, gridBagConstraints);
            this.externalFileHintLabel = new JLabel(" ");
            this.externalFileHintLabel.setForeground(Color.darkGray);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 6;
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.fill = 0;
            gridBagConstraints.insets = new Insets(0, 15 + new JRadioButton((String)"").getPreferredSize().width, 5, 10);
            this.add((Component)this.externalFileHintLabel, gridBagConstraints);
            this.projectSnapshotsList.setCellRenderer(new DefaultListCellRenderer(){

                @Override
                public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                    JLabel jLabel = (JLabel)super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
                    if (object instanceof FileObject) {
                        FileObject fileObject = (FileObject)object;
                        jLabel.setIcon(memoryIcon);
                        String string = fileObject.getName();
                        Set set = WindowManager.getDefault().getRegistry().getOpened();
                        for (TopComponent topComponent : set) {
                            Object object2 = topComponent.getClientProperty((Object)"HeapDumpFileName");
                            if (object2 == null || !FileUtil.toFile((FileObject)fileObject).equals(new File(object2.toString()))) continue;
                            jLabel.setFont(jLabel.getFont().deriveFont(1));
                            break;
                        }
                        if (string.startsWith("heapdump-")) {
                            String string2 = string.substring("heapdump-".length(), string.length());
                            try {
                                long l = Long.parseLong(string2);
                                jLabel.setText(MessageFormat.format(HEAP_SNAPSHOT_DISPLAYNAME, StringUtils.formatUserDate((Date)new Date(l))));
                            }
                            catch (NumberFormatException numberFormatException) {
                                jLabel.setText(MessageFormat.format(HEAP_SNAPSHOT_DISPLAYNAME, string));
                            }
                        } else {
                            jLabel.setText(MessageFormat.format(HEAP_SNAPSHOT_DISPLAYNAME, string));
                        }
                    }
                    return jLabel;
                }
            });
            this.projectSnapshotsList.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    SelectSecondSnapshotPanel.this.updateOKButton();
                }
            });
            this.projectSnapshotsList.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent mouseEvent) {
                    if (mouseEvent.getButton() == 1 && mouseEvent.getClickCount() == 2 && SelectSecondSnapshotPanel.this.projectSnapshotsList.getSelectedValue() != null) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                SelectSecondSnapshotPanel.this.okButton.doClick();
                            }
                        });
                    }
                }
            });
            this.fromProjectRadio.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    SelectSecondSnapshotPanel.this.projectSnapshotsList.setEnabled(SelectSecondSnapshotPanel.this.fromProjectRadio.isSelected());
                    SelectSecondSnapshotPanel.this.projectSnapshotsHintLabel.setText(" ");
                    SelectSecondSnapshotPanel.this.updateOKButton();
                }
            });
            this.fromFileRadio.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    SelectSecondSnapshotPanel.this.externalFileField.setEnabled(SelectSecondSnapshotPanel.this.fromFileRadio.isSelected());
                    SelectSecondSnapshotPanel.this.externalFileButton.setEnabled(SelectSecondSnapshotPanel.this.fromFileRadio.isSelected());
                    if (!SelectSecondSnapshotPanel.this.fromFileRadio.isSelected()) {
                        SelectSecondSnapshotPanel.this.externalFileHintLabel.setText(" ");
                    }
                    SelectSecondSnapshotPanel.this.updateOKButton();
                }
            });
            DocumentListener documentListener = new DocumentListener(){

                @Override
                public void insertUpdate(DocumentEvent documentEvent) {
                    SelectSecondSnapshotPanel.this.updateOKButton();
                }

                @Override
                public void removeUpdate(DocumentEvent documentEvent) {
                    SelectSecondSnapshotPanel.this.updateOKButton();
                }

                @Override
                public void changedUpdate(DocumentEvent documentEvent) {
                    SelectSecondSnapshotPanel.this.updateOKButton();
                }
            };
            this.externalFileField.getDocument().addDocumentListener(documentListener);
            this.externalFileButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    File file;
                    JFileChooser jFileChooser = CompareSnapshotsHelper.getSnapshotFileChooser();
                    jFileChooser.setCurrentDirectory(new File(SelectSecondSnapshotPanel.this.externalFileField.getText()));
                    if (jFileChooser.showOpenDialog(WindowManager.getDefault().getMainWindow()) == 0 && (file = jFileChooser.getSelectedFile()) != null) {
                        SelectSecondSnapshotPanel.this.externalFileField.setText(file.getAbsolutePath());
                    }
                }
            });
            this.updateOKButton();
        }

        private void updateOKButton() {
            if (this.fromProjectRadio.isSelected()) {
                Object e = this.projectSnapshotsList.getSelectedValue();
                this.okButton.setEnabled(e != null && !(e instanceof String));
            } else if (this.fromFileRadio.isSelected()) {
                String string = this.externalFileField.getText();
                if (string.length() > 0) {
                    File file = new File(string);
                    if (file.exists() && file.isFile()) {
                        if (file.equals(CompareSnapshotsHelper.this.heapWalker.getHeapDumpFile())) {
                            this.externalFileHintLabel.setText(COMPARING_SAME_SNAPSHOTS_MSG);
                            this.okButton.setEnabled(false);
                        } else {
                            this.externalFileHintLabel.setText(" ");
                            this.okButton.setEnabled(true);
                        }
                    } else {
                        this.externalFileHintLabel.setText(INVALID_FILE_MSG);
                        this.okButton.setEnabled(false);
                    }
                } else {
                    this.externalFileHintLabel.setText(ENTER_FILE_MSG);
                    this.okButton.setEnabled(false);
                }
            } else {
                this.okButton.setEnabled(false);
            }
        }
    }
}

