/*
 * Decompiled with CFR 0.152.
 */
package sun.security.provider.certpath;

import java.io.IOException;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CRLReason;
import java.security.cert.CertPathValidatorException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateParsingException;
import java.security.cert.TrustAnchor;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import sun.misc.CharacterEncoder;
import sun.misc.HexDumpEncoder;
import sun.security.provider.certpath.AlgorithmChecker;
import sun.security.provider.certpath.CertId;
import sun.security.provider.certpath.OCSP;
import sun.security.provider.certpath.OCSPChecker;
import sun.security.util.Debug;
import sun.security.util.DerInputStream;
import sun.security.util.DerValue;
import sun.security.util.ObjectIdentifier;
import sun.security.x509.AlgorithmId;
import sun.security.x509.Extension;
import sun.security.x509.PKIXExtensions;
import sun.security.x509.X500Name;
import sun.security.x509.X509CertImpl;

public final class OCSPResponse {
    private static ResponseStatus[] rsvalues = ResponseStatus.values();
    private static final Debug DEBUG = Debug.getInstance("certpath");
    private static final boolean dump = Debug.isOn("ocsp");
    private static final ObjectIdentifier OCSP_BASIC_RESPONSE_OID = ObjectIdentifier.newInternal(new int[]{1, 3, 6, 1, 5, 5, 7, 48, 1, 1});
    private static final ObjectIdentifier OCSP_NONCE_EXTENSION_OID = ObjectIdentifier.newInternal(new int[]{1, 3, 6, 1, 5, 5, 7, 48, 1, 2});
    private static final int CERT_STATUS_GOOD = 0;
    private static final int CERT_STATUS_REVOKED = 1;
    private static final int CERT_STATUS_UNKNOWN = 2;
    private static final int NAME_TAG = 1;
    private static final int KEY_TAG = 2;
    private static final String KP_OCSP_SIGNING_OID = "1.3.6.1.5.5.7.3.9";
    private final ResponseStatus responseStatus;
    private final Map<CertId, SingleResponse> singleResponseMap;
    private static final long MAX_CLOCK_SKEW = 900000L;
    private static CRLReason[] values = CRLReason.values();

    OCSPResponse(byte[] byArray, Date date, List<X509Certificate> list) throws IOException, CertPathValidatorException {
        Object object;
        Object object2;
        X509CertImpl[] x509CertImplArray;
        Object[] objectArray;
        int n;
        Object object3;
        if (dump) {
            object3 = new HexDumpEncoder();
            DEBUG.println("\nOCSPResponse bytes...");
            DEBUG.println(((CharacterEncoder)object3).encode(byArray) + "\n");
        }
        object3 = new DerValue(byArray);
        if (((DerValue)object3).tag != 48) {
            throw new IOException("Bad encoding in OCSP response: expected ASN.1 SEQUENCE tag.");
        }
        DerInputStream derInputStream = ((DerValue)object3).getData();
        int n2 = derInputStream.getEnumerated();
        if (n2 < 0 || n2 >= rsvalues.length) {
            throw new IOException("Unknown OCSPResponse status: " + n2);
        }
        this.responseStatus = rsvalues[n2];
        if (DEBUG != null) {
            DEBUG.println("OCSP response status: " + (Object)((Object)this.responseStatus));
        }
        if (this.responseStatus != ResponseStatus.SUCCESSFUL) {
            this.singleResponseMap = Collections.emptyMap();
            return;
        }
        object3 = derInputStream.getDerValue();
        if (!((DerValue)object3).isContextSpecific((byte)0)) {
            throw new IOException("Bad encoding in responseBytes element of OCSP response: expected ASN.1 context specific tag 0.");
        }
        DerValue derValue = ((DerValue)object3).data.getDerValue();
        if (derValue.tag != 48) {
            throw new IOException("Bad encoding in responseBytes element of OCSP response: expected ASN.1 SEQUENCE tag.");
        }
        derInputStream = derValue.data;
        ObjectIdentifier objectIdentifier = derInputStream.getOID();
        if (objectIdentifier.equals((Object)OCSP_BASIC_RESPONSE_OID)) {
            if (DEBUG != null) {
                DEBUG.println("OCSP response type: basic");
            }
        } else {
            if (DEBUG != null) {
                DEBUG.println("OCSP response type: " + objectIdentifier);
            }
            throw new IOException("Unsupported OCSP response type: " + objectIdentifier);
        }
        DerInputStream derInputStream2 = new DerInputStream(derInputStream.getOctetString());
        DerValue[] derValueArray = derInputStream2.getSequence(2);
        if (derValueArray.length < 3) {
            throw new IOException("Unexpected BasicOCSPResponse value");
        }
        DerValue derValue2 = derValueArray[0];
        byte[] byArray2 = derValueArray[0].toByteArray();
        if (derValue2.tag != 48) {
            throw new IOException("Bad encoding in tbsResponseData element of OCSP response: expected ASN.1 SEQUENCE tag.");
        }
        DerInputStream derInputStream3 = derValue2.data;
        DerValue derValue3 = derInputStream3.getDerValue();
        if (derValue3.isContextSpecific((byte)0) && derValue3.isConstructed() && derValue3.isContextSpecific()) {
            derValue3 = derValue3.data.getDerValue();
            n = derValue3.getInteger();
            if (derValue3.data.available() != 0) {
                throw new IOException("Bad encoding in version  element of OCSP response: bad format");
            }
            derValue3 = derInputStream3.getDerValue();
        }
        if ((n = (int)((byte)(derValue3.tag & 0x1F))) == 1) {
            if (DEBUG != null) {
                objectArray = new X500Name(derValue3.getData());
                DEBUG.println("OCSP Responder name: " + objectArray);
            }
        } else if (n == 2) {
            derValue3 = derValue3.data.getDerValue();
            if (DEBUG != null) {
                objectArray = derValue3.getOctetString();
                DEBUG.println("OCSP Responder key ID: " + String.format("0x%0" + objectArray.length * 2 + "x", new BigInteger(1, (byte[])objectArray)));
            }
        } else {
            throw new IOException("Bad encoding in responderID element of OCSP response: expected ASN.1 context specific tag 1 or 2");
        }
        derValue3 = derInputStream3.getDerValue();
        if (DEBUG != null) {
            objectArray = derValue3.getGeneralizedTime();
            DEBUG.println("OCSP response produced at: " + objectArray);
        }
        objectArray = derInputStream3.getSequence(1);
        this.singleResponseMap = new HashMap<CertId, SingleResponse>(objectArray.length);
        if (DEBUG != null) {
            DEBUG.println("OCSP number of SingleResponses: " + objectArray.length);
        }
        for (int i = 0; i < objectArray.length; ++i) {
            SingleResponse singleResponse = new SingleResponse(objectArray[i]);
            this.singleResponseMap.put(singleResponse.getCertId(), singleResponse);
        }
        if (derInputStream3.available() > 0 && (derValue3 = derInputStream3.getDerValue()).isContextSpecific((byte)1)) {
            DerValue[] derValueArray2 = derValue3.data.getSequence(3);
            for (int i = 0; i < derValueArray2.length; ++i) {
                x509CertImplArray = new Extension(derValueArray2[i]);
                if (DEBUG != null) {
                    DEBUG.println("OCSP extension: " + x509CertImplArray);
                }
                if (x509CertImplArray.getExtensionId().equals((Object)OCSP_NONCE_EXTENSION_OID) || !x509CertImplArray.isCritical()) continue;
                throw new IOException("Unsupported OCSP critical extension: " + x509CertImplArray.getExtensionId());
            }
        }
        AlgorithmId algorithmId = AlgorithmId.parse(derValueArray[1]);
        byte[] byArray3 = derValueArray[2].getBitString();
        x509CertImplArray = null;
        if (derValueArray.length > 3) {
            object2 = derValueArray[3];
            if (!((DerValue)object2).isContextSpecific((byte)0)) {
                throw new IOException("Bad encoding in certs element of OCSP response: expected ASN.1 context specific tag 0.");
            }
            object = ((DerValue)object2).getData().getSequence(3);
            x509CertImplArray = new X509CertImpl[((DerValue[])object).length];
            try {
                for (int i = 0; i < ((DerValue[])object).length; ++i) {
                    x509CertImplArray[i] = new X509CertImpl(((DerValue)object[i]).toByteArray());
                }
            }
            catch (CertificateException certificateException) {
                throw new IOException("Bad encoding in X509 Certificate", certificateException);
            }
        }
        object2 = list.get(0);
        if (x509CertImplArray != null && x509CertImplArray[0] != null) {
            object = x509CertImplArray[0];
            if (DEBUG != null) {
                DEBUG.println("Signer certificate name: " + ((X509CertImpl)object).getSubjectX500Principal());
                byte[] byArray4 = ((X509CertImpl)object).getSubjectKeyIdentifier();
                if (byArray4 != null) {
                    DEBUG.println("Signer certificate key ID: " + String.format("0x%0" + byArray4.length * 2 + "x", new BigInteger(1, byArray4)));
                }
            }
            byte[] byArray5 = null;
            for (X509Certificate x509Certificate : list) {
                List<String> list2;
                if (((Certificate)object).equals(x509Certificate)) {
                    object2 = x509Certificate;
                    if (DEBUG == null) break;
                    DEBUG.println("Signer certificate is a trusted responder");
                    break;
                }
                if (!((X509CertImpl)object).getIssuerX500Principal().equals(x509Certificate.getSubjectX500Principal())) continue;
                if (byArray5 == null && (byArray5 = ((X509CertImpl)object).getIssuerKeyIdentifier()) == null && DEBUG != null) {
                    DEBUG.println("No issuer key identifier (AKID) in the signer certificate");
                }
                byte[] byArray6 = null;
                if (byArray5 != null && (byArray6 = OCSPChecker.getKeyId(x509Certificate)) != null) {
                    if (!Arrays.equals(byArray5, byArray6)) continue;
                    if (DEBUG != null) {
                        DEBUG.println("Issuer certificate key ID: " + String.format("0x%0" + byArray5.length * 2 + "x", new BigInteger(1, byArray5)));
                    }
                }
                try {
                    list2 = ((X509CertImpl)object).getExtendedKeyUsage();
                    if (list2 == null) continue;
                    if (!list2.contains(KP_OCSP_SIGNING_OID)) {
                    }
                }
                catch (CertificateParsingException certificateParsingException) {}
                continue;
                list2 = new AlgorithmChecker(new TrustAnchor(x509Certificate, null));
                ((AlgorithmChecker)((Object)list2)).init(false);
                ((AlgorithmChecker)((Object)list2)).check((Certificate)object, Collections.emptySet());
                try {
                    ((X509CertImpl)object).checkValidity();
                }
                catch (GeneralSecurityException generalSecurityException) {
                    if (DEBUG == null) continue;
                    DEBUG.println("Responder's certificate not within the validity period " + generalSecurityException);
                    continue;
                }
                Extension extension = ((X509CertImpl)object).getExtension(PKIXExtensions.OCSPNoCheck_Id);
                if (extension != null && DEBUG != null) {
                    DEBUG.println("Responder's certificate includes the extension id-pkix-ocsp-nocheck.");
                }
                try {
                    ((X509CertImpl)object).verify(x509Certificate.getPublicKey());
                    object2 = object;
                    if (DEBUG == null) break;
                    DEBUG.println("Signer certificate was issued by a trusted responder");
                    break;
                }
                catch (GeneralSecurityException generalSecurityException) {
                    object2 = null;
                }
            }
        }
        if (object2 != null) {
            AlgorithmChecker.check(((Certificate)object2).getPublicKey(), algorithmId);
            if (!this.verifyResponse(byArray2, (X509Certificate)object2, algorithmId, byArray3)) {
                throw new CertPathValidatorException("Error verifying OCSP Responder's signature");
            }
        } else {
            throw new CertPathValidatorException("Responder's certificate is not trusted for signing OCSP responses");
        }
    }

    ResponseStatus getResponseStatus() {
        return this.responseStatus;
    }

    private boolean verifyResponse(byte[] byArray, X509Certificate x509Certificate, AlgorithmId algorithmId, byte[] byArray2) throws CertPathValidatorException {
        try {
            Signature signature = Signature.getInstance(algorithmId.getName());
            signature.initVerify(x509Certificate);
            signature.update(byArray);
            if (signature.verify(byArray2)) {
                if (DEBUG != null) {
                    DEBUG.println("Verified signature of OCSP Responder");
                }
                return true;
            }
            if (DEBUG != null) {
                DEBUG.println("Error verifying signature of OCSP Responder");
            }
            return false;
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new CertPathValidatorException(invalidKeyException);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new CertPathValidatorException(noSuchAlgorithmException);
        }
        catch (SignatureException signatureException) {
            throw new CertPathValidatorException(signatureException);
        }
    }

    SingleResponse getSingleResponse(CertId certId) {
        return this.singleResponseMap.get(certId);
    }

    public static enum ResponseStatus {
        SUCCESSFUL,
        MALFORMED_REQUEST,
        INTERNAL_ERROR,
        TRY_LATER,
        UNUSED,
        SIG_REQUIRED,
        UNAUTHORIZED;

    }

    static final class SingleResponse
    implements OCSP.RevocationStatus {
        private final CertId certId;
        private final OCSP.RevocationStatus.CertStatus certStatus;
        private final Date thisUpdate;
        private final Date nextUpdate;
        private final Date revocationTime;
        private final CRLReason revocationReason;
        private final Map<String, java.security.cert.Extension> singleExtensions;

        private SingleResponse(DerValue derValue) throws IOException {
            Object object;
            int n;
            DerValue[] derValueArray;
            if (derValue.tag != 48) {
                throw new IOException("Bad ASN.1 encoding in SingleResponse");
            }
            DerInputStream derInputStream = derValue.data;
            this.certId = new CertId(derInputStream.getDerValue().data);
            DerValue derValue2 = derInputStream.getDerValue();
            short s = (byte)(derValue2.tag & 0x1F);
            if (s == 1) {
                this.certStatus = OCSP.RevocationStatus.CertStatus.REVOKED;
                this.revocationTime = derValue2.data.getGeneralizedTime();
                if (derValue2.data.available() != 0) {
                    derValueArray = derValue2.data.getDerValue();
                    s = (byte)(derValueArray.tag & 0x1F);
                    this.revocationReason = s == 0 ? ((n = derValueArray.data.getEnumerated()) >= 0 && n < values.length ? values[n] : CRLReason.UNSPECIFIED) : CRLReason.UNSPECIFIED;
                } else {
                    this.revocationReason = CRLReason.UNSPECIFIED;
                }
                if (DEBUG != null) {
                    DEBUG.println("Revocation time: " + this.revocationTime);
                    DEBUG.println("Revocation reason: " + (Object)((Object)this.revocationReason));
                }
            } else {
                this.revocationTime = null;
                this.revocationReason = CRLReason.UNSPECIFIED;
                if (s == 0) {
                    this.certStatus = OCSP.RevocationStatus.CertStatus.GOOD;
                } else if (s == 2) {
                    this.certStatus = OCSP.RevocationStatus.CertStatus.UNKNOWN;
                } else {
                    throw new IOException("Invalid certificate status");
                }
            }
            this.thisUpdate = derInputStream.getGeneralizedTime();
            if (derInputStream.available() == 0) {
                this.nextUpdate = null;
            } else {
                derValue2 = derInputStream.getDerValue();
                s = (byte)(derValue2.tag & 0x1F);
                if (s == 0) {
                    this.nextUpdate = derValue2.data.getGeneralizedTime();
                    if (derInputStream.available() != 0) {
                        derValue2 = derInputStream.getDerValue();
                        s = (byte)(derValue2.tag & 0x1F);
                    }
                } else {
                    this.nextUpdate = null;
                }
            }
            if (derInputStream.available() > 0) {
                derValue2 = derInputStream.getDerValue();
                if (derValue2.isContextSpecific((byte)1)) {
                    derValueArray = derValue2.data.getSequence(3);
                    this.singleExtensions = new HashMap<String, java.security.cert.Extension>(derValueArray.length);
                    for (n = 0; n < derValueArray.length; ++n) {
                        object = new Extension(derValueArray[n]);
                        if (DEBUG != null) {
                            DEBUG.println("OCSP single extension: " + object);
                        }
                        if (((Extension)object).isCritical()) {
                            throw new IOException("Unsupported OCSP critical extension: " + ((Extension)object).getExtensionId());
                        }
                        this.singleExtensions.put(((Extension)object).getId(), (java.security.cert.Extension)object);
                    }
                } else {
                    this.singleExtensions = Collections.emptyMap();
                }
            } else {
                this.singleExtensions = Collections.emptyMap();
            }
            long l = System.currentTimeMillis();
            object = new Date(l + 900000L);
            Date date = new Date(l - 900000L);
            if (DEBUG != null) {
                String string = "";
                if (this.nextUpdate != null) {
                    string = " until " + this.nextUpdate;
                }
                DEBUG.println("Response's validity interval is from " + this.thisUpdate + string);
            }
            if (this.thisUpdate != null && ((Date)object).before(this.thisUpdate) || this.nextUpdate != null && date.after(this.nextUpdate)) {
                if (DEBUG != null) {
                    DEBUG.println("Response is unreliable: its validity interval is out-of-date");
                }
                throw new IOException("Response is unreliable: its validity interval is out-of-date");
            }
        }

        @Override
        public OCSP.RevocationStatus.CertStatus getCertStatus() {
            return this.certStatus;
        }

        private CertId getCertId() {
            return this.certId;
        }

        @Override
        public Date getRevocationTime() {
            return (Date)this.revocationTime.clone();
        }

        @Override
        public CRLReason getRevocationReason() {
            return this.revocationReason;
        }

        @Override
        public Map<String, java.security.cert.Extension> getSingleExtensions() {
            return Collections.unmodifiableMap(this.singleExtensions);
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("SingleResponse:  \n");
            stringBuilder.append(this.certId);
            stringBuilder.append("\nCertStatus: " + (Object)((Object)this.certStatus) + "\n");
            if (this.certStatus == OCSP.RevocationStatus.CertStatus.REVOKED) {
                stringBuilder.append("revocationTime is " + this.revocationTime + "\n");
                stringBuilder.append("revocationReason is " + (Object)((Object)this.revocationReason) + "\n");
            }
            stringBuilder.append("thisUpdate is " + this.thisUpdate + "\n");
            if (this.nextUpdate != null) {
                stringBuilder.append("nextUpdate is " + this.nextUpdate + "\n");
            }
            return stringBuilder.toString();
        }
    }
}

