/*
 * Decompiled with CFR 0.152.
 */
package com.sun.servicetag;

import com.sun.servicetag.RegistrationDocument;
import com.sun.servicetag.ServiceTag;
import com.sun.servicetag.SystemEnvironment;
import com.sun.servicetag.Util;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class RegistrationData {
    private final Map<String, String> environment = this.initEnvironment();
    private final Map<String, ServiceTag> svcTagMap = new LinkedHashMap<String, ServiceTag>();
    private final String urn;

    public RegistrationData() {
        this(Util.generateURN());
        SystemEnvironment systemEnvironment = SystemEnvironment.getSystemEnvironment();
        this.setEnvironment("hostname", systemEnvironment.getHostname());
        this.setEnvironment("hostId", systemEnvironment.getHostId());
        this.setEnvironment("osName", systemEnvironment.getOsName());
        this.setEnvironment("osVersion", systemEnvironment.getOsVersion());
        this.setEnvironment("osArchitecture", systemEnvironment.getOsArchitecture());
        this.setEnvironment("systemModel", systemEnvironment.getSystemModel());
        this.setEnvironment("systemManufacturer", systemEnvironment.getSystemManufacturer());
        this.setEnvironment("cpuManufacturer", systemEnvironment.getCpuManufacturer());
        this.setEnvironment("serialNumber", systemEnvironment.getSerialNumber());
    }

    RegistrationData(String string) {
        this.urn = string;
    }

    private Map<String, String> initEnvironment() {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        linkedHashMap.put("hostname", "");
        linkedHashMap.put("hostId", "");
        linkedHashMap.put("osName", "");
        linkedHashMap.put("osVersion", "");
        linkedHashMap.put("osArchitecture", "");
        linkedHashMap.put("systemModel", "");
        linkedHashMap.put("systemManufacturer", "");
        linkedHashMap.put("cpuManufacturer", "");
        linkedHashMap.put("serialNumber", "");
        return linkedHashMap;
    }

    public String getRegistrationURN() {
        return this.urn;
    }

    public Map<String, String> getEnvironmentMap() {
        return new LinkedHashMap<String, String>(this.environment);
    }

    public void setEnvironment(String string, String string2) {
        if (string == null) {
            throw new NullPointerException("name is null");
        }
        if (string2 == null) {
            throw new NullPointerException("value is null");
        }
        if (this.environment.containsKey(string)) {
            if ((string.equals("hostname") || string.equals("osName")) && string2.length() == 0) {
                throw new IllegalArgumentException("\"" + string + "\" requires non-empty value.");
            }
        } else {
            throw new IllegalArgumentException("\"" + string + "\" is not an environment element.");
        }
        this.environment.put(string, string2);
    }

    public Set<ServiceTag> getServiceTags() {
        return new HashSet<ServiceTag>(this.svcTagMap.values());
    }

    public synchronized ServiceTag addServiceTag(ServiceTag serviceTag) {
        ServiceTag serviceTag2 = ServiceTag.newInstanceWithUrnTimestamp(serviceTag);
        String string = serviceTag2.getInstanceURN();
        if (this.svcTagMap.containsKey(string)) {
            throw new IllegalArgumentException("Instance_urn = " + string + " already exists in the registration data.");
        }
        this.svcTagMap.put(string, serviceTag2);
        return serviceTag2;
    }

    public synchronized ServiceTag getServiceTag(String string) {
        if (string == null) {
            throw new NullPointerException("instanceURN is null");
        }
        return this.svcTagMap.get(string);
    }

    public synchronized ServiceTag removeServiceTag(String string) {
        if (string == null) {
            throw new NullPointerException("instanceURN is null");
        }
        ServiceTag serviceTag = null;
        if (this.svcTagMap.containsKey(string)) {
            serviceTag = this.svcTagMap.remove(string);
        }
        return serviceTag;
    }

    public synchronized ServiceTag updateServiceTag(String string, String string2) {
        ServiceTag serviceTag = this.getServiceTag(string);
        if (serviceTag == null) {
            return null;
        }
        serviceTag = ServiceTag.newInstanceWithUrnTimestamp(serviceTag);
        serviceTag.setProductDefinedInstanceID(string2);
        this.svcTagMap.put(string, serviceTag);
        return serviceTag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RegistrationData loadFromXML(InputStream inputStream) throws IOException {
        try {
            RegistrationData registrationData = RegistrationDocument.load(inputStream);
            return registrationData;
        }
        finally {
            inputStream.close();
        }
    }

    public void storeToXML(OutputStream outputStream) throws IOException {
        RegistrationDocument.store(outputStream, this);
        outputStream.flush();
    }

    public byte[] toXML() {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            this.storeToXML(byteArrayOutputStream);
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            return new byte[0];
        }
    }

    public String toString() {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            this.storeToXML(byteArrayOutputStream);
            return byteArrayOutputStream.toString("UTF-8");
        }
        catch (IOException iOException) {
            return "Error creating the return string.";
        }
    }
}

