/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.visualvm.application.views.threads;

import com.sun.tools.visualvm.application.views.threads.ThreadMXBeanDataManager;
import java.lang.management.ThreadMXBean;
import java.util.logging.Logger;

class DeadlockDetector {
    private static final Logger LOGGER = Logger.getLogger(DeadlockDetector.class.getName());
    private static int deadlockNumber = 10;
    private ThreadMXBean threadBean;
    private boolean deadlockDectionDisabled;
    private boolean findDeadlockedThreadsSupported;
    private int countDown;

    DeadlockDetector(ThreadMXBean tb) {
        this.threadBean = tb;
        this.findDeadlockedThreadsSupported = true;
    }

    long[] detectDeadlock() {
        long[] threadIds;
        if (this.deadlockDectionDisabled) {
            return null;
        }
        if (this.countDown++ % deadlockNumber != 0) {
            return null;
        }
        try {
            threadIds = this.findDeadlockedThreadsSupported ? this.threadBean.findDeadlockedThreads() : this.threadBean.findMonitorDeadlockedThreads();
        }
        catch (SecurityException ex) {
            LOGGER.throwing(ThreadMXBeanDataManager.class.getName(), "detectDeadlock", ex);
            this.deadlockDectionDisabled = true;
            return null;
        }
        catch (UnsupportedOperationException ex) {
            if (this.findDeadlockedThreadsSupported) {
                this.findDeadlockedThreadsSupported = false;
                this.detectDeadlock();
            } else {
                LOGGER.throwing(ThreadMXBeanDataManager.class.getName(), "detectDeadlock", ex);
                this.deadlockDectionDisabled = true;
            }
            return null;
        }
        if (threadIds != null) assert (threadIds.length > 0);
        return threadIds;
    }
}

