/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.actions;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import org.netbeans.lib.profiler.TargetAppRunner;
import org.netbeans.lib.profiler.client.ClientUtils;
import org.netbeans.lib.profiler.common.Profiler;
import org.netbeans.lib.profiler.common.event.ProfilingStateEvent;
import org.netbeans.lib.profiler.common.event.ProfilingStateListener;
import org.netbeans.modules.profiler.ResultsListener;
import org.netbeans.modules.profiler.ResultsManager;
import org.netbeans.modules.profiler.api.icons.Icons;
import org.netbeans.modules.profiler.utilities.Delegate;
import org.netbeans.modules.profiler.utilities.ProfilerUtils;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public final class ResetResultsAction
extends AbstractAction
implements ProfilingStateListener {
    Listener resultListener;
    private static ResetResultsAction instance;

    private ResetResultsAction() {
        this.putValue("Name", NbBundle.getMessage(ResetResultsAction.class, (String)"LBL_ResetResultsAction"));
        this.putValue("ShortDescription", NbBundle.getMessage(ResetResultsAction.class, (String)"HINT_ResetResultsAction"));
        this.putValue("SmallIcon", Icons.getIcon((String)"ProfilerIcons.ResetResults"));
        this.putValue("iconBase", Icons.getResource((String)"ProfilerIcons.ResetResults"));
        this.updateEnabledState();
        this.resultListener = (Listener)Lookup.getDefault().lookup(Listener.class);
        this.resultListener.setDelegate(this);
        Profiler.getDefault().addProfilingStateListener((ProfilingStateListener)this);
    }

    public static synchronized ResetResultsAction getInstance() {
        if (instance == null) {
            instance = new ResetResultsAction();
        }
        return instance;
    }

    public void instrumentationChanged(int n, int n2) {
    }

    public void profilingStateChanged(ProfilingStateEvent profilingStateEvent) {
        this.updateEnabledState();
    }

    public void threadsMonitoringChanged() {
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        ProfilerUtils.runInProfilerRequestProcessor((Runnable)new Runnable(){

            @Override
            public void run() {
                ResultsManager.getDefault().reset();
                try {
                    TargetAppRunner targetAppRunner = Profiler.getDefault().getTargetAppRunner();
                    if (targetAppRunner.targetJVMIsAlive()) {
                        targetAppRunner.resetTimers();
                    } else {
                        targetAppRunner.getProfilerClient().resetClientData();
                    }
                }
                catch (ClientUtils.TargetAppOrVMTerminated targetAppOrVMTerminated) {
                    // empty catch block
                }
            }
        });
    }

    private void updateEnabledState() {
        this.setEnabled(ResultsManager.getDefault().resultsAvailable());
    }

    public static final class Listener
    extends Delegate<ResetResultsAction>
    implements ResultsListener {
        @Override
        public void resultsAvailable() {
            if (this.getDelegate() != null) {
                ((ResetResultsAction)this.getDelegate()).updateEnabledState();
            }
        }

        @Override
        public void resultsReset() {
            if (this.getDelegate() != null) {
                ((ResetResultsAction)this.getDelegate()).updateEnabledState();
            }
        }
    }
}

