/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.lang.management.ThreadInfo;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.GZIPInputStream;
import java.util.zip.Inflater;
import javax.management.openmbean.CompositeData;
import org.netbeans.lib.profiler.common.ProfilingSettings;
import org.netbeans.lib.profiler.common.ProfilingSettingsPresets;
import org.netbeans.lib.profiler.results.ResultsSnapshot;
import org.netbeans.lib.profiler.results.coderegion.CodeRegionResultsSnapshot;
import org.netbeans.lib.profiler.results.cpu.CPUResultsSnapshot;
import org.netbeans.lib.profiler.results.cpu.StackTraceSnapshotBuilder;
import org.netbeans.lib.profiler.results.memory.AllocMemoryResultsSnapshot;
import org.netbeans.lib.profiler.results.memory.LivenessMemoryResultsSnapshot;
import org.netbeans.modules.profiler.api.ProfilerDialogs;
import org.netbeans.modules.profiler.api.ProjectUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class LoadedSnapshot {
    private static final Logger LOGGER = Logger.getLogger(LoadedSnapshot.class.getName());
    private static final String ILLEGAL_SNAPSHOT_DATA_MSG = NbBundle.getMessage(LoadedSnapshot.class, (String)"LoadedSnapshot_IllegalSnapshotDataMsg");
    private static final String INVALID_SNAPSHOT_FILE_MSG = NbBundle.getMessage(LoadedSnapshot.class, (String)"LoadedSnapshot_InvalidSnapshotFileMsg");
    private static final String UNSUPPORTED_SNAPSHOT_VERSION_MSG = NbBundle.getMessage(LoadedSnapshot.class, (String)"LoadedSnapshot_UnsupportedSnapshotVersionMsg");
    private static final String WRONG_SNAPSHOT_TYPE_MSG = NbBundle.getMessage(LoadedSnapshot.class, (String)"LoadedSnapshot_WrongSnapshotTypeMsg");
    private static final String CANNOT_READ_SNAPSHOT_DATA_MSG = NbBundle.getMessage(LoadedSnapshot.class, (String)"LoadedSnapshot_CannotReadSnapshotDataMsg");
    private static final String CANNOT_READ_SETTINGS_DATA_MSG = NbBundle.getMessage(LoadedSnapshot.class, (String)"LoadedSnapshot_CannotReadSettingsDataMsg");
    private static final String UNRECOGNIZED_SNAPSHOT_TYPE_MSG = NbBundle.getMessage(LoadedSnapshot.class, (String)"LoadedSnapshot_UnrecognizedSnapshotTypeMsg");
    private static final String SNAPSHOT_DATA_CORRUPTED_MSG = NbBundle.getMessage(LoadedSnapshot.class, (String)"LoadedSnapshot_SnapshotDataCorruptedMsg");
    private static final String SNAPSHOT_FILE_SHORT_MSG = NbBundle.getMessage(LoadedSnapshot.class, (String)"LoadedSnapshot_SnapshotFileShortMsg");
    private static final String SNAPSHOT_FILE_CORRUPTED = NbBundle.getMessage(LoadedSnapshot.class, (String)"LoadedSnapshot_SnapshotFileCorrupted");
    private static final String SNAPSHOT_FILE_CORRUPTED_REASON = NbBundle.getMessage(LoadedSnapshot.class, (String)"LoadedSnapshot_SnapshotFileCorruptedReason");
    private static final String OUT_OF_MEMORY_LOADING = NbBundle.getMessage(LoadedSnapshot.class, (String)"LoadedSnapshot_OutOfMemoryLoadingMsg");
    public static final int SNAPSHOT_TYPE_UNKNOWN = 0;
    public static final int SNAPSHOT_TYPE_CPU = 1;
    public static final int SNAPSHOT_TYPE_CODEFRAGMENT = 2;
    public static final int SNAPSHOT_TYPE_MEMORY_ALLOCATIONS = 4;
    public static final int SNAPSHOT_TYPE_MEMORY_LIVENESS = 8;
    public static final int SNAPSHOT_TYPE_MEMORY = 12;
    public static final String PROFILER_FILE_MAGIC_STRING = "nBpRoFiLeR";
    private static final byte SNAPSHOT_FILE_VERSION_MAJOR = 1;
    private static final byte SNAPSHOT_FILE_VERSION_MINOR = 1;
    private File file;
    private ProfilingSettings settings;
    private Lookup.Provider project = null;
    private ResultsSnapshot snapshot;
    private boolean saved = false;

    public LoadedSnapshot(ResultsSnapshot resultsSnapshot, ProfilingSettings profilingSettings, File file, Lookup.Provider provider) {
        if (resultsSnapshot == null) {
            throw new IllegalArgumentException();
        }
        if (profilingSettings == null) {
            throw new IllegalArgumentException();
        }
        this.snapshot = resultsSnapshot;
        this.settings = profilingSettings;
        this.file = file;
        this.project = provider;
    }

    private LoadedSnapshot() {
    }

    public void setFile(File file) {
        this.file = file;
        this.saved = true;
    }

    public File getFile() {
        return this.file;
    }

    public Lookup.Provider getProject() {
        return this.project;
    }

    public void setSaved(boolean bl) {
        this.saved = bl;
    }

    public boolean isSaved() {
        return this.saved;
    }

    public ProfilingSettings getSettings() {
        return this.settings;
    }

    public ResultsSnapshot getSnapshot() {
        return this.snapshot;
    }

    public int getType() {
        if (this.snapshot instanceof CPUResultsSnapshot) {
            return 1;
        }
        if (this.snapshot instanceof CodeRegionResultsSnapshot) {
            return 2;
        }
        if (this.snapshot instanceof LivenessMemoryResultsSnapshot) {
            return 8;
        }
        if (this.snapshot instanceof AllocMemoryResultsSnapshot) {
            return 4;
        }
        throw new IllegalStateException(ILLEGAL_SNAPSHOT_DATA_MSG);
    }

    public static LoadedSnapshot loadSnapshot(DataInputStream dataInputStream) throws IOException {
        dataInputStream.mark(100);
        try {
            LoadedSnapshot loadedSnapshot = new LoadedSnapshot();
            if (loadedSnapshot.load(dataInputStream)) {
                return loadedSnapshot;
            }
            return null;
        }
        catch (IOException iOException) {
            if (INVALID_SNAPSHOT_FILE_MSG.equals(iOException.getMessage())) {
                dataInputStream.reset();
                return LoadedSnapshot.loadSnapshotFromStackTraces(dataInputStream);
            }
            throw iOException;
        }
    }

    private static LoadedSnapshot loadSnapshotFromStackTraces(DataInputStream dataInputStream) throws IOException {
        CPUResultsSnapshot cPUResultsSnapshot;
        SamplesInputStream samplesInputStream = new SamplesInputStream(dataInputStream);
        StackTraceSnapshotBuilder stackTraceSnapshotBuilder = new StackTraceSnapshotBuilder();
        ThreadsSample threadsSample = samplesInputStream.readSample();
        long l = threadsSample.getTime();
        while (threadsSample != null) {
            stackTraceSnapshotBuilder.addStacktrace(threadsSample.getTinfos(), threadsSample.getTime());
            threadsSample = samplesInputStream.readSample();
        }
        samplesInputStream.close();
        samplesInputStream = null;
        try {
            cPUResultsSnapshot = stackTraceSnapshotBuilder.createSnapshot(l);
        }
        catch (CPUResultsSnapshot.NoDataAvailableException noDataAvailableException) {
            throw new IOException(noDataAvailableException);
        }
        return new LoadedSnapshot((ResultsSnapshot)cPUResultsSnapshot, ProfilingSettingsPresets.createCPUPreset(), null, null);
    }

    public void setProject(Lookup.Provider provider) {
        this.project = provider;
    }

    static void writeToStream(CPUResultsSnapshot cPUResultsSnapshot, DataOutputStream dataOutputStream) throws IOException {
        LoadedSnapshot loadedSnapshot = new LoadedSnapshot((ResultsSnapshot)cPUResultsSnapshot, ProfilingSettingsPresets.createCPUPreset(), null, null);
        loadedSnapshot.save(dataOutputStream);
    }

    public void save(DataOutputStream dataOutputStream) throws IOException, OutOfMemoryError {
        Properties properties = new Properties();
        this.settings.store((Map)properties);
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest("save properties: --------------------------------------------------------------");
            LOGGER.finest(this.settings.debug());
            LOGGER.finest("-------------------------------------------------------------------------------");
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(1000000);
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(byteArrayOutputStream);
        DataOutputStream dataOutputStream2 = new DataOutputStream(bufferedOutputStream);
        ByteArrayOutputStream byteArrayOutputStream2 = new ByteArrayOutputStream(10000);
        BufferedOutputStream bufferedOutputStream2 = new BufferedOutputStream(byteArrayOutputStream2);
        DataOutputStream dataOutputStream3 = new DataOutputStream(bufferedOutputStream2);
        try {
            this.snapshot.writeToStream(dataOutputStream2);
            dataOutputStream2.flush();
            properties.store(dataOutputStream3, "");
            dataOutputStream3.flush();
            byte[] byArray = byteArrayOutputStream.toByteArray();
            byte[] byArray2 = new byte[byArray.length];
            Deflater deflater = new Deflater();
            deflater.setInput(byArray);
            deflater.finish();
            int n = deflater.deflate(byArray2);
            int n2 = byArray.length;
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.finest("save version:1.1");
                LOGGER.finest("save type:" + this.getType());
                LOGGER.finest("length of uncompressed snapshot data:" + n2);
                LOGGER.finest("save length of snapshot data:" + n);
                LOGGER.finest("length of settings data:" + byteArrayOutputStream2.size());
            }
            dataOutputStream.writeBytes(PROFILER_FILE_MAGIC_STRING);
            dataOutputStream.writeByte(1);
            dataOutputStream.writeByte(1);
            dataOutputStream.writeInt(this.getType());
            dataOutputStream.writeInt(n);
            dataOutputStream.writeInt(n2);
            dataOutputStream.write(byArray2, 0, n);
            dataOutputStream.writeInt(byteArrayOutputStream2.size());
            dataOutputStream.write(byteArrayOutputStream2.toByteArray());
        }
        catch (OutOfMemoryError outOfMemoryError) {
            byteArrayOutputStream = null;
            bufferedOutputStream = null;
            dataOutputStream2 = null;
            byteArrayOutputStream2 = null;
            bufferedOutputStream2 = null;
            dataOutputStream3 = null;
            throw outOfMemoryError;
        }
        finally {
            if (dataOutputStream2 != null) {
                dataOutputStream2.close();
            }
            if (dataOutputStream3 != null) {
                dataOutputStream3.close();
            }
        }
    }

    public String toString() {
        String string = "snapshot = " + this.snapshot.toString();
        String string2 = "file = " + (this.file == null ? "null" : this.file.toString());
        String string3 = "project = " + (this.project == null ? "null" : ProjectUtilities.getDisplayName((Lookup.Provider)this.project));
        return "Loaded Results Snapshot, " + string + ", " + string3 + ", " + string2;
    }

    private static String getCorruptedMessage(IOException iOException) {
        String string = iOException.getMessage();
        if (string == null) {
            if (iOException instanceof EOFException) {
                return MessageFormat.format(SNAPSHOT_FILE_CORRUPTED_REASON, SNAPSHOT_FILE_SHORT_MSG);
            }
            return SNAPSHOT_FILE_CORRUPTED;
        }
        return MessageFormat.format(SNAPSHOT_FILE_CORRUPTED_REASON, string);
    }

    private boolean load(DataInputStream dataInputStream) throws IOException {
        try {
            byte[] byArray;
            int n;
            Properties properties = new Properties();
            this.settings = new ProfilingSettings();
            byte[] byArray2 = new byte[PROFILER_FILE_MAGIC_STRING.length()];
            int n2 = dataInputStream.read(byArray2);
            if (n2 != PROFILER_FILE_MAGIC_STRING.length() || !PROFILER_FILE_MAGIC_STRING.equals(new String(byArray2))) {
                throw new IOException(INVALID_SNAPSHOT_FILE_MSG);
            }
            byte by = dataInputStream.readByte();
            byte by2 = dataInputStream.readByte();
            if (by > 1) {
                throw new IOException(MessageFormat.format(SNAPSHOT_FILE_CORRUPTED_REASON, UNSUPPORTED_SNAPSHOT_VERSION_MSG));
            }
            int n3 = dataInputStream.readInt();
            if (n3 == -1) {
                throw new IOException(MessageFormat.format(SNAPSHOT_FILE_CORRUPTED_REASON, WRONG_SNAPSHOT_TYPE_MSG));
            }
            int n4 = dataInputStream.readInt();
            int n5 = dataInputStream.readInt();
            byte[] byArray3 = new byte[n4];
            int n6 = dataInputStream.read(byArray3, 0, n4);
            if (n4 != n6) {
                throw new IOException(MessageFormat.format(SNAPSHOT_FILE_CORRUPTED_REASON, CANNOT_READ_SNAPSHOT_DATA_MSG));
            }
            int n7 = dataInputStream.readInt();
            if (n7 != (n = dataInputStream.read(byArray = new byte[n7]))) {
                throw new IOException(MessageFormat.format(SNAPSHOT_FILE_CORRUPTED_REASON, CANNOT_READ_SETTINGS_DATA_MSG));
            }
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.finest("load version:" + by + "." + by2);
                LOGGER.finest("load type:" + n3);
                LOGGER.finest("load length of snapshot data:" + n4);
                LOGGER.finest("uncompressed length of snapshot data:" + n5);
                LOGGER.finest("load length of settings data:" + n7);
            }
            switch (n3) {
                case 1: {
                    this.snapshot = new CPUResultsSnapshot();
                    break;
                }
                case 2: {
                    this.snapshot = new CodeRegionResultsSnapshot();
                    break;
                }
                case 4: {
                    this.snapshot = new AllocMemoryResultsSnapshot();
                    break;
                }
                case 8: {
                    this.snapshot = new LivenessMemoryResultsSnapshot();
                    break;
                }
                default: {
                    throw new IOException(MessageFormat.format(SNAPSHOT_FILE_CORRUPTED_REASON, UNRECOGNIZED_SNAPSHOT_TYPE_MSG));
                }
            }
            Inflater inflater = new Inflater();
            inflater.setInput(byArray3, 0, byArray3.length);
            byte[] byArray4 = new byte[n5];
            try {
                int n8 = inflater.inflate(byArray4);
                if (n8 != n5) {
                    throw new IOException(MessageFormat.format(SNAPSHOT_FILE_CORRUPTED_REASON, SNAPSHOT_DATA_CORRUPTED_MSG));
                }
            }
            catch (DataFormatException dataFormatException) {
                throw new IOException(MessageFormat.format(SNAPSHOT_FILE_CORRUPTED_REASON, SNAPSHOT_DATA_CORRUPTED_MSG));
            }
            inflater.end();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray4);
            BufferedInputStream bufferedInputStream = new BufferedInputStream(byteArrayInputStream);
            DataInputStream dataInputStream2 = new DataInputStream(bufferedInputStream);
            try {
                this.snapshot.readFromStream(dataInputStream2);
            }
            catch (IOException iOException) {
                throw new IOException(LoadedSnapshot.getCorruptedMessage(iOException));
            }
            finally {
                dataInputStream2.close();
            }
            ByteArrayInputStream byteArrayInputStream2 = new ByteArrayInputStream(byArray);
            BufferedInputStream bufferedInputStream2 = new BufferedInputStream(byteArrayInputStream2);
            DataInputStream dataInputStream3 = new DataInputStream(bufferedInputStream2);
            try {
                properties.load(dataInputStream3);
            }
            catch (IOException iOException) {
                throw new IOException(LoadedSnapshot.getCorruptedMessage(iOException));
            }
            finally {
                dataInputStream3.close();
            }
            this.settings.load((Map)properties);
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.finest("load properties: --------------------------------------------------------------");
                LOGGER.finest(this.settings.debug());
                LOGGER.finest("-------------------------------------------------------------------------------");
            }
        }
        catch (OutOfMemoryError outOfMemoryError) {
            ProfilerDialogs.displayError((String)OUT_OF_MEMORY_LOADING);
            return false;
        }
        return true;
    }

    static final class ThreadsSample {
        private final long time;
        private final ThreadInfo[] tinfos;

        ThreadsSample(long l, Collection<ThreadInfo> collection) {
            this.time = l;
            this.tinfos = collection.toArray(new ThreadInfo[collection.size()]);
        }

        long getTime() {
            return this.time;
        }

        ThreadInfo[] getTinfos() {
            return this.tinfos;
        }
    }

    static class SamplesInputStream {
        static final String ID = "NPSS";
        static final int MAX_SUPPORTED_VERSION = 2;
        int version;
        int samples;
        long lastTimestamp;
        ObjectInputStream in;
        Map<Long, ThreadInfo> threads;

        SamplesInputStream(File file) throws IOException {
            this(new FileInputStream(file));
        }

        SamplesInputStream(InputStream inputStream) throws IOException {
            this.readHeader(inputStream);
            this.in = new ObjectInputStream(new GZIPInputStream(inputStream));
            if (this.version > 1) {
                this.samples = this.in.readInt();
                this.lastTimestamp = this.in.readLong();
            }
            this.threads = new HashMap<Long, ThreadInfo>(128);
        }

        int getSamples() {
            return this.samples;
        }

        long getLastTimestamp() {
            return this.lastTimestamp;
        }

        ThreadsSample readSample() throws IOException {
            ThreadInfo threadInfo;
            Object object;
            int n;
            long l;
            try {
                l = this.in.readLong();
            }
            catch (EOFException eOFException) {
                return null;
            }
            HashMap<Long, ThreadInfo> hashMap = new HashMap<Long, ThreadInfo>(this.threads.size());
            int n2 = this.in.readInt();
            for (n = 0; n < n2; ++n) {
                object = this.in.readLong();
                threadInfo = this.threads.get(object);
                assert (threadInfo != null);
                hashMap.put((Long)object, threadInfo);
            }
            ThreadInfo[] threadInfoArray = new ThreadInfo[this.in.readInt()];
            for (n = 0; n < threadInfoArray.length; ++n) {
                try {
                    object = (CompositeData)this.in.readObject();
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new RuntimeException(classNotFoundException);
                }
                threadInfo = ThreadInfo.from((CompositeData)object);
                hashMap.put(threadInfo.getThreadId(), threadInfo);
            }
            this.threads = hashMap;
            return new ThreadsSample(l, this.threads.values());
        }

        void close() throws IOException {
            this.in.close();
        }

        private void readHeader(InputStream inputStream) throws IOException {
            byte[] byArray = new byte[ID.length()];
            inputStream.read(byArray);
            String string = new String(byArray);
            if (!ID.equals(string)) {
                throw new IOException("Invalid header " + string);
            }
            this.version = inputStream.read();
            if (this.version > 2) {
                throw new IOException("NPSS file version " + this.version + " is not supported");
            }
        }
    }
}

