/*
 * Decompiled with CFR 0.152.
 */
package com.javafx.tools.doclets.formats.html;

import com.javafx.tools.doclets.formats.html.AbstractMemberWriter;
import com.javafx.tools.doclets.formats.html.LinkInfoImpl;
import com.javafx.tools.doclets.formats.html.SubWriterHolderWriter;
import com.javafx.tools.doclets.formats.html.markup.HtmlTree;
import com.javafx.tools.doclets.formats.html.markup.RawHtml;
import com.javafx.tools.doclets.internal.toolkit.Content;
import com.javafx.tools.doclets.internal.toolkit.util.DocletConstants;
import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.Doc;
import com.sun.javadoc.ExecutableMemberDoc;
import com.sun.javadoc.MemberDoc;
import com.sun.javadoc.MethodDoc;
import com.sun.javadoc.Parameter;
import com.sun.javadoc.ProgramElementDoc;
import com.sun.javadoc.Type;

public abstract class AbstractExecutableMemberWriter
extends AbstractMemberWriter {
    public AbstractExecutableMemberWriter(SubWriterHolderWriter writer, ClassDoc classdoc) {
        super(writer, classdoc);
    }

    public AbstractExecutableMemberWriter(SubWriterHolderWriter writer) {
        super(writer);
    }

    protected int addTypeParameters(ExecutableMemberDoc member, Content htmltree) {
        LinkInfoImpl linkInfo = new LinkInfoImpl(32, member, false);
        String typeParameters = this.writer.getTypeParameterLinks(linkInfo);
        if (linkInfo.displayLength > 0) {
            RawHtml linkContent = new RawHtml(typeParameters);
            htmltree.addContent(linkContent);
            htmltree.addContent(this.writer.getSpace());
            this.writer.displayLength += linkInfo.displayLength + 1;
        }
        return linkInfo.displayLength;
    }

    protected Content getDeprecatedLink(ProgramElementDoc member) {
        ExecutableMemberDoc emd = (ExecutableMemberDoc)member;
        return this.writer.getDocLink(3, (MemberDoc)emd, emd.qualifiedName() + emd.flatSignature());
    }

    protected void addSummaryLink(int context, ClassDoc cd, ProgramElementDoc member, Content tdSummary) {
        ExecutableMemberDoc emd = (ExecutableMemberDoc)member;
        String name = emd.name();
        HtmlTree strong = HtmlTree.STRONG(new RawHtml(this.writer.getDocLink(context, cd, (MemberDoc)emd, name, false)));
        HtmlTree code = HtmlTree.CODE(strong);
        this.writer.displayLength = name.length();
        this.addParameters(emd, false, code);
        tdSummary.addContent(code);
    }

    protected void addInheritedSummaryLink(ClassDoc cd, ProgramElementDoc member, Content linksTree) {
        linksTree.addContent(new RawHtml(this.writer.getDocLink(3, cd, (MemberDoc)member, member.name(), false)));
    }

    protected void addParam(ExecutableMemberDoc member, Parameter param, boolean isVarArg, Content tree) {
        if (param.type() != null) {
            RawHtml link = new RawHtml(this.writer.getLink(new LinkInfoImpl(18, param.type(), isVarArg)));
            tree.addContent(link);
        }
        if (param.name().length() > 0) {
            tree.addContent(this.writer.getSpace());
            tree.addContent(param.name());
        }
    }

    protected void addParameters(ExecutableMemberDoc member, Content htmltree) {
        this.addParameters(member, true, htmltree);
    }

    protected void addParameters(ExecutableMemberDoc member, boolean includeAnnotations, Content htmltree) {
        boolean foundAnnotations;
        htmltree.addContent("(");
        Parameter[] params = member.parameters();
        String indent = this.makeSpace(this.writer.displayLength);
        if (this.configuration().linksource) {
            indent = indent + this.makeSpace(member.name().length());
        }
        for (int paramstart = 0; paramstart < params.length; ++paramstart) {
            Parameter param = params[paramstart];
            if (param.name().startsWith("this$")) continue;
            if (includeAnnotations && (foundAnnotations = this.writer.addAnnotationInfo(indent.length(), (Doc)member, param, htmltree))) {
                htmltree.addContent(DocletConstants.NL);
                htmltree.addContent(indent);
            }
            this.addParam(member, param, paramstart == params.length - 1 && member.isVarArgs(), htmltree);
            break;
        }
        for (int i = paramstart + 1; i < params.length; ++i) {
            htmltree.addContent(",");
            htmltree.addContent(DocletConstants.NL);
            htmltree.addContent(indent);
            if (includeAnnotations && (foundAnnotations = this.writer.addAnnotationInfo(indent.length(), (Doc)member, params[i], htmltree))) {
                htmltree.addContent(DocletConstants.NL);
                htmltree.addContent(indent);
            }
            this.addParam(member, params[i], i == params.length - 1 && member.isVarArgs(), htmltree);
        }
        htmltree.addContent(")");
    }

    protected void addExceptions(ExecutableMemberDoc member, Content htmltree) {
        Type[] exceptions = member.thrownExceptionTypes();
        if (exceptions.length > 0) {
            LinkInfoImpl memberTypeParam = new LinkInfoImpl(3, member, false);
            int retlen = this.getReturnTypeLength(member);
            this.writer.getTypeParameterLinks(memberTypeParam);
            String indent = this.makeSpace(this.modifierString((MemberDoc)member).length() + member.name().length() + (retlen += memberTypeParam.displayLength == 0 ? 0 : memberTypeParam.displayLength + 1) - 4);
            htmltree.addContent(DocletConstants.NL);
            htmltree.addContent(indent);
            htmltree.addContent("throws ");
            indent = indent + "       ";
            RawHtml link = new RawHtml(this.writer.getLink(new LinkInfoImpl(3, exceptions[0])));
            htmltree.addContent(link);
            for (int i = 1; i < exceptions.length; ++i) {
                htmltree.addContent(",");
                htmltree.addContent(DocletConstants.NL);
                htmltree.addContent(indent);
                RawHtml exceptionLink = new RawHtml(this.writer.getLink(new LinkInfoImpl(3, exceptions[i])));
                htmltree.addContent(exceptionLink);
            }
        }
    }

    protected int getReturnTypeLength(ExecutableMemberDoc member) {
        if (member instanceof MethodDoc) {
            MethodDoc method = (MethodDoc)member;
            Type rettype = method.returnType();
            if (rettype.isPrimitive()) {
                return rettype.typeName().length() + rettype.dimension().length();
            }
            LinkInfoImpl linkInfo = new LinkInfoImpl(3, rettype);
            this.writer.getLink(linkInfo);
            return linkInfo.displayLength;
        }
        return -1;
    }

    protected ClassDoc implementsMethodInIntfac(MethodDoc method, ClassDoc[] intfacs) {
        for (int i = 0; i < intfacs.length; ++i) {
            MethodDoc[] methods = intfacs[i].methods();
            if (methods.length <= 0) continue;
            for (int j = 0; j < methods.length; ++j) {
                if (!methods[j].name().equals(method.name()) || !methods[j].signature().equals(method.signature())) continue;
                return intfacs[i];
            }
        }
        return null;
    }

    protected String getErasureAnchor(ExecutableMemberDoc emd) {
        StringBuffer buf = new StringBuffer(emd.name() + "(");
        Parameter[] params = emd.parameters();
        boolean foundTypeVariable = false;
        for (int i = 0; i < params.length; ++i) {
            if (i > 0) {
                buf.append(",");
            }
            Type t = params[i].type();
            foundTypeVariable = foundTypeVariable || t.asTypeVariable() != null;
            buf.append(t.isPrimitive() ? t.typeName() : t.asClassDoc().qualifiedName());
            buf.append(t.dimension());
        }
        buf.append(")");
        return foundTypeVariable ? buf.toString() : null;
    }
}

