/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.components;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.LinkedList;
import javax.swing.BorderFactory;
import javax.swing.JTable;
import javax.swing.JToolTip;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.lib.profiler.ui.components.CellTipAware;
import org.netbeans.lib.profiler.ui.components.CellTipManager;
import org.netbeans.lib.profiler.ui.components.table.EnhancedTableCellRenderer;
import org.netbeans.lib.profiler.ui.components.table.TableCellRendererPersistent;

public class JExtendedTable
extends JTable
implements CellTipAware,
MouseListener,
MouseMotionListener,
MouseWheelListener {
    protected JToolTip cellTip;
    protected Rectangle rendererRect;
    protected int lastColumn = -1;
    protected int lastRow = -1;
    private String internalFindString;
    private String userFindString;
    private int userFindColumn;

    public JExtendedTable(TableModel tableModel) {
        super(tableModel);
        this.setBackground(UIUtils.getProfilerResultsBackground());
        this.cellTip = this.createCellTip();
        this.cellTip.setBorder(BorderFactory.createLineBorder(this.getGridColor()));
        this.cellTip.setLayout(new BorderLayout());
        this.initListeners();
        CellTipManager.sharedInstance().registerComponent(this);
    }

    @Override
    public JToolTip getCellTip() {
        return this.cellTip;
    }

    @Override
    public Point getCellTipLocation() {
        if (this.rendererRect == null) {
            return null;
        }
        return new Point(this.rendererRect.getLocation().x - 1, this.rendererRect.getLocation().y - 1);
    }

    public int getFindColumn() {
        return this.userFindColumn;
    }

    public boolean isFindColumnValid() {
        return this.userFindColumn >= 0 && this.userFindColumn < this.getColumnCount();
    }

    public void setFindParameters(String string, int n) {
        this.userFindString = string;
        this.userFindColumn = n;
        this.internalFindString = this.getInternalFindString(this.userFindString);
    }

    public String getFindString() {
        return this.userFindString;
    }

    public boolean isFindStringDefined() {
        return this.userFindString != null && this.userFindString.trim().length() > 0;
    }

    @Override
    public void setGridColor(Color color) {
        super.setGridColor(color);
        if (color == null || this.cellTip == null) {
            return;
        }
        this.cellTip.setBorder(BorderFactory.createLineBorder(color));
    }

    public boolean canFindBePerformed() {
        return this.getRowCount() > 0 && this.isFindColumnValid() && this.isFindStringDefined();
    }

    public void ensureRowVisible(int n) {
        this.scrollRectToVisible(this.getCellRect(n, 0, true));
    }

    public boolean findFirst() {
        if (!this.canFindBePerformed()) {
            return false;
        }
        if (this.matchesFindCriterion(0)) {
            return this.selectFoundNode(0);
        }
        return this.doFindNext(0);
    }

    public boolean findNext() {
        if (!this.canFindBePerformed()) {
            return false;
        }
        return this.doFindNext(this.getSearchRoot());
    }

    public boolean findPrevious() {
        if (!this.canFindBePerformed()) {
            return false;
        }
        return this.doFindPrevious(this.getSearchRoot());
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        CellTipManager.sharedInstance().setEnabled(false);
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        if (this.contains(mouseEvent.getPoint()) && this.cellTip.isShowing()) {
            return;
        }
        CellTipManager.sharedInstance().setEnabled(false);
        this.lastRow = -1;
        this.lastColumn = -1;
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        int n = this.rowAtPoint(mouseEvent.getPoint());
        int n2 = this.columnAtPoint(mouseEvent.getPoint());
        if (n == this.lastRow && n2 == this.lastColumn) {
            return;
        }
        this.lastRow = n;
        this.lastColumn = n2;
        if (n < 0 || n2 < 0) {
            CellTipManager.sharedInstance().setEnabled(false);
            return;
        }
        TableCellRenderer tableCellRenderer = this.getCellRenderer(n, n2);
        if (!(tableCellRenderer instanceof TableCellRendererPersistent)) {
            return;
        }
        Component component = ((TableCellRendererPersistent)tableCellRenderer).getTableCellRendererComponentPersistent(this, this.getValueAt(n, n2), false, false, n, n2);
        Rectangle rectangle = this.getCellRect(n, n2, false);
        if (component == null) {
            CellTipManager.sharedInstance().setEnabled(false);
            return;
        }
        int n3 = ((EnhancedTableCellRenderer)component).getHorizontalAlignment();
        this.rendererRect = n3 == 11 || n3 == 4 ? new Rectangle(rectangle.x + rectangle.width - component.getPreferredSize().width, rectangle.y, component.getPreferredSize().width, component.getPreferredSize().height) : new Rectangle(rectangle.x, rectangle.y, component.getPreferredSize().width, component.getPreferredSize().height);
        if (this.rendererRect.x >= rectangle.x && this.rendererRect.x + this.rendererRect.width <= rectangle.x + rectangle.width) {
            CellTipManager.sharedInstance().setEnabled(false);
            return;
        }
        while (this.cellTip.getComponentCount() > 0) {
            this.cellTip.remove(0);
        }
        this.cellTip.add(component, "Center");
        this.cellTip.setPreferredSize(new Dimension(this.rendererRect.width + 2, this.getRowHeight(n) + 2));
        CellTipManager.sharedInstance().setEnabled(true);
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        this.mouseMoved(mouseWheelEvent);
        CellTipManager.sharedInstance().setEnabled(false);
    }

    @Override
    public void processMouseEvent(MouseEvent mouseEvent) {
        if (mouseEvent instanceof MouseWheelEvent) {
            Container container = this.getParent();
            if (container == null || !(container instanceof JViewport)) {
                container = this;
            }
            MouseEvent mouseEvent2 = SwingUtilities.convertMouseEvent(this, (MouseWheelEvent)mouseEvent, container);
            container.dispatchEvent((MouseWheelEvent)mouseEvent2);
        } else {
            super.processMouseEvent(mouseEvent);
        }
    }

    public void selectRowByContents(String string, int n, boolean bl) {
        for (int i = 0; i < this.getRowCount(); ++i) {
            if (!this.getValueAt(i, n).toString().equals(string)) continue;
            this.getSelectionModel().setSelectionInterval(i, i);
            if (bl) {
                this.ensureRowVisible(i);
            }
            return;
        }
        this.getSelectionModel().clearSelection();
    }

    public void selectRowByInstance(Object object, int n, boolean bl) {
        for (int i = 0; i < this.getRowCount(); ++i) {
            if (this.getValueAt(i, n) != object) continue;
            this.getSelectionModel().setSelectionInterval(i, i);
            if (bl) {
                this.ensureRowVisible(i);
            }
            return;
        }
        this.getSelectionModel().clearSelection();
    }

    public void selectRowsByInstances(Object[] objectArray, int n, boolean bl) {
        int n2;
        LinkedList<Object> linkedList = new LinkedList<Object>();
        for (n2 = 0; n2 < objectArray.length; ++n2) {
            linkedList.add(objectArray[n2]);
        }
        this.getSelectionModel().clearSelection();
        for (n2 = 0; n2 < this.getRowCount(); ++n2) {
            if (!linkedList.contains(this.getValueAt(n2, n))) continue;
            this.getSelectionModel().addSelectionInterval(n2, n2);
        }
        if (bl && this.getSelectedRow() != -1) {
            this.ensureRowVisible(this.getSelectedRow());
        }
    }

    protected JToolTip createCellTip() {
        return new JToolTip();
    }

    private boolean isAnyRowSelected() {
        return this.getSelectedRow() != -1;
    }

    private String getInternalFindString(String string) {
        if (string == null) {
            return null;
        }
        return string.toLowerCase();
    }

    private int getSearchRoot() {
        if (!this.isAnyRowSelected()) {
            return 0;
        }
        return this.getSelectedRow();
    }

    private boolean doFindNext(int n) {
        for (int i = n + 1; i < this.getRowCount(); ++i) {
            if (!this.matchesFindCriterion(i)) continue;
            return this.selectFoundNode(i);
        }
        return false;
    }

    private boolean doFindPrevious(int n) {
        for (int i = n - 1; i >= 0; --i) {
            if (!this.matchesFindCriterion(i)) continue;
            return this.selectFoundNode(i);
        }
        return false;
    }

    private void initListeners() {
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                if (JExtendedTable.this.getSelectedRows().length > 0) {
                    JExtendedTable.this.repaint();
                }
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                if (JExtendedTable.this.getSelectedRows().length > 0) {
                    JExtendedTable.this.repaint();
                }
            }
        });
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                int n = JExtendedTable.this.getRowCount();
                switch (keyEvent.getKeyCode()) {
                    case 36: {
                        if (n <= 0) break;
                        JExtendedTable.this.setRowSelectionInterval(0, 0);
                        break;
                    }
                    case 35: {
                        if (n <= 0) break;
                        JExtendedTable.this.setRowSelectionInterval(n - 1, n - 1);
                    }
                }
            }
        });
    }

    private boolean matchesFindCriterion(int n) {
        return this.getValueAt(n, this.userFindColumn).toString().toLowerCase().indexOf(this.internalFindString) != -1;
    }

    private boolean selectFoundNode(int n) {
        this.getSelectionModel().setSelectionInterval(n, n);
        this.requestFocusInWindow();
        Rectangle rectangle = this.getCellRect(n, this.userFindColumn, true);
        if (rectangle != null) {
            this.scrollRectToVisible(rectangle);
            return true;
        }
        return false;
    }
}

