/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.options.keymap;

import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableModel;
import org.netbeans.core.options.keymap.api.ShortcutAction;
import org.netbeans.core.options.keymap.api.ShortcutsFinder;
import org.netbeans.modules.options.keymap.ActionHolder;
import org.netbeans.modules.options.keymap.KeymapModel;
import org.netbeans.modules.options.keymap.KeymapPanel;
import org.netbeans.modules.options.keymap.ShortcutsDialog;
import org.netbeans.modules.options.keymap.Utils;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;

public class KeymapViewModel
extends DefaultTableModel
implements ShortcutsFinder {
    private String currentProfile;
    private KeymapModel model = new KeymapModel();
    private Map<String, List<Object>> categoryToActionsCache = new HashMap<String, List<Object>>();
    private Map<String, Map<ShortcutAction, Set<String>>> modifiedProfiles = new HashMap<String, Map<ShortcutAction, Set<String>>>();
    private Set<String> deletedProfiles = new HashSet<String>();
    private Map<String, Map<ShortcutAction, Set<String>>> shortcutsCache = new HashMap<String, Map<ShortcutAction, Set<String>>>();
    static final ActionsComparator actionsComparator = new ActionsComparator();
    private String searchText = "";
    private Map<String, List<String>> categories;
    private volatile boolean applyInProgress = false;

    public KeymapViewModel() {
        super(new String[]{NbBundle.getMessage(KeymapViewModel.class, (String)"Actions"), NbBundle.getMessage(KeymapViewModel.class, (String)"Shortcut"), NbBundle.getMessage(KeymapViewModel.class, (String)"Category")}, 0);
        this.currentProfile = this.model.getCurrentProfile();
    }

    public Class getColumnClass(int n) {
        switch (n) {
            case 0: {
                return ActionHolder.class;
            }
        }
        return String.class;
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return n2 == 1;
    }

    void setSearchText(String string) {
        this.searchText = string;
    }

    public Map<String, List<String>> getCategories() {
        if (this.categories == null) {
            this.categories = new TreeMap<String, List<String>>();
            ArrayList<String> arrayList = new ArrayList<String>(this.model.getActionCategories());
            Collections.sort(arrayList);
            for (String string : arrayList) {
                String string2 = "";
                StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
                while (stringTokenizer.hasMoreTokens()) {
                    String string3 = stringTokenizer.nextToken();
                    List<String> list = this.categories.get(string2);
                    if (list == null) {
                        list = new ArrayList<String>();
                        this.categories.put(string2, list);
                    }
                    String string4 = string2 = string2.length() == 0 ? string3 : string2 + '/' + string3;
                    if (!list.isEmpty() && list.get(list.size() - 1).equals(string2)) continue;
                    list.add(string2);
                }
            }
        }
        return this.categories;
    }

    public List<Object> getItems(String string) {
        List<Object> list = this.categoryToActionsCache.get(string);
        if (list == null) {
            list = new ArrayList<Object>();
            List<String> list2 = this.getCategories().get(string);
            if (list2 != null) {
                list.addAll(list2);
            }
            ArrayList<ShortcutAction> arrayList = new ArrayList<ShortcutAction>(this.model.getActions(string));
            Collections.sort(arrayList, new ActionsComparator());
            list.addAll(arrayList);
            this.categoryToActionsCache.put(string, list);
        }
        return list;
    }

    void update() {
        String string;
        boolean bl = false;
        if (this.searchText.matches(".*[A-Z].*")) {
            bl = true;
            string = this.searchText;
        } else {
            string = this.searchText.toLowerCase();
        }
        this.getDataVector().removeAllElements();
        for (String string2 : this.getCategories().keySet()) {
            for (String string3 : this.getCategories().get(string2)) {
                for (Object object : this.getItems(string3)) {
                    if (!(object instanceof ShortcutAction)) continue;
                    ShortcutAction shortcutAction = (ShortcutAction)object;
                    String[] stringArray = this.getShortcuts(shortcutAction);
                    String string4 = shortcutAction.getDisplayName();
                    if (string4.isEmpty() || !this.searched(bl ? string4 : string4.toLowerCase(), string)) continue;
                    if (stringArray.length == 0) {
                        this.addRow(new Object[]{new ActionHolder(shortcutAction, false), "", string3});
                        continue;
                    }
                    for (int i = 0; i < stringArray.length; ++i) {
                        String string5 = stringArray[i];
                        this.addRow(new Object[]{i == 0 ? new ActionHolder(shortcutAction, false) : new ActionHolder(shortcutAction, true), string5, string3});
                    }
                }
            }
        }
        this.fireTableDataChanged();
    }

    private boolean searched(String string, String string2) {
        return string.length() == 0 || string.startsWith(string2) || string.contains(string2);
    }

    List<String> getProfiles() {
        HashSet<String> hashSet = new HashSet<String>(this.model.getProfiles());
        hashSet.addAll(this.modifiedProfiles.keySet());
        ArrayList<String> arrayList = new ArrayList<String>(hashSet);
        Collections.sort(arrayList);
        return arrayList;
    }

    boolean isCustomProfile(String string) {
        return this.model.isCustomProfile(string);
    }

    void deleteOrRestoreProfile(String string) {
        if (this.model.isCustomProfile(string)) {
            this.deletedProfiles.add(string);
            this.modifiedProfiles.remove(string);
        } else {
            Map<ShortcutAction, Set<String>> map = this.model.getKeymapDefaults(string);
            map = KeymapViewModel.convertFromEmacs(map);
            this.modifiedProfiles.put(string, map);
            this.update();
        }
    }

    String getCurrentProfile() {
        return this.currentProfile;
    }

    void setCurrentProfile(String string) {
        this.currentProfile = string;
    }

    void cloneProfile(String string) {
        HashMap<ShortcutAction, Set<String>> hashMap = new HashMap<ShortcutAction, Set<String>>();
        this.cloneProfile("", hashMap);
        this.modifiedProfiles.put(string, hashMap);
    }

    private void cloneProfile(String string, Map<ShortcutAction, Set<String>> map) {
        for (Object object : this.getItems(string)) {
            if (object instanceof String) {
                this.cloneProfile((String)object, map);
                continue;
            }
            String[] stringArray = this.getShortcuts((ShortcutAction)object);
            map.put((ShortcutAction)object, new HashSet<String>(Arrays.asList(stringArray)));
        }
    }

    @Override
    public ShortcutAction findActionForShortcut(String string) {
        return this.findActionForShortcut(string, "", false, null, "");
    }

    Set<ShortcutAction> findActionForShortcutPrefix(String string) {
        HashSet<ShortcutAction> hashSet = new HashSet<ShortcutAction>();
        if (string.length() == 0) {
            return hashSet;
        }
        if (string.contains(" ")) {
            this.findActionForShortcut(string.substring(0, string.indexOf(32)), "", true, hashSet, string);
        } else {
            this.findActionForShortcut(string, "", true, hashSet, string);
        }
        return hashSet;
    }

    private ShortcutAction findActionForShortcut(String string, String string2, boolean bl, Set<ShortcutAction> set, String string3) {
        Map<ShortcutAction, Set<String>> map = this.modifiedProfiles.get(this.currentProfile);
        if (map != null) {
            for (Map.Entry object : map.entrySet()) {
                for (Object object2 : (Set)object.getValue()) {
                    if (bl) {
                        if (!((String)object2).equals(string) && (!((String)object2).startsWith(string3) || !string.equals(string3) || !((String)object2).contains(" "))) continue;
                        set.add((ShortcutAction)object.getKey());
                        continue;
                    }
                    if (!((String)object2).equals(string)) continue;
                    return (ShortcutAction)object.getKey();
                }
            }
        }
        for (Object object : this.getItems(string2)) {
            Object object3;
            Object object2;
            if (object instanceof String) {
                object3 = this.findActionForShortcut(string, (String)object, bl, set, string3);
                if (object3 == null || bl) continue;
                return object3;
            }
            object3 = (ShortcutAction)object;
            object2 = this.getShortcuts((ShortcutAction)object3);
            int n = ((String[])object2).length;
            for (int i = 0; i < n; ++i) {
                if (bl) {
                    if (!((String)object2[i]).equals(string) && (!((String)object2[i]).startsWith(string3) || !string.equals(string3) || !((String)object2[i]).contains(" "))) continue;
                    set.add((ShortcutAction)object3);
                    continue;
                }
                if (!((String)object2[i]).equals(string)) continue;
                return object3;
            }
        }
        return null;
    }

    @Override
    public ShortcutAction findActionForId(final String string) {
        if (SwingUtilities.isEventDispatchThread()) {
            return this.findActionForId(string, "");
        }
        final ShortcutAction[] shortcutActionArray = new ShortcutAction[1];
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    shortcutActionArray[0] = KeymapViewModel.this.findActionForId(string, "");
                }
            });
        }
        catch (Exception exception) {
            ErrorManager.getDefault().notify((Throwable)exception);
        }
        return shortcutActionArray[0];
    }

    private ShortcutAction findActionForId(String string, String string2) {
        for (Object object : this.getItems(string2)) {
            Object object2;
            if (object instanceof String) {
                object2 = this.findActionForId(string, (String)object);
                if (object2 == null) continue;
                return object2;
            }
            object2 = ((ShortcutAction)object).getId();
            if (!string.equals(object2)) continue;
            return (ShortcutAction)object;
        }
        return null;
    }

    @Override
    public String[] getShortcuts(ShortcutAction shortcutAction) {
        Map<ShortcutAction, Set<String>> map;
        if (this.modifiedProfiles.containsKey(this.currentProfile) && (map = this.modifiedProfiles.get(this.currentProfile)).containsKey(shortcutAction)) {
            Set<String> set = map.get(shortcutAction);
            return set.toArray(new String[set.size()]);
        }
        map = this.getProfileMap(this.currentProfile);
        Set<String> set = map.get(shortcutAction);
        if (set == null) {
            return new String[0];
        }
        return set.toArray(new String[set.size()]);
    }

    private Map<ShortcutAction, Set<String>> getProfileMap(String string) {
        if (!this.shortcutsCache.containsKey(string)) {
            Map<ShortcutAction, Set<String>> map = KeymapViewModel.convertFromEmacs(this.model.getKeymap(string));
            this.shortcutsCache.put(string, map);
        }
        return this.shortcutsCache.get(string);
    }

    public Set<String> getAllCurrentlyUsedShortcuts() {
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        Map<ShortcutAction, Set<String>> map = this.modifiedProfiles.get(this.currentProfile);
        if (map != null) {
            for (Map.Entry<ShortcutAction, Set<String>> entry : map.entrySet()) {
                for (String string : entry.getValue()) {
                    linkedHashSet.add(string);
                    if (!string.contains(" ")) continue;
                    linkedHashSet.add(string.substring(0, string.indexOf(32)));
                }
            }
        }
        for (Map.Entry<ShortcutAction, Set<String>> entry : this.getProfileMap(this.currentProfile).entrySet()) {
            for (String string : entry.getValue()) {
                linkedHashSet.add(string);
                if (!string.contains(" ")) continue;
                linkedHashSet.add(string.substring(0, string.indexOf(32)));
            }
        }
        return linkedHashSet;
    }

    void addShortcut(ShortcutAction shortcutAction, String string) {
        ShortcutAction shortcutAction2 = this.findActionForShortcut(string);
        if (shortcutAction2 != null && shortcutAction2 != shortcutAction) {
            this.removeShortcut(shortcutAction2, string);
            this.fireTableDataChanged();
            this.update();
        }
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        linkedHashSet.addAll(Arrays.asList(this.getShortcuts(shortcutAction)));
        linkedHashSet.add(string);
        this.setShortcuts(shortcutAction, linkedHashSet);
    }

    void revertShortcutsToDefault(ShortcutAction shortcutAction) {
        ShortcutAction shortcutAction2;
        Map<ShortcutAction, Set<String>> map = this.model.getKeymapDefaults(this.currentProfile);
        Set<String> set = (map = KeymapViewModel.convertFromEmacs(map)).get(shortcutAction);
        if (set == null) {
            set = Collections.emptySet();
        }
        HashSet<ShortcutAction> hashSet = new HashSet<ShortcutAction>();
        for (String string : set) {
            shortcutAction2 = this.findActionForShortcut(string);
            if (shortcutAction2 == null || shortcutAction2.equals(shortcutAction)) continue;
            hashSet.add(shortcutAction2);
        }
        if (hashSet.size() > 0) {
            if (this.overrideAll(hashSet)) {
                for (String string : set) {
                    shortcutAction2 = this.findActionForShortcut(string);
                    this.removeShortcut(shortcutAction2, string);
                }
            } else {
                return;
            }
        }
        this.setShortcuts(shortcutAction, set);
        this.update();
    }

    private boolean overrideAll(Set<ShortcutAction> set) {
        JPanel jPanel = new JPanel();
        StringBuffer stringBuffer = new StringBuffer();
        for (ShortcutAction shortcutAction : set) {
            stringBuffer.append(" '" + shortcutAction.getDisplayName() + "'<br>");
        }
        jPanel.add(new JLabel(NbBundle.getMessage(KeymapViewModel.class, (String)"Override_All", (Object)stringBuffer)));
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)jPanel, NbBundle.getMessage(KeymapViewModel.class, (String)"Conflicting_Shortcut_Dialog"), true, 0, null, null);
        DialogDisplayer.getDefault().notify((NotifyDescriptor)dialogDescriptor);
        return dialogDescriptor.getValue().equals(DialogDescriptor.YES_OPTION);
    }

    @Override
    public void setShortcuts(ShortcutAction shortcutAction, Set<String> set) {
        Map<ShortcutAction, Set<String>> map = this.modifiedProfiles.get(this.currentProfile);
        if (map == null) {
            map = new HashMap<ShortcutAction, Set<String>>();
            this.modifiedProfiles.put(this.currentProfile, map);
        }
        map.put(shortcutAction, set);
    }

    public void removeShortcut(ShortcutAction shortcutAction, String string) {
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>(Arrays.asList(this.getShortcuts(shortcutAction)));
        linkedHashSet.remove(string);
        this.setShortcuts(shortcutAction, linkedHashSet);
    }

    @Override
    public void refreshActions() {
        this.categoryToActionsCache = new HashMap<String, List<Object>>();
        this.model.refreshActions();
    }

    @Override
    public void apply() {
        if (this.applyInProgress) {
            return;
        }
        this.applyInProgress = true;
        RequestProcessor.getDefault().post(new Runnable(){

            @Override
            public void run() {
                for (String string : KeymapViewModel.this.modifiedProfiles.keySet()) {
                    Map map = (Map)KeymapViewModel.this.modifiedProfiles.get(string);
                    map = KeymapViewModel.convertToEmacs(map);
                    KeymapViewModel.this.model.changeKeymap(string, map);
                }
                for (String string : KeymapViewModel.this.deletedProfiles) {
                    KeymapViewModel.this.model.deleteProfile(string);
                }
                KeymapViewModel.this.model.setCurrentProfile(KeymapViewModel.this.currentProfile);
                KeymapViewModel.this.modifiedProfiles = new HashMap();
                KeymapViewModel.this.deletedProfiles = new HashSet();
                KeymapViewModel.this.shortcutsCache = new HashMap();
                KeymapViewModel.this.model = new KeymapModel();
                KeymapViewModel.this.applyInProgress = false;
            }
        });
    }

    public boolean isChanged() {
        return !this.modifiedProfiles.isEmpty() || !this.deletedProfiles.isEmpty();
    }

    public void cancel() {
        this.modifiedProfiles = new HashMap<String, Map<ShortcutAction, Set<String>>>();
        this.deletedProfiles = new HashSet<String>();
        this.shortcutsCache = new HashMap<String, Map<ShortcutAction, Set<String>>>();
        this.setCurrentProfile(this.model.getCurrentProfile());
        this.model = new KeymapModel();
    }

    Map<String, Map<ShortcutAction, Set<String>>> getModifiedProfiles() {
        return this.modifiedProfiles;
    }

    Set<String> getDeletedProfiles() {
        return this.deletedProfiles;
    }

    void setModifiedProfiles(Map<String, Map<ShortcutAction, Set<String>>> map) {
        this.modifiedProfiles = map;
    }

    void setDeletedProfiles(Set<String> set) {
        this.deletedProfiles = set;
    }

    @Override
    public String showShortcutsDialog() {
        final ShortcutsDialog shortcutsDialog = new ShortcutsDialog();
        shortcutsDialog.init(this);
        final DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)shortcutsDialog, KeymapViewModel.loc("Add_Shortcut_Dialog"), true, new Object[]{DialogDescriptor.OK_OPTION, DialogDescriptor.CANCEL_OPTION}, DialogDescriptor.OK_OPTION, 0, null, (ActionListener)shortcutsDialog.getListener());
        dialogDescriptor.setClosingOptions(new Object[]{DialogDescriptor.OK_OPTION, DialogDescriptor.CANCEL_OPTION});
        dialogDescriptor.setAdditionalOptions(new Object[]{shortcutsDialog.getBClear(), shortcutsDialog.getBTab()});
        dialogDescriptor.setValid(shortcutsDialog.isShortcutValid());
        shortcutsDialog.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getPropertyName() == null || "ShortcutsDialog.PROP_SHORTCUT_VALID".equals(propertyChangeEvent.getPropertyName())) {
                    dialogDescriptor.setValid(shortcutsDialog.isShortcutValid());
                }
            }
        });
        DialogDisplayer.getDefault().notify((NotifyDescriptor)dialogDescriptor);
        if (dialogDescriptor.getValue() == DialogDescriptor.OK_OPTION) {
            return shortcutsDialog.getTfShortcut().getText();
        }
        return null;
    }

    private static Map<ShortcutAction, Set<String>> convertToEmacs(Map<ShortcutAction, Set<String>> map) {
        HashMap<ShortcutAction, Set<String>> hashMap = new HashMap<ShortcutAction, Set<String>>();
        for (Map.Entry<ShortcutAction, Set<String>> entry : map.entrySet()) {
            ShortcutAction shortcutAction = entry.getKey();
            HashSet<String> hashSet = new HashSet<String>();
            for (String string : entry.getValue()) {
                KeyStroke[] keyStrokeArray;
                if (string.length() == 0 || (keyStrokeArray = KeymapViewModel.getKeyStrokes(string, " ")) == null) continue;
                StringBuffer stringBuffer = new StringBuffer(Utilities.keyToString((KeyStroke)keyStrokeArray[0]));
                int n = keyStrokeArray.length;
                for (int i = 1; i < n; ++i) {
                    stringBuffer.append(' ').append(Utilities.keyToString((KeyStroke)keyStrokeArray[i]));
                }
                hashSet.add(stringBuffer.toString());
            }
            hashMap.put(shortcutAction, hashSet);
        }
        return hashMap;
    }

    private static Map<ShortcutAction, Set<String>> convertFromEmacs(Map<ShortcutAction, Set<String>> map) {
        HashMap<ShortcutAction, Set<String>> hashMap = new HashMap<ShortcutAction, Set<String>>();
        for (Map.Entry<ShortcutAction, Set<String>> entry : map.entrySet()) {
            ShortcutAction shortcutAction = entry.getKey();
            LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
            for (String string : entry.getValue()) {
                KeyStroke[] keyStrokeArray = Utilities.stringToKeys((String)string);
                linkedHashSet.add(Utils.getKeyStrokesAsText(keyStrokeArray, " "));
            }
            hashMap.put(shortcutAction, linkedHashSet);
        }
        return hashMap;
    }

    private static KeyStroke[] getKeyStrokes(String string, String string2) {
        if (string.length() == 0) {
            return new KeyStroke[0];
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        ArrayList<KeyStroke> arrayList = new ArrayList<KeyStroke>();
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken().trim();
            KeyStroke keyStroke = Utils.getKeyStroke(string3);
            if (keyStroke == null) {
                return null;
            }
            arrayList.add(keyStroke);
        }
        return arrayList.toArray(new KeyStroke[arrayList.size()]);
    }

    private static String loc(String string) {
        return NbBundle.getMessage(KeymapPanel.class, (String)string);
    }

    static class ActionsComparator
    implements Comparator {
        ActionsComparator() {
        }

        public int compare(Object object, Object object2) {
            if (object instanceof String) {
                if (object2 instanceof String) {
                    return ((String)object).compareTo((String)object2);
                }
                return 1;
            }
            if (object2 instanceof String) {
                return -1;
            }
            return ((ShortcutAction)object).getDisplayName().compareTo(((ShortcutAction)object2).getDisplayName());
        }
    }
}

