/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.server.system;

import java.lang.management.ManagementFactory;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.management.InstanceNotFoundException;
import javax.management.JMRuntimeException;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.ReflectionException;

public class HeapDump {
    private static Object hotspotDiag;
    private static Method dumpHeapMethod;
    private static boolean initialized;

    private HeapDump() {
    }

    public static void initialize(boolean bl) {
        if (bl) {
            HeapDump.initialize15();
        } else {
            HeapDump.initialize16();
        }
    }

    public static String takeHeapDump(boolean bl, String string) {
        if (bl) {
            return HeapDump.takeHeapDump15(string);
        }
        return HeapDump.takeHeapDump16(string);
    }

    private static native void initialize15();

    private static void initialize16() {
        MBeanServer mBeanServer;
        if (initialized) {
            return;
        }
        initialized = true;
        try {
            mBeanServer = ManagementFactory.getPlatformMBeanServer();
        }
        catch (JMRuntimeException jMRuntimeException) {
            System.err.println(jMRuntimeException.getLocalizedMessage());
            initialized = false;
            return;
        }
        try {
            ObjectInstance objectInstance = mBeanServer.getObjectInstance(new ObjectName("com.sun.management:type=HotSpotDiagnostic"));
            hotspotDiag = mBeanServer.instantiate(objectInstance.getClassName());
            dumpHeapMethod = hotspotDiag.getClass().getMethod("dumpHeap", String.class, Boolean.TYPE);
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            malformedObjectNameException.printStackTrace();
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            System.err.println("Heap Dump is not available");
        }
        catch (MBeanException mBeanException) {
            mBeanException.printStackTrace();
        }
        catch (SecurityException securityException) {
            securityException.printStackTrace();
        }
        catch (ReflectionException reflectionException) {
            reflectionException.printStackTrace();
        }
        catch (NullPointerException nullPointerException) {
            nullPointerException.printStackTrace();
        }
        catch (NoSuchMethodException noSuchMethodException) {
            noSuchMethodException.printStackTrace();
        }
    }

    private static String takeHeapDump15(String string) {
        int n = -1;
        try {
            n = HeapDump.takeHeapDump15Native(string);
        }
        catch (Exception exception) {
            return exception.getLocalizedMessage();
        }
        if (n == -1) {
            return "Take heap dump is not available.";
        }
        return null;
    }

    private static native int takeHeapDump15Native(String var0);

    private static String takeHeapDump16(String string) {
        String string2 = null;
        HeapDump.initialize16();
        if (dumpHeapMethod == null || hotspotDiag == null) {
            return "Take heap dump is not available.";
        }
        try {
            dumpHeapMethod.invoke(hotspotDiag, string, Boolean.TRUE);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            string2 = illegalArgumentException.getLocalizedMessage();
        }
        catch (IllegalAccessException illegalAccessException) {
            string2 = illegalAccessException.getLocalizedMessage();
        }
        catch (InvocationTargetException invocationTargetException) {
            string2 = invocationTargetException.getTargetException().getLocalizedMessage();
        }
        return string2;
    }
}

