/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.options;

import java.awt.Image;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.netbeans.modules.options.TabbedController;
import org.netbeans.spi.options.OptionsCategory;
import org.netbeans.spi.options.OptionsPanelController;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;

public class OptionsCategoryImpl
extends OptionsCategory {
    private String title;
    private String categoryName;
    private String iconBase;
    private ImageIcon icon;
    private Callable<OptionsPanelController> controller;
    private String keywords;
    private String keywordsCategory;
    private String advancedOptionsFolder;

    public OptionsCategoryImpl(String string, String string2, String string3, Callable<OptionsPanelController> callable, String string4, String string5, String string6) {
        this.title = string;
        this.categoryName = string2;
        this.iconBase = string3;
        this.controller = callable;
        this.advancedOptionsFolder = string6;
        this.keywords = string4;
        this.keywordsCategory = string5;
    }

    @Override
    public Icon getIcon() {
        if (this.icon == null) {
            Image image = ImageUtilities.loadImage((String)this.iconBase);
            if (image != null) {
                return new ImageIcon(image);
            }
            image = ImageUtilities.loadImage((String)(this.iconBase + ".png"));
            if (image != null) {
                return new ImageIcon(image);
            }
            image = ImageUtilities.loadImage((String)(this.iconBase + ".gif"));
            if (image == null) {
                return null;
            }
            this.icon = new ImageIcon(image);
        }
        return this.icon;
    }

    @Override
    public String getCategoryName() {
        return this.categoryName;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public OptionsPanelController create() {
        if (this.advancedOptionsFolder != null) {
            return new TabbedController(this.advancedOptionsFolder);
        }
        try {
            return this.controller.call();
        }
        catch (Exception exception) {
            Exceptions.printStackTrace((Throwable)exception);
            return new TabbedController("<error>");
        }
    }

    final Map<String, Set<String>> getKeywordsByCategory() {
        if (this.keywordsCategory != null && this.keywords != null) {
            return Collections.singletonMap(this.keywordsCategory, new HashSet<String>(Arrays.asList(this.keywords.split(","))));
        }
        return Collections.emptyMap();
    }
}

