/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.mimelookup;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventListener;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.spi.editor.mimelookup.MimeDataProvider;
import org.netbeans.spi.editor.mimelookup.MimeLookupInitializer;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.WeakListeners;
import org.openide.util.lookup.ProxyLookup;

public final class MimePathLookup
extends ProxyLookup
implements LookupListener {
    private static final Logger LOG = Logger.getLogger(MimePathLookup.class.getName());
    private final MimePath mimePath;
    private final boolean mimePathBanned;
    private final Lookup.Result<MimeDataProvider> dataProviders;
    private final Lookup.Result<MimeLookupInitializer> mimeInitializers;
    private boolean initialized = false;

    public MimePathLookup(MimePath mimePath) {
        if (mimePath == null) {
            throw new NullPointerException("Mime path can't be null.");
        }
        this.mimePath = mimePath;
        this.mimePathBanned = mimePath.size() > 0 && mimePath.getMimeType(0).contains("text/base");
        this.dataProviders = Lookup.getDefault().lookup(new Lookup.Template(MimeDataProvider.class));
        this.dataProviders.addLookupListener((LookupListener)WeakListeners.create(LookupListener.class, (EventListener)((Object)this), this.dataProviders));
        this.mimeInitializers = Lookup.getDefault().lookup(new Lookup.Template(MimeLookupInitializer.class));
        this.mimeInitializers.addLookupListener((LookupListener)WeakListeners.create(LookupListener.class, (EventListener)((Object)this), this.mimeInitializers));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void beforeLookup(Lookup.Template<?> template) {
        MimePathLookup mimePathLookup = this;
        synchronized (mimePathLookup) {
            if (!this.initialized) {
                this.initialized = true;
                this.rebuild();
            }
        }
    }

    public MimePath getMimePath() {
        return this.mimePath;
    }

    private void rebuild() {
        Object object;
        Object object2;
        Iterator iterator2;
        ArrayList<Lookup> arrayList = new ArrayList<Lookup>();
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Rebuilding MimeLookup for '" + this.mimePath.getPath() + "'...");
        }
        for (Iterator iterator2 : this.dataProviders.allInstances()) {
            if (this.mimePathBanned && !this.isDefaultProvider((MimeDataProvider)((Object)iterator2))) continue;
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("- Querying MimeDataProvider(" + this.mimePath.getPath() + "): " + iterator2);
            }
            if ((object2 = iterator2.getLookup(this.mimePath)) == null) continue;
            arrayList.add((Lookup)object2);
        }
        try {
            iterator2 = MimePath.class.getDeclaredMethod("getInheritedPaths", String.class, String.class);
            ((Method)((Object)iterator2)).setAccessible(true);
            object2 = (List)((Method)((Object)iterator2)).invoke(this.mimePath, new Object[]{null, null});
            object = object2;
        }
        catch (Exception exception) {
            LOG.log(Level.WARNING, "Can't call org.netbeans.api.editor.mimelookup.MimePath.getInheritedPaths method.", exception);
            object = Collections.singletonList(this.mimePath.getPath());
        }
        iterator2 = object.iterator();
        while (iterator2.hasNext()) {
            Lookup lookup;
            Object object3;
            object2 = (String)iterator2.next();
            MimePath mimePath = MimePath.parse((String)object2);
            Object object4 = this.mimeInitializers.allInstances();
            for (int i = 0; i < mimePath.size(); ++i) {
                object3 = new ArrayList(object4.size());
                lookup = object4.iterator();
                while (lookup.hasNext()) {
                    MimeLookupInitializer mimeLookupInitializer = (MimeLookupInitializer)lookup.next();
                    object3.addAll(mimeLookupInitializer.child(mimePath.getMimeType(i)).allInstances());
                }
                object4 = object3;
            }
            Iterator iterator3 = object4.iterator();
            while (iterator3.hasNext()) {
                object3 = (MimeLookupInitializer)iterator3.next();
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("- Querying MimeLookupInitializer(" + (String)object2 + "): " + object3);
                }
                if ((lookup = object3.lookup()) == null) continue;
                arrayList.add(lookup);
            }
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("MimeLookup for '" + this.mimePath.getPath() + "' rebuilt.");
        }
        this.setLookups(arrayList.toArray(new Lookup[arrayList.size()]));
    }

    private boolean isDefaultProvider(MimeDataProvider mimeDataProvider) {
        return mimeDataProvider.getClass().getName().equals("org.netbeans.modules.editor.mimelookup.impl.DefaultMimeDataProvider");
    }

    public void resultChanged(LookupEvent lookupEvent) {
        this.rebuild();
    }
}

