/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans;

import java.awt.AWTPermission;
import java.awt.datatransfer.Clipboard;
import java.io.FileDescriptor;
import java.lang.reflect.Field;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.LoggingPermission;
import org.netbeans.ExitSecurityException;
import org.openide.util.Lookup;

public class TopSecurityManager
extends SecurityManager {
    private static final boolean check = !Boolean.getBoolean("netbeans.security.nocheck");
    private static final Logger LOG = Logger.getLogger(TopSecurityManager.class.getName());
    private Permission allPermission;
    private static final Class<?> classLoaderClass = ClassLoader.class;
    private static final Class URLClass = URL.class;
    private static final Class runtimePermissionClass = RuntimePermission.class;
    private static final Class accessControllerClass = AccessController.class;
    private static final Class awtPermissionClass = AWTPermission.class;
    private static SecurityManager fsSecManager;
    private static final List<SecurityManager> delegates;
    static boolean officialExit;
    private final Set<String> warnedClassesNDE = new HashSet<String>(25);
    private static final Set<String> warnedClassesNH;
    private static Field urlField;
    private static ThreadLocal<Object> CLIPBOARD_FORBIDDEN;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void register(SecurityManager securityManager) throws SecurityException {
        List<SecurityManager> list = delegates;
        synchronized (list) {
            if (delegates.contains(securityManager)) {
                throw new SecurityException();
            }
            delegates.add(securityManager);
            if (fsSecManager == null) {
                for (Lookup.Item item : Lookup.getDefault().lookupResult(SecurityManager.class).allItems()) {
                    if (item == null || !"org.netbeans.modules.masterfs.filebasedfs.utils.FileChangedManager".equals(item.getId())) continue;
                    fsSecManager = (SecurityManager)item.getInstance();
                    break;
                }
                assert (fsSecManager != null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unregister(SecurityManager securityManager) throws SecurityException {
        List<SecurityManager> list = delegates;
        synchronized (list) {
            if (!delegates.contains(securityManager)) {
                throw new SecurityException();
            }
            delegates.remove(securityManager);
        }
    }

    public TopSecurityManager() {
        this.allPermission = new AllPermission();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void checkExit(int n) throws SecurityException {
        if (!check) {
            return;
        }
        List<SecurityManager> list = delegates;
        synchronized (list) {
            Iterator<SecurityManager> iterator = delegates.iterator();
            while (iterator.hasNext()) {
                iterator.next().checkExit(n);
            }
        }
        PrivilegedCheck.checkExit(n, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SecurityManager getSecurityManager() {
        if (fsSecManager == null) {
            List<SecurityManager> list = delegates;
            synchronized (list) {
                return fsSecManager;
            }
        }
        return fsSecManager;
    }

    private void notifyDelete(String string) {
        SecurityManager securityManager = this.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkDelete(string);
        }
    }

    private void notifyRead(String string) {
        SecurityManager securityManager = this.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkRead(string);
        }
    }

    private void notifyWrite(String string) {
        SecurityManager securityManager = this.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkWrite(string);
        }
    }

    static Class[] getStack() {
        SecurityManager securityManager = System.getSecurityManager();
        TopSecurityManager topSecurityManager = securityManager instanceof TopSecurityManager ? (TopSecurityManager)securityManager : new TopSecurityManager();
        return topSecurityManager.getClassContext();
    }

    public static void exit(int n) {
        if (officialExit) {
            return;
        }
        officialExit = true;
        System.exit(n);
    }

    final void checkExitImpl(int n, AccessControlContext accessControlContext) throws SecurityException {
        if (!officialExit) {
            throw new ExitSecurityException("Illegal attempt to exit early");
        }
        super.checkExit(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkTopLevelWindow(Object object) {
        List<SecurityManager> list = delegates;
        synchronized (list) {
            for (SecurityManager securityManager : delegates) {
                securityManager.checkTopLevelWindow(object);
            }
        }
        return super.checkTopLevelWindow(object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void checkPropertyAccess(String string) {
        Set<String> set;
        String string2;
        if ("netbeans.debug.exceptions".equals(string)) {
            for (Class<?> clazz : this.getClassContext()) {
                if (clazz == TopSecurityManager.class || clazz == System.class || clazz == Boolean.class) continue;
                string2 = clazz.getName();
                set = this.warnedClassesNDE;
                synchronized (set) {
                    if (this.warnedClassesNDE.add(string2)) {
                        LOG.log(Level.WARNING, "use of system property netbeans.debug.exceptions has been obsoleted in favor of java.util.logging.Logger at {0}", TopSecurityManager.findCallStackLine(string2));
                    }
                    break;
                }
            }
        }
        if ("netbeans.home".equals(string) || "netbeans.user".equals(string)) {
            for (Class<?> clazz : this.getClassContext()) {
                if (clazz == TopSecurityManager.class || clazz == System.class || clazz == Boolean.class) continue;
                string2 = clazz.getName();
                set = warnedClassesNH;
                synchronized (set) {
                    if (warnedClassesNH.add(string2)) {
                        LOG.log(Level.WARNING, "use of system property {0} has been obsoleted in favor of InstalledFileLocator at {1}", new Object[]{string, TopSecurityManager.findCallStackLine(string2)});
                    }
                    break;
                }
            }
        }
    }

    private static String findCallStackLine(String string) {
        for (StackTraceElement stackTraceElement : Thread.currentThread().getStackTrace()) {
            if (!stackTraceElement.getClassName().equals(string)) continue;
            return stackTraceElement.toString();
        }
        return string;
    }

    @Override
    public void checkRead(String string) {
        this.notifyRead(string);
    }

    @Override
    public void checkRead(FileDescriptor fileDescriptor) {
    }

    @Override
    public void checkWrite(FileDescriptor fileDescriptor) {
    }

    @Override
    public void checkDelete(String string) {
        this.notifyDelete(string);
        try {
            this.checkPermission(this.allPermission);
            return;
        }
        catch (SecurityException securityException) {
            super.checkDelete(string);
            return;
        }
    }

    @Override
    public void checkWrite(String string) {
        this.notifyWrite(string);
        try {
            this.checkPermission(this.allPermission);
            return;
        }
        catch (SecurityException securityException) {
            super.checkWrite(string);
            return;
        }
    }

    @Override
    public void checkConnect(String string, int n) {
        if (!check) {
            return;
        }
        try {
            this.checkPermission(this.allPermission);
            return;
        }
        catch (SecurityException securityException) {
            try {
                super.checkConnect(string, n);
                return;
            }
            catch (SecurityException securityException2) {
                PrivilegedCheck.checkConnect(string, n, this);
                return;
            }
        }
    }

    final void checkConnectImpl(String string, int n) {
        Class clazz = this.getInsecureClass();
        if (clazz != null) {
            URL uRL = TopSecurityManager.getClassURL(clazz);
            if (uRL != null) {
                try {
                    String string2 = uRL.getHost();
                    InetAddress inetAddress = InetAddress.getByName(string);
                    InetAddress inetAddress2 = InetAddress.getByName(string2);
                    if (inetAddress.equals(inetAddress2)) {
                        return;
                    }
                }
                catch (UnknownHostException unknownHostException) {
                    unknownHostException.printStackTrace();
                }
            }
            throw new SecurityException();
        }
    }

    @Override
    public void checkConnect(String string, int n, Object object) {
        this.checkConnect(string, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void checkPermission(Permission permission) {
        this.checkSetSecurityManager(permission);
        if (!awtPermissionClass.isInstance(permission) || !"accessClipboard".equals(permission.getName())) return;
        Class<TopSecurityManager> clazz = TopSecurityManager.class;
        synchronized (TopSecurityManager.class) {
            ThreadLocal<Object> threadLocal = CLIPBOARD_FORBIDDEN;
            // ** MonitorExit[var3_2] (shouldn't be in output)
            if (threadLocal == null) {
                return;
            }
            if (threadLocal.get() != null) {
                threadLocal.set(this);
                throw new SecurityException();
            }
            this.checkWhetherAccessedFromSwingTransfer();
            return;
        }
    }

    @Override
    public void checkPermission(Permission permission, Object object) {
        this.checkSetSecurityManager(permission);
    }

    private boolean checkLogger(Permission permission) {
        if (LoggingPermission.class.isInstance(permission)) {
            Throwable throwable = new Exception().fillInStackTrace();
            for (StackTraceElement stackTraceElement : throwable.getStackTrace()) {
                if ("java.util.logging.LogManager".equals(stackTraceElement.getClassName()) && "reset".equals(stackTraceElement.getMethodName())) {
                    SecurityException securityException = new SecurityException("Illegal attempt to reset system logger");
                    throw securityException;
                }
                if (!"java.util.logging.LogManager".equals(stackTraceElement.getClassName()) || !"readConfiguration".equals(stackTraceElement.getMethodName())) continue;
                SecurityException securityException = new SecurityException("Illegal attempt to replace system logger configuration");
                throw securityException;
            }
        }
        return true;
    }

    public static void install() {
        try {
            System.setSecurityManager(new TopSecurityManager());
        }
        catch (SecurityException securityException) {
            LOG.log(Level.WARNING, "Cannot associated own security manager");
            LOG.log(Level.INFO, "Cannot associated own security manager", securityException);
        }
    }

    static void uninstall() {
        System.setSecurityManager(null);
    }

    private void checkSetSecurityManager(Permission permission) {
        if (runtimePermissionClass.isInstance(permission) && permission.getName().equals("setSecurityManager")) {
            Class<?>[] classArray = this.getClassContext();
            boolean bl = false;
            for (int i = 0; i < classArray.length; ++i) {
                if (classArray[i].getName().equals("org.netbeans.TopSecurityManager")) {
                    if (!bl) continue;
                    return;
                }
                if (classArray[i] != System.class) break;
                bl = true;
            }
            throw new SecurityException();
        }
    }

    private Class getInsecureClass() {
        Class<?>[] classArray = this.getClassContext();
        boolean bl = false;
        for (int i = 0; i < classArray.length; ++i) {
            if (classArray[i] == accessControllerClass) {
                if (bl) {
                    return null;
                }
                bl = true;
                continue;
            }
            if (classArray[i].getClassLoader() != null) {
                if (TopSecurityManager.isSecureClass(classArray[i])) {
                    if (!classLoaderClass.isAssignableFrom(classArray[i])) continue;
                    return null;
                }
                return classArray[i];
            }
            if (!classLoaderClass.isAssignableFrom(classArray[i])) continue;
            return null;
        }
        return null;
    }

    static boolean isSecureClass(Class clazz) {
        URL uRL = TopSecurityManager.getClassURL(clazz);
        if (uRL != null) {
            return TopSecurityManager.isSecureProtocol(uRL.getProtocol());
        }
        return true;
    }

    static URL getClassURL(Class clazz) {
        CodeSource codeSource = clazz.getProtectionDomain().getCodeSource();
        if (codeSource != null) {
            URL uRL = codeSource.getLocation();
            return uRL;
        }
        return null;
    }

    static Field getUrlField(Class clazz) {
        if (urlField == null) {
            try {
                Field[] fieldArray = clazz.getDeclaredFields();
                for (int i = 0; i < fieldArray.length; ++i) {
                    if (fieldArray[i].getType() != URLClass) continue;
                    fieldArray[i].setAccessible(true);
                    urlField = fieldArray[i];
                    break;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return urlField;
    }

    static boolean isSecureProtocol(String string) {
        return !string.equals("http") && !string.equals("ftp") && !string.equals("rmi");
    }

    /*
     * Exception decompiling
     */
    public static void makeSwingUseSpecialClipboard(Clipboard var0) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void checkWhetherAccessedFromSwingTransfer() throws SecurityException {
        for (Class<?> clazz : this.getClassContext()) {
            if (!clazz.getName().equals("javax.swing.TransferHandler$TransferAction")) continue;
            throw new SecurityException("All swing access to clipboard should be redirected to ExClipboard");
        }
    }

    static {
        delegates = new ArrayList<SecurityManager>();
        officialExit = false;
        warnedClassesNH = new HashSet<String>(25);
        warnedClassesNH.add("org.openide.modules.Places");
        warnedClassesNH.add("org.netbeans.MainImpl");
        warnedClassesNH.add("org.netbeans.MainImpl$BootClassLoader");
        warnedClassesNH.add("org.netbeans.org.netbeans.CLIHandler");
        warnedClassesNH.add("org.netbeans.Stamps");
        warnedClassesNH.add("org.netbeans.core.startup.InstalledFileLocatorImpl");
        warnedClassesNH.add("org.netbeans.core.startup.CLIOptions");
        warnedClassesNH.add("org.netbeans.updater.UpdateTracking");
        warnedClassesNH.add("org.netbeans.core.ui.ProductInformationPanel");
        warnedClassesNH.add("org.netbeans.lib.uihandler.LogFormatter");
        warnedClassesNH.add("org.netbeans.modules.j2ee.sun.ide.j2ee.PluginProperties");
        warnedClassesNH.add("org.netbeans.modules.apisupport.project.universe.NbPlatform");
    }

    private static final class PrivilegedCheck
    implements PrivilegedExceptionAction<Object> {
        int action;
        TopSecurityManager tsm;
        int status;
        AccessControlContext acc;
        String host;
        int port;

        public PrivilegedCheck(int n, TopSecurityManager topSecurityManager) {
            this.action = n;
            this.tsm = topSecurityManager;
            if (n == 0) {
                this.acc = AccessController.getContext();
            }
        }

        @Override
        public Object run() throws Exception {
            switch (this.action) {
                case 0: {
                    this.tsm.checkExitImpl(this.status, this.acc);
                    break;
                }
                case 1: {
                    this.tsm.checkConnectImpl(this.host, this.port);
                    break;
                }
            }
            return null;
        }

        static void checkExit(int n, TopSecurityManager topSecurityManager) {
            PrivilegedCheck privilegedCheck = new PrivilegedCheck(0, topSecurityManager);
            privilegedCheck.status = n;
            PrivilegedCheck.check(privilegedCheck);
        }

        static void checkConnect(String string, int n, TopSecurityManager topSecurityManager) {
            PrivilegedCheck privilegedCheck = new PrivilegedCheck(1, topSecurityManager);
            privilegedCheck.host = string;
            privilegedCheck.port = n;
            PrivilegedCheck.check(privilegedCheck);
        }

        private static void check(PrivilegedCheck privilegedCheck) {
            try {
                AccessController.doPrivileged(privilegedCheck);
            }
            catch (PrivilegedActionException privilegedActionException) {
                Exception exception = privilegedActionException.getException();
                if (exception instanceof RuntimeException) {
                    throw (RuntimeException)exception;
                }
                exception.printStackTrace();
            }
        }
    }
}

