/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webpane.webkit.dom;

import com.sun.webpane.platform.Disposer;
import com.sun.webpane.platform.DisposerRecord;
import com.sun.webpane.webkit.dom.CSSPrimitiveValueImpl;
import org.w3c.dom.css.CSSPrimitiveValue;
import org.w3c.dom.css.Rect;

public class RectImpl
implements Rect {
    protected final long contextPeer;
    protected final long rootPeer;
    protected final long peer;

    RectImpl(long peer, long contextPeer, long rootPeer) {
        this.peer = peer;
        this.contextPeer = contextPeer;
        this.rootPeer = rootPeer;
        Disposer.addRecord(this, new SelfDisposer(peer));
    }

    static Rect create(long peer, long contextPeer, long rootPeer) {
        if (peer == 0L) {
            return null;
        }
        return new RectImpl(peer, contextPeer, rootPeer);
    }

    long getPeer() {
        return this.peer;
    }

    static long getPeer(Rect arg) {
        return arg == null ? 0L : ((RectImpl)arg).getPeer();
    }

    public boolean equals(Object that) {
        return that instanceof RectImpl && this.peer == ((RectImpl)that).peer;
    }

    public int hashCode() {
        long p = this.peer;
        return (int)(p ^ p >> 17);
    }

    private static native void dispose(long var0);

    static Rect getImpl(long peer, long contextPeer, long rootPeer) {
        return RectImpl.create(peer, contextPeer, rootPeer);
    }

    @Override
    public CSSPrimitiveValue getTop() {
        return CSSPrimitiveValueImpl.getImpl(RectImpl.getTopImpl(this.getPeer()), this.contextPeer, this.rootPeer);
    }

    static native long getTopImpl(long var0);

    @Override
    public CSSPrimitiveValue getRight() {
        return CSSPrimitiveValueImpl.getImpl(RectImpl.getRightImpl(this.getPeer()), this.contextPeer, this.rootPeer);
    }

    static native long getRightImpl(long var0);

    @Override
    public CSSPrimitiveValue getBottom() {
        return CSSPrimitiveValueImpl.getImpl(RectImpl.getBottomImpl(this.getPeer()), this.contextPeer, this.rootPeer);
    }

    static native long getBottomImpl(long var0);

    @Override
    public CSSPrimitiveValue getLeft() {
        return CSSPrimitiveValueImpl.getImpl(RectImpl.getLeftImpl(this.getPeer()), this.contextPeer, this.rootPeer);
    }

    static native long getLeftImpl(long var0);

    static class SelfDisposer
    implements DisposerRecord {
        private final long peer;

        SelfDisposer(long peer) {
            this.peer = peer;
        }

        @Override
        public void dispose() {
            RectImpl.dispose(this.peer);
        }
    }
}

