/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.heapwalk.memorylint;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.lib.profiler.heap.ArrayItemValue;
import org.netbeans.lib.profiler.heap.Field;
import org.netbeans.lib.profiler.heap.FieldValue;
import org.netbeans.lib.profiler.heap.Heap;
import org.netbeans.lib.profiler.heap.Instance;
import org.netbeans.lib.profiler.heap.JavaClass;
import org.netbeans.lib.profiler.heap.ObjectArrayInstance;
import org.netbeans.lib.profiler.heap.ObjectFieldValue;
import org.netbeans.lib.profiler.heap.Value;
import org.netbeans.modules.profiler.heapwalk.memorylint.MemoryLint;
import org.openide.util.NbBundle;

public class Utils {
    public static boolean isReachableFrom(Instance instance, Instance instance2) {
        if (instance == null || instance2 == null) {
            return false;
        }
        Logger.getLogger(Utils.class.getName()).log(Level.FINE, "Utils.isReachableFrom {0}, {1}", new Object[]{instance, instance2});
        HashSet<Instance> hashSet = new HashSet<Instance>();
        LinkedList<Instance> linkedList = new LinkedList<Instance>();
        linkedList.add(instance);
        while (!linkedList.isEmpty()) {
            if (linkedList.size() > 200) {
                Logger.getLogger(Utils.class.getName()).log(Level.FINE, "overflow in isReachableFrom {0}, {1}", new Object[]{instance, instance2});
                break;
            }
            Instance instance3 = (Instance)linkedList.remove(0);
            if (instance3.equals(instance2)) {
                return true;
            }
            List list = instance3.getFieldValues();
            for (FieldValue fieldValue : list) {
                Instance instance4 = null;
                if (fieldValue instanceof ObjectFieldValue) {
                    Field field = ((ObjectFieldValue)fieldValue).getField();
                    if ("referent".equals(field.getName()) && "java.lang.ref.Reference".equals(field.getDeclaringClass().getName())) continue;
                    instance4 = ((ObjectFieldValue)fieldValue).getInstance();
                }
                if (fieldValue instanceof ArrayItemValue) {
                    instance4 = ((ArrayItemValue)fieldValue).getInstance();
                }
                if (instance4 == null || !hashSet.add(instance4)) continue;
                linkedList.add(instance4);
            }
        }
        return false;
    }

    public static Set<Instance> getRetainedSet(Collection<Instance> collection, Heap heap) {
        Instance instance;
        FieldValue fieldValue;
        Instance instance2;
        Object object;
        Object object22;
        Object object3 = null;
        JavaClass javaClass = heap.getJavaClassByName("java.lang.ref.Reference");
        for (Object object22 : javaClass.getFields()) {
            object = (Field)object22;
            if (!"referent".equals(object.getName())) continue;
            object3 = object;
            break;
        }
        HashSet hashSet = new HashSet();
        object22 = heap.getGCRoots();
        object = new HashSet();
        LinkedList<Object> linkedList = new LinkedList<Object>();
        for (Object object4 : object22) {
            Object object5 = object4.getInstance();
            if (collection.contains(object5)) continue;
            linkedList.add(object5);
        }
        while (!linkedList.isEmpty()) {
            instance2 = (Instance)linkedList.remove(0);
            if (!object.add(instance2)) continue;
            for (Object object5 : instance2.getFieldValues()) {
                fieldValue = (FieldValue)object5;
                if (fieldValue.getField().equals(object3) || !(object5 instanceof ObjectFieldValue) || (instance = ((ObjectFieldValue)object5).getInstance()) == null || collection.contains(instance)) continue;
                linkedList.add(instance);
            }
            if (!(instance2 instanceof ObjectArrayInstance)) continue;
            for (Object object5 : ((ObjectArrayInstance)instance2).getValues()) {
                fieldValue = object5;
                if (fieldValue == null || collection.contains(fieldValue)) continue;
                linkedList.add(fieldValue);
            }
        }
        linkedList.addAll(collection);
        hashSet.addAll(collection);
        while (!linkedList.isEmpty()) {
            instance2 = (Instance)linkedList.remove(0);
            for (Object object5 : instance2.getFieldValues()) {
                fieldValue = (FieldValue)object5;
                if (fieldValue.getField().equals(object3) || !(object5 instanceof ObjectFieldValue) || (instance = ((ObjectFieldValue)object5).getInstance()) == null || object.contains(instance) || !hashSet.add(instance)) continue;
                linkedList.add(instance);
            }
        }
        return hashSet;
    }

    public static Set<Instance> getRetainedSet(Instance instance, Heap heap) {
        return Utils.getRetainedSet(Collections.singleton(instance), heap);
    }

    public static String getRootIncommingString(Instance instance) {
        String string = null;
        while ((instance = instance.getNearestGCRootPointer()) != null) {
            String string2 = instance.getJavaClass().getName();
            if (string == null) {
                string = "<< " + string2;
            }
            if (!string2.startsWith("java.") && !string2.startsWith("javax.")) {
                return string2;
            }
            if (!instance.isGCRoot()) continue;
            break;
        }
        return string == null ? "unknown" : string;
    }

    public static String getSignificantIncommingString(Instance instance) {
        HashSet<Instance> hashSet = new HashSet<Instance>();
        String string = null;
        LinkedList<Instance> linkedList = new LinkedList<Instance>();
        linkedList.add(instance);
        while (!linkedList.isEmpty()) {
            if (linkedList.size() > 10) {
                Logger.getLogger(Utils.class.getName()).log(Level.FINE, "overflow in getSignificantIncommingString({0})", new Object[]{instance});
                break;
            }
            Instance instance2 = (Instance)linkedList.remove(0);
            List list = instance2.getReferences();
            for (Value value : list) {
                String string2 = value.getDefiningInstance().getJavaClass().getName();
                if (string == null) {
                    string = "<< " + string2;
                }
                if (string2.startsWith("java.") || string2.startsWith("javax.")) {
                    Instance instance3 = value.getDefiningInstance();
                    if (!hashSet.add(instance3)) continue;
                    linkedList.add(instance3);
                    continue;
                }
                return string2;
            }
        }
        return string == null ? "unknown" : string;
    }

    public static String printClass(MemoryLint memoryLint, String string) {
        if (string.startsWith("<< ")) {
            string = string.substring("<< ".length());
        }
        if ("unknown".equals(string)) {
            return NbBundle.getMessage(Utils.class, (String)"LBL_UnknownClass");
        }
        String string2 = string;
        String string3 = string;
        String string4 = "";
        int n = string.lastIndexOf(46);
        int n2 = string.lastIndexOf(58);
        if (n2 == -1) {
            n2 = string.lastIndexOf(59);
        }
        if (n2 > 0) {
            string2 = string.substring(0, n2);
            string4 = "." + string.substring(n2 + 1);
        }
        string3 = string2.substring(n + 1);
        return "<a href='file://class/" + string2 + "'>" + string3 + "</a>" + string4;
    }

    public static String printInstance(Instance instance) {
        String string = instance.getJavaClass().getName();
        return "<a href='file://instance/" + string + "/" + instance.getInstanceNumber() + "'>" + string + '#' + instance.getInstanceNumber() + "</a>";
    }
}

