/*
 * Decompiled with CFR 0.152.
 */
package org.openide.nodes;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.lang.reflect.Array;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.ChildrenArray;
import org.openide.nodes.Node;
import org.openide.nodes.NodeOp;
import org.openide.util.Utilities;

abstract class EntrySupport {
    public final Children children;
    protected List<Children.Entry> entries = Collections.emptyList();

    protected EntrySupport(Children children) {
        this.children = children;
    }

    public abstract int getNodesCount(boolean var1);

    public abstract Node[] getNodes(boolean var1);

    public abstract Node getNodeAt(int var1);

    public abstract Node[] testNodes();

    public abstract boolean isInitialized();

    abstract void notifySetEntries();

    final void setEntries(Collection<? extends Children.Entry> collection) {
        this.setEntries(collection, false);
    }

    abstract void setEntries(Collection<? extends Children.Entry> var1, boolean var2);

    protected final List<Children.Entry> getEntries() {
        return new ArrayList<Children.Entry>(this.entries);
    }

    abstract List<Node> snapshot();

    abstract void refreshEntry(Children.Entry var1);

    static class Lazy
    extends EntrySupport {
        private Map<Children.Entry, EntryInfo> entryToInfo = new HashMap<Children.Entry, EntryInfo>();
        private List<Children.Entry> visibleEntries = Collections.emptyList();
        private static final Logger LOGGER = Logger.getLogger(Lazy.class.getName());
        private static final int prefetchCount = Math.max(Integer.getInteger("org.openide.explorer.VisualizerNode.prefetchCount", 50), 0);
        protected final Object LOCK = new Object();
        private boolean initInProgress = false;
        private boolean inited = false;
        private Thread initThread;
        private int snapshotCount;
        private boolean mustNotifySetEntries = false;

        public Lazy(Children children) {
            super(children);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean checkInit() {
            if (this.inited) {
                return true;
            }
            boolean bl = false;
            Object object = this.LOCK;
            synchronized (object) {
                if (!this.initInProgress) {
                    bl = true;
                    this.initInProgress = true;
                    this.initThread = Thread.currentThread();
                }
            }
            boolean bl2 = LOGGER.isLoggable(Level.FINER);
            if (bl) {
                if (bl2) {
                    LOGGER.finer("Initialize " + this + " on " + Thread.currentThread());
                    LOGGER.finer("    callAddNotify()");
                }
                try {
                    this.children.callAddNotify();
                }
                finally {
                    class Notify
                    implements Runnable {
                        Notify() {
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            Object object = Lazy.this.LOCK;
                            synchronized (object) {
                                Lazy.this.initThread = null;
                                Lazy.this.LOCK.notifyAll();
                            }
                        }
                    }
                    Notify notify = new Notify();
                    this.inited = true;
                    if (Children.MUTEX.isReadAccess()) {
                        Children.MUTEX.postWriteRequest((Runnable)notify);
                    } else {
                        notify.run();
                    }
                }
            }
            if (Children.MUTEX.isReadAccess() || Children.MUTEX.isWriteAccess() || this.initThread == Thread.currentThread()) {
                if (bl2) {
                    LOGGER.log(Level.FINER, "Cannot wait for finished initialization " + this + " on " + Thread.currentThread() + " read access: " + Children.MUTEX.isReadAccess() + " write access: " + Children.MUTEX.isWriteAccess() + " initThread: " + this.initThread);
                }
                this.notifySetEntries();
                return false;
            }
            Object object2 = this.LOCK;
            synchronized (object2) {
                while (this.initThread != null) {
                    try {
                        this.LOCK.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            return true;
        }

        final int getSnapshotCount() {
            assert (Thread.holdsLock(this.LOCK));
            return this.snapshotCount;
        }

        final void incrementCount() {
            assert (Thread.holdsLock(this.LOCK));
            ++this.snapshotCount;
        }

        final void decrementCount() {
            assert (Thread.holdsLock(this.LOCK));
            ++this.snapshotCount;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        List<Node> snapshot() {
            this.checkInit();
            try {
                Children.PR.enterReadAccess();
                LazySnapshot lazySnapshot = this.createSnapshot();
                return lazySnapshot;
            }
            finally {
                Children.PR.exitReadAccess();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final void registerNode(int n, EntryInfo entryInfo) {
            if (n == -1) {
                try {
                    Children.PR.enterWriteAccess();
                    boolean bl = false;
                    LOGGER.finer("register node");
                    Object object = this.LOCK;
                    synchronized (object) {
                        int n2 = 0;
                        boolean bl2 = false;
                        if ((n2 += this.getSnapshotCount()) == 0) {
                            for (Children.Entry entry : Lazy.notNull(this.visibleEntries)) {
                                EntryInfo entryInfo2 = this.entryToInfo.get(entry);
                                if (entryInfo2.currentNode() != null) {
                                    ++n2;
                                    break;
                                }
                                if (entryInfo2 != entryInfo) continue;
                                bl2 = true;
                            }
                        }
                        boolean bl3 = bl = n2 == 0 && (bl2 || entryInfo == null);
                        if (bl) {
                            this.inited = false;
                            this.initThread = null;
                            this.initInProgress = false;
                            if (this.children.getEntrySupport() == this) {
                                if (LOGGER.isLoggable(Level.FINER)) {
                                    LOGGER.finer("callRemoveNotify() " + this);
                                }
                                this.children.callRemoveNotify();
                            }
                        }
                    }
                }
                finally {
                    Children.PR.exitWriteAccess();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Node getNodeAt(int n) {
            if (!this.checkInit()) {
                return null;
            }
            Object object = null;
            do {
                try {
                    Children.Entry entry;
                    Children.PR.enterReadAccess();
                    List<Children.Entry> list = Lazy.notNull(this.visibleEntries);
                    if (n >= list.size()) {
                        entry = object;
                        return entry;
                    }
                    entry = list.get(n);
                    EntryInfo entryInfo = this.entryToInfo.get(entry);
                    object = entryInfo.getNode();
                    if (!Lazy.isDummyNode((Node)object)) {
                        Object object2 = object;
                        return object2;
                    }
                    this.hideEmpty(null, entry);
                }
                finally {
                    Children.PR.exitReadAccess();
                }
            } while (!Children.MUTEX.isReadAccess());
            return object;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Node[] getNodes(boolean bl) {
            Node[] nodeArray;
            if (!this.checkInit()) {
                return new Node[0];
            }
            Node node = null;
            if (bl) {
                node = this.children.findChild(null);
            }
            Children.LOG.log(Level.FINEST, "findChild returns: {0}", node);
            Children.LOG.log(Level.FINEST, "after findChild: {0}", bl);
            do {
                HashSet<Children.Entry> hashSet = null;
                nodeArray = null;
                try {
                    Children.PR.enterReadAccess();
                    List<Children.Entry> list = Lazy.notNull(this.visibleEntries);
                    ArrayList<Node> arrayList = new ArrayList<Node>(list.size());
                    for (Children.Entry entry : list) {
                        EntryInfo entryInfo = this.entryToInfo.get(entry);
                        assert (!entryInfo.isHidden());
                        Node node2 = entryInfo.getNode();
                        if (Lazy.isDummyNode(node2)) {
                            if (hashSet == null) {
                                hashSet = new HashSet<Children.Entry>();
                            }
                            hashSet.add(entry);
                        }
                        arrayList.add(node2);
                    }
                    nodeArray = arrayList.toArray(new Node[0]);
                    if (hashSet == null) {
                        Node[] nodeArray2 = nodeArray;
                        return nodeArray2;
                    }
                    this.hideEmpty(hashSet, null);
                }
                finally {
                    Children.PR.exitReadAccess();
                }
            } while (!Children.MUTEX.isReadAccess());
            return nodeArray;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Node[] testNodes() {
            if (!this.inited) {
                return null;
            }
            ArrayList<Node> arrayList = new ArrayList<Node>();
            try {
                Children.PR.enterReadAccess();
                for (Children.Entry entry : Lazy.notNull(this.visibleEntries)) {
                    EntryInfo entryInfo = this.entryToInfo.get(entry);
                    Node node = entryInfo.currentNode();
                    if (node == null) continue;
                    arrayList.add(node);
                }
            }
            finally {
                Children.PR.exitReadAccess();
            }
            return arrayList.isEmpty() ? null : arrayList.toArray(new Node[arrayList.size()]);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int getNodesCount(boolean bl) {
            this.checkInit();
            try {
                Children.PR.enterReadAccess();
                int n = Lazy.notNull(this.visibleEntries).size();
                return n;
            }
            finally {
                Children.PR.exitReadAccess();
            }
        }

        @Override
        public boolean isInitialized() {
            return this.inited;
        }

        Children.Entry entryForNode(Node node) {
            for (Map.Entry<Children.Entry, EntryInfo> entry : this.entryToInfo.entrySet()) {
                if (entry.getValue().currentNode() != node) continue;
                return entry.getKey();
            }
            return null;
        }

        static final boolean isDummyNode(Node node) {
            return node.getClass().getName().endsWith("EntrySupport$Lazy$DummyNode");
        }

        @Override
        void refreshEntry(Children.Entry entry) {
            assert (Children.MUTEX.isWriteAccess());
            boolean bl = LOGGER.isLoggable(Level.FINER);
            if (bl) {
                LOGGER.finer("refreshEntry() " + this);
                LOGGER.finer("    entry: " + entry);
            }
            if (!this.inited) {
                return;
            }
            EntryInfo entryInfo = this.entryToInfo.get(entry);
            if (entryInfo == null) {
                if (bl) {
                    LOGGER.finer("    no such entry: " + entry);
                }
                return;
            }
            Node node = entryInfo.currentNode();
            EntryInfo entryInfo2 = null;
            Node node2 = null;
            if (entryInfo.isHidden()) {
                node2 = entryInfo.getNode(true, null);
            } else {
                entryInfo2 = entryInfo.duplicate(null);
                node2 = entryInfo2.getNode(true, null);
            }
            boolean bl2 = Lazy.isDummyNode(node2);
            if (bl2 && entryInfo.isHidden()) {
                return;
            }
            if (node2.equals(node)) {
                return;
            }
            if (!entryInfo.isHidden() || bl2) {
                this.removeEntries(null, entry, entryInfo2, true, true);
            }
            if (entryInfo2 != null) {
                entryInfo = entryInfo2;
                this.entryToInfo.put(entry, entryInfo);
            }
            if (bl2) {
                return;
            }
            int n = 0;
            entryInfo.setIndex(-1);
            ArrayList<Children.Entry> arrayList = new ArrayList<Children.Entry>();
            for (Children.Entry entry2 : this.entries) {
                EntryInfo entryInfo3 = this.entryToInfo.get(entry2);
                if (entryInfo3.isHidden()) continue;
                entryInfo3.setIndex(n++);
                arrayList.add(entry2);
            }
            this.visibleEntries = arrayList;
            this.fireSubNodesChangeIdx(true, new int[]{entryInfo.getIndex()}, entry, this.createSnapshot(), null);
        }

        @Override
        void notifySetEntries() {
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.finer("notifySetEntries() " + this);
            }
            this.mustNotifySetEntries = true;
        }

        @Override
        void setEntries(Collection<? extends Children.Entry> collection, boolean bl) {
            List<Children.Entry> list;
            assert (Children.MUTEX.isWriteAccess());
            boolean bl2 = LOGGER.isLoggable(Level.FINER);
            if (bl2) {
                LOGGER.finer("setEntries(): " + this);
                LOGGER.finer("    inited: " + this.inited);
                LOGGER.finer("    mustNotifySetEnties: " + this.mustNotifySetEntries);
                LOGGER.finer("    newEntries size: " + collection.size() + " data:" + collection);
                LOGGER.finer("    entries size: " + this.entries.size() + " data:" + this.entries);
                LOGGER.finer("    visibleEntries size: " + Lazy.notNull(this.visibleEntries).size() + " data:" + this.visibleEntries);
                LOGGER.finer("    entryToInfo size: " + this.entryToInfo.size());
            }
            int n = 0;
            int n2 = 0;
            assert ((n = this.entries.size()) >= 0);
            assert ((n2 = this.entryToInfo.size()) >= 0);
            assert (this.entries.size() == this.entryToInfo.size()) : "Entries: " + this.entries.size() + "; vis. entries: " + Lazy.notNull(this.visibleEntries).size() + "; Infos: " + this.entryToInfo.size() + "; entriesSize: " + n + "; entryToInfoSize: " + n2 + Lazy.dumpEntriesInfos(this.entries, this.entryToInfo);
            if (!this.mustNotifySetEntries && !this.inited) {
                this.entries = new ArrayList<Children.Entry>(collection);
                this.visibleEntries = new ArrayList<Children.Entry>(collection);
                this.entryToInfo.keySet().retainAll(this.entries);
                for (int i = 0; i < this.entries.size(); ++i) {
                    Children.Entry entry = (Children.Entry)this.entries.get(i);
                    EntryInfo entryInfo = this.entryToInfo.get(entry);
                    if (entryInfo == null) {
                        entryInfo = new EntryInfo(entry);
                        this.entryToInfo.put(entry, entryInfo);
                    }
                    entryInfo.setIndex(i);
                }
                return;
            }
            HashSet<Children.Entry> hashSet = new HashSet<Children.Entry>(this.entries);
            hashSet.removeAll(collection);
            if (!hashSet.isEmpty()) {
                this.removeEntries(hashSet, null, null, false, false);
            }
            if (!(list = this.updateOrder(collection)).isEmpty()) {
                this.entries = new ArrayList<Children.Entry>(collection);
                int[] nArray = new int[list.size()];
                int n3 = 0;
                int n4 = 0;
                boolean bl3 = list.size() == 2 && prefetchCount > 0;
                this.visibleEntries = new ArrayList<Children.Entry>();
                for (int i = 0; i < this.entries.size(); ++i) {
                    Children.Entry entry = (Children.Entry)this.entries.get(i);
                    EntryInfo entryInfo = this.entryToInfo.get(entry);
                    if (entryInfo == null) {
                        Node node;
                        entryInfo = new EntryInfo(entry);
                        this.entryToInfo.put(entry, entryInfo);
                        if (bl3 && Lazy.isDummyNode(node = entryInfo.getNode())) {
                            entryInfo.setIndex(-2);
                            continue;
                        }
                        nArray[n3++] = n4;
                    }
                    if (entryInfo.isHidden()) continue;
                    entryInfo.setIndex(n4++);
                    this.visibleEntries.add(entry);
                }
                if (n3 == 0) {
                    return;
                }
                if (nArray.length != n3) {
                    int[] nArray2 = new int[n3];
                    for (int i = 0; i < nArray2.length; ++i) {
                        nArray2[i] = nArray[i];
                    }
                    nArray = nArray2;
                }
                this.fireSubNodesChangeIdx(true, nArray, null, this.createSnapshot(), null);
            }
        }

        private List<Children.Entry> updateOrder(Collection<? extends Children.Entry> collection) {
            assert (Children.MUTEX.isWriteAccess());
            LinkedList<Children.Entry> linkedList = new LinkedList<Children.Entry>();
            int[] nArray = new int[this.visibleEntries.size()];
            int n = 0;
            int n2 = 0;
            LinkedList<Children.Entry> linkedList2 = null;
            ArrayList<Children.Entry> arrayList = null;
            for (Children.Entry entry : collection) {
                EntryInfo entryInfo = this.entryToInfo.get(entry);
                if (entryInfo == null) {
                    linkedList.add(entry);
                    continue;
                }
                if (linkedList2 == null) {
                    linkedList2 = new LinkedList<Children.Entry>();
                    arrayList = new ArrayList<Children.Entry>();
                }
                linkedList2.add(entry);
                if (entryInfo.isHidden()) continue;
                arrayList.add(entry);
                int n3 = entryInfo.getIndex();
                if (n != n3) {
                    entryInfo.setIndex(n);
                    nArray[n3] = 1 + n;
                    ++n2;
                }
                ++n;
            }
            if (n2 > 0) {
                for (int i = 0; i < nArray.length; ++i) {
                    if (nArray[i] == 0) {
                        nArray[i] = i;
                        continue;
                    }
                    int n3 = i;
                    nArray[n3] = nArray[n3] - 1;
                }
                this.entries = linkedList2;
                this.visibleEntries = arrayList;
                Node node = this.children.parent;
                if (node != null) {
                    node.fireReorderChange(nArray);
                }
            }
            return linkedList;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Node getNode(Children.Entry entry) {
            this.checkInit();
            try {
                Children.PR.enterReadAccess();
                EntryInfo entryInfo = this.entryToInfo.get(entry);
                if (entryInfo == null) {
                    if (LOGGER.isLoggable(Level.FINER)) {
                        LOGGER.finer("getNode() " + this);
                        LOGGER.finer("    no such entry: " + entry);
                    }
                    Node node = null;
                    return node;
                }
                Node node = entryInfo.getNode();
                Node node2 = Lazy.isDummyNode(node) ? null : node;
                return node2;
            }
            finally {
                Children.PR.exitReadAccess();
            }
        }

        protected void fireSubNodesChangeIdx(boolean bl, int[] nArray, Children.Entry entry, List<Node> list, List<Node> list2) {
            if (this.children.parent != null && this.children.getEntrySupport() == this) {
                this.children.parent.fireSubNodesChangeIdx(bl, nArray, entry, list, list2);
            }
        }

        private static <T> List<T> notNull(List<T> list) {
            if (list == null) {
                return Collections.emptyList();
            }
            return list;
        }

        private static String dumpEntriesInfos(List<Children.Entry> list, Map<Children.Entry, EntryInfo> map) {
            StringBuilder stringBuilder = new StringBuilder();
            int n = 0;
            for (Children.Entry object : list) {
                stringBuilder.append("\n").append(++n).append(" entry ").append(object).append(" -> ").append(map.get(object));
            }
            stringBuilder.append("\n\n");
            for (Map.Entry entry : map.entrySet()) {
                if (list.contains(entry.getKey())) {
                    stringBuilder.append("\n").append(" contained ").append(entry.getValue());
                    continue;
                }
                stringBuilder.append("\n").append(" missing   ").append(entry.getValue()).append(" for ").append(entry.getKey());
            }
            return stringBuilder.toString();
        }

        void hideEmpty(final Set<Children.Entry> set, final Children.Entry entry) {
            Children.MUTEX.postWriteRequest(new Runnable(){

                @Override
                public void run() {
                    Lazy.this.removeEntries(set, entry, null, true, true);
                }
            });
        }

        private void removeEntries(Set<Children.Entry> set, Children.Entry entry, EntryInfo entryInfo, boolean bl, boolean bl2) {
            Object object22;
            assert (Children.MUTEX.isWriteAccess());
            boolean bl3 = LOGGER.isLoggable(Level.FINER);
            if (bl3) {
                LOGGER.finer("removeEntries(): " + this);
                LOGGER.finer("    entriesToRemove: " + set);
                LOGGER.finer("    entryToRemove: " + entry);
                LOGGER.finer("    newEntryInfo: " + entryInfo);
                LOGGER.finer("    justHide: " + bl);
                LOGGER.finer("    delayed: " + bl2);
            }
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            int n4 = set != null ? set.size() : 1;
            int[] nArray = new int[n4];
            List<Children.Entry> list = this.visibleEntries;
            HashMap<Children.Entry, EntryInfo> hashMap = null;
            ArrayList<Children.Entry> arrayList = bl ? null : new ArrayList<Children.Entry>();
            Node[] nodeArray = null;
            this.visibleEntries = new ArrayList<Children.Entry>();
            for (Object object22 : this.entries) {
                Node[] nodeArray2 = this.entryToInfo.get(object22);
                int n5 = set != null ? set.remove(object22) : entry.equals(object22);
                if (n5 != 0) {
                    if (nodeArray2.isHidden()) {
                        if (bl) continue;
                        this.entryToInfo.remove(object22);
                        continue;
                    }
                    nArray[n2++] = nodeArray2.getIndex();
                    if (hashMap == null) {
                        hashMap = new HashMap<Children.Entry, EntryInfo>(this.entryToInfo);
                    }
                    Node node = nodeArray2.currentNode();
                    if (!nodeArray2.isHidden() && node != null && !Lazy.isDummyNode(node)) {
                        if (nodeArray == null) {
                            nodeArray = new Node[n4];
                        }
                        nodeArray[n3++] = node;
                    }
                    if (bl) {
                        EntryInfo object3 = entryInfo != null ? entryInfo : nodeArray2.duplicate(null);
                        this.entryToInfo.put(nodeArray2.entry, object3);
                        object3.setIndex(-2);
                        continue;
                    }
                    this.entryToInfo.remove(object22);
                    continue;
                }
                if (!nodeArray2.isHidden()) {
                    this.visibleEntries.add(nodeArray2.entry);
                    nodeArray2.setIndex(n++);
                }
                if (bl) continue;
                arrayList.add(nodeArray2.entry);
            }
            if (!bl) {
                this.entries = arrayList;
            }
            if (n2 == 0) {
                return;
            }
            if (n2 < nArray.length) {
                nArray = (int[])Lazy.resizeArray(nArray, n2);
            }
            LazySnapshot lazySnapshot = this.createSnapshot(this.visibleEntries, new HashMap<Children.Entry, EntryInfo>(this.entryToInfo), bl2);
            object22 = this.createSnapshot(list, hashMap, false);
            this.fireSubNodesChangeIdx(false, nArray, entry, lazySnapshot, (List<Node>)object22);
            if (n3 > 0) {
                if (n3 < nodeArray.length) {
                    nodeArray = (Node[])Lazy.resizeArray(nodeArray, n3);
                }
                if (this.children.parent != null) {
                    for (Node node : nodeArray) {
                        node.deassignFrom(this.children);
                        node.fireParentNodeChange(this.children.parent, null);
                    }
                }
                this.children.destroyNodes(nodeArray);
            }
        }

        private static Object resizeArray(Object object, int n) {
            int n2 = Array.getLength(object);
            Class<?> clazz = object.getClass().getComponentType();
            Object object2 = Array.newInstance(clazz, n);
            int n3 = Math.min(n2, n);
            if (n3 > 0) {
                System.arraycopy(object, 0, object2, 0, n3);
            }
            return object2;
        }

        LazySnapshot createSnapshot() {
            return this.createSnapshot(this.visibleEntries, new HashMap<Children.Entry, EntryInfo>(this.entryToInfo), false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected LazySnapshot createSnapshot(List<Children.Entry> list, Map<Children.Entry, EntryInfo> map, boolean bl) {
            Object object = this.LOCK;
            synchronized (object) {
                return bl ? new DelayedLazySnapshot(list, map) : new LazySnapshot(list, map);
            }
        }

        final class DelayedLazySnapshot
        extends LazySnapshot {
            public DelayedLazySnapshot(List<Children.Entry> list, Map<Children.Entry, EntryInfo> map) {
                super(list, map);
            }
        }

        class LazySnapshot
        extends AbstractList<Node> {
            final List<Children.Entry> entries;
            final Map<Children.Entry, EntryInfo> entryToInfo;

            public LazySnapshot(List<Children.Entry> list, Map<Children.Entry, EntryInfo> map) {
                Lazy.this.incrementCount();
                this.entries = list;
                assert (list != null);
                this.entryToInfo = map != null ? map : Collections.emptyMap();
            }

            @Override
            public Node get(int n) {
                Children.Entry entry = this.entries.get(n);
                return this.get(entry);
            }

            Node get(Children.Entry entry) {
                EntryInfo entryInfo = this.entryToInfo.get(entry);
                Node node = entryInfo.getNode();
                if (Lazy.isDummyNode(node)) {
                    Lazy.this.hideEmpty(null, entry);
                }
                return node;
            }

            @Override
            public String toString() {
                return this.entries.toString();
            }

            @Override
            public int size() {
                return this.entries.size();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void finalize() throws Throwable {
                boolean bl = false;
                Object object = Lazy.this.LOCK;
                synchronized (object) {
                    Lazy.this.decrementCount();
                    if (Lazy.this.getSnapshotCount() == 0) {
                        bl = true;
                    }
                }
                if (bl) {
                    Lazy.this.registerNode(-1, null);
                }
            }
        }

        static class DummyNode
        extends AbstractNode {
            public DummyNode() {
                super(Children.LEAF);
            }
        }

        private static final class NodeRef
        extends WeakReference<Node>
        implements Runnable {
            private final EntryInfo info;

            public NodeRef(Node node, EntryInfo entryInfo) {
                super(node, Utilities.activeReferenceQueue());
                entryInfo.lazy().registerNode(1, entryInfo);
                this.info = entryInfo;
            }

            @Override
            public void run() {
                this.info.lazy().registerNode(-1, this.info);
            }
        }

        final class EntryInfo {
            final Children.Entry entry;
            private NodeRef refNode;
            private int index = -1;
            private Thread creatingNodeThread = null;

            public EntryInfo(Children.Entry entry) {
                this.entry = entry;
            }

            final EntryInfo duplicate(Node node) {
                EntryInfo entryInfo = new EntryInfo(this.entry);
                entryInfo.index = this.index;
                entryInfo.refNode = node != null ? new NodeRef(node, entryInfo) : this.refNode;
                return entryInfo;
            }

            final Lazy lazy() {
                return Lazy.this;
            }

            public final Node getNode() {
                return this.getNode(false, null);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public final Node getNode(boolean bl, Object object) {
                Collection<Object> collection;
                boolean bl2;
                Node node;
                while (true) {
                    node = null;
                    bl2 = false;
                    collection = Lazy.this.LOCK;
                    synchronized (collection) {
                        if (bl) {
                            this.refNode = null;
                        }
                        if (this.refNode != null && (node = (Node)this.refNode.get()) != null) {
                            return node;
                        }
                        if (this.creatingNodeThread != null) {
                            if (this.creatingNodeThread == Thread.currentThread()) {
                                return new DummyNode();
                            }
                            try {
                                Lazy.this.LOCK.wait();
                            }
                            catch (InterruptedException interruptedException) {}
                        } else {
                            this.creatingNodeThread = Thread.currentThread();
                            bl2 = true;
                        }
                    }
                    collection = Collections.emptyList();
                    if (bl2) {
                        try {
                            collection = this.entry.nodes(object);
                        }
                        catch (RuntimeException runtimeException) {
                            NodeOp.warning(runtimeException);
                        }
                    }
                    Object object2 = Lazy.this.LOCK;
                    synchronized (object2) {
                        if (bl2) break;
                        if (this.refNode != null && (node = (Node)this.refNode.get()) != null) {
                            return node;
                        }
                    }
                }
                {
                    if (collection.size() == 0) {
                        node = new DummyNode();
                    } else {
                        if (collection.size() > 1) {
                            LOGGER.fine("Number of nodes for Entry: " + this.entry + " is " + collection.size() + " instead of 1");
                        }
                        node = (Node)collection.iterator().next();
                    }
                    this.refNode = new NodeRef(node, this);
                    if (bl2) {
                        this.creatingNodeThread = null;
                        Lazy.this.LOCK.notifyAll();
                    }
                }
                node.assignTo(Lazy.this.children, -1);
                node.fireParentNodeChange(null, Lazy.this.children.parent);
                return node;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            Node currentNode() {
                Object object = Lazy.this.LOCK;
                synchronized (object) {
                    return this.refNode == null ? null : (Node)this.refNode.get();
                }
            }

            final boolean isHidden() {
                return this.index == -2;
            }

            final void setIndex(int n) {
                this.index = n;
            }

            final int getIndex() {
                assert (this.index >= 0) : "When first asked for it has to be set: " + this.index;
                return this.index;
            }

            public String toString() {
                return "EntryInfo for entry: " + this.entry + ", node: " + (this.refNode == null ? null : (Node)this.refNode.get());
            }
        }
    }

    static class Default
    extends EntrySupport {
        private static final Reference<ChildrenArray> EMPTY = new WeakReference<Object>(null);
        private Reference<ChildrenArray> array = EMPTY;
        private Map<Children.Entry, Info> map;
        private static final Object LOCK = new Object();
        private static final Logger LOGGER = Logger.getLogger(Default.class.getName());
        private Thread initThread;
        private boolean inited = false;
        private boolean mustNotifySetEnties = false;

        public Default(Children children) {
            super(children);
        }

        @Override
        public boolean isInitialized() {
            ChildrenArray childrenArray = this.array.get();
            return this.inited && childrenArray != null && childrenArray.isInitialized();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        List<Node> snapshot() {
            Node[] nodeArray = this.getNodes();
            try {
                Children.PR.enterReadAccess();
                DefaultSnapshot defaultSnapshot = this.createSnapshot();
                return defaultSnapshot;
            }
            finally {
                Children.PR.exitReadAccess();
            }
        }

        DefaultSnapshot createSnapshot() {
            return new DefaultSnapshot(this.getNodes(), this.array.get());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final Node[] getNodes() {
            Node[] nodeArray;
            boolean bl = LOGGER.isLoggable(Level.FINER);
            if (bl) {
                LOGGER.finer("getNodes() " + this);
            }
            boolean[] blArray = new boolean[2];
            do {
                ChildrenArray childrenArray = this.getArray(blArray);
                try {
                    Children.PR.enterReadAccess();
                    if (this != this.children.getEntrySupport()) {
                        Node[] nodeArray2 = new Node[]{};
                        return nodeArray2;
                    }
                    blArray[1] = this.isInitialized();
                    nodeArray = childrenArray.nodes();
                }
                finally {
                    Children.PR.exitReadAccess();
                }
                if (bl) {
                    LOGGER.finer("  length     : " + (nodeArray == null ? "nodes is null" : Integer.valueOf(nodeArray.length)));
                    LOGGER.finer("  init now   : " + this.isInitialized());
                }
                if (!blArray[1]) continue;
                return nodeArray;
            } while (!blArray[0]);
            this.notifySetEntries();
            return nodeArray == null ? new Node[]{} : nodeArray;
        }

        @Override
        public Node[] getNodes(boolean bl) {
            boolean bl2 = LOGGER.isLoggable(Level.FINER);
            ChildrenArray childrenArray = null;
            Node node = null;
            if (bl) {
                if (bl2) {
                    LOGGER.finer("computing optimal result");
                }
                childrenArray = this.getArray(null);
                if (bl2) {
                    LOGGER.finer("optimal result is here: " + childrenArray);
                }
                node = this.children.findChild(null);
                if (bl2) {
                    LOGGER.finer("Find child got: " + node);
                }
                Children.LOG.log(Level.FINEST, "after findChild: {0}", bl);
            }
            return this.getNodes();
        }

        @Override
        public final int getNodesCount(boolean bl) {
            return this.getNodes(bl).length;
        }

        @Override
        public Node getNodeAt(int n) {
            Node[] nodeArray = this.getNodes();
            return n < nodeArray.length ? nodeArray[n] : null;
        }

        final Node[] justComputeNodes() {
            Object object;
            if (this.map == null) {
                this.map = Collections.synchronizedMap(new HashMap(17));
                LOGGER.finer("Map initialized");
            }
            LinkedList<Node> linkedList = new LinkedList<Node>();
            for (Children.Entry entry : this.entries) {
                object = this.findInfo(entry);
                linkedList.addAll(((Info)object).nodes(false));
            }
            Node[] nodeArray = linkedList.toArray(new Node[linkedList.size()]);
            for (int i = 0; i < nodeArray.length; ++i) {
                object = nodeArray[i];
                if (object == null) {
                    LOGGER.warning("null node among children!");
                    for (int j = 0; j < nodeArray.length; ++j) {
                        LOGGER.log(Level.WARNING, "  {0} = {1}", new Object[]{j, nodeArray[j]});
                    }
                    for (Children.Entry entry : this.entries) {
                        Info info = this.findInfo(entry);
                        LOGGER.log(Level.WARNING, "  entry: {0} info {1} nodes: {2}", new Object[]{entry, info, info.nodes(false)});
                    }
                    throw new NullPointerException("arr[" + i + "] is null");
                }
                ((Node)object).assignTo(this.children, i);
                ((Node)object).fireParentNodeChange(null, this.children.parent);
            }
            return nodeArray;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Info findInfo(Children.Entry entry) {
            Map<Children.Entry, Info> map = this.map;
            synchronized (map) {
                Info info = this.map.get(entry);
                if (info == null) {
                    info = new Info(entry);
                    this.map.put(entry, info);
                    if (LOGGER.isLoggable(Level.FINER)) {
                        LOGGER.finer("Put: " + entry + " info: " + info);
                    }
                }
                return info;
            }
        }

        @Override
        void notifySetEntries() {
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.finer(this + " mustNotifySetEntries()");
            }
            this.mustNotifySetEnties = true;
        }

        private void checkConsistency() {
            assert (this.map.size() == this.entries.size()) : "map.size()=" + this.map.size() + " entries.size()=" + this.entries.size();
        }

        @Override
        protected void setEntries(Collection<? extends Children.Entry> collection, boolean bl) {
            List<Info> list;
            Node[] nodeArray;
            assert (bl || Children.MUTEX.isWriteAccess());
            boolean bl2 = LOGGER.isLoggable(Level.FINER);
            ChildrenArray childrenArray = this.array.get();
            if (bl2) {
                LOGGER.finer("setEntries for " + this + " on " + Thread.currentThread());
                LOGGER.finer("       values: " + collection);
                LOGGER.finer("       holder: " + childrenArray);
                LOGGER.finer("       mustNotifySetEntries: " + this.mustNotifySetEnties);
            }
            Node[] nodeArray2 = nodeArray = childrenArray == null ? null : childrenArray.nodes();
            if (this.mustNotifySetEnties) {
                if (childrenArray == null) {
                    childrenArray = this.getArray(null);
                }
                if (nodeArray == null) {
                    childrenArray.entrySupport = this;
                    nodeArray = childrenArray.nodes();
                }
                this.mustNotifySetEnties = false;
            } else if (childrenArray == null || nodeArray == null) {
                this.entries = new ArrayList<Children.Entry>(collection);
                if (this.map != null) {
                    this.map.keySet().retainAll(new HashSet(this.entries));
                }
                return;
            }
            this.checkConsistency();
            LinkedHashSet<Children.Entry> linkedHashSet = new LinkedHashSet<Children.Entry>(this.entries);
            HashSet<? extends Children.Entry> hashSet = new HashSet<Children.Entry>(collection);
            linkedHashSet.removeAll(hashSet);
            if (!linkedHashSet.isEmpty()) {
                this.updateRemove(nodeArray, linkedHashSet);
                nodeArray = childrenArray.nodes();
            }
            if (!(list = this.updateOrder(nodeArray, collection)).isEmpty()) {
                this.updateAdd(list, new ArrayList<Children.Entry>(collection));
            }
        }

        private void checkInfo(Info info, Children.Entry entry, Collection<? extends Children.Entry> collection, Map<Children.Entry, Info> map) {
            if (info == null) {
                throw new IllegalStateException("Error in " + this.getClass().getName() + " with entry " + entry + " from among " + collection + " in " + map + " probably caused by faulty key implementation." + " The key hashCode() and equals() methods must behave as for an IMMUTABLE object" + " and the hashCode() must return the same value for equals() keys.");
            }
        }

        private void updateRemove(Node[] nodeArray, Set<Children.Entry> set) {
            assert (Children.MUTEX.isWriteAccess());
            LinkedList<Node> linkedList = new LinkedList<Node>();
            ChildrenArray childrenArray = this.array.get();
            for (Children.Entry entry : set) {
                Info info = this.map.remove(entry);
                this.checkInfo(info, entry, null, this.map);
                linkedList.addAll(info.nodes(true));
                childrenArray.remove(info);
            }
            this.entries.removeAll(set);
            this.checkConsistency();
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.finer("Current : " + this.entries);
                LOGGER.finer("Removing: " + set);
            }
            if (!linkedList.isEmpty()) {
                this.clearNodes();
                this.notifyRemove(linkedList, nodeArray);
            }
        }

        private List<Info> updateOrder(Node[] nodeArray, Collection<? extends Children.Entry> collection) {
            Object object;
            assert (Children.MUTEX.isWriteAccess());
            LinkedList<Info> linkedList = new LinkedList<Info>();
            HashMap<Info, Integer> hashMap = new HashMap<Info, Integer>();
            int n = 0;
            for (Children.Entry entry : this.entries) {
                object = this.map.get(entry);
                this.checkInfo((Info)object, entry, this.entries, this.map);
                hashMap.put((Info)object, n);
                n += ((Info)object).length();
            }
            int[] nArray = new int[nodeArray.length];
            int n2 = 0;
            int n3 = 0;
            object = null;
            for (Children.Entry entry : collection) {
                Info info = this.map.get(entry);
                if (info == null) {
                    info = new Info(entry);
                    linkedList.add(info);
                } else {
                    int n4 = info.length();
                    if (object == null) {
                        object = new LinkedList();
                    }
                    object.add(entry);
                    Integer n5 = (Integer)hashMap.get(info);
                    int n6 = n5;
                    if (n2 != n6) {
                        for (int i = 0; i < n4; ++i) {
                            nArray[n6 + i] = 1 + n2 + i;
                        }
                        n3 += n4;
                    }
                }
                n2 += info.length();
            }
            if (n3 > 0) {
                for (int i = 0; i < nArray.length; ++i) {
                    if (nArray[i] == 0) {
                        nArray[i] = i;
                        continue;
                    }
                    int n4 = i;
                    nArray[n4] = nArray[n4] - 1;
                }
                if (LOGGER.isLoggable(Level.FINER)) {
                    LOGGER.finer("Entries before reordering: " + this.entries);
                    LOGGER.finer("Entries after reordering: " + object);
                }
                this.entries = object;
                this.checkConsistency();
                this.clearNodes();
                Node node = this.children.parent;
                if (node != null) {
                    node.fireReorderChange(nArray);
                }
            }
            return linkedList;
        }

        private void updateAdd(Collection<Info> collection, List<Children.Entry> list) {
            assert (Children.MUTEX.isWriteAccess());
            LinkedList<Node> linkedList = new LinkedList<Node>();
            for (Info info : collection) {
                linkedList.addAll(info.nodes(false));
                this.map.put(info.entry, info);
            }
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.finer("Entries before updateAdd(): " + this.entries);
                LOGGER.finer("Entries after updateAdd(): " + list);
            }
            this.entries = list;
            this.checkConsistency();
            if (!linkedList.isEmpty()) {
                this.clearNodes();
                this.notifyAdd(linkedList);
            }
        }

        @Override
        final void refreshEntry(Children.Entry entry) {
            Collection<Node> collection;
            ChildrenArray childrenArray = this.array.get();
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.finer("refreshEntry: " + entry + " holder=" + childrenArray);
            }
            if (childrenArray == null) {
                return;
            }
            Node[] nodeArray = childrenArray.nodes();
            if (nodeArray == null) {
                return;
            }
            this.checkConsistency();
            Info info = this.map.get(entry);
            if (info == null) {
                return;
            }
            Collection<Node> collection2 = info.nodes(false);
            if (((Object)collection2).equals(collection = info.entry.nodes(null))) {
                return;
            }
            HashSet<Node> hashSet = new HashSet<Node>(collection2);
            hashSet.removeAll(new HashSet<Node>(collection));
            if (!hashSet.isEmpty()) {
                collection2.removeAll(hashSet);
                this.clearNodes();
                this.notifyRemove(hashSet, nodeArray);
                nodeArray = childrenArray.nodes();
            }
            List<Node> list = this.refreshOrder(entry, collection2, collection);
            info.useNodes(collection);
            if (!list.isEmpty()) {
                this.clearNodes();
                this.notifyAdd(list);
            }
        }

        private List<Node> refreshOrder(Children.Entry entry, Collection<Node> collection, Collection<Node> collection2) {
            Object object;
            LinkedList<Node> linkedList = new LinkedList<Node>();
            HashSet<Node> hashSet = new HashSet<Node>(collection);
            HashSet<Node> hashSet2 = new HashSet<Node>(hashSet);
            Node[] nodeArray = new Node[collection.size()];
            Iterator<Node> iterator = collection2.iterator();
            int n = 0;
            while (iterator.hasNext()) {
                object = iterator.next();
                if (hashSet.remove(object)) {
                    nodeArray[n++] = object;
                    continue;
                }
                if (!hashSet2.contains(object)) {
                    linkedList.add((Node)object);
                    continue;
                }
                iterator.remove();
            }
            object = NodeOp.computePermutation(collection.toArray(new Node[collection.size()]), nodeArray);
            if (object != null) {
                this.clearNodes();
                this.findInfo(entry).useNodes(Arrays.asList(nodeArray));
                Node node = this.children.parent;
                if (node != null) {
                    node.fireReorderChange((int[])object);
                }
            }
            return linkedList;
        }

        Node[] notifyRemove(Collection<Node> collection, Node[] nodeArray) {
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.finer("notifyRemove: " + collection);
                LOGGER.finer("Current     : " + Arrays.asList(nodeArray));
            }
            Node[] nodeArray2 = collection.toArray(new Node[collection.size()]);
            if (this.children.parent != null) {
                if (this.children.getEntrySupport() == this) {
                    this.children.parent.fireSubNodesChange(false, nodeArray2, nodeArray);
                }
                for (Node node : collection) {
                    node.deassignFrom(this.children);
                    node.fireParentNodeChange(this.children.parent, null);
                }
            }
            this.children.destroyNodes(nodeArray2);
            return nodeArray2;
        }

        void notifyAdd(Collection<Node> collection) {
            Node node2;
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.finer("notifyAdd: " + collection);
            }
            for (Node node2 : collection) {
                node2.assignTo(this.children, -1);
                node2.fireParentNodeChange(null, this.children.parent);
            }
            Node[] nodeArray = collection.toArray(new Node[collection.size()]);
            node2 = this.children.parent;
            if (node2 != null && this.children.getEntrySupport() == this) {
                node2.fireSubNodesChange(true, nodeArray, null);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Node[] testNodes() {
            ChildrenArray childrenArray = this.array.get();
            if (childrenArray == null) {
                return null;
            }
            try {
                Children.PR.enterReadAccess();
                Node[] nodeArray = childrenArray.nodes();
                return nodeArray;
            }
            finally {
                Children.PR.exitReadAccess();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private ChildrenArray getArray(boolean[] blArray) {
            ChildrenArray childrenArray;
            block27: {
                Object object;
                boolean bl;
                block26: {
                    class SetAndNotify
                    implements Runnable {
                        public ChildrenArray toSet;
                        public Children whatSet;

                        SetAndNotify() {
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            Object object = LOCK;
                            synchronized (object) {
                                Default.this.initThread = null;
                                LOCK.notifyAll();
                            }
                            if (bl) {
                                LOGGER.finer("notifyAll done");
                            }
                        }
                    }
                    block25: {
                        bl = LOGGER.isLoggable(Level.FINER);
                        boolean bl2 = false;
                        object = LOCK;
                        synchronized (object) {
                            childrenArray = this.array.get();
                            if (childrenArray == null) {
                                childrenArray = new ChildrenArray();
                                this.registerChildrenArray(childrenArray, true);
                                bl2 = true;
                                this.initThread = Thread.currentThread();
                            }
                        }
                        if (!bl2) break block26;
                        if (bl) {
                            LOGGER.finer("Initialize " + this + " on " + Thread.currentThread());
                        }
                        try {
                            this.children.callAddNotify();
                            if (!bl) break block25;
                            LOGGER.finer("addNotify successfully called for " + this + " on " + Thread.currentThread());
                        }
                        catch (Throwable throwable) {
                            boolean bl3 = Children.MUTEX.isReadAccess();
                            if (bl) {
                                LOGGER.finer("notifyAll for " + this + " on " + Thread.currentThread() + "  notifyLater: " + bl3);
                            }
                            childrenArray.entrySupport = this;
                            this.inited = true;
                            SetAndNotify setAndNotify = new SetAndNotify();
                            setAndNotify.toSet = childrenArray;
                            setAndNotify.whatSet = this.children;
                            if (bl3) {
                                Children.MUTEX.postWriteRequest((Runnable)setAndNotify);
                            } else {
                                setAndNotify.run();
                            }
                            throw throwable;
                        }
                    }
                    boolean bl4 = Children.MUTEX.isReadAccess();
                    if (bl) {
                        LOGGER.finer("notifyAll for " + this + " on " + Thread.currentThread() + "  notifyLater: " + bl4);
                    }
                    childrenArray.entrySupport = this;
                    this.inited = true;
                    SetAndNotify setAndNotify = new SetAndNotify();
                    setAndNotify.toSet = childrenArray;
                    setAndNotify.whatSet = this.children;
                    if (bl4) {
                        Children.MUTEX.postWriteRequest((Runnable)setAndNotify);
                    } else {
                        setAndNotify.run();
                    }
                    break block27;
                }
                if (this.initThread != null) {
                    if (Children.MUTEX.isReadAccess() || Children.MUTEX.isWriteAccess() || this.initThread == Thread.currentThread()) {
                        if (bl) {
                            LOGGER.log(Level.FINER, "cannot initialize better " + this + " on " + Thread.currentThread() + " read access: " + Children.MUTEX.isReadAccess() + " write access: " + Children.MUTEX.isWriteAccess() + " initThread: " + this.initThread);
                        }
                        if (blArray != null) {
                            blArray[0] = true;
                        }
                        childrenArray.entrySupport = this;
                        return childrenArray;
                    }
                    object = LOCK;
                    synchronized (object) {
                        while (this.initThread != null) {
                            if (bl) {
                                LOGGER.finer("waiting for children for " + this + " on " + Thread.currentThread());
                            }
                            try {
                                LOCK.wait();
                            }
                            catch (InterruptedException interruptedException) {}
                        }
                    }
                    if (bl) {
                        LOGGER.finer(" children are here for " + this + " on " + Thread.currentThread() + " children " + this.children);
                    }
                }
            }
            return childrenArray;
        }

        private void clearNodes() {
            ChildrenArray childrenArray;
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.finer("  clearNodes()");
            }
            if ((childrenArray = this.array.get()) != null) {
                childrenArray.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final void registerChildrenArray(ChildrenArray childrenArray, boolean bl) {
            boolean bl2 = LOGGER.isLoggable(Level.FINER);
            if (bl2) {
                LOGGER.finer("registerChildrenArray: " + childrenArray + " weak: " + bl);
            }
            Object object = LOCK;
            synchronized (object) {
                if (this.array != null && this.array.get() == childrenArray && ((ChArrRef)this.array).isWeak() == bl) {
                    return;
                }
                this.array = new ChArrRef(childrenArray, bl);
            }
            if (bl2) {
                LOGGER.finer("pointed by: " + childrenArray + " to: " + this.array);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final void finalizedChildrenArray(Reference reference) {
            assert (reference.get() == null) : "Should be null";
            try {
                Children.PR.enterWriteAccess();
                if (LOGGER.isLoggable(Level.FINER)) {
                    LOGGER.fine("previous array: " + this.array + " caller: " + reference);
                }
                Object object = LOCK;
                synchronized (object) {
                    if (this.array == reference && this.children.getEntrySupport() == this) {
                        this.mustNotifySetEnties = false;
                        this.array = EMPTY;
                        this.inited = false;
                        this.children.callRemoveNotify();
                        assert (this.array == EMPTY);
                    }
                }
            }
            finally {
                Children.PR.exitWriteAccess();
            }
        }

        private class ChArrRef
        extends WeakReference<ChildrenArray>
        implements Runnable {
            private final ChildrenArray chArr;

            public ChArrRef(ChildrenArray childrenArray, boolean bl) {
                super(childrenArray, Utilities.activeReferenceQueue());
                this.chArr = bl ? null : childrenArray;
            }

            @Override
            public ChildrenArray get() {
                return this.chArr != null ? this.chArr : (ChildrenArray)super.get();
            }

            boolean isWeak() {
                return this.chArr == null;
            }

            @Override
            public void run() {
                Default.this.finalizedChildrenArray(this);
            }
        }

        static class DefaultSnapshot
        extends AbstractList<Node> {
            private Node[] nodes;
            Object holder;

            public DefaultSnapshot(Node[] nodeArray, ChildrenArray childrenArray) {
                this.nodes = nodeArray;
                this.holder = childrenArray;
            }

            @Override
            public Node get(int n) {
                return this.nodes != null && n < this.nodes.length ? this.nodes[n] : null;
            }

            @Override
            public int size() {
                return this.nodes != null ? this.nodes.length : 0;
            }
        }

        final class Info {
            int length;
            final Children.Entry entry;

            public Info(Children.Entry entry) {
                this.entry = entry;
            }

            public Collection<Node> nodes(boolean bl) {
                assert (!bl || Default.this.array.get() != null) : "ChildrenArray is not initialized";
                ChildrenArray childrenArray = Default.this.getArray(null);
                return childrenArray.nodesFor(this, bl);
            }

            public void useNodes(Collection<Node> collection) {
                ChildrenArray childrenArray = Default.this.getArray(null);
                childrenArray.useNodes(this, collection);
                for (Node node : collection) {
                    node.assignTo(Default.this.children, -1);
                    node.fireParentNodeChange(null, Default.this.children.parent);
                }
            }

            public int length() {
                return this.length;
            }

            public String toString() {
                return "Children.Info[" + this.entry + ",length=" + this.length + "]";
            }
        }
    }
}

