/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.updater;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Window;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Collection;
import java.util.Locale;
import java.util.logging.Level;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTextArea;
import javax.swing.border.LineBorder;
import org.netbeans.updater.Localization;
import org.netbeans.updater.UpdaterDispatcher;
import org.netbeans.updater.UpdatingContext;
import org.netbeans.updater.XMLUtil;

public class UpdaterFrame
extends JPanel
implements UpdatingContext {
    public static final int OS_WIN = 1;
    public static final int OS_SOLARIS = 8;
    public static final int OS_LINUX = 16;
    public static final int OS_OS2 = 1024;
    public static final int OS_OTHER = 65536;
    private static final String SPLASH_PATH = "org/netbeans/updater/resources/updatersplash";
    private boolean bigBounds = false;
    private Window splashWindow;
    private boolean noSplash = false;
    private JLabel jLabel3;
    private JTextArea jTextArea1;
    private JProgressBar progressBar;
    private JLabel textLabel;

    public UpdaterFrame() {
        this((String[])null);
    }

    private UpdaterFrame(String[] stringArray) {
        if (stringArray != null && stringArray.length > 0) {
            this.cli(stringArray);
        }
        this.initComponents();
        if (UpdaterFrame.addBorder()) {
            this.setBorder(new LineBorder(UpdaterFrame.stringToColor("UpdaterFrame.LineBorder.Color", new Color(0, 0, 0))));
        }
        this.loadSplash();
    }

    static final void center(Window window) {
        window.pack();
        GraphicsConfiguration graphicsConfiguration = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        Rectangle rectangle = graphicsConfiguration.getBounds();
        Dimension dimension = window.getSize();
        window.setLocation(rectangle.x + (rectangle.width - dimension.width) / 2, rectangle.y + (rectangle.height - dimension.height) / 2);
    }

    static String getMainWindowTitle() {
        return Localization.getBrandedString("UpdaterFrame.Form.title");
    }

    private void initComponents() {
        this.jLabel3 = new JLabel();
        this.jTextArea1 = new JTextArea();
        this.textLabel = new JLabel();
        this.progressBar = new JProgressBar();
        this.setBackground(UpdaterFrame.stringToColor("UpdaterFrame.Background", new Color(6, 4, 100)));
        this.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        this.add((Component)this.jLabel3, gridBagConstraints);
        this.jTextArea1.setBackground(UpdaterFrame.stringToColor("UpdaterFrame.TextBackground", new Color(213, 204, 187)));
        this.jTextArea1.setEditable(false);
        this.jTextArea1.setForeground(UpdaterFrame.stringToColor("UpdaterFrame.TextForeground", Color.white));
        this.jTextArea1.setText(Localization.getBrandedString("UpdaterFrame.jTextArea1.text"));
        this.jTextArea1.setDisabledTextColor(UpdaterFrame.stringToColor("UpdaterFrame.DisabledTextColor", Color.white));
        this.jTextArea1.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(8, 14, 0, 14);
        this.add((Component)this.jTextArea1, gridBagConstraints);
        this.textLabel.setFont(new Font(Localization.getBrandedString("UpdaterFrame.textLabel.fontName"), 1, 11));
        this.textLabel.setForeground(UpdaterFrame.stringToColor("UpdaterFrame.TextForeground", Color.white));
        this.textLabel.setText(Localization.getBrandedString("UpdaterFrame.textLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(8, 14, 8, 14);
        this.add((Component)this.textLabel, gridBagConstraints);
        this.progressBar.setPreferredSize(UpdaterFrame.stringToDimension("UpdaterFrame.ProgressBar.PreferredSize", new Dimension(300, 20)));
        this.progressBar.setRequestFocusEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 14, 10, 14);
        this.add((Component)this.progressBar, gridBagConstraints);
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        if (UpdaterFrame.isGradient()) {
            Color color = UpdaterFrame.stringToColor("UpdaterFrame.outerColor", new Color(230, 242, 234));
            Color color2 = UpdaterFrame.stringToColor("UpdaterFrame.centerColor", Color.WHITE);
            int n = this.getWidth();
            int n2 = this.getHeight();
            Graphics2D graphics2D = (Graphics2D)graphics;
            if (UpdaterFrame.isGradientVertical()) {
                Icon icon = this.jLabel3.getIcon();
                int n3 = icon != null ? icon.getIconHeight() : 0;
                graphics2D.setPaint(new GradientPaint(0.0f, n3, color2, 0.0f, n2, color));
                graphics2D.fillRect(0, n3, n, n2 - n3);
            } else {
                graphics2D.setPaint(new GradientPaint(0.0f, 0.0f, color, n / 2, 0.0f, color2, true));
                graphics2D.fillRect(0, 0, n, n2);
            }
        } else {
            super.paintComponent(graphics);
        }
    }

    private void showSplash() {
        this.splashWindow = UpdaterFrame.getOperatingSystem() == 1 || UpdaterFrame.getOperatingSystem() == 8 || UpdaterFrame.getOperatingSystem() == 1024 || UpdaterFrame.getOperatingSystem() == 16 ? new SplashWindow(this) : new SplashFrame(this);
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                UpdaterFrame.this.splashWindow.setVisible(true);
                UpdaterFrame.this.splashWindow.toFront();
            }
        });
    }

    @Override
    public void disposeSplash() {
        if (this.splashWindow != null) {
            this.splashWindow.dispose();
        }
    }

    public static void main(String ... stringArray) {
        UpdaterFrame updaterFrame = new UpdaterFrame(stringArray);
        if (!updaterFrame.noSplash) {
            updaterFrame.showSplash();
        }
        new UpdaterDispatcher(updaterFrame).run();
    }

    @Override
    public Collection<File> forInstall() {
        return null;
    }

    @Override
    public void unpackingIsRunning() {
    }

    @Override
    public void unpackingFinished() {
        this.runningFinished();
    }

    @Override
    public void runningFinished() {
        System.exit(0);
    }

    @Override
    public void setLabel(final String string) {
        if (this.noSplash) {
            return;
        }
        final JLabel jLabel = this.textLabel;
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                jLabel.setText(string);
            }
        });
    }

    @Override
    public void setProgressRange(final long l, final long l2) {
        if (this.noSplash) {
            return;
        }
        this.bigBounds = l2 > 65535L;
        final JProgressBar jProgressBar = this.progressBar;
        final boolean bl = this.bigBounds;
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                jProgressBar.setMinimum(bl ? (int)(l / 1024L) : (int)l);
                jProgressBar.setMaximum(bl ? (int)(l2 / 1024L) : (int)l2);
            }
        });
    }

    @Override
    public void setProgressValue(final long l) {
        if (this.noSplash) {
            return;
        }
        final boolean bl = this.bigBounds;
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                UpdaterFrame.this.progressBar.setValue(bl ? (int)(l / 1024L) : (int)l);
            }
        });
    }

    private static int getOperatingSystem() {
        int n = -1;
        String string = System.getProperty("os.name");
        n = string != null && string.startsWith("Windows") ? 1 : ("Solaris".equals(string) ? 8 : (string.startsWith("SunOS") ? 8 : ("Linux".equals(string) ? 16 : ("OS/2".equals(string) ? 1024 : 65536))));
        return n;
    }

    @Override
    public boolean isFromIDE() {
        return false;
    }

    private static Color stringToColor(String string, Color color) {
        try {
            String string2 = Localization.getBrandedString(string + "_R");
            int n = Integer.parseInt(string2);
            string2 = Localization.getBrandedString(string + "_G");
            int n2 = Integer.parseInt(string2);
            string2 = Localization.getBrandedString(string + "_B");
            int n3 = Integer.parseInt(string2);
            return new Color(n, n2, n3);
        }
        catch (Exception exception) {
            return color;
        }
    }

    private static Dimension stringToDimension(String string, Dimension dimension) {
        try {
            String string2 = Localization.getBrandedString(string + "_X");
            int n = Integer.parseInt(string2);
            string2 = Localization.getBrandedString(string + "_Y");
            int n2 = Integer.parseInt(string2);
            return new Dimension(n, n2);
        }
        catch (Exception exception) {
            return dimension;
        }
    }

    private static boolean addBorder() {
        return "true".equals(Localization.getBrandedString("UpdaterFrame.hasBorder"));
    }

    private static boolean isGradient() {
        return "true".equals(Localization.getBrandedString("UpdaterFrame.isGradient"));
    }

    private static boolean isGradientVertical() {
        return "true".equals(Localization.getBrandedString("UpdaterFrame.isGradientVertical"));
    }

    private void loadSplash() {
        URL uRL = Localization.getBrandedResource(SPLASH_PATH, ".gif");
        if (uRL != null) {
            this.jLabel3.setIcon(new ImageIcon(uRL));
        }
    }

    @Override
    public OutputStream createOS(File file) throws FileNotFoundException {
        return new FileOutputStream(file);
    }

    private static boolean isOption(String string, String string2) {
        if (string == null) {
            return false;
        }
        if (string.startsWith("--")) {
            return string.substring(2).equals(string2);
        }
        if (string.startsWith("-")) {
            return string.substring(1).equals(string2);
        }
        return false;
    }

    private int cli(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            String string;
            if (stringArray[i] == null) continue;
            if (UpdaterFrame.isOption(stringArray[i], "noexit")) {
                throw new IllegalStateException();
            }
            if (UpdaterFrame.isOption(stringArray[i], "nosplash")) {
                this.noSplash = true;
                continue;
            }
            if (UpdaterFrame.isOption(stringArray[i], "locale")) {
                String string2;
                stringArray[i] = null;
                string = stringArray[++i];
                String string3 = "";
                String string4 = "";
                int n = string.indexOf(":");
                if (n == -1) {
                    string2 = string;
                } else {
                    string2 = string.substring(0, n);
                    int n2 = string.indexOf(":", n + 1);
                    if (n2 != -1) {
                        string3 = string.substring(n + 1, n2);
                        string4 = string.substring(n2 + 1);
                    } else {
                        string3 = string.substring(n + 1);
                    }
                }
                Locale.setDefault(new Locale(string2, string3, string4));
                continue;
            }
            if (!UpdaterFrame.isOption(stringArray[i], "branding")) continue;
            stringArray[i] = null;
            if (++i == stringArray.length) {
                System.err.println("Option --branding requires one argument.");
                return 2;
            }
            string = stringArray[i];
            if (string.equals("-")) {
                string = null;
            }
            try {
                Localization.setBranding(string);
                continue;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                XMLUtil.LOG.log(Level.WARNING, "Cannot change branding", illegalArgumentException);
                return 1;
            }
        }
        return 0;
    }

    static class SplashWindow
    extends Window {
        public SplashWindow(UpdaterFrame updaterFrame) {
            super(new Frame());
            this.setLayout(new BorderLayout());
            this.add((Component)updaterFrame, "Center");
            UpdaterFrame.center(this);
        }

        @Override
        public Dimension getPreferredSize() {
            return UpdaterFrame.stringToDimension("UpdaterFrame.Splash.PreferredSize", new Dimension(400, 280));
        }
    }

    static class SplashFrame
    extends JFrame {
        public SplashFrame(UpdaterFrame updaterFrame) {
            super(UpdaterFrame.getMainWindowTitle());
            this.setDefaultCloseOperation(0);
            this.setCursor(Cursor.getPredefinedCursor(3));
            this.getContentPane().add(updaterFrame);
            UpdaterFrame.center(this);
        }

        @Override
        public Dimension getPreferredSize() {
            return UpdaterFrame.stringToDimension("UpdaterFrame.Splash.PreferredSize", new Dimension(400, 280));
        }
    }
}

