/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ssl;

import java.io.IOException;
import java.io.PrintStream;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.net.ssl.SSLKeyException;
import javax.net.ssl.SSLProtocolException;
import sun.security.internal.spec.TlsRsaPremasterSecretParameterSpec;
import sun.security.ssl.Debug;
import sun.security.ssl.HandshakeInStream;
import sun.security.ssl.HandshakeMessage;
import sun.security.ssl.HandshakeOutStream;
import sun.security.ssl.JsseJce;
import sun.security.ssl.ProtocolVersion;
import sun.security.util.KeyUtil;

final class RSAClientKeyExchange
extends HandshakeMessage {
    private static final String PROP_NAME = "com.sun.net.ssl.rsaPreMasterSecretFix";
    private static final boolean rsaPreMasterSecretFix = Debug.getBooleanProperty("com.sun.net.ssl.rsaPreMasterSecretFix", false);
    private ProtocolVersion protocolVersion;
    SecretKey preMaster;
    private byte[] encrypted;

    RSAClientKeyExchange(ProtocolVersion protocolVersion, ProtocolVersion protocolVersion2, SecureRandom secureRandom, PublicKey publicKey) throws IOException {
        byte by;
        byte by2;
        if (!publicKey.getAlgorithm().equals("RSA")) {
            throw new SSLKeyException("Public key not of type RSA");
        }
        this.protocolVersion = protocolVersion;
        if (rsaPreMasterSecretFix || protocolVersion2.v >= ProtocolVersion.TLS11.v) {
            by2 = protocolVersion2.major;
            by = protocolVersion2.minor;
        } else {
            by2 = protocolVersion.major;
            by = protocolVersion.minor;
        }
        try {
            String string = protocolVersion.v >= ProtocolVersion.TLS12.v ? "SunTls12RsaPremasterSecret" : "SunTlsRsaPremasterSecret";
            KeyGenerator keyGenerator = JsseJce.getKeyGenerator(string);
            keyGenerator.init(new TlsRsaPremasterSecretParameterSpec(by2, by), secureRandom);
            this.preMaster = keyGenerator.generateKey();
            Cipher cipher = JsseJce.getCipher("RSA/ECB/PKCS1Padding");
            cipher.init(3, (Key)publicKey, secureRandom);
            this.encrypted = cipher.wrap(this.preMaster);
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw (SSLKeyException)new SSLKeyException("RSA premaster secret error").initCause(generalSecurityException);
        }
    }

    RSAClientKeyExchange(ProtocolVersion protocolVersion, ProtocolVersion protocolVersion2, SecureRandom secureRandom, HandshakeInStream handshakeInStream, int n, PrivateKey privateKey) throws IOException {
        if (!privateKey.getAlgorithm().equals("RSA")) {
            throw new SSLKeyException("Private key not of type RSA");
        }
        if (protocolVersion.v >= ProtocolVersion.TLS10.v) {
            this.encrypted = handshakeInStream.getBytes16();
        } else {
            this.encrypted = new byte[n];
            if (handshakeInStream.read(this.encrypted) != n) {
                throw new SSLProtocolException("SSL: read PreMasterSecret: short read");
            }
        }
        try {
            Cipher cipher = JsseJce.getCipher("RSA/ECB/PKCS1Padding");
            cipher.init(4, privateKey);
            this.preMaster = (SecretKey)cipher.unwrap(this.encrypted, "TlsRsaPremasterSecret", 3);
            this.preMaster = this.polishPreMasterSecretKey(protocolVersion, protocolVersion2, secureRandom, this.preMaster, null);
        }
        catch (Exception exception) {
            this.preMaster = this.polishPreMasterSecretKey(protocolVersion, protocolVersion2, secureRandom, null, exception);
        }
    }

    private SecretKey polishPreMasterSecretKey(ProtocolVersion protocolVersion, ProtocolVersion protocolVersion2, SecureRandom secureRandom, SecretKey secretKey, Exception exception) {
        this.protocolVersion = protocolVersion2;
        if (exception == null && secretKey != null) {
            byte[] byArray = secretKey.getEncoded();
            if (byArray == null) {
                int n;
                if (debug != null && Debug.isOn("handshake")) {
                    System.out.println("unable to get the plaintext of the premaster secret");
                }
                if ((n = KeyUtil.getKeySize(secretKey)) > 0 && n != 384) {
                    if (debug != null && Debug.isOn("handshake")) {
                        System.out.println("incorrect length of premaster secret: " + n / 8);
                    }
                    return RSAClientKeyExchange.generateDummySecret(protocolVersion2);
                }
                return secretKey;
            }
            if (byArray.length == 48) {
                if (protocolVersion2.major == byArray[0] && protocolVersion2.minor == byArray[1]) {
                    return secretKey;
                }
                if (protocolVersion2.v <= ProtocolVersion.TLS10.v && protocolVersion.major == byArray[0] && protocolVersion.minor == byArray[1]) {
                    this.protocolVersion = protocolVersion;
                    return secretKey;
                }
                if (debug != null && Debug.isOn("handshake")) {
                    System.out.println("Mismatching Protocol Versions, ClientHello.client_version is " + protocolVersion2 + ", while PreMasterSecret.client_version is " + ProtocolVersion.valueOf(byArray[0], byArray[1]));
                }
                return RSAClientKeyExchange.generateDummySecret(protocolVersion2);
            }
            if (debug != null && Debug.isOn("handshake")) {
                System.out.println("incorrect length of premaster secret: " + byArray.length);
            }
            return RSAClientKeyExchange.generateDummySecret(protocolVersion2);
        }
        if (debug != null && Debug.isOn("handshake") && exception != null) {
            System.out.println("Error decrypting premaster secret:");
            exception.printStackTrace(System.out);
        }
        return RSAClientKeyExchange.generateDummySecret(protocolVersion2);
    }

    static SecretKey generateDummySecret(ProtocolVersion protocolVersion) {
        if (debug != null && Debug.isOn("handshake")) {
            System.out.println("Generating a random fake premaster secret");
        }
        try {
            String string = protocolVersion.v >= ProtocolVersion.TLS12.v ? "SunTls12RsaPremasterSecret" : "SunTlsRsaPremasterSecret";
            KeyGenerator keyGenerator = JsseJce.getKeyGenerator(string);
            keyGenerator.init(new TlsRsaPremasterSecretParameterSpec(protocolVersion.major, protocolVersion.minor));
            return keyGenerator.generateKey();
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new RuntimeException("Could not generate dummy secret", generalSecurityException);
        }
    }

    @Override
    int messageType() {
        return 16;
    }

    @Override
    int messageLength() {
        if (this.protocolVersion.v >= ProtocolVersion.TLS10.v) {
            return this.encrypted.length + 2;
        }
        return this.encrypted.length;
    }

    @Override
    void send(HandshakeOutStream handshakeOutStream) throws IOException {
        if (this.protocolVersion.v >= ProtocolVersion.TLS10.v) {
            handshakeOutStream.putBytes16(this.encrypted);
        } else {
            handshakeOutStream.write(this.encrypted);
        }
    }

    @Override
    void print(PrintStream printStream) throws IOException {
        printStream.println("*** ClientKeyExchange, RSA PreMasterSecret, " + this.protocolVersion);
    }
}

