/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ssl;

import java.io.ByteArrayOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Locale;
import java.util.Set;
import sun.security.ssl.CloneableDigest;
import sun.security.ssl.ProtocolVersion;

final class HandshakeHash {
    private int version = -1;
    private ByteArrayOutputStream data = new ByteArrayOutputStream();
    private final boolean isServer;
    private MessageDigest md5;
    private MessageDigest sha;
    private final int clonesNeeded;
    private boolean cvAlgDetermined = false;
    private String cvAlg;
    private MessageDigest finMD;

    HandshakeHash(boolean bl, boolean bl2, Set<String> set) {
        this.isServer = bl;
        this.clonesNeeded = bl2 ? 3 : 2;
    }

    void update(byte[] byArray, int n, int n2) {
        switch (this.version) {
            case 1: {
                this.md5.update(byArray, n, n2);
                this.sha.update(byArray, n, n2);
                break;
            }
            default: {
                if (this.finMD != null) {
                    this.finMD.update(byArray, n, n2);
                }
                this.data.write(byArray, n, n2);
            }
        }
    }

    void reset() {
        if (this.version != -1) {
            throw new RuntimeException("reset() can be only be called before protocolDetermined");
        }
        this.data.reset();
    }

    void protocolDetermined(ProtocolVersion protocolVersion) {
        if (this.version != -1) {
            return;
        }
        this.version = protocolVersion.compareTo(ProtocolVersion.TLS12) >= 0 ? 2 : 1;
        switch (this.version) {
            case 1: {
                try {
                    this.md5 = CloneableDigest.getDigest("MD5", this.clonesNeeded);
                    this.sha = CloneableDigest.getDigest("SHA", this.clonesNeeded);
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                    throw new RuntimeException("Algorithm MD5 or SHA not available", noSuchAlgorithmException);
                }
                byte[] byArray = this.data.toByteArray();
                this.update(byArray, 0, byArray.length);
                break;
            }
        }
    }

    MessageDigest getMD5Clone() {
        if (this.version != 1) {
            throw new RuntimeException("getMD5Clone() can be only be called for TLS 1.1");
        }
        return HandshakeHash.cloneDigest(this.md5);
    }

    MessageDigest getSHAClone() {
        if (this.version != 1) {
            throw new RuntimeException("getSHAClone() can be only be called for TLS 1.1");
        }
        return HandshakeHash.cloneDigest(this.sha);
    }

    private static MessageDigest cloneDigest(MessageDigest messageDigest) {
        try {
            return (MessageDigest)messageDigest.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException("Could not clone digest", cloneNotSupportedException);
        }
    }

    private static String normalizeAlgName(String string) {
        if ((string = string.toUpperCase(Locale.US)).startsWith("SHA")) {
            if (string.length() == 3) {
                return "SHA-1";
            }
            if (string.charAt(3) != '-') {
                return "SHA-" + string.substring(3);
            }
        }
        return string;
    }

    void setFinishedAlg(String string) {
        if (string == null) {
            throw new RuntimeException("setFinishedAlg's argument cannot be null");
        }
        if (this.finMD != null) {
            return;
        }
        try {
            this.finMD = CloneableDigest.getDigest(HandshakeHash.normalizeAlgName(string), 2);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new Error(noSuchAlgorithmException);
        }
        this.finMD.update(this.data.toByteArray());
    }

    void restrictCertificateVerifyAlgs(Set<String> set) {
        if (this.version == 1) {
            throw new RuntimeException("setCertificateVerifyAlg() cannot be called for TLS 1.1");
        }
    }

    void setCertificateVerifyAlg(String string) {
        if (this.cvAlgDetermined) {
            return;
        }
        this.cvAlg = string == null ? null : HandshakeHash.normalizeAlgName(string);
        this.cvAlgDetermined = true;
    }

    byte[] getAllHandshakeMessages() {
        return this.data.toByteArray();
    }

    byte[] getFinishedHash() {
        try {
            return HandshakeHash.cloneDigest(this.finMD).digest();
        }
        catch (Exception exception) {
            throw new Error("BAD");
        }
    }
}

