/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.raw.data;

import java.util.Observable;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.store.raw.ContainerKey;
import org.apache.derby.iapi.store.raw.xact.RawTransaction;
import org.apache.derby.impl.store.raw.data.ContainerActionOnCommit;

public class DropOnCommit
extends ContainerActionOnCommit {
    protected boolean isStreamContainer = false;

    public DropOnCommit(ContainerKey containerKey) {
        super(containerKey);
    }

    public DropOnCommit(ContainerKey containerKey, boolean bl) {
        super(containerKey);
        this.isStreamContainer = bl;
    }

    public void update(Observable observable, Object object) {
        if (object.equals(RawTransaction.COMMIT) || object.equals(RawTransaction.ABORT)) {
            RawTransaction rawTransaction = (RawTransaction)observable;
            try {
                if (this.isStreamContainer) {
                    rawTransaction.dropStreamContainer(this.identity.getSegmentId(), this.identity.getContainerId());
                } else {
                    rawTransaction.dropContainer(this.identity);
                }
            }
            catch (StandardException standardException) {
                rawTransaction.setObserverException(standardException);
            }
            observable.deleteObserver(this);
            rawTransaction.notifyObservers(object);
        }
    }
}

