/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.jmx.json;

import com.oracle.javafx.jmx.json.JSONDocument;
import com.oracle.javafx.jmx.json.impl.JSONMessages;
import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;

public class JSONWriter {
    private final Writer writer;
    private Stack<Container> where = new Stack();

    JSONWriter(Writer writer) {
        this.writer = writer;
    }

    public JSONWriter startObject() throws IOException {
        this.writeSeparatorIfNeeded();
        this.writer.write("{");
        this.where.push(new Container(ContainerType.OBJECT));
        return this;
    }

    public JSONWriter startObject(String string) throws IOException {
        if (this.where.peek().type != ContainerType.OBJECT) {
            throw new IllegalStateException(JSONMessages.localize(null, "not_inside_object"));
        }
        this.writeSeparatorIfNeeded();
        this.writeEscapedString(string);
        this.writer.write(":{");
        this.where.push(new Container(ContainerType.OBJECT));
        return this;
    }

    public JSONWriter endObject() throws IOException {
        if (this.where.peek().type != ContainerType.OBJECT) {
            throw new IllegalStateException(JSONMessages.localize(null, "mismatched_call_to_endObject"));
        }
        this.where.pop();
        this.writer.write("}");
        return this;
    }

    public JSONWriter startArray() throws IOException {
        this.writeSeparatorIfNeeded();
        this.writer.write("[");
        this.where.push(new Container(ContainerType.ARRAY));
        return this;
    }

    public JSONWriter startArray(String string) throws IOException {
        if (this.where.peek().type != ContainerType.OBJECT) {
            throw new IllegalStateException(JSONMessages.localize(null, "not_inside_object"));
        }
        this.writeSeparatorIfNeeded();
        this.writeEscapedString(string);
        this.writer.write(":[");
        this.where.push(new Container(ContainerType.ARRAY));
        return this;
    }

    public JSONWriter endArray() throws IOException {
        if (this.where.peek().type != ContainerType.ARRAY) {
            throw new IllegalStateException(JSONMessages.localize(null, "mismatched_call_to_endArray"));
        }
        this.writer.write("]");
        this.where.pop();
        return this;
    }

    public JSONWriter objectValue(String string, Object object) throws IOException {
        if (this.where.peek().type != ContainerType.OBJECT) {
            throw new IllegalStateException(JSONMessages.localize(null, "not_inside_object"));
        }
        this.writeSeparatorIfNeeded();
        this.writeEscapedString(string);
        this.writer.write(":");
        this.writeValue(object);
        return this;
    }

    public JSONWriter arrayValue(Object object) throws IOException {
        if (this.where.peek().type != ContainerType.ARRAY) {
            throw new IllegalStateException(JSONMessages.localize(null, "not_inside_array"));
        }
        this.writeSeparatorIfNeeded();
        this.writeValue(object);
        return this;
    }

    public JSONWriter writeObject(Map<String, Object> map) throws IOException {
        this.startObject();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            this.objectValue(entry.getKey(), entry.getValue());
        }
        this.endObject();
        return this;
    }

    public JSONWriter writeArray(List<Object> list) throws IOException {
        this.startArray();
        for (Object object : list) {
            this.arrayValue(object);
        }
        this.endArray();
        return this;
    }

    public JSONWriter flush() throws IOException {
        this.writer.flush();
        return this;
    }

    public void close() throws IOException {
        this.writer.close();
    }

    private void writeValue(Object object) throws IOException {
        if (object == null) {
            this.writer.write("null");
        } else if (object instanceof Map) {
            this.startObject();
            for (Map.Entry entry : ((Map)object).entrySet()) {
                this.objectValue((String)entry.getKey(), entry.getValue());
            }
            this.endObject();
        } else if (object instanceof List) {
            this.startArray();
            Iterator iterator = ((List)object).iterator();
            while (iterator.hasNext()) {
                this.arrayValue(iterator.next());
            }
            this.endArray();
        } else if (object instanceof String) {
            this.writeEscapedString((String)object);
        } else {
            this.writer.write(object.toString());
        }
    }

    private void writeSeparatorIfNeeded() throws IOException {
        if (this.where.empty()) {
            return;
        }
        if (this.where.peek().first) {
            this.where.peek().first = false;
        } else {
            this.writer.write(",");
        }
    }

    private void writeEscapedString(String string) throws IOException {
        this.writer.write("\"");
        JSONDocument.printEscapedString(this.writer, string);
        this.writer.write("\"");
    }

    private static class Container {
        ContainerType type;
        boolean first;

        Container(ContainerType containerType) {
            this.type = containerType;
            this.first = true;
        }
    }

    private static enum ContainerType {
        ARRAY,
        OBJECT;

    }
}

