/*
 * Decompiled with CFR 0.152.
 */
package com.javafx.tools.doclets.internal.toolkit.taglets;

import com.javafx.tools.doclets.Taglet;
import com.javafx.tools.doclets.internal.toolkit.taglets.CodeTaglet;
import com.javafx.tools.doclets.internal.toolkit.taglets.DocRootTaglet;
import com.javafx.tools.doclets.internal.toolkit.taglets.ExpertTaglet;
import com.javafx.tools.doclets.internal.toolkit.taglets.InheritDocTaglet;
import com.javafx.tools.doclets.internal.toolkit.taglets.LegacyTaglet;
import com.javafx.tools.doclets.internal.toolkit.taglets.LiteralTaglet;
import com.javafx.tools.doclets.internal.toolkit.taglets.ParamTaglet;
import com.javafx.tools.doclets.internal.toolkit.taglets.PropertyGetterTaglet;
import com.javafx.tools.doclets.internal.toolkit.taglets.PropertySetterTaglet;
import com.javafx.tools.doclets.internal.toolkit.taglets.ReturnTaglet;
import com.javafx.tools.doclets.internal.toolkit.taglets.SeeTaglet;
import com.javafx.tools.doclets.internal.toolkit.taglets.SimpleTaglet;
import com.javafx.tools.doclets.internal.toolkit.taglets.ThrowsTaglet;
import com.javafx.tools.doclets.internal.toolkit.taglets.ValueTaglet;
import com.javafx.tools.doclets.internal.toolkit.util.MessageRetriever;
import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.ConstructorDoc;
import com.sun.javadoc.Doc;
import com.sun.javadoc.FieldDoc;
import com.sun.javadoc.MethodDoc;
import com.sun.javadoc.PackageDoc;
import com.sun.javadoc.RootDoc;
import com.sun.javadoc.Tag;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TagletManager {
    public static final char SIMPLE_TAGLET_OPT_SEPERATOR = ':';
    public static final String ALT_SIMPLE_TAGLET_OPT_SEPERATOR = "-";
    private LinkedHashMap<String, com.javafx.tools.doclets.internal.toolkit.taglets.Taglet> customTags;
    private com.javafx.tools.doclets.internal.toolkit.taglets.Taglet[] packageTags;
    private com.javafx.tools.doclets.internal.toolkit.taglets.Taglet[] typeTags;
    private com.javafx.tools.doclets.internal.toolkit.taglets.Taglet[] fieldTags;
    private com.javafx.tools.doclets.internal.toolkit.taglets.Taglet[] constructorTags;
    private com.javafx.tools.doclets.internal.toolkit.taglets.Taglet[] methodTags;
    private com.javafx.tools.doclets.internal.toolkit.taglets.Taglet[] overviewTags;
    private com.javafx.tools.doclets.internal.toolkit.taglets.Taglet[] inlineTags;
    private com.javafx.tools.doclets.internal.toolkit.taglets.Taglet[] serializedFormTags;
    private MessageRetriever message;
    private Set<String> standardTags;
    private Set<String> standardTagsLowercase;
    private Set<String> overridenStandardTags = new HashSet<String>();
    private Set<String> potentiallyConflictingTags = new HashSet<String>();
    private Set<String> unseenCustomTags;
    private boolean nosince;
    private boolean showversion;
    private boolean showauthor;

    public TagletManager(boolean nosince, boolean showversion, boolean showauthor, MessageRetriever message) {
        this.standardTags = new HashSet<String>();
        this.standardTagsLowercase = new HashSet<String>();
        this.unseenCustomTags = new HashSet<String>();
        this.customTags = new LinkedHashMap();
        this.nosince = nosince;
        this.showversion = showversion;
        this.showauthor = showauthor;
        this.message = message;
        this.initStandardTags();
        this.initStandardTagsLowercase();
    }

    public void addCustomTag(com.javafx.tools.doclets.internal.toolkit.taglets.Taglet customTag) {
        if (customTag != null) {
            String name = customTag.getName();
            if (this.customTags.containsKey(name)) {
                this.customTags.remove(name);
            }
            this.customTags.put(name, customTag);
            this.checkTagName(name);
        }
    }

    public void addCustomTag(String classname, String tagletPath) {
        try {
            Object newLastTag;
            Class<?> customTagClass = null;
            String cpString = null;
            cpString = this.appendPath(System.getProperty("env.class.path"), cpString);
            cpString = this.appendPath(System.getProperty("java.class.path"), cpString);
            cpString = this.appendPath(tagletPath, cpString);
            URLClassLoader appClassLoader = new URLClassLoader(TagletManager.pathToURLs(cpString));
            customTagClass = appClassLoader.loadClass(classname);
            Method meth = customTagClass.getMethod("register", Map.class);
            Object[] list = this.customTags.values().toArray();
            com.javafx.tools.doclets.internal.toolkit.taglets.Taglet lastTag = list != null && list.length > 0 ? (com.javafx.tools.doclets.internal.toolkit.taglets.Taglet)list[list.length - 1] : null;
            meth.invoke(null, this.customTags);
            list = this.customTags.values().toArray();
            Object object = newLastTag = list != null && list.length > 0 ? list[list.length - 1] : null;
            if (lastTag != newLastTag) {
                this.message.notice("doclet.Notice_taglet_registered", classname);
                if (newLastTag != null) {
                    this.checkTaglet(newLastTag);
                }
            }
        }
        catch (Exception exc) {
            this.message.error("doclet.Error_taglet_not_registered", exc.getClass().getName(), classname);
        }
    }

    private String appendPath(String path1, String path2) {
        if (path1 == null || path1.length() == 0) {
            return path2 == null ? "." : path2;
        }
        if (path2 == null || path2.length() == 0) {
            return path1;
        }
        return path1 + File.pathSeparator + path2;
    }

    private static URL[] pathToURLs(String path) {
        StringTokenizer st = new StringTokenizer(path, File.pathSeparator);
        URL[] urls = new URL[st.countTokens()];
        int count = 0;
        while (st.hasMoreTokens()) {
            URL url = TagletManager.fileToURL(new File(st.nextToken()));
            if (url == null) continue;
            urls[count++] = url;
        }
        if (urls.length != count) {
            URL[] tmp = new URL[count];
            System.arraycopy(urls, 0, tmp, 0, count);
            urls = tmp;
        }
        return urls;
    }

    private static URL fileToURL(File file) {
        String name;
        try {
            name = file.getCanonicalPath();
        }
        catch (IOException e) {
            name = file.getAbsolutePath();
        }
        name = name.replace(File.separatorChar, '/');
        if (!name.startsWith("/")) {
            name = "/" + name;
        }
        if (!file.isFile()) {
            name = name + "/";
        }
        try {
            return new URL("file", "", name);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("file");
        }
    }

    public void addNewSimpleCustomTag(String tagName, String header, String locations) {
        if (tagName == null || locations == null) {
            return;
        }
        com.javafx.tools.doclets.internal.toolkit.taglets.Taglet tag = this.customTags.get(tagName);
        locations = locations.toLowerCase();
        if (tag == null || header != null) {
            this.customTags.remove(tagName);
            this.customTags.put(tagName, new SimpleTaglet(tagName, header, locations));
            if (locations != null && locations.indexOf(120) == -1) {
                this.checkTagName(tagName);
            }
        } else {
            this.customTags.remove(tagName);
            this.customTags.put(tagName, tag);
        }
    }

    private void checkTagName(String name) {
        if (this.standardTags.contains(name)) {
            this.overridenStandardTags.add(name);
        } else {
            if (name.indexOf(46) == -1) {
                this.potentiallyConflictingTags.add(name);
            }
            this.unseenCustomTags.add(name);
        }
    }

    private void checkTaglet(Object taglet) {
        if (taglet instanceof com.javafx.tools.doclets.internal.toolkit.taglets.Taglet) {
            this.checkTagName(((com.javafx.tools.doclets.internal.toolkit.taglets.Taglet)taglet).getName());
        } else if (taglet instanceof Taglet) {
            Taglet legacyTaglet = (Taglet)taglet;
            this.customTags.remove(legacyTaglet.getName());
            this.customTags.put(legacyTaglet.getName(), new LegacyTaglet(legacyTaglet));
            this.checkTagName(legacyTaglet.getName());
        } else {
            throw new IllegalArgumentException("Given object is not a taglet.");
        }
    }

    public void seenCustomTag(String name) {
        this.unseenCustomTags.remove(name);
    }

    public void checkTags(Doc doc, Tag[] tags, boolean areInlineTags) {
        if (tags == null) {
            return;
        }
        for (int i = 0; i < tags.length; ++i) {
            String name = tags[i].name();
            if (name.length() > 0 && name.charAt(0) == '@') {
                name = name.substring(1, name.length());
            }
            if (!this.standardTags.contains(name) && !this.customTags.containsKey(name)) {
                if (this.standardTagsLowercase.contains(name.toLowerCase())) {
                    this.message.warning(tags[i].position(), "doclet.UnknownTagLowercase", tags[i].name());
                    continue;
                }
                this.message.warning(tags[i].position(), "doclet.UnknownTag", tags[i].name());
                continue;
            }
            com.javafx.tools.doclets.internal.toolkit.taglets.Taglet taglet = this.customTags.get(name);
            if (taglet == null) continue;
            if (areInlineTags && !taglet.isInlineTag()) {
                this.printTagMisuseWarn(taglet, tags[i], "inline");
            }
            if (doc instanceof RootDoc && !taglet.inOverview()) {
                this.printTagMisuseWarn(taglet, tags[i], "overview");
                continue;
            }
            if (doc instanceof PackageDoc && !taglet.inPackage()) {
                this.printTagMisuseWarn(taglet, tags[i], "package");
                continue;
            }
            if (doc instanceof ClassDoc && !taglet.inType()) {
                this.printTagMisuseWarn(taglet, tags[i], "class");
                continue;
            }
            if (doc instanceof ConstructorDoc && !taglet.inConstructor()) {
                this.printTagMisuseWarn(taglet, tags[i], "constructor");
                continue;
            }
            if (doc instanceof FieldDoc && !taglet.inField()) {
                this.printTagMisuseWarn(taglet, tags[i], "field");
                continue;
            }
            if (!(doc instanceof MethodDoc) || taglet.inMethod()) continue;
            this.printTagMisuseWarn(taglet, tags[i], "method");
        }
    }

    private void printTagMisuseWarn(com.javafx.tools.doclets.internal.toolkit.taglets.Taglet taglet, Tag tag, String holderType) {
        String[] locations;
        LinkedHashSet<String> locationsSet = new LinkedHashSet<String>();
        if (taglet.inOverview()) {
            locationsSet.add("overview");
        }
        if (taglet.inPackage()) {
            locationsSet.add("package");
        }
        if (taglet.inType()) {
            locationsSet.add("class/interface");
        }
        if (taglet.inConstructor()) {
            locationsSet.add("constructor");
        }
        if (taglet.inField()) {
            locationsSet.add("field");
        }
        if (taglet.inMethod()) {
            locationsSet.add("method");
        }
        if (taglet.isInlineTag()) {
            locationsSet.add("inline text");
        }
        if ((locations = locationsSet.toArray(new String[0])) == null || locations.length == 0) {
            return;
        }
        StringBuffer combined_locations = new StringBuffer();
        for (int i = 0; i < locations.length; ++i) {
            if (i > 0) {
                combined_locations.append(", ");
            }
            combined_locations.append(locations[i]);
        }
        this.message.warning(tag.position(), "doclet.tag_misuse", "@" + taglet.getName(), holderType, combined_locations.toString());
    }

    public com.javafx.tools.doclets.internal.toolkit.taglets.Taglet[] getPackageCustomTags() {
        if (this.packageTags == null) {
            this.initCustomTagArrays();
        }
        return this.packageTags;
    }

    public com.javafx.tools.doclets.internal.toolkit.taglets.Taglet[] getTypeCustomTags() {
        if (this.typeTags == null) {
            this.initCustomTagArrays();
        }
        return this.typeTags;
    }

    public com.javafx.tools.doclets.internal.toolkit.taglets.Taglet[] getInlineCustomTags() {
        if (this.inlineTags == null) {
            this.initCustomTagArrays();
        }
        return this.inlineTags;
    }

    public com.javafx.tools.doclets.internal.toolkit.taglets.Taglet[] getFieldCustomTags() {
        if (this.fieldTags == null) {
            this.initCustomTagArrays();
        }
        return this.fieldTags;
    }

    public com.javafx.tools.doclets.internal.toolkit.taglets.Taglet[] getSerializedFormTags() {
        if (this.serializedFormTags == null) {
            this.initCustomTagArrays();
        }
        return this.serializedFormTags;
    }

    public com.javafx.tools.doclets.internal.toolkit.taglets.Taglet[] getCustomTags(Doc doc) {
        if (doc instanceof ConstructorDoc) {
            return this.getConstructorCustomTags();
        }
        if (doc instanceof MethodDoc) {
            return this.getMethodCustomTags();
        }
        if (doc instanceof FieldDoc) {
            return this.getFieldCustomTags();
        }
        if (doc instanceof ClassDoc) {
            return this.getTypeCustomTags();
        }
        if (doc instanceof PackageDoc) {
            return this.getPackageCustomTags();
        }
        if (doc instanceof RootDoc) {
            return this.getOverviewCustomTags();
        }
        return null;
    }

    public com.javafx.tools.doclets.internal.toolkit.taglets.Taglet[] getConstructorCustomTags() {
        if (this.constructorTags == null) {
            this.initCustomTagArrays();
        }
        return this.constructorTags;
    }

    public com.javafx.tools.doclets.internal.toolkit.taglets.Taglet[] getMethodCustomTags() {
        if (this.methodTags == null) {
            this.initCustomTagArrays();
        }
        return this.methodTags;
    }

    public com.javafx.tools.doclets.internal.toolkit.taglets.Taglet[] getOverviewCustomTags() {
        if (this.overviewTags == null) {
            this.initCustomTagArrays();
        }
        return this.overviewTags;
    }

    private void initCustomTagArrays() {
        Iterator<com.javafx.tools.doclets.internal.toolkit.taglets.Taglet> it = this.customTags.values().iterator();
        ArrayList<com.javafx.tools.doclets.internal.toolkit.taglets.Taglet> pTags = new ArrayList<com.javafx.tools.doclets.internal.toolkit.taglets.Taglet>(this.customTags.size());
        ArrayList<com.javafx.tools.doclets.internal.toolkit.taglets.Taglet> tTags = new ArrayList<com.javafx.tools.doclets.internal.toolkit.taglets.Taglet>(this.customTags.size());
        ArrayList<com.javafx.tools.doclets.internal.toolkit.taglets.Taglet> fTags = new ArrayList<com.javafx.tools.doclets.internal.toolkit.taglets.Taglet>(this.customTags.size());
        ArrayList<com.javafx.tools.doclets.internal.toolkit.taglets.Taglet> cTags = new ArrayList<com.javafx.tools.doclets.internal.toolkit.taglets.Taglet>(this.customTags.size());
        ArrayList<com.javafx.tools.doclets.internal.toolkit.taglets.Taglet> mTags = new ArrayList<com.javafx.tools.doclets.internal.toolkit.taglets.Taglet>(this.customTags.size());
        ArrayList<com.javafx.tools.doclets.internal.toolkit.taglets.Taglet> iTags = new ArrayList<com.javafx.tools.doclets.internal.toolkit.taglets.Taglet>(this.customTags.size());
        ArrayList<com.javafx.tools.doclets.internal.toolkit.taglets.Taglet> oTags = new ArrayList<com.javafx.tools.doclets.internal.toolkit.taglets.Taglet>(this.customTags.size());
        while (it.hasNext()) {
            com.javafx.tools.doclets.internal.toolkit.taglets.Taglet current = it.next();
            if (current.inPackage() && !current.isInlineTag()) {
                pTags.add(current);
            }
            if (current.inType() && !current.isInlineTag()) {
                tTags.add(current);
            }
            if (current.inField() && !current.isInlineTag()) {
                fTags.add(current);
            }
            if (current.inConstructor() && !current.isInlineTag()) {
                cTags.add(current);
            }
            if (current.inMethod() && !current.isInlineTag()) {
                mTags.add(current);
            }
            if (current.isInlineTag()) {
                iTags.add(current);
            }
            if (!current.inOverview() || current.isInlineTag()) continue;
            oTags.add(current);
        }
        this.packageTags = pTags.toArray(new com.javafx.tools.doclets.internal.toolkit.taglets.Taglet[0]);
        this.typeTags = tTags.toArray(new com.javafx.tools.doclets.internal.toolkit.taglets.Taglet[0]);
        this.fieldTags = fTags.toArray(new com.javafx.tools.doclets.internal.toolkit.taglets.Taglet[0]);
        this.constructorTags = cTags.toArray(new com.javafx.tools.doclets.internal.toolkit.taglets.Taglet[0]);
        this.methodTags = mTags.toArray(new com.javafx.tools.doclets.internal.toolkit.taglets.Taglet[0]);
        this.overviewTags = oTags.toArray(new com.javafx.tools.doclets.internal.toolkit.taglets.Taglet[0]);
        this.inlineTags = iTags.toArray(new com.javafx.tools.doclets.internal.toolkit.taglets.Taglet[0]);
        this.serializedFormTags = new com.javafx.tools.doclets.internal.toolkit.taglets.Taglet[4];
        this.serializedFormTags[0] = this.customTags.get("serialData");
        this.serializedFormTags[1] = this.customTags.get("throws");
        this.serializedFormTags[2] = this.customTags.get("since");
        this.serializedFormTags[3] = this.customTags.get("see");
    }

    private void initStandardTags() {
        com.javafx.tools.doclets.internal.toolkit.taglets.Taglet temp = new ParamTaglet();
        this.customTags.put(temp.getName(), temp);
        temp = new ReturnTaglet();
        this.customTags.put(temp.getName(), temp);
        temp = new ThrowsTaglet();
        this.customTags.put(temp.getName(), temp);
        temp = new SimpleTaglet("exception", null, "mc");
        this.customTags.put(temp.getName(), temp);
        if (!this.nosince) {
            temp = new SimpleTaglet("since", this.message.getText("doclet.Since", new Object[0]), "a");
            this.customTags.put(temp.getName(), temp);
        }
        if (this.showversion) {
            temp = new SimpleTaglet("version", this.message.getText("doclet.Version", new Object[0]), "pto");
            this.customTags.put(temp.getName(), temp);
        }
        if (this.showauthor) {
            temp = new SimpleTaglet("author", this.message.getText("doclet.Author", new Object[0]), "pto");
            this.customTags.put(temp.getName(), temp);
        }
        temp = new PropertyGetterTaglet();
        this.customTags.put(temp.getName(), temp);
        temp = new PropertySetterTaglet();
        this.customTags.put(temp.getName(), temp);
        temp = new SimpleTaglet("propertyDescription", this.message.getText("doclet.PropertyDescription", new Object[0]), "fm");
        this.customTags.put(temp.getName(), temp);
        temp = new SimpleTaglet("defaultValue", this.message.getText("doclet.DefaultValue", new Object[0]), "fm");
        this.customTags.put(temp.getName(), temp);
        temp = new SimpleTaglet("serialData", this.message.getText("doclet.SerialData", new Object[0]), "x");
        this.customTags.put(temp.getName(), temp);
        temp = new SimpleTaglet("factory", this.message.getText("doclet.Factory", new Object[0]), "m");
        this.customTags.put(temp.getName(), temp);
        temp = new SeeTaglet();
        this.customTags.put(temp.getName(), temp);
        temp = new DocRootTaglet();
        this.customTags.put(temp.getName(), temp);
        temp = new InheritDocTaglet();
        this.customTags.put(temp.getName(), temp);
        temp = new ValueTaglet();
        this.customTags.put(temp.getName(), temp);
        temp = new LegacyTaglet(new LiteralTaglet());
        this.customTags.put(temp.getName(), temp);
        temp = new LegacyTaglet(new CodeTaglet());
        this.customTags.put(temp.getName(), temp);
        temp = new SimpleTaglet("treatAsPrivate", null, "fmt");
        this.customTags.put(temp.getName(), temp);
        temp = new LegacyTaglet(new ExpertTaglet());
        this.customTags.put(temp.getName(), temp);
        this.standardTags.add("param");
        this.standardTags.add("return");
        this.standardTags.add("throws");
        this.standardTags.add("exception");
        this.standardTags.add("since");
        this.standardTags.add("version");
        this.standardTags.add("author");
        this.standardTags.add("propertyGetter");
        this.standardTags.add("propertySetter");
        this.standardTags.add("propertyDescription");
        this.standardTags.add("defaultValue");
        this.standardTags.add("see");
        this.standardTags.add("deprecated");
        this.standardTags.add("link");
        this.standardTags.add("linkplain");
        this.standardTags.add("inheritDoc");
        this.standardTags.add("docRoot");
        this.standardTags.add("value");
        this.standardTags.add("serial");
        this.standardTags.add("serialData");
        this.standardTags.add("serialField");
        this.standardTags.add("Text");
        this.standardTags.add("literal");
        this.standardTags.add("code");
        this.standardTags.add("treatAsPrivate");
        this.standardTags.add("expert");
    }

    private void initStandardTagsLowercase() {
        Iterator<String> it = this.standardTags.iterator();
        while (it.hasNext()) {
            this.standardTagsLowercase.add(it.next().toLowerCase());
        }
    }

    public boolean isKnownCustomTag(String tagName) {
        return this.customTags.containsKey(tagName);
    }

    public void printReport() {
        this.printReportHelper("doclet.Notice_taglet_conflict_warn", this.potentiallyConflictingTags);
        this.printReportHelper("doclet.Notice_taglet_overriden", this.overridenStandardTags);
        this.printReportHelper("doclet.Notice_taglet_unseen", this.unseenCustomTags);
    }

    private void printReportHelper(String noticeKey, Set<String> names) {
        if (names.size() > 0) {
            String[] namesArray = names.toArray(new String[0]);
            String result = " ";
            for (int i = 0; i < namesArray.length; ++i) {
                result = result + "@" + namesArray[i];
                if (i + 1 >= namesArray.length) continue;
                result = result + ", ";
            }
            this.message.notice(noticeKey, result);
        }
    }

    public com.javafx.tools.doclets.internal.toolkit.taglets.Taglet getTaglet(String name) {
        if (name.indexOf("@") == 0) {
            return this.customTags.get(name.substring(1));
        }
        return this.customTags.get(name);
    }
}

