/*
 * Decompiled with CFR 0.152.
 */
package com.javafx.tools.doclets.formats.html;

import com.javafx.tools.doclets.formats.html.ConfigurationImpl;
import com.javafx.tools.doclets.formats.html.HtmlSerialFieldWriter;
import com.javafx.tools.doclets.formats.html.HtmlSerialMethodWriter;
import com.javafx.tools.doclets.formats.html.LinkInfoImpl;
import com.javafx.tools.doclets.formats.html.SubWriterHolderWriter;
import com.javafx.tools.doclets.formats.html.markup.HtmlConstants;
import com.javafx.tools.doclets.formats.html.markup.HtmlStyle;
import com.javafx.tools.doclets.formats.html.markup.HtmlTag;
import com.javafx.tools.doclets.formats.html.markup.HtmlTree;
import com.javafx.tools.doclets.formats.html.markup.RawHtml;
import com.javafx.tools.doclets.formats.html.markup.StringContent;
import com.javafx.tools.doclets.internal.toolkit.Content;
import com.javafx.tools.doclets.internal.toolkit.SerializedFormWriter;
import com.sun.javadoc.ClassDoc;
import java.io.IOException;

public class SerializedFormWriterImpl
extends SubWriterHolderWriter
implements SerializedFormWriter {
    private static final String FILE_NAME = "serialized-form.html";

    public SerializedFormWriterImpl() throws IOException {
        super(ConfigurationImpl.getInstance(), FILE_NAME);
    }

    public void writeHeader(String header) {
        this.printHtmlHeader(header, null, true);
        this.printTop();
        this.navLinks(true);
        this.hr();
        this.center();
        this.h1();
        this.print(header);
        this.h1End();
        this.centerEnd();
    }

    public Content getHeader(String header) {
        HtmlTree bodyTree = this.getBody(true, this.getWindowTitle(header));
        this.addTop(bodyTree);
        this.addNavLinks(true, bodyTree);
        StringContent h1Content = new StringContent(header);
        HtmlTree heading = HtmlTree.HEADING(HtmlConstants.TITLE_HEADING, true, HtmlStyle.title, h1Content);
        HtmlTree div = HtmlTree.DIV(HtmlStyle.header, heading);
        ((Content)bodyTree).addContent(div);
        return bodyTree;
    }

    public Content getSerializedSummariesHeader() {
        HtmlTree ul = new HtmlTree(HtmlTag.UL);
        ul.addStyle(HtmlStyle.blockList);
        return ul;
    }

    public Content getPackageSerializedHeader() {
        HtmlTree li = new HtmlTree(HtmlTag.LI);
        li.addStyle(HtmlStyle.blockList);
        return li;
    }

    public Content getPackageHeader(String packageName) {
        HtmlTree heading = HtmlTree.HEADING(HtmlConstants.PACKAGE_HEADING, true, this.packageLabel);
        ((Content)heading).addContent(this.getSpace());
        ((Content)heading).addContent(packageName);
        return heading;
    }

    public Content getClassSerializedHeader() {
        HtmlTree ul = new HtmlTree(HtmlTag.UL);
        ul.addStyle(HtmlStyle.blockList);
        return ul;
    }

    public Content getClassHeader(ClassDoc classDoc) {
        String classLink = classDoc.isPublic() || classDoc.isProtected() ? this.getLink(new LinkInfoImpl(classDoc, this.configuration.getClassName(classDoc))) : classDoc.qualifiedName();
        HtmlTree li = HtmlTree.LI(HtmlStyle.blockList, this.getMarkerAnchor(classDoc.qualifiedName()));
        String superClassLink = classDoc.superclassType() != null ? this.getLink(new LinkInfoImpl(7, classDoc.superclassType())) : null;
        String className = superClassLink == null ? this.configuration.getText("doclet.Class_0_implements_serializable", classLink) : this.configuration.getText("doclet.Class_0_extends_implements_serializable", classLink, superClassLink);
        RawHtml classNameContent = new RawHtml(className);
        ((Content)li).addContent(HtmlTree.HEADING(HtmlConstants.SERIALIZED_MEMBER_HEADING, classNameContent));
        return li;
    }

    public Content getSerialUIDInfoHeader() {
        HtmlTree dl = new HtmlTree(HtmlTag.DL);
        dl.addStyle(HtmlStyle.nameValue);
        return dl;
    }

    public void addSerialUIDInfo(String header, String serialUID, Content serialUidTree) {
        StringContent headerContent = new StringContent(header);
        serialUidTree.addContent(HtmlTree.DT(headerContent));
        StringContent serialContent = new StringContent(serialUID);
        serialUidTree.addContent(HtmlTree.DD(serialContent));
    }

    public Content getClassContentHeader() {
        HtmlTree ul = new HtmlTree(HtmlTag.UL);
        ul.addStyle(HtmlStyle.blockList);
        return ul;
    }

    public Content getSerializedContent(Content serializedTreeContent) {
        HtmlTree divContent = HtmlTree.DIV(HtmlStyle.serializedFormContainer, serializedTreeContent);
        return divContent;
    }

    public void addFooter(Content serializedTree) {
        this.addNavLinks(false, serializedTree);
        this.addBottom(serializedTree);
    }

    public void printDocument(Content serializedTree) {
        this.printHtmlDocument(null, true, serializedTree);
    }

    private void tableHeader() {
        this.tableIndexSummary();
        this.trBgcolorStyle("#CCCCFF", "TableSubHeadingColor");
    }

    private void tableFooter() {
        this.fontEnd();
        this.thEnd();
        this.trEnd();
        this.tableEnd();
    }

    public SerializedFormWriter.SerialFieldWriter getSerialFieldWriter(ClassDoc classDoc) {
        return new HtmlSerialFieldWriter(this, classDoc);
    }

    public SerializedFormWriter.SerialMethodWriter getSerialMethodWriter(ClassDoc classDoc) {
        return new HtmlSerialMethodWriter(this, classDoc);
    }
}

