/*
 * Decompiled with CFR 0.152.
 */
package com.javafx.tools.doclets.formats.html;

import com.javafx.tools.doclets.formats.html.AbstractMemberWriter;
import com.javafx.tools.doclets.formats.html.LinkInfoImpl;
import com.javafx.tools.doclets.formats.html.SubWriterHolderWriter;
import com.javafx.tools.doclets.formats.html.markup.HtmlConstants;
import com.javafx.tools.doclets.formats.html.markup.HtmlStyle;
import com.javafx.tools.doclets.formats.html.markup.HtmlTag;
import com.javafx.tools.doclets.formats.html.markup.HtmlTree;
import com.javafx.tools.doclets.formats.html.markup.RawHtml;
import com.javafx.tools.doclets.formats.html.markup.StringContent;
import com.javafx.tools.doclets.internal.toolkit.Configuration;
import com.javafx.tools.doclets.internal.toolkit.Content;
import com.javafx.tools.doclets.internal.toolkit.MemberSummaryWriter;
import com.javafx.tools.doclets.internal.toolkit.PropertyWriter;
import com.javafx.tools.doclets.internal.toolkit.util.Util;
import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.Doc;
import com.sun.javadoc.MemberDoc;
import com.sun.javadoc.MethodDoc;
import com.sun.javadoc.ProgramElementDoc;
import java.io.IOException;

public class PropertyWriterImpl
extends AbstractMemberWriter
implements PropertyWriter,
MemberSummaryWriter {
    public PropertyWriterImpl(SubWriterHolderWriter writer, ClassDoc classdoc) {
        super(writer, classdoc);
    }

    public PropertyWriterImpl(SubWriterHolderWriter writer) {
        super(writer);
    }

    public Content getMemberSummaryHeader(ClassDoc classDoc, Content memberSummaryTree) {
        memberSummaryTree.addContent(HtmlConstants.START_OF_PROPERTY_SUMMARY);
        Content memberTree = this.writer.getMemberTreeHeader();
        this.writer.addSummaryHeader(this, classDoc, memberTree);
        return memberTree;
    }

    public Content getFieldDetailsTreeHeader(ClassDoc classDoc, Content memberDetailsTree) {
        memberDetailsTree.addContent(HtmlConstants.START_OF_PROPERTY_DETAILS);
        Content fieldDetailsTree = this.writer.getMemberTreeHeader();
        fieldDetailsTree.addContent(this.writer.getMarkerAnchor("property_detail"));
        HtmlTree heading = HtmlTree.HEADING(HtmlConstants.DETAILS_HEADING, this.writer.propertyDetailsLabel);
        fieldDetailsTree.addContent(heading);
        return fieldDetailsTree;
    }

    public Content getFieldDocTreeHeader(MethodDoc field, Content fieldDetailsTree) {
        fieldDetailsTree.addContent(this.writer.getMarkerAnchor(field.name()));
        Content fieldDocTree = this.writer.getMemberTreeHeader();
        HtmlTree heading = new HtmlTree(HtmlConstants.MEMBER_HEADING);
        ((Content)heading).addContent(field.name().substring(0, field.name().lastIndexOf("Property")));
        fieldDocTree.addContent(heading);
        return fieldDocTree;
    }

    public Content getSignature(MethodDoc property) {
        HtmlTree pre = new HtmlTree(HtmlTag.PRE);
        this.writer.addAnnotationInfo((ProgramElementDoc)property, (Content)pre);
        this.addModifiers((MemberDoc)property, pre);
        RawHtml propertylink = new RawHtml(this.writer.getLink(new LinkInfoImpl(3, property.returnType())));
        ((Content)pre).addContent(propertylink);
        ((Content)pre).addContent(" ");
        if (this.configuration().linksource) {
            StringContent propertyName = new StringContent(property.name());
            this.writer.addSrcLink((ProgramElementDoc)property, propertyName, pre);
        } else {
            this.addName(property.name(), pre);
        }
        return pre;
    }

    public void addDeprecated(MethodDoc field, Content fieldDocTree) {
    }

    public void addComments(MethodDoc field, Content fieldDocTree) {
        ClassDoc holder = field.containingClass();
        if (field.inlineTags().length > 0) {
            if (holder.equals(this.classdoc) || !holder.isPublic() && !Util.isLinkable(holder, this.configuration())) {
                this.writer.addInlineComment((Doc)field, fieldDocTree);
            } else {
                RawHtml link = new RawHtml(this.writer.getDocLink(30, holder, (MemberDoc)field, holder.isIncluded() ? holder.typeName() : holder.qualifiedTypeName(), false));
                HtmlTree codeLink = HtmlTree.CODE(link);
                HtmlTree strong = HtmlTree.STRONG(holder.isClass() ? this.writer.descfrmClassLabel : this.writer.descfrmInterfaceLabel);
                ((Content)strong).addContent(this.writer.getSpace());
                ((Content)strong).addContent(codeLink);
                fieldDocTree.addContent(HtmlTree.DIV(HtmlStyle.block, strong));
                this.writer.addInlineComment((Doc)field, fieldDocTree);
            }
        }
    }

    public void addTags(MethodDoc field, Content fieldDocTree) {
        this.writer.addTagsInfo((Doc)field, fieldDocTree);
    }

    public Content getFieldDetails(Content fieldDetailsTree) {
        return this.getMemberTree(fieldDetailsTree);
    }

    public Content getFieldDoc(Content fieldDocTree, boolean isLastContent) {
        return this.getMemberTree(fieldDocTree, isLastContent);
    }

    public void close() throws IOException {
        this.writer.close();
    }

    public int getMemberKind() {
        return 7;
    }

    public void addSummaryLabel(Content memberTree) {
        HtmlTree label = HtmlTree.HEADING(HtmlConstants.SUMMARY_HEADING, this.writer.getResource("doclet.Property_Summary"));
        memberTree.addContent(label);
    }

    public String getTableSummary() {
        return this.configuration().getText("doclet.Member_Table_Summary", this.configuration().getText("doclet.Property_Summary"), this.configuration().getText("doclet.properties"));
    }

    public String getCaption() {
        return this.configuration().getText("doclet.Properties");
    }

    public String[] getSummaryTableHeader(ProgramElementDoc member) {
        String[] header = new String[]{this.configuration().getText("doclet.Type"), this.configuration().getText("doclet.0_and_1", this.configuration().getText("doclet.Property"), this.configuration().getText("doclet.Description"))};
        return header;
    }

    public void addSummaryAnchor(ClassDoc cd, Content memberTree) {
        memberTree.addContent(this.writer.getMarkerAnchor("property_summary"));
    }

    public void addInheritedSummaryAnchor(ClassDoc cd, Content inheritedTree) {
        inheritedTree.addContent(this.writer.getMarkerAnchor("properties_inherited_from_class_" + this.configuration().getClassName(cd)));
    }

    public void addInheritedSummaryLabel(ClassDoc cd, Content inheritedTree) {
        RawHtml classLink = new RawHtml(this.writer.getPreQualifiedClassLink(3, cd, false));
        StringContent label = new StringContent(cd.isClass() ? this.configuration().getText("doclet.Properties_Inherited_From_Class") : this.configuration().getText("doclet.Properties_Inherited_From_Interface"));
        HtmlTree labelHeading = HtmlTree.HEADING(HtmlConstants.INHERITED_SUMMARY_HEADING, label);
        ((Content)labelHeading).addContent(this.writer.getSpace());
        ((Content)labelHeading).addContent(classLink);
        inheritedTree.addContent(labelHeading);
    }

    protected void addSummaryLink(int context, ClassDoc cd, ProgramElementDoc member, Content tdSummary) {
        HtmlTree strong = HtmlTree.STRONG(new RawHtml(this.writer.getDocLink(context, cd, (MemberDoc)member, member.name().substring(0, member.name().lastIndexOf("Property")), false, true)));
        HtmlTree code = HtmlTree.CODE(strong);
        tdSummary.addContent(code);
    }

    protected void addInheritedSummaryLink(ClassDoc cd, ProgramElementDoc member, Content linksTree) {
        linksTree.addContent(new RawHtml(this.writer.getDocLink(3, cd, (MemberDoc)member, member.name().lastIndexOf("Property") != -1 && Configuration.javafxJavadoc ? member.name().substring(0, member.name().length() - "Property".length()) : member.name(), false, true)));
    }

    protected void addSummaryType(ProgramElementDoc member, Content tdSummaryType) {
        MethodDoc method = (MethodDoc)member;
        this.addModifierAndType((ProgramElementDoc)method, method.returnType(), tdSummaryType);
    }

    protected Content getDeprecatedLink(ProgramElementDoc member) {
        return this.writer.getDocLink(3, (MemberDoc)member, ((MethodDoc)member).qualifiedName());
    }

    protected Content getNavSummaryLink(ClassDoc cd, boolean link) {
        if (link) {
            return this.writer.getHyperLink("", cd == null ? "property_summary" : "properties_inherited_from_class_" + this.configuration().getClassName(cd), this.writer.getResource("doclet.navProperty"));
        }
        return this.writer.getResource("doclet.navProperty");
    }

    protected void addNavDetailLink(boolean link, Content liNav) {
        if (link) {
            liNav.addContent(this.writer.getHyperLink("", "property_detail", this.writer.getResource("doclet.navProperty")));
        } else {
            liNav.addContent(this.writer.getResource("doclet.navProperty"));
        }
    }
}

