/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.progress.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.api.progress.ProgressRunnable;
import org.netbeans.api.progress.ProgressUtils;
import org.netbeans.modules.progress.spi.RunOffEDTProvider;
import org.netbeans.modules.progress.ui.AbstractWindowRunner;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.util.Cancellable;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.Parameters;
import org.openide.util.RequestProcessor;
import org.openide.windows.WindowManager;

public class RunOffEDTImpl
implements RunOffEDTProvider,
RunOffEDTProvider.Progress {
    private static final RequestProcessor WORKER = new RequestProcessor(ProgressUtils.class.getName());
    private static final Map<String, Long> CUMULATIVE_SPENT_TIME = new HashMap<String, Long>();
    private static final Map<String, Long> MAXIMAL_SPENT_TIME = new HashMap<String, Long>();
    private static final Map<String, Integer> INVOCATION_COUNT = new HashMap<String, Integer>();
    private static final int CANCEL_TIME = 1000;
    private static final int WARNING_TIME = Integer.getInteger("org.netbeans.modules.progress.ui.WARNING_TIME", 10000);
    private static final Logger LOG = Logger.getLogger(RunOffEDTImpl.class.getName());
    private final boolean assertionsOn;

    public void runOffEventDispatchThread(Runnable runnable, String string, AtomicBoolean atomicBoolean, boolean bl, int n, int n2) {
        Parameters.notNull((CharSequence)"operation", (Object)runnable);
        Parameters.notNull((CharSequence)"cancelOperation", (Object)atomicBoolean);
        if (!SwingUtilities.isEventDispatchThread()) {
            runnable.run();
            return;
        }
        long l = System.currentTimeMillis();
        this.runOffEventDispatchThreadImpl(runnable, string, atomicBoolean, bl, n, n2);
        long l2 = System.currentTimeMillis() - l;
        if (this.assertionsOn) {
            Integer n3;
            String string2 = runnable.getClass().getName();
            Long l3 = CUMULATIVE_SPENT_TIME.get(string2);
            if (l3 == null) {
                l3 = 0L;
            }
            l3 = l3 + l2;
            CUMULATIVE_SPENT_TIME.put(string2, l3);
            Long l4 = MAXIMAL_SPENT_TIME.get(string2);
            if (l4 == null) {
                l4 = 0L;
            }
            if (l2 > l4) {
                l4 = l2;
                MAXIMAL_SPENT_TIME.put(string2, l4);
            }
            if ((n3 = INVOCATION_COUNT.get(string2)) == null) {
                n3 = 0;
            }
            Integer n4 = n3;
            Integer n5 = n3 = Integer.valueOf(n3 + 1);
            INVOCATION_COUNT.put(string2, n3);
            if (l2 > (long)WARNING_TIME) {
                LOG.log(Level.WARNING, "Lengthy operation: {0}:{1}:{2}:{3}:{4}", new Object[]{string2, l3, n3, l4, String.format("%3.2f", (double)l3.longValue() / (double)n3.intValue())});
            }
        }
    }

    private void runOffEventDispatchThreadImpl(final Runnable runnable, String string, final AtomicBoolean atomicBoolean, boolean bl, int n, int n2) {
        Object object;
        final CountDownLatch countDownLatch = new CountDownLatch(1);
        final AtomicReference<Dialog> atomicReference = new AtomicReference<Dialog>();
        WORKER.post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (atomicBoolean.get()) {
                    return;
                }
                try {
                    runnable.run();
                    countDownLatch.countDown();
                }
                catch (Throwable throwable) {
                    countDownLatch.countDown();
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            Dialog dialog = (Dialog)atomicReference.get();
                            if (dialog != null) {
                                dialog.setVisible(false);
                            }
                        }
                    });
                    throw throwable;
                }
                SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
            }
        });
        Window window = null;
        Component component = null;
        Component component2 = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        if (component2 != null && (window = SwingUtilities.getWindowAncestor(component2)) != null) {
            object = (RootPaneContainer)((Object)SwingUtilities.getAncestorOfClass(RootPaneContainer.class, component2));
            component = object.getGlassPane();
        }
        if (window == null || component == null) {
            window = WindowManager.getDefault().getMainWindow();
            component = ((JFrame)window).getGlassPane();
        }
        if (RunOffEDTImpl.waitMomentarily(component, null, n, countDownLatch, window)) {
            return;
        }
        object = Cursor.getPredefinedCursor(3);
        if (RunOffEDTImpl.waitMomentarily(component, (Cursor)object, n2, countDownLatch, window)) {
            return;
        }
        String string2 = NbBundle.getMessage(RunOffEDTImpl.class, (String)"RunOffAWT.TITLE_Operation");
        String string3 = NbBundle.getMessage(RunOffEDTImpl.class, (String)"RunOffAWT.BTN_Cancel");
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)string, string2, true, new Object[]{string3}, (Object)string3, 0, null, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                atomicBoolean.set(true);
                ((Dialog)atomicReference.get()).setVisible(false);
            }
        });
        dialogDescriptor.setMessageType(1);
        atomicReference.set(DialogDisplayer.getDefault().createDialog(dialogDescriptor));
        ((Dialog)atomicReference.get()).setVisible(true);
        if (bl) {
            try {
                if (!countDownLatch.await(1000L, TimeUnit.MILLISECONDS)) {
                    throw new IllegalStateException("Canceled operation did not finish in time.");
                }
            }
            catch (InterruptedException interruptedException) {
                LOG.log(Level.FINE, null, interruptedException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean waitMomentarily(Component component, Cursor cursor, int n, CountDownLatch countDownLatch, Window window) {
        Cursor cursor2 = window.getCursor();
        Cursor cursor3 = component.getCursor();
        try {
            if (cursor != null) {
                window.setCursor(cursor);
                component.setCursor(cursor);
            }
            component.setVisible(true);
            try {
                boolean bl = countDownLatch.await(n, TimeUnit.MILLISECONDS);
                return bl;
            }
            catch (InterruptedException interruptedException) {
                LOG.log(Level.FINE, null, interruptedException);
                boolean bl = true;
                component.setVisible(false);
                window.setCursor(cursor2);
                component.setCursor(cursor3);
                return bl;
            }
        }
        finally {
            component.setVisible(false);
            window.setCursor(cursor2);
            component.setCursor(cursor3);
        }
    }

    public RunOffEDTImpl() {
        boolean bl = false;
        if (!$assertionsDisabled) {
            bl = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        this.assertionsOn = bl;
    }

    public <T> Future<T> showProgressDialogAndRunLater(ProgressRunnable<T> progressRunnable, ProgressHandle progressHandle, boolean bl) {
        ProgressBackgroundRunner<T> progressBackgroundRunner = new ProgressBackgroundRunner<T>(progressRunnable, progressHandle, bl, progressRunnable instanceof Cancellable);
        Future future = progressBackgroundRunner.start();
        assert (EventQueue.isDispatchThread() == (future != null));
        if (future == null) {
            try {
                future = progressBackgroundRunner.waitForStart();
            }
            catch (InterruptedException interruptedException) {
                LOG.log(Level.FINE, "Interrupted/cancelled during start {0}", progressRunnable);
                LOG.log(Level.FINER, "Interrupted/cancelled during start", interruptedException);
                return null;
            }
        }
        return future;
    }

    public <T> T showProgressDialogAndRun(ProgressRunnable<T> progressRunnable, String string, boolean bl) {
        try {
            return this.showProgressDialogAndRunLater(progressRunnable, progressRunnable instanceof Cancellable ? ProgressHandleFactory.createHandle((String)string, (Cancellable)((Cancellable)progressRunnable)) : ProgressHandleFactory.createHandle((String)string), bl).get();
        }
        catch (InterruptedException interruptedException) {
            Exceptions.printStackTrace((Throwable)interruptedException);
        }
        catch (CancellationException cancellationException) {
            LOG.log(Level.FINER, "Cancelled " + progressRunnable, cancellationException);
        }
        catch (ExecutionException executionException) {
            Exceptions.printStackTrace((Throwable)executionException);
        }
        return null;
    }

    public void showProgressDialogAndRun(Runnable runnable, ProgressHandle progressHandle, boolean bl) {
        boolean bl2 = runnable instanceof Cancellable;
        ProgressBackgroundRunner progressBackgroundRunner = new ProgressBackgroundRunner(runnable, progressHandle, bl, bl2);
        progressBackgroundRunner.start();
        try {
            try {
                progressBackgroundRunner.waitForStart().get();
            }
            catch (CancellationException cancellationException) {
                LOG.log(Level.FINER, "Cancelled " + runnable, cancellationException);
            }
            catch (ExecutionException executionException) {
                Exceptions.printStackTrace((Throwable)executionException);
            }
        }
        catch (InterruptedException interruptedException) {
            Exceptions.printStackTrace((Throwable)interruptedException);
        }
    }

    private static final class ProgressBackgroundRunner<T>
    extends AbstractWindowRunner<T>
    implements Cancellable {
        private final ProgressRunnable<T> toRun;

        ProgressBackgroundRunner(ProgressRunnable<T> progressRunnable, String string, boolean bl, boolean bl2) {
            super(bl2 ? ProgressHandleFactory.createHandle((String)string, (Cancellable)((Cancellable)progressRunnable)) : ProgressHandleFactory.createHandle((String)string), bl, bl2);
            this.toRun = progressRunnable;
        }

        ProgressBackgroundRunner(ProgressRunnable<T> progressRunnable, ProgressHandle progressHandle, boolean bl, boolean bl2) {
            super(progressHandle, bl, bl2);
            this.toRun = progressRunnable;
        }

        ProgressBackgroundRunner(Runnable runnable, ProgressHandle progressHandle, boolean bl, boolean bl2) {
            this(bl2 ? new CancellableRunnablePR(runnable) : new RunnablePR(runnable), progressHandle, bl, bl2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected T runBackground() {
            Object object;
            this.handle.start();
            this.handle.switchToIndeterminate();
            try {
                object = this.toRun.run(this.handle);
            }
            finally {
                this.handle.finish();
            }
            return (T)object;
        }

        public boolean cancel() {
            if (this.toRun instanceof Cancellable) {
                return ((Cancellable)this.toRun).cancel();
            }
            return false;
        }

        private static final class CancellableRunnablePR<T>
        extends RunnablePR<T>
        implements Cancellable {
            CancellableRunnablePR(Runnable runnable) {
                super(runnable);
            }

            public boolean cancel() {
                return ((Cancellable)this.toRun).cancel();
            }
        }

        private static class RunnablePR<T>
        implements ProgressRunnable<T> {
            protected final Runnable toRun;

            RunnablePR(Runnable runnable) {
                this.toRun = runnable;
            }

            public T run(ProgressHandle progressHandle) {
                this.toRun.run();
                return null;
            }
        }
    }

    static final class TranslucentMask
    extends JComponent {
        private static final String PROGRESS_WINDOW_MASK_COLOR = "progress.windowMaskColor";

        TranslucentMask() {
            this.setVisible(false);
        }

        @Override
        public boolean isOpaque() {
            return false;
        }

        @Override
        public void paint(Graphics graphics) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            Color color = UIManager.getColor(PROGRESS_WINDOW_MASK_COLOR);
            if (color == null) {
                color = new Color(180, 180, 180, 148);
            }
            graphics2D.setColor(color);
            graphics2D.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
    }

    static class CancellableFutureTask<T>
    extends FutureTask<T>
    implements Cancellable {
        volatile RequestProcessor.Task task;
        private final Callable<T> c;

        CancellableFutureTask(Callable<T> callable) {
            super(callable);
            this.c = callable;
        }

        public boolean cancel() {
            return this.cancel(true);
        }

        @Override
        public boolean cancel(boolean bl) {
            boolean bl2 = this.c instanceof Cancellable ? ((Cancellable)this.c).cancel() : false;
            return bl2 &= super.cancel(bl) & this.task.cancel();
        }

        @Override
        public String toString() {
            return super.toString() + "[" + this.c + "]";
        }
    }
}

