/*
 * Decompiled with CFR 0.152.
 */
package org.openide.loaders;

import java.awt.Image;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.Action;
import org.netbeans.modules.openide.loaders.DataNodeUtils;
import org.netbeans.modules.openide.loaders.UIException;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileStatusEvent;
import org.openide.filesystems.FileStatusListener;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectPool;
import org.openide.loaders.DefaultDataObject;
import org.openide.loaders.FolderList;
import org.openide.loaders.LoaderTransfer;
import org.openide.loaders.MimeFactory;
import org.openide.loaders.MultiDataObject;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.CookieSet;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;
import org.openide.util.actions.SystemAction;
import org.openide.util.datatransfer.ExTransferable;

public class DataNode
extends AbstractNode {
    static final long serialVersionUID = -7882925922830244768L;
    private DataObject obj;
    private PropL propL;
    private static boolean showFileExtensions = true;
    private static final String PROP_EXTENSION = "extension";
    private static Class defaultLookup;
    private static RequestProcessor.Task refreshNamesIconsTask;
    private static Set<DataNode> refreshNameNodes;
    private static Set<DataNode> refreshIconNodes;
    private static boolean refreshNamesIconsRunning;
    private static final Object refreshNameIconLock;

    public DataNode(DataObject dataObject, Children children) {
        this(dataObject, children, null);
    }

    public DataNode(DataObject dataObject, Children children, Lookup lookup) {
        super(children, lookup);
        this.obj = dataObject;
        this.propL = new PropL();
        if (lookup == null) {
            this.setCookieSet(CookieSet.createGeneric((CookieSet.Before)this.propL));
        }
        dataObject.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this.propL, (Object)dataObject));
        super.setName(dataObject.getName());
        this.updateDisplayName();
    }

    private void updateDisplayName() {
        FileObject fileObject = this.obj.getPrimaryFile();
        String string = fileObject.isRoot() ? FileUtil.getFileDisplayName((FileObject)fileObject) : (showFileExtensions || this.obj instanceof DataFolder || this.obj instanceof DefaultDataObject ? fileObject.getNameExt() : fileObject.getName());
        if (this.displayFormat != null) {
            this.setDisplayName(this.displayFormat.format(new Object[]{string}));
        } else {
            this.setDisplayName(string);
        }
    }

    public DataObject getDataObject() {
        return this.obj;
    }

    public void setName(String string, boolean bl) {
        try {
            if (bl) {
                this.obj.rename(string);
            }
            super.setName(string);
            this.updateDisplayName();
        }
        catch (IOException iOException) {
            String string2 = Exceptions.findLocalizedMessage((Throwable)iOException);
            if (string2 == null) {
                string2 = NbBundle.getMessage(DataNode.class, (String)"MSG_renameError", (Object)this.getName(), (Object)string);
            }
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException(iOException);
            Exceptions.attachLocalizedMessage((Throwable)illegalArgumentException, (String)string2);
            throw illegalArgumentException;
        }
    }

    public void setName(String string) {
        this.setName(string, true);
    }

    public String getDisplayName() {
        String string = super.getDisplayName();
        try {
            string = this.obj.getPrimaryFile().getFileSystem().getStatus().annotateName(string, (Set)new LazyFilesSet());
        }
        catch (FileStateInvalidException fileStateInvalidException) {
            // empty catch block
        }
        return string;
    }

    public String getHtmlDisplayName() {
        try {
            FileSystem.Status status = this.obj.getPrimaryFile().getFileSystem().getStatus();
            if (status instanceof FileSystem.HtmlStatus) {
                FileSystem.HtmlStatus htmlStatus = (FileSystem.HtmlStatus)status;
                String string = htmlStatus.annotateNameHtml(super.getDisplayName(), (Set)new LazyFilesSet());
                if (!super.getDisplayName().equals(string)) {
                    return string;
                }
            }
        }
        catch (FileStateInvalidException fileStateInvalidException) {
            // empty catch block
        }
        return super.getHtmlDisplayName();
    }

    private Image getImageFromFactory(int n) {
        MimeFactory mimeFactory = (MimeFactory)this.getLookup().lookup(MimeFactory.class);
        return mimeFactory != null ? mimeFactory.getImage(n) : null;
    }

    public Image getIcon(int n) {
        Image image = this.getImageFromFactory(n);
        if (image == null) {
            image = super.getIcon(n);
        }
        try {
            image = this.obj.getPrimaryFile().getFileSystem().getStatus().annotateIcon(image, n, (Set)new LazyFilesSet());
        }
        catch (FileStateInvalidException fileStateInvalidException) {
            // empty catch block
        }
        return image;
    }

    public Image getOpenedIcon(int n) {
        Image image = this.getImageFromFactory(n);
        if (image == null) {
            image = super.getOpenedIcon(n);
        }
        try {
            image = this.obj.getPrimaryFile().getFileSystem().getStatus().annotateIcon(image, n, (Set)new LazyFilesSet());
        }
        catch (FileStateInvalidException fileStateInvalidException) {
            // empty catch block
        }
        return image;
    }

    public HelpCtx getHelpCtx() {
        return this.obj.getHelpCtx();
    }

    public boolean canRename() {
        return this.obj.isRenameAllowed();
    }

    public boolean canDestroy() {
        return this.obj.isDeleteAllowed();
    }

    public void destroy() throws IOException {
        if (this.obj.isDeleteAllowed()) {
            this.obj.delete();
        }
        super.destroy();
    }

    public boolean canCopy() {
        return this.obj.isCopyAllowed();
    }

    public boolean canCut() {
        return this.obj.isMoveAllowed();
    }

    @Deprecated
    protected SystemAction[] createActions() {
        return null;
    }

    public Action[] getActions(boolean bl) {
        if (this.systemActions == null) {
            this.systemActions = this.createActions();
        }
        if (this.systemActions != null) {
            return this.systemActions;
        }
        MimeFactory mimeFactory = (MimeFactory)this.getLookup().lookup(MimeFactory.class);
        if (mimeFactory != null) {
            return mimeFactory.getActions();
        }
        return this.obj.getLoader().getSwingActions();
    }

    @Deprecated
    public SystemAction[] getActions() {
        if (this.systemActions == null) {
            this.systemActions = this.createActions();
        }
        if (this.systemActions != null) {
            return this.systemActions;
        }
        return this.obj.getLoader().getActions();
    }

    public Action getPreferredAction() {
        if (this.obj.isTemplate()) {
            return null;
        }
        Action action = super.getPreferredAction();
        if (action != null) {
            return action;
        }
        Action[] actionArray = this.getActions(false);
        if (actionArray != null && actionArray.length > 0) {
            return actionArray[0];
        }
        return null;
    }

    public <T extends Node.Cookie> T getCookie(Class<T> clazz) {
        if (this.ownLookup()) {
            return (T)super.getCookie(clazz);
        }
        T t = this.obj.getCookie(clazz);
        if (t != null) {
            return t;
        }
        return (T)super.getCookie(clazz);
    }

    protected Sheet createSheet() {
        Sheet sheet = Sheet.createDefault();
        Sheet.Set set = sheet.get("properties");
        Node.Property property = DataNode.createNameProperty(this.obj);
        set.put(property);
        FileObject fileObject = this.getDataObject().getPrimaryFile();
        if (DataNode.couldBeTemplate(fileObject) && fileObject.canWrite()) {
            try {
                property = new PropertySupport.Reflection((Object)this.obj, Boolean.TYPE, "isTemplate", "setTemplate");
                property.setName("template");
                property.setDisplayName(DataObject.getString("PROP_template"));
                property.setShortDescription(DataObject.getString("HINT_template"));
                set.put(property);
            }
            catch (Exception exception) {
                throw new InternalError();
            }
        }
        if (fileObject.isData()) {
            if (!this.obj.getPrimaryFile().getNameExt().equals(this.obj.getName())) {
                set.put((Node.Property)new ExtensionProperty());
            }
            set.put((Node.Property)new AllFilesProperty());
            set.put((Node.Property)new SizeProperty());
            set.put((Node.Property)new LastModifiedProperty());
        }
        if (fileObject.isFolder()) {
            AllFilesProperty allFilesProperty = new AllFilesProperty();
            allFilesProperty.setHidden(true);
            set.put((Node.Property)allFilesProperty);
        }
        return sheet;
    }

    private static boolean couldBeTemplate(FileObject fileObject) {
        FileSystem fileSystem;
        try {
            fileSystem = fileObject.getFileSystem();
        }
        catch (FileStateInvalidException fileStateInvalidException) {
            return false;
        }
        return fileSystem.isDefault() && fileObject.getPath().startsWith("Templates/");
    }

    public Transferable clipboardCopy() throws IOException {
        ExTransferable exTransferable = ExTransferable.create((Transferable)super.clipboardCopy());
        exTransferable.put(LoaderTransfer.transferable(this.getDataObject(), 1));
        this.addExternalFileTransferable(exTransferable, this.getDataObject());
        return exTransferable;
    }

    public Transferable clipboardCut() throws IOException {
        ExTransferable exTransferable = ExTransferable.create((Transferable)super.clipboardCut());
        exTransferable.put(LoaderTransfer.transferable(this.getDataObject(), 4));
        this.addExternalFileTransferable(exTransferable, this.getDataObject());
        return exTransferable;
    }

    private void addExternalFileTransferable(ExTransferable exTransferable, DataObject dataObject) {
        FileObject fileObject = dataObject.getPrimaryFile();
        File file = FileUtil.toFile((FileObject)fileObject);
        if (null != file) {
            final ArrayList<File> arrayList = new ArrayList<File>(1);
            arrayList.add(file);
            exTransferable.put(new ExTransferable.Single(DataFlavor.javaFileListFlavor){

                public Object getData() {
                    return arrayList;
                }
            });
            final String string = file.toURI().toString() + "\r\n";
            exTransferable.put(new ExTransferable.Single(this.createUriListFlavor()){

                public Object getData() {
                    return string;
                }
            });
        }
    }

    private DataFlavor createUriListFlavor() {
        try {
            return new DataFlavor("text/uri-list;class=java.lang.String");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new AssertionError((Object)classNotFoundException);
        }
    }

    static Node.Property createNameProperty(final DataObject dataObject) {
        PropertySupport.ReadWrite<String> readWrite = new PropertySupport.ReadWrite<String>("name", String.class, DataObject.getString("PROP_name"), DataObject.getString("HINT_name")){

            public String getValue() {
                return dataObject.getName();
            }

            public void setValue(String string) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
                if (!this.canWrite()) {
                    throw new IllegalAccessException();
                }
                if (string == null) {
                    throw new IllegalArgumentException();
                }
                try {
                    dataObject.rename(string);
                }
                catch (IOException iOException) {
                    String string2 = null;
                    string2 = iOException.getLocalizedMessage() == null || iOException.getLocalizedMessage().equals(iOException.getMessage()) ? NbBundle.getMessage(DataNode.class, (String)"MSG_renameError", (Object)dataObject.getName(), (Object)string) : iOException.getLocalizedMessage();
                    UIException.annotateUser(iOException, null, string2, null, null);
                    throw new InvocationTargetException(iOException);
                }
            }

            public boolean canWrite() {
                return dataObject.isRenameAllowed();
            }

            public Object getValue(String string) {
                if ("suppressCustomEditor".equals(string)) {
                    return Boolean.TRUE;
                }
                return super.getValue(string);
            }
        };
        return readWrite;
    }

    private void updateFilesInCookieSet(Set<FileObject> set) {
        if (this.ownLookup()) {
            return;
        }
        this.getCookieSet().assign(FileObject.class, (Object[])set.toArray(new FileObject[0]));
    }

    void fireChange(final PropertyChangeEvent propertyChangeEvent) {
        Mutex.EVENT.writeAccess(new Runnable(){

            @Override
            public void run() {
                if ("children".equals(propertyChangeEvent.getPropertyName())) {
                    return;
                }
                if ("primaryFile".equals(propertyChangeEvent.getPropertyName())) {
                    DataNode.this.propL.updateStatusListener();
                    DataNode.this.setName(DataNode.this.obj.getName(), false);
                    DataNode.this.updateFilesInCookieSet(DataNode.this.obj.files());
                    return;
                }
                if ("files".equals(propertyChangeEvent.getPropertyName())) {
                    DataNode.this.updateFilesInCookieSet(DataNode.this.obj.files());
                }
                if ("name".equals(propertyChangeEvent.getPropertyName())) {
                    DataNode.super.setName(DataNode.this.obj.getName());
                    DataNode.this.updateDisplayName();
                }
                if ("cookie".equals(propertyChangeEvent.getPropertyName())) {
                    DataNode.this.fireCookieChange();
                }
                if ("valid".equals(propertyChangeEvent.getPropertyName())) {
                    Object object = propertyChangeEvent.getNewValue();
                    if (object instanceof Boolean && !((Boolean)object).booleanValue()) {
                        DataNode.this.fireNodeDestroyed();
                    }
                    return;
                }
                List<String> list = Arrays.asList("name", "files", "template");
                if (list.contains(propertyChangeEvent.getPropertyName())) {
                    DataNode.this.firePropertyChange(propertyChangeEvent.getPropertyName(), propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue());
                }
            }
        });
    }

    public Node.Handle getHandle() {
        return new ObjectHandle(this.obj, this.obj.isValid() ? this != this.obj.getNodeDelegate() : true);
    }

    final void fireChangeAccess(boolean bl, boolean bl2) {
        if (bl2) {
            this.fireDisplayNameChange(null, null);
        }
        if (bl) {
            this.fireIconChange();
        }
    }

    public static boolean getShowFileExtensions() {
        return showFileExtensions;
    }

    public static void setShowFileExtensions(boolean bl) {
        boolean bl2 = showFileExtensions != bl;
        showFileExtensions = bl;
        if (bl2) {
            DataNodeUtils.reqProcessor().post(new Runnable(){

                @Override
                public void run() {
                    Iterator<DataObjectPool.Item> iterator = DataObjectPool.getPOOL().getActiveDataObjects();
                    while (iterator.hasNext()) {
                        DataObject dataObject = iterator.next().getDataObjectOrNull();
                        if (dataObject == null || !(dataObject.getNodeDelegate() instanceof DataNode)) continue;
                        ((DataNode)dataObject.getNodeDelegate()).updateDisplayName();
                    }
                }
            }, 300, 1);
        }
    }

    private boolean ownLookup() {
        if (defaultLookup == null) {
            try {
                defaultLookup = Class.forName("org.openide.nodes.NodeLookup", false, Node.class.getClassLoader());
            }
            catch (ClassNotFoundException classNotFoundException) {
                Exceptions.printStackTrace((Throwable)classNotFoundException);
                return false;
            }
        }
        return !defaultLookup.isInstance(this.getLookup());
    }

    static {
        refreshNamesIconsTask = null;
        refreshNameNodes = null;
        refreshIconNodes = null;
        refreshNamesIconsRunning = false;
        refreshNameIconLock = "DataNode.refreshNameIconLock";
    }

    private class LazyFilesSet
    implements Set<FileObject> {
        private Set<FileObject> obj_files;

        private LazyFilesSet() {
        }

        private synchronized void lazyInitialization() {
            this.obj_files = DataNode.this.obj.files();
        }

        @Override
        public boolean add(FileObject fileObject) {
            this.lazyInitialization();
            return this.obj_files.add(fileObject);
        }

        @Override
        public boolean addAll(Collection<? extends FileObject> collection) {
            this.lazyInitialization();
            return this.obj_files.addAll(collection);
        }

        @Override
        public void clear() {
            this.lazyInitialization();
            this.obj_files.clear();
        }

        @Override
        public boolean contains(Object object) {
            this.lazyInitialization();
            return this.obj_files.contains(object);
        }

        @Override
        public boolean containsAll(Collection collection) {
            this.lazyInitialization();
            return this.obj_files.containsAll(collection);
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public Iterator<FileObject> iterator() {
            return new FilesIterator();
        }

        @Override
        public boolean remove(Object object) {
            this.lazyInitialization();
            return this.obj_files.remove(object);
        }

        @Override
        public boolean removeAll(Collection collection) {
            this.lazyInitialization();
            return this.obj_files.removeAll(collection);
        }

        @Override
        public boolean retainAll(Collection collection) {
            this.lazyInitialization();
            return this.obj_files.retainAll(collection);
        }

        @Override
        public int size() {
            this.lazyInitialization();
            return this.obj_files.size();
        }

        @Override
        public Object[] toArray() {
            this.lazyInitialization();
            return this.obj_files.toArray();
        }

        @Override
        public <FileObject> FileObject[] toArray(FileObject[] FileObjectArray) {
            this.lazyInitialization();
            return this.obj_files.toArray(FileObjectArray);
        }

        @Override
        public boolean equals(Object object) {
            this.lazyInitialization();
            return object instanceof Set && ((Object)this.obj_files).equals(object);
        }

        public String toString() {
            this.lazyInitialization();
            return this.obj_files.toString();
        }

        @Override
        public int hashCode() {
            this.lazyInitialization();
            return ((Object)this.obj_files).hashCode();
        }

        private final class FilesIterator
        implements Iterator<FileObject> {
            private boolean first = true;
            private Iterator<FileObject> itDelegate = null;

            FilesIterator() {
            }

            @Override
            public boolean hasNext() {
                return this.first ? true : this.getIteratorDelegate().hasNext();
            }

            @Override
            public FileObject next() {
                if (this.first) {
                    this.first = false;
                    return DataNode.this.obj.getPrimaryFile();
                }
                return this.getIteratorDelegate().next();
            }

            @Override
            public void remove() {
                this.getIteratorDelegate().remove();
            }

            private Iterator<FileObject> getIteratorDelegate() {
                if (this.itDelegate == null) {
                    LazyFilesSet.this.lazyInitialization();
                    this.itDelegate = LazyFilesSet.this.obj_files.iterator();
                    this.itDelegate.next();
                }
                return this.itDelegate;
            }
        }
    }

    private static class ObjectHandle
    implements Node.Handle {
        private FileObject obj;
        private boolean clone;
        static final long serialVersionUID = 6616060729084681518L;

        public ObjectHandle(DataObject dataObject, boolean bl) {
            this.obj = dataObject.getPrimaryFile();
            this.clone = bl;
        }

        public Node getNode() throws IOException {
            if (this.obj == null) {
                throw new IOException("File could not be restored");
            }
            Node node = DataObject.find(this.obj).getNodeDelegate();
            return this.clone ? node.cloneNode() : node;
        }
    }

    private static class NamesUpdater
    implements Runnable {
        private NamesUpdater() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            int n;
            DataNode[] dataNodeArray;
            DataNode[] dataNodeArray2;
            Object object = refreshNameIconLock;
            synchronized (object) {
                if (refreshNameNodes != null) {
                    dataNodeArray2 = refreshNameNodes.toArray(new DataNode[refreshNameNodes.size()]);
                    refreshNameNodes.clear();
                } else {
                    dataNodeArray2 = new DataNode[]{};
                }
                if (refreshIconNodes != null) {
                    dataNodeArray = refreshIconNodes.toArray(new DataNode[refreshIconNodes.size()]);
                    refreshIconNodes.clear();
                } else {
                    dataNodeArray = new DataNode[]{};
                }
                refreshNamesIconsRunning = false;
            }
            for (n = 0; n < dataNodeArray2.length; ++n) {
                dataNodeArray2[n].fireChangeAccess(false, true);
            }
            for (n = 0; n < dataNodeArray.length; ++n) {
                dataNodeArray[n].fireChangeAccess(true, false);
            }
        }
    }

    private class PropL
    implements PropertyChangeListener,
    FileStatusListener,
    CookieSet.Before {
        private FileStatusListener weakL;
        private FileSystem previous;

        public PropL() {
            this.updateStatusListener();
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            DataNode.this.fireChange(propertyChangeEvent);
        }

        private void updateStatusListener() {
            if (this.previous != null) {
                this.previous.removeFileStatusListener(this.weakL);
            }
            try {
                this.previous = DataNode.this.obj.getPrimaryFile().getFileSystem();
                if (this.weakL == null) {
                    this.weakL = FileUtil.weakFileStatusListener((FileStatusListener)this, null);
                }
                this.previous.addFileStatusListener(this.weakL);
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                this.previous = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void annotationChanged(FileStatusEvent fileStatusEvent) {
            boolean bl;
            Object object;
            if (DataNode.this.getDataObject() instanceof MultiDataObject) {
                object = (MultiDataObject)DataNode.this.getDataObject();
                bl = fileStatusEvent.hasChanged(((DataObject)object).getPrimaryFile());
                if (!bl) {
                    for (FileObject fileObject : ((MultiDataObject)object).getSecondary().keySet()) {
                        if (!fileStatusEvent.hasChanged(fileObject)) continue;
                        bl = true;
                        break;
                    }
                }
            } else {
                bl = false;
                for (FileObject bl2 : DataNode.this.obj.files()) {
                    if (!fileStatusEvent.hasChanged(bl2)) continue;
                    bl = true;
                    break;
                }
            }
            if (bl) {
                object = refreshNameIconLock;
                synchronized (object) {
                    int n;
                    boolean bl2;
                    boolean bl3 = false;
                    if (fileStatusEvent.isNameChange()) {
                        if (refreshNameNodes == null) {
                            refreshNameNodes = new HashSet();
                        }
                        bl2 = bl3 | refreshNameNodes.add(DataNode.this);
                    }
                    if (fileStatusEvent.isIconChange()) {
                        if (refreshIconNodes == null) {
                            refreshIconNodes = new HashSet();
                        }
                        n = bl2 | refreshIconNodes.add(DataNode.this);
                    }
                    if (n != 0 && !refreshNamesIconsRunning) {
                        refreshNamesIconsRunning = true;
                        if (refreshNamesIconsTask == null) {
                            refreshNamesIconsTask = DataNodeUtils.reqProcessor().post((Runnable)new NamesUpdater());
                        } else {
                            refreshNamesIconsTask.schedule(0);
                        }
                    }
                }
            }
        }

        public void beforeLookup(Class<?> clazz) {
            if (clazz.isAssignableFrom(FileObject.class)) {
                DataNode.this.updateFilesInCookieSet(DataNode.this.obj.files());
            }
        }
    }

    private final class ExtensionProperty
    extends PropertySupport.ReadWrite<String> {
        public ExtensionProperty() {
            super(DataNode.PROP_EXTENSION, String.class, DataObject.getString("PROP_extension"), DataObject.getString("HINT_extension"));
        }

        public boolean canWrite() {
            return DataNode.this.obj.isRenameAllowed();
        }

        public String getValue() throws IllegalAccessException, InvocationTargetException {
            return DataNode.this.obj.getPrimaryFile().getExt();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setValue(String string) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            if (this.getValue().equals(string)) {
                return;
            }
            try {
                if (DataNode.this.obj.isModified()) {
                    String string2 = DataObject.getString("ERROR_extension");
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)string2));
                    return;
                }
                FileObject fileObject = DataNode.this.obj.getPrimaryFile();
                FileLock fileLock = fileObject.lock();
                try {
                    fileObject.rename(fileLock, fileObject.getName(), string);
                }
                finally {
                    fileLock.releaseLock();
                }
                DataNode.this.obj.dispose();
                if (DataNode.this.obj instanceof MultiDataObject) {
                    FolderList folderList = FolderList.find(fileObject.getParent(), true);
                    folderList.getChildren();
                    folderList.refresh();
                }
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
    }

    private final class LastModifiedProperty
    extends PropertySupport.ReadOnly<Date> {
        public LastModifiedProperty() {
            super("lastModified", Date.class, DataObject.getString("PROP_lastModified"), DataObject.getString("HINT_lastModified"));
        }

        public Date getValue() {
            return DataNode.this.getDataObject().getPrimaryFile().lastModified();
        }
    }

    private final class SizeProperty
    extends PropertySupport.ReadOnly<Long> {
        public SizeProperty() {
            super("size", Long.TYPE, DataObject.getString("PROP_size"), DataObject.getString("HINT_size"));
        }

        public Long getValue() {
            return new Long(DataNode.this.getDataObject().getPrimaryFile().getSize());
        }
    }

    private final class AllFilesProperty
    extends PropertySupport.ReadOnly<String[]> {
        public AllFilesProperty() {
            super("files", String[].class, DataObject.getString("PROP_files"), DataObject.getString("HINT_files"));
        }

        public String[] getValue() {
            Set<FileObject> set = DataNode.this.obj.files();
            FileObject fileObject = DataNode.this.obj.getPrimaryFile();
            Object[] objectArray = new String[set.size()];
            assert (set.contains(fileObject));
            int n = 1;
            Iterator<FileObject> iterator = set.iterator();
            while (iterator.hasNext()) {
                FileObject fileObject2;
                objectArray[(fileObject2 = iterator.next()) == fileObject ? 0 : n++] = this.name(fileObject2);
            }
            Arrays.sort(objectArray, 1, objectArray.length);
            return objectArray;
        }

        private String name(FileObject fileObject) {
            return FileUtil.getFileDisplayName((FileObject)fileObject);
        }
    }
}

