/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.visualvm.sampler.memory;

import com.sun.tools.visualvm.application.jvm.HeapHistogram;
import com.sun.tools.visualvm.sampler.AbstractSamplerSupport;
import com.sun.tools.visualvm.sampler.memory.MemorySamplerSupport;
import com.sun.tools.visualvm.uisupport.HTMLTextArea;
import com.sun.tools.visualvm.uisupport.TransparentToolBar;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.lang.management.MemoryMXBean;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.JToggleButton;
import javax.swing.KeyStroke;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.netbeans.lib.profiler.ui.UIConstants;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.lib.profiler.ui.components.FilterComponent;
import org.netbeans.lib.profiler.ui.components.JExtendedTable;
import org.netbeans.lib.profiler.ui.components.table.ClassNameTableCellRenderer;
import org.netbeans.lib.profiler.ui.components.table.CustomBarCellRenderer;
import org.netbeans.lib.profiler.ui.components.table.DiffBarCellRenderer;
import org.netbeans.lib.profiler.ui.components.table.ExtendedTableModel;
import org.netbeans.lib.profiler.ui.components.table.JExtendedTablePanel;
import org.netbeans.lib.profiler.ui.components.table.LabelBracketTableCellRenderer;
import org.netbeans.lib.profiler.ui.components.table.LabelTableCellRenderer;
import org.netbeans.lib.profiler.ui.components.table.SortableTableModel;
import org.netbeans.modules.profiler.api.icons.Icons;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

final class MemoryView
extends JPanel {
    static final int MODE_HEAP = 1;
    static final int MODE_PERMGEN = 2;
    static final int MODE_THREADALLOC = 3;
    private final int mode;
    private final AbstractSamplerSupport.Refresher refresher;
    private boolean forceRefresh = false;
    private final MemoryMXBean memoryBean;
    private final MemorySamplerSupport.HeapDumper heapDumper;
    private final MemorySamplerSupport.SnapshotDumper snapshotDumper;
    private HTMLTextArea area;
    private AbstractButton snapshotButton;
    private AbstractButton deltaButton;
    private AbstractButton pauseButton;
    private AbstractButton refreshButton;
    private AbstractButton gcButton;
    private AbstractButton heapdumpButton;
    private JExtendedTable resTable;
    private ExtendedTableModel resTableModel;
    private JExtendedTablePanel resTablePanel;
    private FilterComponent filterComponent;
    private CustomBarCellRenderer customBarCellRenderer;
    private DiffBarCellRenderer diffBarCellRenderer;
    private LabelTableCellRenderer labelTableCellRenderer;
    private LabelBracketTableCellRenderer labelBracketTableCellRenderer;
    private String filterString = "";
    private int filterType = 20;
    private List<HeapHistogram.ClassInfo> classes = new ArrayList<HeapHistogram.ClassInfo>();
    private List<HeapHistogram.ClassInfo> baseClasses = new ArrayList<HeapHistogram.ClassInfo>();
    private List<Integer> filteredSortedIndexes = new ArrayList<Integer>();
    private int totalClasses = -1;
    private long totalBytes;
    private long baseTotalBytes = -1L;
    private long totalInstances;
    private long baseTotalInstances = -1L;
    private int sortingColumn = 1;
    private boolean sortOrder = false;
    private String[] columnNames;
    private TableCellRenderer[] columnRenderers;
    private String[] columnToolTips;
    private Class[] columnTypes;
    private int[] columnWidths;
    private int minNamesColumnWidth;

    MemoryView(AbstractSamplerSupport.Refresher refresher, int mode, MemoryMXBean memoryBean, MemorySamplerSupport.SnapshotDumper snapshotDumper, MemorySamplerSupport.HeapDumper heapDumper) {
        this.refresher = refresher;
        this.mode = mode;
        this.memoryBean = memoryBean;
        this.snapshotDumper = snapshotDumper;
        this.heapDumper = heapDumper;
        this.initColumnsData();
        this.initComponents();
        this.addHierarchyListener(new HierarchyListener(){

            @Override
            public void hierarchyChanged(HierarchyEvent e) {
                if ((e.getChangeFlags() & 4L) != 0L && MemoryView.this.isShowing()) {
                    MemoryView.this.refresher.refresh();
                }
            }
        });
    }

    void initSession() {
        this.snapshotButton.setEnabled(false);
    }

    boolean isPaused() {
        return this.pauseButton.isSelected() && !this.forceRefresh;
    }

    boolean isEmpty() {
        return this.resTableModel.getRowCount() == 0;
    }

    void refresh(HeapHistogram histogram) {
        if (histogram == null || this.isPaused()) {
            return;
        }
        this.forceRefresh = false;
        if (this.deltaButton.isSelected()) {
            if (this.baseClasses == null) {
                this.baseClasses = new ArrayList<HeapHistogram.ClassInfo>(this.classes);
                this.baseTotalBytes = this.totalBytes;
                this.baseTotalInstances = this.totalInstances;
                this.columnRenderers[1] = this.diffBarCellRenderer;
                this.columnRenderers[2] = this.labelTableCellRenderer;
                this.columnRenderers[3] = this.labelTableCellRenderer;
                this.updateColumnRenderers();
            }
            Collection newClasses = this.getHistogram(histogram);
            this.classes = MemoryView.computeDeltaClasses(this.baseClasses, newClasses);
            this.totalClasses = this.baseClasses.size() - newClasses.size();
            this.totalBytes = this.getTotalBytes(histogram) - this.baseTotalBytes;
            this.totalInstances = this.getTotalInstances(histogram) - this.baseTotalInstances;
            long maxAbsDiffBytes = 0L;
            for (HeapHistogram.ClassInfo cInfo : this.classes) {
                maxAbsDiffBytes = Math.max(maxAbsDiffBytes, Math.abs(cInfo.getBytes()));
            }
            this.diffBarCellRenderer.setMaximum(maxAbsDiffBytes);
            this.diffBarCellRenderer.setMinimum(-maxAbsDiffBytes);
        } else {
            if (this.baseClasses != null) {
                this.baseClasses = null;
                this.baseTotalBytes = -1L;
                this.baseTotalInstances = -1L;
                this.columnRenderers[1] = this.customBarCellRenderer;
                this.columnRenderers[2] = this.labelBracketTableCellRenderer;
                this.columnRenderers[3] = this.labelBracketTableCellRenderer;
                this.updateColumnRenderers();
            }
            this.classes.clear();
            this.classes.addAll(this.getHistogram(histogram));
            this.totalClasses = this.classes.size();
            this.totalBytes = this.getTotalBytes(histogram);
            this.totalInstances = this.getTotalInstances(histogram);
            this.customBarCellRenderer.setMaximum(this.totalBytes);
        }
        this.updateData(false);
        this.refreshUI();
        this.snapshotButton.setEnabled(this.snapshotDumper != null);
    }

    void terminate() {
        this.pauseButton.setEnabled(false);
        this.refreshButton.setEnabled(false);
        this.deltaButton.setEnabled(false);
        this.gcButton.setEnabled(false);
        this.heapdumpButton.setEnabled(false);
    }

    private Collection getHistogram(HeapHistogram histogram) {
        if (this.mode == 1) {
            return histogram.getHeapHistogram();
        }
        if (this.mode == 2) {
            return histogram.getPermGenHistogram();
        }
        return null;
    }

    private long getTotalBytes(HeapHistogram histogram) {
        if (this.mode == 1) {
            return histogram.getTotalHeapBytes();
        }
        if (this.mode == 2) {
            return histogram.getTotalPermGenHeapBytes();
        }
        return -1L;
    }

    private long getTotalInstances(HeapHistogram histogram) {
        if (this.mode == 1) {
            return histogram.getTotalHeapInstances();
        }
        if (this.mode == 2) {
            return histogram.getTotalPerGenInstances();
        }
        return -1L;
    }

    private static List<HeapHistogram.ClassInfo> computeDeltaClasses(Collection<HeapHistogram.ClassInfo> basis, Collection<HeapHistogram.ClassInfo> changed) {
        HashMap<String, DeltaClassInfo> deltaMap = new HashMap<String, DeltaClassInfo>((int)((double)basis.size() * 1.3));
        for (HeapHistogram.ClassInfo cInfo : basis) {
            deltaMap.put(cInfo.getName(), new DeltaClassInfo(cInfo, true));
        }
        for (HeapHistogram.ClassInfo cInfo : changed) {
            DeltaClassInfo bInfo = (DeltaClassInfo)((Object)deltaMap.get(cInfo.getName()));
            if (bInfo != null) {
                bInfo.add(cInfo);
                continue;
            }
            deltaMap.put(cInfo.getName(), new DeltaClassInfo(cInfo, false));
        }
        return new ArrayList<HeapHistogram.ClassInfo>(deltaMap.values());
    }

    private void updateData(boolean sortOnly) {
        int selectedRow = this.resTable.getSelectedRow();
        String selectedRowContents = null;
        if (selectedRow != -1) {
            selectedRowContents = (String)this.resTable.getValueAt(selectedRow, 0);
        }
        if (!sortOnly) {
            this.filterData();
        }
        this.sortData();
        this.resTableModel.fireTableDataChanged();
        if (selectedRowContents != null) {
            this.resTable.selectRowByContents(selectedRowContents, 0, false);
        }
    }

    private void filterData() {
        this.filteredSortedIndexes.clear();
        String[] filterStrings = this.filterComponent.getFilterStrings();
        if (this.filterType == 0 || filterStrings == null || filterStrings[0].equals("")) {
            for (int i = 0; i < this.classes.size(); ++i) {
                this.filteredSortedIndexes.add(i);
            }
        } else {
            for (int i = 0; i < this.classes.size(); ++i) {
                if (!MemoryView.passedFilters(this.classes.get(i).getName(), filterStrings, this.filterType)) continue;
                this.filteredSortedIndexes.add(i);
            }
        }
    }

    private static boolean passedFilters(String value, String[] filters, int type) {
        for (int i = 0; i < filters.length; ++i) {
            if (!MemoryView.passedFilter(value, filters[i], type)) continue;
            return true;
        }
        return false;
    }

    private static boolean passedFilter(String value, String filter, int type) {
        switch (type) {
            case 10: {
                return value.regionMatches(true, 0, filter, 0, filter.length());
            }
            case 20: {
                return value.toLowerCase().indexOf(filter.toLowerCase()) != -1;
            }
            case 30: {
                return value.regionMatches(true, value.length() - filter.length(), filter, 0, filter.length());
            }
            case 40: {
                return value.equalsIgnoreCase(filter);
            }
            case 50: {
                return value.matches(filter);
            }
        }
        return false;
    }

    private void sortData() {
        Collections.sort(this.filteredSortedIndexes, new Comparator(){

            public int compare(Object o1, Object o2) {
                Integer index1 = (Integer)o1;
                Integer index2 = (Integer)o2;
                HeapHistogram.ClassInfo class1 = (HeapHistogram.ClassInfo)MemoryView.this.classes.get(index1);
                HeapHistogram.ClassInfo class2 = (HeapHistogram.ClassInfo)MemoryView.this.classes.get(index2);
                switch (MemoryView.this.sortingColumn) {
                    case 0: {
                        return MemoryView.this.sortOrder ? class1.getName().compareTo(class2.getName()) : class2.getName().compareTo(class1.getName());
                    }
                    case 1: 
                    case 2: {
                        return MemoryView.this.sortOrder ? Long.valueOf(class1.getBytes()).compareTo(class2.getBytes()) : Long.valueOf(class2.getBytes()).compareTo(class1.getBytes());
                    }
                    case 3: {
                        return MemoryView.this.sortOrder ? Long.valueOf(class1.getInstancesCount()).compareTo(class2.getInstancesCount()) : Long.valueOf(class2.getInstancesCount()).compareTo(class1.getInstancesCount());
                    }
                }
                return 0;
            }
        });
    }

    private JExtendedTable initTable() {
        this.resTableModel = new ExtendedTableModel(new SortableTableModel(){

            public String getColumnName(int col) {
                return MemoryView.this.columnNames[col];
            }

            public int getRowCount() {
                return MemoryView.this.filteredSortedIndexes.size();
            }

            public int getColumnCount() {
                return MemoryView.this.columnNames.length;
            }

            public Class getColumnClass(int col) {
                return MemoryView.this.columnTypes[col];
            }

            public Object getValueAt(int row, int col) {
                HeapHistogram.ClassInfo classs = (HeapHistogram.ClassInfo)MemoryView.this.classes.get((Integer)MemoryView.this.filteredSortedIndexes.get(row));
                boolean deltas = MemoryView.this.baseClasses != null;
                long bytes = classs.getBytes();
                long instances = classs.getInstancesCount();
                NumberFormat formatter = NumberFormat.getInstance();
                switch (col) {
                    case 0: {
                        return classs.getName();
                    }
                    case 1: {
                        return bytes;
                    }
                    case 2: {
                        if (deltas) {
                            return bytes > 0L ? "+" + formatter.format(bytes) : formatter.format(bytes);
                        }
                        return bytes == 0L ? "0 (0.0%)" : formatter.format(bytes) + " (" + this.getPercentValue(bytes, MemoryView.this.totalBytes) + "%)";
                    }
                    case 3: {
                        if (deltas) {
                            return instances > 0L ? "+" + formatter.format(instances) : formatter.format(instances);
                        }
                        return instances == 0L ? "0 (0.0%)" : formatter.format(instances) + " (" + this.getPercentValue(instances, MemoryView.this.totalInstances) + "%)";
                    }
                }
                return null;
            }

            private String getPercentValue(float value, float basevalue) {
                int basis = (int)(value / basevalue * 1000.0f);
                int percent = basis / 10;
                int permille = basis % 10;
                return "" + percent + "." + permille;
            }

            public String getColumnToolTipText(int col) {
                return MemoryView.this.columnToolTips[col];
            }

            public void sortByColumn(int column, boolean order) {
                MemoryView.this.sortingColumn = column;
                MemoryView.this.sortOrder = order;
                MemoryView.this.updateData(true);
            }

            public boolean getInitialSorting(int column) {
                switch (column) {
                    case 0: {
                        return true;
                    }
                }
                return false;
            }
        });
        this.resTable = new JExtendedTable((TableModel)this.resTableModel){

            public void doLayout() {
                int columnsWidthsSum = 0;
                int realFirstColumn = -1;
                for (int i = 0; i < MemoryView.this.resTableModel.getColumnCount(); ++i) {
                    int index = MemoryView.this.resTableModel.getRealColumn(i);
                    if (index == 0) {
                        realFirstColumn = i;
                        continue;
                    }
                    columnsWidthsSum += this.getColumnModel().getColumn(i).getPreferredWidth();
                }
                if (realFirstColumn != -1) {
                    this.getColumnModel().getColumn(realFirstColumn).setPreferredWidth(Math.max(this.getWidth() - columnsWidthsSum, MemoryView.this.minNamesColumnWidth));
                }
                super.doLayout();
            }
        };
        this.resTableModel.setTable((JTable)this.resTable);
        this.resTableModel.setInitialSorting(this.sortingColumn, this.sortOrder);
        this.resTable.setRowSelectionAllowed(true);
        this.resTable.setSelectionMode(0);
        this.resTable.setGridColor(UIConstants.TABLE_VERTICAL_GRID_COLOR);
        this.resTable.setSelectionBackground(UIConstants.TABLE_SELECTION_BACKGROUND_COLOR);
        this.resTable.setSelectionForeground(UIConstants.TABLE_SELECTION_FOREGROUND_COLOR);
        this.resTable.setShowHorizontalLines(false);
        this.resTable.setShowVerticalLines(true);
        this.resTable.setRowMargin(0);
        this.resTable.setRowHeight(UIUtils.getDefaultRowHeight() + 2);
        this.resTable.getAccessibleContext().setAccessibleName("");
        this.resTable.getAccessibleContext().setAccessibleDescription("");
        HashSet<KeyStroke> keys = new HashSet<KeyStroke>(this.resTable.getFocusTraversalKeys(0));
        keys.add(KeyStroke.getKeyStroke(9, 0));
        this.resTable.setFocusTraversalKeys(0, keys);
        keys = new HashSet(this.resTable.getFocusTraversalKeys(1));
        keys.add(KeyStroke.getKeyStroke(9, 1));
        this.resTable.setFocusTraversalKeys(1, keys);
        this.setColumnsData();
        return this.resTable;
    }

    protected void initColumnsData() {
        int maxWidth = this.getFontMetrics(this.getFont()).charWidth('W') * 13;
        this.minNamesColumnWidth = this.getFontMetrics(this.getFont()).charWidth('W') * 30;
        ClassNameTableCellRenderer classNameTableCellRenderer = new ClassNameTableCellRenderer();
        this.customBarCellRenderer = new CustomBarCellRenderer(0L, 100L);
        this.diffBarCellRenderer = new DiffBarCellRenderer(0L, 100L);
        this.labelTableCellRenderer = new LabelTableCellRenderer(11);
        this.labelBracketTableCellRenderer = new LabelBracketTableCellRenderer(11);
        this.columnNames = new String[]{NbBundle.getMessage(MemoryView.class, (String)"COL_Class_name"), NbBundle.getMessage(MemoryView.class, (String)"COL_Bytes_rel"), NbBundle.getMessage(MemoryView.class, (String)"COL_Bytes"), NbBundle.getMessage(MemoryView.class, (String)"COL_Instances")};
        this.columnToolTips = new String[]{NbBundle.getMessage(MemoryView.class, (String)"COL_Class_name"), NbBundle.getMessage(MemoryView.class, (String)"COL_Bytes_rel"), NbBundle.getMessage(MemoryView.class, (String)"COL_Bytes"), NbBundle.getMessage(MemoryView.class, (String)"COL_Instances")};
        this.columnTypes = new Class[]{String.class, Number.class, String.class, String.class};
        this.columnRenderers = new TableCellRenderer[]{classNameTableCellRenderer, this.customBarCellRenderer, this.labelBracketTableCellRenderer, this.labelBracketTableCellRenderer};
        this.columnWidths = new int[]{maxWidth, maxWidth, maxWidth, maxWidth};
    }

    private void setColumnsData() {
        TableColumnModel colModel = this.resTable.getColumnModel();
        colModel.getColumn(0).setPreferredWidth(this.minNamesColumnWidth);
        for (int i = 0; i < colModel.getColumnCount(); ++i) {
            int index = this.resTableModel.getRealColumn(i);
            if (index == 0) {
                colModel.getColumn(i).setPreferredWidth(this.minNamesColumnWidth);
            } else {
                colModel.getColumn(i).setPreferredWidth(this.columnWidths[index - 1]);
            }
            colModel.getColumn(i).setCellRenderer(this.columnRenderers[index]);
        }
    }

    private void updateColumnRenderers() {
        TableColumnModel colModel = this.resTable.getColumnModel();
        for (int i = 0; i < colModel.getColumnCount(); ++i) {
            colModel.getColumn(i).setCellRenderer(this.columnRenderers[this.resTableModel.getRealColumn(i)]);
        }
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        this.setOpaque(false);
        TransparentToolBar toolBar = new TransparentToolBar();
        this.pauseButton = new JToggleButton(){

            @Override
            protected void fireActionPerformed(ActionEvent event) {
                boolean selected = MemoryView.this.pauseButton.isSelected();
                MemoryView.this.refreshButton.setEnabled(selected);
                if (!selected) {
                    MemoryView.this.refresher.refresh();
                }
            }
        };
        this.pauseButton.setIcon(new ImageIcon(ImageUtilities.loadImage((String)"com/sun/tools/visualvm/sampler/resources/pause.png", (boolean)true)));
        this.pauseButton.setToolTipText(NbBundle.getMessage(MemoryView.class, (String)"TOOLTIP_Pause_results"));
        this.pauseButton.setOpaque(false);
        toolBar.addItem((JComponent)this.pauseButton);
        this.refreshButton = new JButton(){

            @Override
            protected void fireActionPerformed(ActionEvent event) {
                MemoryView.this.forceRefresh = true;
                MemoryView.this.refresher.refresh();
            }
        };
        this.refreshButton.setIcon(new ImageIcon(ImageUtilities.loadImage((String)"com/sun/tools/visualvm/sampler/resources/update.png", (boolean)true)));
        this.refreshButton.setToolTipText(NbBundle.getMessage(MemoryView.class, (String)"TOOLTIP_Update_results"));
        this.refreshButton.setEnabled(this.pauseButton.isSelected());
        this.refreshButton.setOpaque(false);
        toolBar.addItem((JComponent)this.refreshButton);
        toolBar.addSeparator();
        this.deltaButton = new JToggleButton(NbBundle.getMessage(MemoryView.class, (String)"LBL_Deltas")){

            @Override
            protected void fireActionPerformed(ActionEvent event) {
                MemoryView.this.refresher.refresh();
            }
        };
        this.deltaButton.setToolTipText(NbBundle.getMessage(MemoryView.class, (String)"TOOLTIP_Deltas"));
        this.deltaButton.setOpaque(false);
        toolBar.addItem((JComponent)this.deltaButton);
        toolBar.addSeparator();
        this.snapshotButton = new JButton(NbBundle.getMessage(MemoryView.class, (String)"LBL_Snapshot"), new ImageIcon(ImageUtilities.loadImage((String)"com/sun/tools/visualvm/sampler/resources/snapshot.png", (boolean)true))){

            @Override
            protected void fireActionPerformed(ActionEvent event) {
                MemoryView.this.snapshotDumper.takeSnapshot((event.getModifiers() & Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()) == 0);
            }
        };
        this.snapshotButton.setToolTipText(NbBundle.getMessage(MemoryView.class, (String)"TOOLTIP_Snapshot"));
        this.snapshotButton.setOpaque(false);
        this.snapshotButton.setEnabled(false);
        toolBar.addItem((JComponent)this.snapshotButton);
        toolBar.addFiller();
        this.gcButton = new JButton(NbBundle.getMessage(MemoryView.class, (String)"LBL_Gc")){

            @Override
            protected void fireActionPerformed(ActionEvent event) {
                RequestProcessor.getDefault().post(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            MemoryView.this.memoryBean.gc();
                        }
                        catch (Exception e) {
                            this.setEnabled(false);
                            Exceptions.printStackTrace((Throwable)e);
                        }
                    }
                });
            }
        };
        this.gcButton.setToolTipText(NbBundle.getMessage(MemoryView.class, (String)"TOOLTIP_Gc"));
        this.gcButton.setOpaque(false);
        this.gcButton.setEnabled(this.memoryBean != null);
        toolBar.addItem((JComponent)this.gcButton);
        this.heapdumpButton = new JButton(NbBundle.getMessage(MemoryView.class, (String)"LBL_HeapDump")){

            @Override
            protected void fireActionPerformed(ActionEvent event) {
                MemoryView.this.heapDumper.takeHeapDump((event.getModifiers() & Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()) == 0);
            }
        };
        this.heapdumpButton.setToolTipText(NbBundle.getMessage(MemoryView.class, (String)"TOOLTIP_HeapDump"));
        this.heapdumpButton.setOpaque(false);
        this.heapdumpButton.setEnabled(this.heapDumper != null);
        toolBar.addItem((JComponent)this.heapdumpButton);
        int maxHeight = this.pauseButton.getPreferredSize().height;
        maxHeight = Math.max(maxHeight, this.refreshButton.getPreferredSize().height);
        maxHeight = Math.max(maxHeight, this.snapshotButton.getPreferredSize().height);
        maxHeight = Math.max(maxHeight, this.deltaButton.getPreferredSize().height);
        maxHeight = Math.max(maxHeight, this.gcButton.getPreferredSize().height);
        maxHeight = Math.max(maxHeight, this.heapdumpButton.getPreferredSize().height);
        int width = this.pauseButton.getPreferredSize().width;
        Dimension size = new Dimension(maxHeight, maxHeight);
        this.pauseButton.setMinimumSize(size);
        this.pauseButton.setPreferredSize(size);
        this.pauseButton.setMaximumSize(size);
        width = this.refreshButton.getPreferredSize().width;
        size = new Dimension(maxHeight, maxHeight);
        this.refreshButton.setMinimumSize(size);
        this.refreshButton.setPreferredSize(size);
        this.refreshButton.setMaximumSize(size);
        width = this.snapshotButton.getPreferredSize().width;
        size = new Dimension(width + 5, maxHeight);
        this.snapshotButton.setMinimumSize(size);
        this.snapshotButton.setPreferredSize(size);
        this.snapshotButton.setMaximumSize(size);
        width = this.deltaButton.getPreferredSize().width;
        size = new Dimension(width + 5, maxHeight);
        this.deltaButton.setMinimumSize(size);
        this.deltaButton.setPreferredSize(size);
        this.deltaButton.setMaximumSize(size);
        width = this.gcButton.getPreferredSize().width;
        size = new Dimension(width + 5, maxHeight);
        this.gcButton.setMinimumSize(size);
        this.gcButton.setPreferredSize(size);
        this.gcButton.setMaximumSize(size);
        width = this.heapdumpButton.getPreferredSize().width;
        size = new Dimension(width + 5, maxHeight);
        this.heapdumpButton.setMinimumSize(size);
        this.heapdumpButton.setPreferredSize(size);
        this.heapdumpButton.setMaximumSize(size);
        toolBar.setBorder(BorderFactory.createEmptyBorder(4, 4, 3, 4));
        JPanel resultsPanel = new JPanel(new BorderLayout());
        resultsPanel.setOpaque(false);
        JPanel areaPanel = new JPanel(new BorderLayout());
        areaPanel.setOpaque(false);
        this.area = new HTMLTextArea();
        this.area.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.refreshUI();
        areaPanel.add((Component)this.area, "North");
        areaPanel.add((Component)new JSeparator(), "South");
        resultsPanel.add((Component)areaPanel, "North");
        this.add((Component)toolBar, "North");
        this.resTable = this.initTable();
        this.resTable.addComponentListener((ComponentListener)new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                MemoryView.this.revalidate();
            }
        });
        this.resTablePanel = new JExtendedTablePanel(this.resTable);
        resultsPanel.add((Component)this.resTablePanel, "Center");
        resultsPanel.setBorder(this.resTablePanel.getBorder());
        this.resTablePanel.setBorder(BorderFactory.createEmptyBorder());
        this.add((Component)resultsPanel, "Center");
        this.initFilterPanel();
    }

    private void initFilterPanel() {
        this.filterComponent = new FilterComponent();
        this.filterComponent.addFilterItem(Icons.getImageIcon((String)"GeneralIcons.FilterStartsWith"), NbBundle.getMessage(MemoryView.class, (String)"LBL_Starts_with"), 10);
        this.filterComponent.addFilterItem(Icons.getImageIcon((String)"GeneralIcons.FilterContains"), NbBundle.getMessage(MemoryView.class, (String)"LBL_Contains"), 20);
        this.filterComponent.addFilterItem(Icons.getImageIcon((String)"GeneralIcons.FilterEndsWith"), NbBundle.getMessage(MemoryView.class, (String)"LBL_Ends_with"), 30);
        this.filterComponent.addFilterItem(Icons.getImageIcon((String)"GeneralIcons.FilterRegExp"), NbBundle.getMessage(MemoryView.class, (String)"LBL_Regexp"), 50);
        this.filterComponent.setFilterValues(this.filterString, this.filterType);
        this.filterComponent.setEmptyFilterText(NbBundle.getMessage(MemoryView.class, (String)"LBL_Class_filter"));
        this.filterComponent.addFilterListener(new FilterComponent.FilterListener(){

            public void filterChanged() {
                MemoryView.this.filterString = MemoryView.this.filterComponent.getFilterString();
                MemoryView.this.filterType = MemoryView.this.filterComponent.getFilterType();
                MemoryView.this.updateData(false);
            }
        });
        this.add((Component)this.filterComponent, "South");
    }

    private void refreshUI() {
        int selStart = this.area.getSelectionStart();
        int selEnd = this.area.getSelectionEnd();
        this.area.setText(this.getBasicTelemetry());
        this.area.select(selStart, selEnd);
    }

    private String getBasicTelemetry() {
        String sInstances;
        String sClasses;
        boolean deltas;
        boolean bl = deltas = this.baseClasses != null;
        String string = this.totalClasses == -1 ? "" : (sClasses = (deltas && this.totalClasses > 0 ? "+" : "") + NumberFormat.getInstance().format(this.totalClasses));
        String string2 = this.totalInstances == -1L ? "" : (sInstances = (deltas && this.totalInstances > 0L ? "+" : "") + NumberFormat.getInstance().format(this.totalInstances));
        String sBytes = this.totalBytes == -1L ? "" : (deltas && this.totalBytes > 0L ? "+" : "") + NumberFormat.getInstance().format(this.totalBytes);
        String ssClasses = NbBundle.getMessage(MemoryView.class, (String)"LBL_Classes", (Object)sClasses);
        String ssInstances = NbBundle.getMessage(MemoryView.class, (String)"LBL_Instances", (Object)sInstances);
        String ssBytes = NbBundle.getMessage(MemoryView.class, (String)"LBL_Bytes", (Object)sBytes);
        return "<nobr>" + ssClasses + "&nbsp;&nbsp;&nbsp;&nbsp;" + ssInstances + "&nbsp;&nbsp;&nbsp;&nbsp;" + ssBytes + "</nobr>";
    }

    private static class DeltaClassInfo
    extends HeapHistogram.ClassInfo {
        String name;
        long instancesCount;
        long bytes;

        DeltaClassInfo(HeapHistogram.ClassInfo cInfo, boolean negative) {
            this.name = cInfo.getName();
            this.instancesCount = negative ? -cInfo.getInstancesCount() : cInfo.getInstancesCount();
            this.bytes = negative ? -cInfo.getBytes() : cInfo.getBytes();
        }

        void add(HeapHistogram.ClassInfo cInfo) {
            this.instancesCount += cInfo.getInstancesCount();
            this.bytes += cInfo.getBytes();
        }

        public String getName() {
            return this.name;
        }

        public long getInstancesCount() {
            return this.instancesCount;
        }

        public long getBytes() {
            return this.bytes;
        }
    }
}

