/*
 * Decompiled with CFR 0.152.
 */
package oracle.jrockit.jfr.settings;

import com.oracle.jrockit.jfr.EventInfo;
import oracle.jrockit.jfr.events.EventDescriptor;

@Deprecated
public final class EventSetting {
    private final int id;
    private final boolean enabled;
    private final boolean stacktrace;
    private final long thresholdNanos;
    private final long period;

    public EventSetting(int n, boolean bl, boolean bl2, long l, long l2) {
        this.id = n;
        this.enabled = bl;
        this.stacktrace = bl2;
        this.thresholdNanos = l;
        this.period = l2;
    }

    public EventSetting(int n) {
        this(n, false, false, -1L, -1L);
    }

    public EventSetting() {
        this(0);
    }

    public EventSetting(EventDescriptor eventDescriptor, boolean bl, boolean bl2, long l, long l2) {
        this(eventDescriptor.getId(), bl, eventDescriptor.hasStackTrace() ? bl2 : false, l, eventDescriptor.isRequestable() ? l2 : 0L);
    }

    public EventSetting(EventDescriptor eventDescriptor, EventSetting eventSetting) {
        this(eventDescriptor, eventSetting.isEnabled(), eventSetting.isStacktraceEnabled(), eventSetting.getThreshold(), eventSetting.getPeriod());
    }

    public EventSetting(EventInfo eventInfo, boolean bl, boolean bl2, long l, long l2) {
        this(eventInfo.getId(), bl, eventInfo.hasStackTrace() ? bl2 : false, l, eventInfo.isRequestable() ? l2 : 0L);
    }

    public EventSetting(EventInfo eventInfo, EventSetting eventSetting) {
        this(eventInfo, eventSetting.isEnabled(), eventSetting.isStacktraceEnabled(), eventSetting.getThreshold(), eventSetting.getPeriod());
    }

    public EventSetting(int n, EventSetting eventSetting) {
        this(n, eventSetting.isEnabled(), eventSetting.isStacktraceEnabled(), eventSetting.getThreshold(), eventSetting.getPeriod());
    }

    public EventSetting(EventSetting eventSetting, EventSetting eventSetting2) {
        assert (eventSetting.id == eventSetting2.id || eventSetting2.id == 0);
        this.id = eventSetting.id;
        this.enabled = eventSetting.enabled || eventSetting2.enabled;
        this.stacktrace = eventSetting.stacktrace || eventSetting2.stacktrace;
        long l = Math.min(eventSetting.thresholdNanos, eventSetting2.thresholdNanos);
        if (l == -1L) {
            l = Math.max(eventSetting.thresholdNanos, eventSetting2.thresholdNanos);
        }
        this.thresholdNanos = l;
        long l2 = Math.min(eventSetting.period, eventSetting2.period);
        if (l2 == -1L || l2 == 0L) {
            l2 = Math.max(eventSetting.period, eventSetting2.period);
        }
        this.period = l2;
    }

    public EventSetting(EventInfo eventInfo) {
        this(eventInfo.getId());
    }

    public int getId() {
        return this.id;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isStacktraceEnabled() {
        return this.stacktrace;
    }

    public long getThreshold() {
        return this.thresholdNanos;
    }

    public long getPeriod() {
        return this.period;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("{ id=").append(this.id);
        if (this.enabled) {
            stringBuilder.append(", enabled");
        }
        if (this.stacktrace) {
            stringBuilder.append(", stacktrace");
        }
        if (this.thresholdNanos != 0L) {
            stringBuilder.append(", threshold=").append(this.thresholdNanos).append("ns");
        }
        if (this.period != 0L) {
            stringBuilder.append(", period=").append(this.period).append("ms");
        }
        stringBuilder.append(" }");
        return stringBuilder.toString();
    }

    public int hashCode() {
        int n = 17;
        n = 31 * n + this.id;
        n = 31 * n + (this.enabled ? 1 : 0);
        n = 31 * n + (int)(this.thresholdNanos ^ this.thresholdNanos >>> 32);
        n = 31 * n + (int)(this.period ^ this.period >>> 32);
        return n;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof EventSetting) {
            EventSetting eventSetting = (EventSetting)object;
            return eventSetting.id == this.id && eventSetting.enabled == this.enabled && eventSetting.thresholdNanos == this.thresholdNanos && eventSetting.stacktrace == this.stacktrace && eventSetting.period == this.period;
        }
        return false;
    }
}

