/*
 * Decompiled with CFR 0.152.
 */
package org.openide.windows;

import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Window;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.SwingUtilities;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.windows.DummyWindowManager;
import org.openide.windows.Mode;
import org.openide.windows.TopComponent;
import org.openide.windows.TopComponentGroup;
import org.openide.windows.WindowSystemListener;
import org.openide.windows.Workspace;

public abstract class WindowManager
implements Serializable {
    @Deprecated
    public static final String PROP_WORKSPACES = "workspaces";
    @Deprecated
    public static final String PROP_CURRENT_WORKSPACE = "currentWorkspace";
    public static final String PROP_MODES = "modes";
    private static WindowManager dummyInstance;
    static final long serialVersionUID = -4133918059009277602L;
    private Reference<TopComponent> activeComponent = new WeakReference<Object>(null);
    private TopComponent.Registry registry;

    public static final WindowManager getDefault() {
        WindowManager windowManager = (WindowManager)Lookup.getDefault().lookup(WindowManager.class);
        return windowManager != null ? windowManager : WindowManager.getDummyInstance();
    }

    private static synchronized WindowManager getDummyInstance() {
        if (dummyInstance == null) {
            dummyInstance = new DummyWindowManager();
        }
        return dummyInstance;
    }

    public abstract Mode findMode(String var1);

    public abstract Mode findMode(TopComponent var1);

    public abstract Set<? extends Mode> getModes();

    public abstract Frame getMainWindow();

    public abstract void updateUI();

    protected abstract Component createTopComponentManager(TopComponent var1);

    protected TopComponent.Registry componentRegistry() {
        return (TopComponent.Registry)Lookup.getDefault().lookup(TopComponent.Registry.class);
    }

    public synchronized TopComponent.Registry getRegistry() {
        if (this.registry != null) {
            return this.registry;
        }
        this.registry = this.componentRegistry();
        return this.registry;
    }

    @Deprecated
    public final Workspace createWorkspace(String string) {
        return this.createWorkspace(string, string);
    }

    @Deprecated
    public abstract Workspace createWorkspace(String var1, String var2);

    @Deprecated
    public abstract Workspace findWorkspace(String var1);

    @Deprecated
    public abstract Workspace[] getWorkspaces();

    @Deprecated
    public abstract void setWorkspaces(Workspace[] var1);

    @Deprecated
    public abstract Workspace getCurrentWorkspace();

    public abstract TopComponentGroup findTopComponentGroup(String var1);

    public abstract void addPropertyChangeListener(PropertyChangeListener var1);

    public abstract void removePropertyChangeListener(PropertyChangeListener var1);

    @Deprecated
    protected static final Component findComponentManager(TopComponent topComponent) {
        return null;
    }

    protected void activateComponent(TopComponent topComponent) {
        if (this.getActiveComponent() == topComponent) {
            return;
        }
        TopComponent topComponent2 = this.getActiveComponent();
        if (topComponent2 != null) {
            try {
                topComponent2.componentDeactivated();
            }
            catch (Throwable throwable) {
                WindowManager.logThrowable(throwable, "[Winsys] TopComponent " + topComponent2.getClass().getName() + " throws runtime exception from its componentDeactivated() method.\nPlease repair it!");
            }
        }
        this.setActiveComponent(topComponent);
        TopComponent topComponent3 = this.getActiveComponent();
        if (topComponent3 != null) {
            try {
                topComponent3.componentActivated();
            }
            catch (Throwable throwable) {
                WindowManager.logThrowable(throwable, "[Winsys] TopComponent " + topComponent3.getClass().getName() + " throws runtime exception from its componentActivated() method.\nPlease repair it!");
            }
        }
    }

    protected void componentOpenNotify(TopComponent topComponent) {
        try {
            topComponent.componentOpened();
        }
        catch (Throwable throwable) {
            WindowManager.logThrowable(throwable, "[Winsys] TopComponent " + topComponent.getClass().getName() + " throws exception/error from its componentOpened() method.\nPlease repair it!");
        }
    }

    protected void componentCloseNotify(TopComponent topComponent) {
        try {
            topComponent.componentClosed();
        }
        catch (Throwable throwable) {
            WindowManager.logThrowable(throwable, "[Winsys] TopComponent " + topComponent.getClass().getName() + " throws exception/error from its componentClosed() method.\nPlease repair it!");
        }
        if (topComponent == this.getActiveComponent()) {
            this.activateComponent(null);
        }
    }

    protected void componentShowing(TopComponent topComponent) {
        try {
            topComponent.componentShowing();
        }
        catch (Throwable throwable) {
            WindowManager.logThrowable(throwable, "[Winsys] TopComponent " + topComponent.getClass().getName() + " throws runtime exception from its componentShowing() method.\nPlease repair it!");
        }
    }

    protected void componentHidden(TopComponent topComponent) {
        try {
            topComponent.componentHidden();
        }
        catch (Throwable throwable) {
            WindowManager.logThrowable(throwable, "[Winsys] TopComponent " + topComponent.getClass().getName() + " throws runtime exception from its componentHidden() method.\nPlease repair it!");
        }
    }

    private static void logThrowable(Throwable throwable, String string) {
        if (throwable instanceof ThreadDeath || throwable instanceof OutOfMemoryError) {
            throw (Error)throwable;
        }
        Logger.getLogger(WindowManager.class.getName()).log(Level.WARNING, string, throwable);
    }

    protected abstract void topComponentOpen(TopComponent var1);

    protected void topComponentOpenAtTabPosition(TopComponent topComponent, int n) {
        this.topComponentOpen(topComponent);
    }

    protected int topComponentGetTabPosition(TopComponent topComponent) {
        Mode mode = this.findMode(topComponent);
        if (mode == null || !this.topComponentIsOpened(topComponent)) {
            return -1;
        }
        TopComponent[] topComponentArray = mode.getTopComponents();
        for (int i = 0; i < topComponentArray.length; ++i) {
            if (topComponentArray[i] != topComponent) continue;
            return i;
        }
        return -1;
    }

    protected abstract void topComponentClose(TopComponent var1);

    protected abstract void topComponentRequestActive(TopComponent var1);

    protected abstract void topComponentRequestVisible(TopComponent var1);

    protected abstract void topComponentDisplayNameChanged(TopComponent var1, String var2);

    protected abstract void topComponentHtmlDisplayNameChanged(TopComponent var1, String var2);

    protected abstract void topComponentToolTipChanged(TopComponent var1, String var2);

    protected abstract void topComponentIconChanged(TopComponent var1, Image var2);

    protected abstract void topComponentActivatedNodesChanged(TopComponent var1, Node[] var2);

    protected abstract boolean topComponentIsOpened(TopComponent var1);

    protected abstract Action[] topComponentDefaultActions(TopComponent var1);

    protected abstract String topComponentID(TopComponent var1, String var2);

    protected void topComponentRequestAttention(TopComponent topComponent) {
    }

    protected void topComponentToFront(TopComponent topComponent) {
        Window window = SwingUtilities.getWindowAncestor(topComponent);
        if (null != window) {
            Frame frame;
            int n;
            if (window instanceof Frame && ((n = (frame = (Frame)window).getExtendedState()) & 1) > 0) {
                frame.setExtendedState(n & 0xFFFFFFFE);
            }
            window.toFront();
        }
    }

    protected void topComponentCancelRequestAttention(TopComponent topComponent) {
    }

    public String findTopComponentID(TopComponent topComponent) {
        return this.topComponentID(topComponent, topComponent.preferredID());
    }

    public abstract TopComponent findTopComponent(String var1);

    public void invokeWhenUIReady(Runnable runnable) {
        EventQueue.invokeLater(runnable);
    }

    public boolean isEditorTopComponent(TopComponent topComponent) {
        return false;
    }

    public boolean isOpenedEditorTopComponent(TopComponent topComponent) {
        return false;
    }

    public TopComponent[] getOpenedTopComponents(Mode mode) {
        TopComponent[] topComponentArray = mode.getTopComponents();
        ArrayList<TopComponent> arrayList = new ArrayList<TopComponent>(topComponentArray.length);
        for (TopComponent topComponent : topComponentArray) {
            if (!topComponent.isOpened()) continue;
            arrayList.add(topComponent);
        }
        return arrayList.toArray(new TopComponent[arrayList.size()]);
    }

    public boolean isEditorMode(Mode mode) {
        return false;
    }

    private TopComponent getActiveComponent() {
        return this.activeComponent.get();
    }

    private void setActiveComponent(TopComponent topComponent) {
        this.activeComponent = new WeakReference<TopComponent>(topComponent);
    }

    public void addWindowSystemListener(WindowSystemListener windowSystemListener) {
    }

    public void removeWindowSystemListener(WindowSystemListener windowSystemListener) {
    }

    public void setRole(String string) {
    }

    public String getRole() {
        return null;
    }

    @Deprecated
    protected static interface Component
    extends Serializable {
        @Deprecated
        public static final long serialVersionUID = 0L;

        public void open();

        public void open(Workspace var1);

        public void close(Workspace var1);

        public void requestFocus();

        public void requestVisible();

        public Node[] getActivatedNodes();

        public void setActivatedNodes(Node[] var1);

        public void nameChanged();

        public void setIcon(Image var1);

        public Image getIcon();

        public Set<Workspace> whereOpened();
    }
}

