/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.oops;

import java.util.Observable;
import java.util.Observer;
import sun.jvm.hotspot.debugger.OopHandle;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.types.Type;
import sun.jvm.hotspot.types.TypeDataBase;
import sun.jvm.hotspot.types.WrongTypeException;

public class CheckedExceptionElement {
    private static long offsetOfClassCPIndex;
    private OopHandle handle;
    private long offset;

    private static synchronized void initialize(TypeDataBase db) throws WrongTypeException {
        Type type = db.lookupType("CheckedExceptionElement");
        offsetOfClassCPIndex = type.getCIntegerField("class_cp_index").getOffset();
    }

    public CheckedExceptionElement(OopHandle handle, long offset) {
        this.handle = handle;
        this.offset = offset;
    }

    public int getClassCPIndex() {
        return (int)this.handle.getCIntegerAt(this.offset + offsetOfClassCPIndex, 2L, true);
    }

    static {
        VM.registerVMInitializedObserver(new Observer(){

            @Override
            public void update(Observable o, Object data) {
                CheckedExceptionElement.initialize(VM.getVM().getTypeDataBase());
            }
        });
    }
}

