/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.debugger.cdbg.basic;

import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.debugger.cdbg.FieldIdentifier;
import sun.jvm.hotspot.debugger.cdbg.ObjectVisitor;
import sun.jvm.hotspot.debugger.cdbg.Type;
import sun.jvm.hotspot.debugger.cdbg.TypeVisitor;
import sun.jvm.hotspot.debugger.cdbg.basic.BasicCDebugInfoDataBase;
import sun.jvm.hotspot.debugger.cdbg.basic.BasicType;
import sun.jvm.hotspot.debugger.cdbg.basic.ResolveListener;
import sun.jvm.hotspot.utilities.Assert;

public class LazyType
extends BasicType {
    private Object key;
    private int cvAttributes;

    public LazyType(Object key) {
        this(key, 0);
    }

    private LazyType(Object key, int cvAttributes) {
        super(null, 0, cvAttributes);
        if (Assert.ASSERTS_ENABLED) {
            Assert.that(key != null, "key must not be null");
        }
        this.key = key;
        this.cvAttributes = cvAttributes;
    }

    @Override
    public boolean isLazy() {
        return true;
    }

    public Object getKey() {
        return this.key;
    }

    @Override
    Type resolveTypes(BasicCDebugInfoDataBase db, ResolveListener listener) {
        BasicType t = (BasicType)db.resolveType(this, (Type)this, listener, "resolving lazy type");
        if (t.isLazy()) {
            return this;
        }
        if (this.cvAttributes != 0) {
            return t.getCVVariant(this.cvAttributes);
        }
        return t;
    }

    @Override
    public void iterateObject(Address a, ObjectVisitor v, FieldIdentifier f) {
    }

    @Override
    protected Type createCVVariant(int cvAttributes) {
        return new LazyType(this.key, cvAttributes);
    }

    @Override
    public void visit(TypeVisitor v) {
    }
}

