/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.ui;

import com.sun.java.swing.action.ActionManager;
import com.sun.java.swing.action.StateChangeAction;
import com.sun.java.swing.ui.StatusBar;
import com.sun.java.swing.ui.ToggleActionPropertyChangeListener;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;

public abstract class CommonMenuBar
extends JMenuBar {
    protected ActionManager manager;
    private StatusBar statusBar;

    protected CommonMenuBar(ActionManager manager) {
        this(manager, StatusBar.getInstance());
    }

    protected CommonMenuBar(ActionManager manager, StatusBar status) {
        this.manager = manager;
        this.statusBar = status;
        this.configureMenu();
    }

    protected abstract void configureMenu();

    protected void configureToggleMenuItem(JMenuItem menuItem, Action action) {
        this.configureMenuItem(menuItem, action);
        action.addPropertyChangeListener(new ToggleActionPropertyChangeListener(menuItem));
    }

    protected void configureMenuItem(JMenuItem menuItem, Action action) {
        menuItem.addMouseListener(this.statusBar);
    }

    protected JMenu createMenu(String name, char mnemonic) {
        JMenu menu = new JMenu(name);
        menu.setMnemonic(mnemonic);
        return menu;
    }

    protected void addMenuItem(JMenu menu, Action action) {
        JMenuItem menuItem = menu.add(action);
        this.configureMenuItem(menuItem, action);
    }

    protected void addCheckBoxMenuItem(JMenu menu, StateChangeAction a) {
        this.addCheckBoxMenuItem(menu, a, false);
    }

    protected void addCheckBoxMenuItem(JMenu menu, StateChangeAction a, boolean selected) {
        JCheckBoxMenuItem mi = new JCheckBoxMenuItem(a);
        mi.addItemListener(a);
        mi.setSelected(selected);
        menu.add(mi);
        this.configureToggleMenuItem(mi, a);
    }

    protected void addRadioButtonMenuItem(JMenu menu, ButtonGroup group, StateChangeAction a) {
        this.addRadioButtonMenuItem(menu, group, a, false);
    }

    protected void addRadioButtonMenuItem(JMenu menu, ButtonGroup group, StateChangeAction a, boolean selected) {
        JRadioButtonMenuItem mi = new JRadioButtonMenuItem(a);
        mi.addItemListener(a);
        mi.setSelected(selected);
        menu.add(mi);
        if (group != null) {
            group.add(mi);
        }
        this.configureToggleMenuItem(mi, a);
    }
}

