/*
 * Decompiled with CFR 0.152.
 */
package sun.security.provider.certpath;

import java.security.AccessController;
import java.security.InvalidAlgorithmParameterException;
import java.security.cert.CertPath;
import java.security.cert.CertPathParameters;
import java.security.cert.CertPathValidatorException;
import java.security.cert.CertPathValidatorResult;
import java.security.cert.CertPathValidatorSpi;
import java.security.cert.Certificate;
import java.security.cert.PKIXCertPathChecker;
import java.security.cert.PKIXCertPathValidatorResult;
import java.security.cert.PKIXParameters;
import java.security.cert.PKIXReason;
import java.security.cert.PolicyNode;
import java.security.cert.TrustAnchor;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Set;
import sun.security.action.GetBooleanSecurityPropertyAction;
import sun.security.provider.certpath.AdaptableX509CertSelector;
import sun.security.provider.certpath.AlgorithmChecker;
import sun.security.provider.certpath.BasicChecker;
import sun.security.provider.certpath.ConstraintsChecker;
import sun.security.provider.certpath.CrlRevocationChecker;
import sun.security.provider.certpath.KeyChecker;
import sun.security.provider.certpath.OCSPChecker;
import sun.security.provider.certpath.PKIXMasterCertPathValidator;
import sun.security.provider.certpath.PolicyChecker;
import sun.security.provider.certpath.PolicyNodeImpl;
import sun.security.provider.certpath.UntrustedChecker;
import sun.security.util.Debug;
import sun.security.x509.X509CertImpl;

public class PKIXCertPathValidator
extends CertPathValidatorSpi {
    private static final Debug debug = Debug.getInstance("certpath");
    private Date testDate;
    private List<PKIXCertPathChecker> userCheckers;
    private String sigProvider;
    private BasicChecker basicChecker;
    private boolean ocspEnabled = false;
    private boolean onlyEECert = false;

    /*
     * WARNING - void declaration
     */
    @Override
    public CertPathValidatorResult engineValidate(CertPath certPath, CertPathParameters certPathParameters) throws CertPathValidatorException, InvalidAlgorithmParameterException {
        if (debug != null) {
            debug.println("PKIXCertPathValidator.engineValidate()...");
        }
        if (!(certPathParameters instanceof PKIXParameters)) {
            throw new InvalidAlgorithmParameterException("inappropriate parameters, must be an instance of PKIXParameters");
        }
        if (!certPath.getType().equals("X.509") && !certPath.getType().equals("X509")) {
            throw new InvalidAlgorithmParameterException("inappropriate certification path type specified, must be X.509 or X509");
        }
        PKIXParameters pKIXParameters = (PKIXParameters)certPathParameters;
        Set<TrustAnchor> set = pKIXParameters.getTrustAnchors();
        for (TrustAnchor object2 : set) {
            if (object2.getNameConstraints() == null) continue;
            throw new InvalidAlgorithmParameterException("name constraints in trust anchor not supported");
        }
        ArrayList<? extends Certificate> arrayList = new ArrayList<Certificate>(certPath.getCertificates());
        if (debug != null) {
            if (arrayList.isEmpty()) {
                debug.println("PKIXCertPathValidator.engineValidate() certList is empty");
            }
            debug.println("PKIXCertPathValidator.engineValidate() reversing certpath...");
        }
        Collections.reverse(arrayList);
        this.populateVariables(pKIXParameters);
        Object var6_7 = null;
        if (!arrayList.isEmpty()) {
            X509Certificate x509Certificate = (X509Certificate)arrayList.get(0);
        }
        CertPathValidatorException certPathValidatorException = null;
        for (TrustAnchor trustAnchor : set) {
            X509Certificate x509Certificate = trustAnchor.getTrustedCert();
            if (x509Certificate != null) {
                void var6_9;
                if (debug != null) {
                    debug.println("PKIXCertPathValidator.engineValidate() anchor.getTrustedCert() != null");
                }
                if (!this.isWorthTrying(x509Certificate, (X509Certificate)var6_9)) continue;
                if (debug != null) {
                    debug.println("anchor.getTrustedCert().getSubjectX500Principal() = " + x509Certificate.getSubjectX500Principal());
                }
            } else if (debug != null) {
                debug.println("PKIXCertPathValidator.engineValidate(): anchor.getTrustedCert() == null");
            }
            try {
                PolicyNodeImpl policyNodeImpl = new PolicyNodeImpl(null, "2.5.29.32.0", null, false, Collections.singleton("2.5.29.32.0"), false);
                PolicyNode policyNode = this.doValidate(trustAnchor, certPath, (ArrayList<X509Certificate>)arrayList, pKIXParameters, policyNodeImpl);
                return new PKIXCertPathValidatorResult(trustAnchor, policyNode, this.basicChecker.getPublicKey());
            }
            catch (CertPathValidatorException certPathValidatorException2) {
                certPathValidatorException = certPathValidatorException2;
            }
        }
        if (certPathValidatorException != null) {
            throw certPathValidatorException;
        }
        throw new CertPathValidatorException("Path does not chain with any of the trust anchors", null, null, -1, PKIXReason.NO_TRUST_ANCHOR);
    }

    private boolean isWorthTrying(X509Certificate x509Certificate, X509Certificate x509Certificate2) {
        boolean bl = false;
        if (debug != null) {
            debug.println("PKIXCertPathValidator.isWorthTrying() checking if this trusted cert is worth trying ...");
        }
        if (x509Certificate2 == null) {
            return true;
        }
        AdaptableX509CertSelector adaptableX509CertSelector = new AdaptableX509CertSelector();
        adaptableX509CertSelector.setSubject(x509Certificate2.getIssuerX500Principal());
        adaptableX509CertSelector.setValidityPeriod(x509Certificate2.getNotBefore(), x509Certificate2.getNotAfter());
        try {
            X509CertImpl x509CertImpl = X509CertImpl.toImpl(x509Certificate2);
            adaptableX509CertSelector.parseAuthorityKeyIdentifierExtension(x509CertImpl.getAuthorityKeyIdentifierExtension());
            bl = adaptableX509CertSelector.match(x509Certificate);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (debug != null) {
            if (bl) {
                debug.println("YES - try this trustedCert");
            } else {
                debug.println("NO - don't try this trustedCert");
            }
        }
        return bl;
    }

    private void populateVariables(PKIXParameters pKIXParameters) {
        this.testDate = pKIXParameters.getDate();
        if (this.testDate == null) {
            this.testDate = new Date(System.currentTimeMillis());
        }
        this.userCheckers = pKIXParameters.getCertPathCheckers();
        this.sigProvider = pKIXParameters.getSigProvider();
        if (pKIXParameters.isRevocationEnabled()) {
            this.ocspEnabled = AccessController.doPrivileged(new GetBooleanSecurityPropertyAction("ocsp.enable"));
            this.onlyEECert = AccessController.doPrivileged(new GetBooleanSecurityPropertyAction("com.sun.security.onlyCheckRevocationOfEECert"));
        }
    }

    private PolicyNode doValidate(TrustAnchor trustAnchor, CertPath certPath, ArrayList<X509Certificate> arrayList, PKIXParameters pKIXParameters, PolicyNodeImpl policyNodeImpl) throws CertPathValidatorException {
        Object object;
        int n = arrayList.size();
        this.basicChecker = new BasicChecker(trustAnchor, this.testDate, this.sigProvider, false);
        AlgorithmChecker algorithmChecker = new AlgorithmChecker(trustAnchor);
        KeyChecker keyChecker = new KeyChecker(n, pKIXParameters.getTargetCertConstraints());
        ConstraintsChecker constraintsChecker = new ConstraintsChecker(n);
        PolicyChecker policyChecker = new PolicyChecker(pKIXParameters.getInitialPolicies(), n, pKIXParameters.isExplicitPolicyRequired(), pKIXParameters.isPolicyMappingInhibited(), pKIXParameters.isAnyPolicyInhibited(), pKIXParameters.getPolicyQualifiersRejected(), policyNodeImpl);
        UntrustedChecker untrustedChecker = new UntrustedChecker();
        ArrayList<PKIXCertPathChecker> arrayList2 = new ArrayList<PKIXCertPathChecker>();
        arrayList2.add(untrustedChecker);
        arrayList2.add(algorithmChecker);
        arrayList2.add(keyChecker);
        arrayList2.add(constraintsChecker);
        arrayList2.add(policyChecker);
        arrayList2.add(this.basicChecker);
        if (pKIXParameters.isRevocationEnabled()) {
            if (this.ocspEnabled) {
                object = new OCSPChecker(certPath, pKIXParameters, this.onlyEECert);
                arrayList2.add((PKIXCertPathChecker)object);
            }
            object = new CrlRevocationChecker(trustAnchor, pKIXParameters, arrayList, this.onlyEECert);
            arrayList2.add((PKIXCertPathChecker)object);
        }
        arrayList2.addAll(this.userCheckers);
        object = new PKIXMasterCertPathValidator(arrayList2);
        ((PKIXMasterCertPathValidator)object).validate(certPath, arrayList);
        return policyChecker.getPolicyTree();
    }
}

