/*
 * Decompiled with CFR 0.152.
 */
package sun.org.mozilla.javascript.internal.optimizer;

import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.List;
import sun.org.mozilla.classfile.internal.ClassFileWriter;
import sun.org.mozilla.javascript.internal.CompilerEnvirons;
import sun.org.mozilla.javascript.internal.Context;
import sun.org.mozilla.javascript.internal.Evaluator;
import sun.org.mozilla.javascript.internal.Function;
import sun.org.mozilla.javascript.internal.GeneratedClassLoader;
import sun.org.mozilla.javascript.internal.Kit;
import sun.org.mozilla.javascript.internal.NativeFunction;
import sun.org.mozilla.javascript.internal.ObjArray;
import sun.org.mozilla.javascript.internal.ObjToIntMap;
import sun.org.mozilla.javascript.internal.RhinoException;
import sun.org.mozilla.javascript.internal.Script;
import sun.org.mozilla.javascript.internal.ScriptRuntime;
import sun.org.mozilla.javascript.internal.Scriptable;
import sun.org.mozilla.javascript.internal.SecurityController;
import sun.org.mozilla.javascript.internal.ast.FunctionNode;
import sun.org.mozilla.javascript.internal.ast.Name;
import sun.org.mozilla.javascript.internal.ast.ScriptNode;
import sun.org.mozilla.javascript.internal.optimizer.BodyCodegen;
import sun.org.mozilla.javascript.internal.optimizer.OptFunctionNode;
import sun.org.mozilla.javascript.internal.optimizer.OptTransformer;
import sun.org.mozilla.javascript.internal.optimizer.Optimizer;

public class Codegen
implements Evaluator {
    static final String DEFAULT_MAIN_METHOD_CLASS = "sun.org.mozilla.javascript.internal.optimizer.OptRuntime";
    private static final String SUPER_CLASS_NAME = "sun.org.mozilla.javascript.internal.NativeFunction";
    static final String DIRECT_CALL_PARENT_FIELD = "_dcp";
    private static final String ID_FIELD_NAME = "_id";
    private static final String REGEXP_INIT_METHOD_NAME = "_reInit";
    private static final String REGEXP_INIT_METHOD_SIGNATURE = "(Lsun/org/mozilla/javascript/internal/RegExpProxy;Lsun/org/mozilla/javascript/internal/Context;)V";
    static final String REGEXP_ARRAY_FIELD_NAME = "_re";
    static final String REGEXP_ARRAY_FIELD_TYPE = "[Ljava/lang/Object;";
    static final String FUNCTION_INIT_SIGNATURE = "(Lsun/org/mozilla/javascript/internal/Context;Lsun/org/mozilla/javascript/internal/Scriptable;)V";
    static final String FUNCTION_CONSTRUCTOR_SIGNATURE = "(Lsun/org/mozilla/javascript/internal/Scriptable;Lsun/org/mozilla/javascript/internal/Context;I)V";
    private static final Object globalLock = new Object();
    private static int globalSerialClassCounter;
    private CompilerEnvirons compilerEnv;
    private ObjArray directCallTargets;
    ScriptNode[] scriptOrFnNodes;
    private ObjToIntMap scriptOrFnIndexes;
    private String mainMethodClass = "sun.org.mozilla.javascript.internal.optimizer.OptRuntime";
    String mainClassName;
    String mainClassSignature;
    private double[] itsConstantList;
    private int itsConstantListSize;

    @Override
    public void captureStackInfo(RhinoException rhinoException) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getSourcePositionFromStack(Context context, int[] nArray) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getPatchedStack(RhinoException rhinoException, String string) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<String> getScriptStack(RhinoException rhinoException) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setEvalScriptFlag(Script script) {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object compile(CompilerEnvirons compilerEnvirons, ScriptNode scriptNode, String string, boolean bl) {
        int n;
        Object object = globalLock;
        synchronized (object) {
            n = ++globalSerialClassCounter;
        }
        object = "c";
        if (scriptNode.getSourceName().length() > 0 && !Character.isJavaIdentifierStart(((String)(object = scriptNode.getSourceName().replaceAll("\\W", "_"))).charAt(0))) {
            object = "_" + (String)object;
        }
        String string2 = "sun.org.mozilla.javascript.internal.gen." + (String)object + "_" + n;
        byte[] byArray = this.compileToClassFile(compilerEnvirons, string2, scriptNode, string, bl);
        return new Object[]{string2, byArray};
    }

    @Override
    public Script createScriptObject(Object object, Object object2) {
        Script script;
        Class<?> clazz = this.defineClass(object, object2);
        try {
            script = (Script)clazz.newInstance();
        }
        catch (Exception exception) {
            throw new RuntimeException("Unable to instantiate compiled class:" + exception.toString());
        }
        return script;
    }

    @Override
    public Function createFunctionObject(Context context, Scriptable scriptable, Object object, Object object2) {
        NativeFunction nativeFunction;
        Class<?> clazz = this.defineClass(object, object2);
        try {
            Constructor<?> constructor = clazz.getConstructors()[0];
            Object[] objectArray = new Object[]{scriptable, context, 0};
            nativeFunction = (NativeFunction)constructor.newInstance(objectArray);
        }
        catch (Exception exception) {
            throw new RuntimeException("Unable to instantiate compiled class:" + exception.toString());
        }
        return nativeFunction;
    }

    private Class<?> defineClass(Object object, Object object2) {
        RuntimeException runtimeException;
        Object[] objectArray = (Object[])object;
        String string = (String)objectArray[0];
        byte[] byArray = (byte[])objectArray[1];
        ClassLoader classLoader = this.getClass().getClassLoader();
        GeneratedClassLoader generatedClassLoader = SecurityController.createLoader(classLoader, object2);
        try {
            Class<?> clazz = generatedClassLoader.defineClass(string, byArray);
            generatedClassLoader.linkClass(clazz);
            return clazz;
        }
        catch (SecurityException securityException) {
            runtimeException = securityException;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            runtimeException = illegalArgumentException;
        }
        throw new RuntimeException("Malformed optimizer package " + runtimeException);
    }

    byte[] compileToClassFile(CompilerEnvirons compilerEnvirons, String string, ScriptNode scriptNode, String string2, boolean bl) {
        this.compilerEnv = compilerEnvirons;
        this.transform(scriptNode);
        if (bl) {
            scriptNode = scriptNode.getFunctionNode(0);
        }
        this.initScriptNodesData(scriptNode);
        this.mainClassName = string;
        this.mainClassSignature = ClassFileWriter.classNameToSignature(string);
        try {
            return this.generateCode(string2);
        }
        catch (ClassFileWriter.ClassFileFormatException classFileFormatException) {
            throw this.reportClassFileFormatException(scriptNode, classFileFormatException.getMessage());
        }
    }

    private RuntimeException reportClassFileFormatException(ScriptNode scriptNode, String string) {
        String string2 = scriptNode instanceof FunctionNode ? ScriptRuntime.getMessage2("msg.while.compiling.fn", ((FunctionNode)scriptNode).getFunctionName(), string) : ScriptRuntime.getMessage1("msg.while.compiling.script", string);
        return Context.reportRuntimeError(string2, scriptNode.getSourceName(), scriptNode.getLineno(), null, 0);
    }

    private void transform(ScriptNode scriptNode) {
        Codegen.initOptFunctions_r(scriptNode);
        int n = this.compilerEnv.getOptimizationLevel();
        HashMap<String, OptFunctionNode> hashMap = null;
        if (n > 0 && scriptNode.getType() == 136) {
            int n2 = scriptNode.getFunctionCount();
            for (int i = 0; i != n2; ++i) {
                String string;
                OptFunctionNode optFunctionNode = OptFunctionNode.get(scriptNode, i);
                if (optFunctionNode.fnode.getFunctionType() != 1 || (string = optFunctionNode.fnode.getName()).length() == 0) continue;
                if (hashMap == null) {
                    hashMap = new HashMap<String, OptFunctionNode>();
                }
                hashMap.put(string, optFunctionNode);
            }
        }
        if (hashMap != null) {
            this.directCallTargets = new ObjArray();
        }
        OptTransformer optTransformer = new OptTransformer(hashMap, this.directCallTargets);
        optTransformer.transform(scriptNode);
        if (n > 0) {
            new Optimizer().optimize(scriptNode);
        }
    }

    private static void initOptFunctions_r(ScriptNode scriptNode) {
        int n = scriptNode.getFunctionCount();
        for (int i = 0; i != n; ++i) {
            FunctionNode functionNode = scriptNode.getFunctionNode(i);
            new OptFunctionNode(functionNode);
            Codegen.initOptFunctions_r(functionNode);
        }
    }

    private void initScriptNodesData(ScriptNode scriptNode) {
        ObjArray objArray = new ObjArray();
        Codegen.collectScriptNodes_r(scriptNode, objArray);
        int n = objArray.size();
        this.scriptOrFnNodes = new ScriptNode[n];
        objArray.toArray(this.scriptOrFnNodes);
        this.scriptOrFnIndexes = new ObjToIntMap(n);
        for (int i = 0; i != n; ++i) {
            this.scriptOrFnIndexes.put(this.scriptOrFnNodes[i], i);
        }
    }

    private static void collectScriptNodes_r(ScriptNode scriptNode, ObjArray objArray) {
        objArray.add(scriptNode);
        int n = scriptNode.getFunctionCount();
        for (int i = 0; i != n; ++i) {
            Codegen.collectScriptNodes_r(scriptNode.getFunctionNode(i), objArray);
        }
    }

    private byte[] generateCode(String string) {
        int n;
        boolean bl = this.scriptOrFnNodes[0].getType() == 136;
        boolean bl2 = this.scriptOrFnNodes.length > 1 || !bl;
        String string2 = null;
        if (this.compilerEnv.isGenerateDebugInfo()) {
            string2 = this.scriptOrFnNodes[0].getSourceName();
        }
        ClassFileWriter classFileWriter = new ClassFileWriter(this.mainClassName, SUPER_CLASS_NAME, string2);
        classFileWriter.addField(ID_FIELD_NAME, "I", (short)2);
        classFileWriter.addField(DIRECT_CALL_PARENT_FIELD, this.mainClassSignature, (short)2);
        classFileWriter.addField(REGEXP_ARRAY_FIELD_NAME, REGEXP_ARRAY_FIELD_TYPE, (short)2);
        if (bl2) {
            this.generateFunctionConstructor(classFileWriter);
        }
        if (bl) {
            classFileWriter.addInterface("sun/org/mozilla/javascript/internal/Script");
            this.generateScriptCtor(classFileWriter);
            this.generateMain(classFileWriter);
            this.generateExecute(classFileWriter);
        }
        this.generateCallMethod(classFileWriter);
        this.generateResumeGenerator(classFileWriter);
        this.generateNativeFunctionOverrides(classFileWriter, string);
        int n2 = this.scriptOrFnNodes.length;
        for (n = 0; n != n2; ++n) {
            ScriptNode scriptNode = this.scriptOrFnNodes[n];
            BodyCodegen bodyCodegen = new BodyCodegen();
            bodyCodegen.cfw = classFileWriter;
            bodyCodegen.codegen = this;
            bodyCodegen.compilerEnv = this.compilerEnv;
            bodyCodegen.scriptOrFn = scriptNode;
            bodyCodegen.scriptOrFnIndex = n;
            try {
                bodyCodegen.generateBodyCode();
            }
            catch (ClassFileWriter.ClassFileFormatException classFileFormatException) {
                throw this.reportClassFileFormatException(scriptNode, classFileFormatException.getMessage());
            }
            if (scriptNode.getType() != 109) continue;
            OptFunctionNode optFunctionNode = OptFunctionNode.get(scriptNode);
            this.generateFunctionInit(classFileWriter, optFunctionNode);
            if (!optFunctionNode.isTargetOfDirectCall()) continue;
            this.emitDirectConstructor(classFileWriter, optFunctionNode);
        }
        if (this.directCallTargets != null) {
            n = this.directCallTargets.size();
            for (int i = 0; i != n; ++i) {
                classFileWriter.addField(Codegen.getDirectTargetFieldName(i), this.mainClassSignature, (short)2);
            }
        }
        this.emitRegExpInit(classFileWriter);
        this.emitConstantDudeInitializers(classFileWriter);
        return classFileWriter.toByteArray();
    }

    private void emitDirectConstructor(ClassFileWriter classFileWriter, OptFunctionNode optFunctionNode) {
        int n;
        classFileWriter.startMethod(this.getDirectCtorName(optFunctionNode.fnode), this.getBodyMethodSignature(optFunctionNode.fnode), (short)10);
        int n2 = optFunctionNode.fnode.getParamCount();
        int n3 = 4 + n2 * 3 + 1;
        classFileWriter.addALoad(0);
        classFileWriter.addALoad(1);
        classFileWriter.addALoad(2);
        classFileWriter.addInvoke(182, "sun/org/mozilla/javascript/internal/BaseFunction", "createObject", "(Lsun/org/mozilla/javascript/internal/Context;Lsun/org/mozilla/javascript/internal/Scriptable;)Lsun/org/mozilla/javascript/internal/Scriptable;");
        classFileWriter.addAStore(n3);
        classFileWriter.addALoad(0);
        classFileWriter.addALoad(1);
        classFileWriter.addALoad(2);
        classFileWriter.addALoad(n3);
        for (n = 0; n < n2; ++n) {
            classFileWriter.addALoad(4 + n * 3);
            classFileWriter.addDLoad(5 + n * 3);
        }
        classFileWriter.addALoad(4 + n2 * 3);
        classFileWriter.addInvoke(184, this.mainClassName, this.getBodyMethodName(optFunctionNode.fnode), this.getBodyMethodSignature(optFunctionNode.fnode));
        n = classFileWriter.acquireLabel();
        classFileWriter.add(89);
        classFileWriter.add(193, "sun/org/mozilla/javascript/internal/Scriptable");
        classFileWriter.add(153, n);
        classFileWriter.add(192, "sun/org/mozilla/javascript/internal/Scriptable");
        classFileWriter.add(176);
        classFileWriter.markLabel(n);
        classFileWriter.addALoad(n3);
        classFileWriter.add(176);
        classFileWriter.stopMethod((short)(n3 + 1));
    }

    static boolean isGenerator(ScriptNode scriptNode) {
        return scriptNode.getType() == 109 && ((FunctionNode)scriptNode).isGenerator();
    }

    private void generateResumeGenerator(ClassFileWriter classFileWriter) {
        int n;
        boolean bl = false;
        for (n = 0; n < this.scriptOrFnNodes.length; ++n) {
            if (!Codegen.isGenerator(this.scriptOrFnNodes[n])) continue;
            bl = true;
        }
        if (!bl) {
            return;
        }
        classFileWriter.startMethod("resumeGenerator", "(Lsun/org/mozilla/javascript/internal/Context;Lsun/org/mozilla/javascript/internal/Scriptable;ILjava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;", (short)17);
        classFileWriter.addALoad(0);
        classFileWriter.addALoad(1);
        classFileWriter.addALoad(2);
        classFileWriter.addALoad(4);
        classFileWriter.addALoad(5);
        classFileWriter.addILoad(3);
        classFileWriter.addLoadThis();
        classFileWriter.add(180, classFileWriter.getClassName(), ID_FIELD_NAME, "I");
        n = classFileWriter.addTableSwitch(0, this.scriptOrFnNodes.length - 1);
        classFileWriter.markTableSwitchDefault(n);
        int n2 = classFileWriter.acquireLabel();
        for (int i = 0; i < this.scriptOrFnNodes.length; ++i) {
            ScriptNode scriptNode = this.scriptOrFnNodes[i];
            classFileWriter.markTableSwitchCase(n, i, 6);
            if (Codegen.isGenerator(scriptNode)) {
                String string = "(" + this.mainClassSignature + "Lsun/org/mozilla/javascript/internal/Context;" + "Lsun/org/mozilla/javascript/internal/Scriptable;" + "Ljava/lang/Object;" + "Ljava/lang/Object;I)Ljava/lang/Object;";
                classFileWriter.addInvoke(184, this.mainClassName, this.getBodyMethodName(scriptNode) + "_gen", string);
                classFileWriter.add(176);
                continue;
            }
            classFileWriter.add(167, n2);
        }
        classFileWriter.markLabel(n2);
        Codegen.pushUndefined(classFileWriter);
        classFileWriter.add(176);
        classFileWriter.stopMethod((short)6);
    }

    private void generateCallMethod(ClassFileWriter classFileWriter) {
        classFileWriter.startMethod("call", "(Lsun/org/mozilla/javascript/internal/Context;Lsun/org/mozilla/javascript/internal/Scriptable;Lsun/org/mozilla/javascript/internal/Scriptable;[Ljava/lang/Object;)Ljava/lang/Object;", (short)17);
        int n = classFileWriter.acquireLabel();
        classFileWriter.addALoad(1);
        classFileWriter.addInvoke(184, "sun/org/mozilla/javascript/internal/ScriptRuntime", "hasTopCall", "(Lsun/org/mozilla/javascript/internal/Context;)Z");
        classFileWriter.add(154, n);
        classFileWriter.addALoad(0);
        classFileWriter.addALoad(1);
        classFileWriter.addALoad(2);
        classFileWriter.addALoad(3);
        classFileWriter.addALoad(4);
        classFileWriter.addInvoke(184, "sun/org/mozilla/javascript/internal/ScriptRuntime", "doTopCall", "(Lsun/org/mozilla/javascript/internal/Callable;Lsun/org/mozilla/javascript/internal/Context;Lsun/org/mozilla/javascript/internal/Scriptable;Lsun/org/mozilla/javascript/internal/Scriptable;[Ljava/lang/Object;)Ljava/lang/Object;");
        classFileWriter.add(176);
        classFileWriter.markLabel(n);
        classFileWriter.addALoad(0);
        classFileWriter.addALoad(1);
        classFileWriter.addALoad(2);
        classFileWriter.addALoad(3);
        classFileWriter.addALoad(4);
        int n2 = this.scriptOrFnNodes.length;
        boolean bl = 2 <= n2;
        int n3 = 0;
        short s = 0;
        if (bl) {
            classFileWriter.addLoadThis();
            classFileWriter.add(180, classFileWriter.getClassName(), ID_FIELD_NAME, "I");
            n3 = classFileWriter.addTableSwitch(1, n2 - 1);
        }
        for (int i = 0; i != n2; ++i) {
            int n4;
            OptFunctionNode optFunctionNode;
            ScriptNode scriptNode = this.scriptOrFnNodes[i];
            if (bl) {
                if (i == 0) {
                    classFileWriter.markTableSwitchDefault(n3);
                    s = classFileWriter.getStackTop();
                } else {
                    classFileWriter.markTableSwitchCase(n3, i - 1, s);
                }
            }
            if (scriptNode.getType() == 109 && (optFunctionNode = OptFunctionNode.get(scriptNode)).isTargetOfDirectCall() && (n4 = optFunctionNode.fnode.getParamCount()) != 0) {
                for (int j = 0; j != n4; ++j) {
                    classFileWriter.add(190);
                    classFileWriter.addPush(j);
                    int n5 = classFileWriter.acquireLabel();
                    int n6 = classFileWriter.acquireLabel();
                    classFileWriter.add(164, n5);
                    classFileWriter.addALoad(4);
                    classFileWriter.addPush(j);
                    classFileWriter.add(50);
                    classFileWriter.add(167, n6);
                    classFileWriter.markLabel(n5);
                    Codegen.pushUndefined(classFileWriter);
                    classFileWriter.markLabel(n6);
                    classFileWriter.adjustStackTop(-1);
                    classFileWriter.addPush(0.0);
                    classFileWriter.addALoad(4);
                }
            }
            classFileWriter.addInvoke(184, this.mainClassName, this.getBodyMethodName(scriptNode), this.getBodyMethodSignature(scriptNode));
            classFileWriter.add(176);
        }
        classFileWriter.stopMethod((short)5);
    }

    private void generateMain(ClassFileWriter classFileWriter) {
        classFileWriter.startMethod("main", "([Ljava/lang/String;)V", (short)9);
        classFileWriter.add(187, classFileWriter.getClassName());
        classFileWriter.add(89);
        classFileWriter.addInvoke(183, classFileWriter.getClassName(), "<init>", "()V");
        classFileWriter.add(42);
        classFileWriter.addInvoke(184, this.mainMethodClass, "main", "(Lsun/org/mozilla/javascript/internal/Script;[Ljava/lang/String;)V");
        classFileWriter.add(177);
        classFileWriter.stopMethod((short)1);
    }

    private void generateExecute(ClassFileWriter classFileWriter) {
        classFileWriter.startMethod("exec", "(Lsun/org/mozilla/javascript/internal/Context;Lsun/org/mozilla/javascript/internal/Scriptable;)Ljava/lang/Object;", (short)17);
        classFileWriter.addLoadThis();
        classFileWriter.addALoad(1);
        classFileWriter.addALoad(2);
        classFileWriter.add(89);
        classFileWriter.add(1);
        classFileWriter.addInvoke(182, classFileWriter.getClassName(), "call", "(Lsun/org/mozilla/javascript/internal/Context;Lsun/org/mozilla/javascript/internal/Scriptable;Lsun/org/mozilla/javascript/internal/Scriptable;[Ljava/lang/Object;)Ljava/lang/Object;");
        classFileWriter.add(176);
        classFileWriter.stopMethod((short)3);
    }

    private void generateScriptCtor(ClassFileWriter classFileWriter) {
        classFileWriter.startMethod("<init>", "()V", (short)1);
        classFileWriter.addLoadThis();
        classFileWriter.addInvoke(183, SUPER_CLASS_NAME, "<init>", "()V");
        classFileWriter.addLoadThis();
        classFileWriter.addPush(0);
        classFileWriter.add(181, classFileWriter.getClassName(), ID_FIELD_NAME, "I");
        classFileWriter.add(177);
        classFileWriter.stopMethod((short)1);
    }

    private void generateFunctionConstructor(ClassFileWriter classFileWriter) {
        classFileWriter.startMethod("<init>", FUNCTION_CONSTRUCTOR_SIGNATURE, (short)1);
        classFileWriter.addALoad(0);
        classFileWriter.addInvoke(183, SUPER_CLASS_NAME, "<init>", "()V");
        classFileWriter.addLoadThis();
        classFileWriter.addILoad(3);
        classFileWriter.add(181, classFileWriter.getClassName(), ID_FIELD_NAME, "I");
        classFileWriter.addLoadThis();
        classFileWriter.addALoad(2);
        classFileWriter.addALoad(1);
        int n = this.scriptOrFnNodes[0].getType() == 136 ? 1 : 0;
        int n2 = this.scriptOrFnNodes.length;
        if (n == n2) {
            throw Codegen.badTree();
        }
        boolean bl = 2 <= n2 - n;
        int n3 = 0;
        short s = 0;
        if (bl) {
            classFileWriter.addILoad(3);
            n3 = classFileWriter.addTableSwitch(n + 1, n2 - 1);
        }
        for (int i = n; i != n2; ++i) {
            if (bl) {
                if (i == n) {
                    classFileWriter.markTableSwitchDefault(n3);
                    s = classFileWriter.getStackTop();
                } else {
                    classFileWriter.markTableSwitchCase(n3, i - 1 - n, s);
                }
            }
            OptFunctionNode optFunctionNode = OptFunctionNode.get(this.scriptOrFnNodes[i]);
            classFileWriter.addInvoke(183, this.mainClassName, this.getFunctionInitMethodName(optFunctionNode), FUNCTION_INIT_SIGNATURE);
            classFileWriter.add(177);
        }
        classFileWriter.stopMethod((short)4);
    }

    private void generateFunctionInit(ClassFileWriter classFileWriter, OptFunctionNode optFunctionNode) {
        classFileWriter.startMethod(this.getFunctionInitMethodName(optFunctionNode), FUNCTION_INIT_SIGNATURE, (short)18);
        classFileWriter.addLoadThis();
        classFileWriter.addALoad(1);
        classFileWriter.addALoad(2);
        classFileWriter.addInvoke(182, "sun/org/mozilla/javascript/internal/NativeFunction", "initScriptFunction", FUNCTION_INIT_SIGNATURE);
        int n = optFunctionNode.fnode.getRegexpCount();
        if (n != 0) {
            classFileWriter.addLoadThis();
            this.pushRegExpArray(classFileWriter, optFunctionNode.fnode, 1, 2);
            classFileWriter.add(181, this.mainClassName, REGEXP_ARRAY_FIELD_NAME, REGEXP_ARRAY_FIELD_TYPE);
        }
        classFileWriter.add(177);
        classFileWriter.stopMethod((short)3);
    }

    private void generateNativeFunctionOverrides(ClassFileWriter classFileWriter, String string) {
        classFileWriter.startMethod("getLanguageVersion", "()I", (short)1);
        classFileWriter.addPush(this.compilerEnv.getLanguageVersion());
        classFileWriter.add(172);
        classFileWriter.stopMethod((short)1);
        for (int i = 0; i != 6; ++i) {
            short s;
            if (i == 4 && string == null) continue;
            switch (i) {
                case 0: {
                    s = 1;
                    classFileWriter.startMethod("getFunctionName", "()Ljava/lang/String;", (short)1);
                    break;
                }
                case 1: {
                    s = 1;
                    classFileWriter.startMethod("getParamCount", "()I", (short)1);
                    break;
                }
                case 2: {
                    s = 1;
                    classFileWriter.startMethod("getParamAndVarCount", "()I", (short)1);
                    break;
                }
                case 3: {
                    s = 2;
                    classFileWriter.startMethod("getParamOrVarName", "(I)Ljava/lang/String;", (short)1);
                    break;
                }
                case 5: {
                    s = 3;
                    classFileWriter.startMethod("getParamOrVarConst", "(I)Z", (short)1);
                    break;
                }
                case 4: {
                    s = 1;
                    classFileWriter.startMethod("getEncodedSource", "()Ljava/lang/String;", (short)1);
                    classFileWriter.addPush(string);
                    break;
                }
                default: {
                    throw Kit.codeBug();
                }
            }
            int n = this.scriptOrFnNodes.length;
            int n2 = 0;
            int n3 = 0;
            if (n > 1) {
                classFileWriter.addLoadThis();
                classFileWriter.add(180, classFileWriter.getClassName(), ID_FIELD_NAME, "I");
                n2 = classFileWriter.addTableSwitch(1, n - 1);
            }
            block17: for (int j = 0; j != n; ++j) {
                ScriptNode scriptNode = this.scriptOrFnNodes[j];
                if (j == 0) {
                    if (n > 1) {
                        classFileWriter.markTableSwitchDefault(n2);
                        n3 = classFileWriter.getStackTop();
                    }
                } else {
                    classFileWriter.markTableSwitchCase(n2, j - 1, n3);
                }
                switch (i) {
                    case 0: {
                        if (scriptNode.getType() == 136) {
                            classFileWriter.addPush("");
                        } else {
                            String string2 = ((FunctionNode)scriptNode).getName();
                            classFileWriter.addPush(string2);
                        }
                        classFileWriter.add(176);
                        continue block17;
                    }
                    case 1: {
                        classFileWriter.addPush(scriptNode.getParamCount());
                        classFileWriter.add(172);
                        continue block17;
                    }
                    case 2: {
                        classFileWriter.addPush(scriptNode.getParamAndVarCount());
                        classFileWriter.add(172);
                        continue block17;
                    }
                    case 3: {
                        int n4;
                        int n5 = scriptNode.getParamAndVarCount();
                        if (n5 == 0) {
                            classFileWriter.add(1);
                            classFileWriter.add(176);
                            continue block17;
                        }
                        if (n5 == 1) {
                            classFileWriter.addPush(scriptNode.getParamOrVarName(0));
                            classFileWriter.add(176);
                            continue block17;
                        }
                        classFileWriter.addILoad(1);
                        int n6 = classFileWriter.addTableSwitch(1, n5 - 1);
                        for (n4 = 0; n4 != n5; ++n4) {
                            if (classFileWriter.getStackTop() != 0) {
                                Kit.codeBug();
                            }
                            String string3 = scriptNode.getParamOrVarName(n4);
                            if (n4 == 0) {
                                classFileWriter.markTableSwitchDefault(n6);
                            } else {
                                classFileWriter.markTableSwitchCase(n6, n4 - 1, 0);
                            }
                            classFileWriter.addPush(string3);
                            classFileWriter.add(176);
                        }
                        continue block17;
                    }
                    case 5: {
                        int n7 = scriptNode.getParamAndVarCount();
                        boolean[] blArray = scriptNode.getParamAndVarConst();
                        if (n7 == 0) {
                            classFileWriter.add(3);
                            classFileWriter.add(172);
                            continue block17;
                        }
                        if (n7 == 1) {
                            classFileWriter.addPush(blArray[0]);
                            classFileWriter.add(172);
                            continue block17;
                        }
                        classFileWriter.addILoad(1);
                        int n4 = classFileWriter.addTableSwitch(1, n7 - 1);
                        for (int k = 0; k != n7; ++k) {
                            if (classFileWriter.getStackTop() != 0) {
                                Kit.codeBug();
                            }
                            if (k == 0) {
                                classFileWriter.markTableSwitchDefault(n4);
                            } else {
                                classFileWriter.markTableSwitchCase(n4, k - 1, 0);
                            }
                            classFileWriter.addPush(blArray[k]);
                            classFileWriter.add(172);
                        }
                        continue block17;
                    }
                    case 4: {
                        classFileWriter.addPush(scriptNode.getEncodedSourceStart());
                        classFileWriter.addPush(scriptNode.getEncodedSourceEnd());
                        classFileWriter.addInvoke(182, "java/lang/String", "substring", "(II)Ljava/lang/String;");
                        classFileWriter.add(176);
                        continue block17;
                    }
                    default: {
                        throw Kit.codeBug();
                    }
                }
            }
            classFileWriter.stopMethod(s);
        }
    }

    private void emitRegExpInit(ClassFileWriter classFileWriter) {
        int n;
        int n2 = 0;
        for (n = 0; n != this.scriptOrFnNodes.length; ++n) {
            n2 += this.scriptOrFnNodes[n].getRegexpCount();
        }
        if (n2 == 0) {
            return;
        }
        classFileWriter.startMethod(REGEXP_INIT_METHOD_NAME, REGEXP_INIT_METHOD_SIGNATURE, (short)42);
        classFileWriter.addField("_reInitDone", "Z", (short)10);
        classFileWriter.add(178, this.mainClassName, "_reInitDone", "Z");
        n = classFileWriter.acquireLabel();
        classFileWriter.add(153, n);
        classFileWriter.add(177);
        classFileWriter.markLabel(n);
        for (int i = 0; i != this.scriptOrFnNodes.length; ++i) {
            ScriptNode scriptNode = this.scriptOrFnNodes[i];
            int n3 = scriptNode.getRegexpCount();
            for (int j = 0; j != n3; ++j) {
                String string = this.getCompiledRegexpName(scriptNode, j);
                String string2 = "Ljava/lang/Object;";
                String string3 = scriptNode.getRegexpString(j);
                String string4 = scriptNode.getRegexpFlags(j);
                classFileWriter.addField(string, string2, (short)10);
                classFileWriter.addALoad(0);
                classFileWriter.addALoad(1);
                classFileWriter.addPush(string3);
                if (string4 == null) {
                    classFileWriter.add(1);
                } else {
                    classFileWriter.addPush(string4);
                }
                classFileWriter.addInvoke(185, "sun/org/mozilla/javascript/internal/RegExpProxy", "compileRegExp", "(Lsun/org/mozilla/javascript/internal/Context;Ljava/lang/String;Ljava/lang/String;)Ljava/lang/Object;");
                classFileWriter.add(179, this.mainClassName, string, string2);
            }
        }
        classFileWriter.addPush(1);
        classFileWriter.add(179, this.mainClassName, "_reInitDone", "Z");
        classFileWriter.add(177);
        classFileWriter.stopMethod((short)2);
    }

    private void emitConstantDudeInitializers(ClassFileWriter classFileWriter) {
        int n = this.itsConstantListSize;
        if (n == 0) {
            return;
        }
        classFileWriter.startMethod("<clinit>", "()V", (short)24);
        double[] dArray = this.itsConstantList;
        for (int i = 0; i != n; ++i) {
            double d = dArray[i];
            String string = "_k" + i;
            String string2 = Codegen.getStaticConstantWrapperType(d);
            classFileWriter.addField(string, string2, (short)10);
            int n2 = (int)d;
            if ((double)n2 == d) {
                classFileWriter.add(187, "java/lang/Integer");
                classFileWriter.add(89);
                classFileWriter.addPush(n2);
                classFileWriter.addInvoke(183, "java/lang/Integer", "<init>", "(I)V");
            } else {
                classFileWriter.addPush(d);
                Codegen.addDoubleWrap(classFileWriter);
            }
            classFileWriter.add(179, this.mainClassName, string, string2);
        }
        classFileWriter.add(177);
        classFileWriter.stopMethod((short)0);
    }

    void pushRegExpArray(ClassFileWriter classFileWriter, ScriptNode scriptNode, int n, int n2) {
        int n3 = scriptNode.getRegexpCount();
        if (n3 == 0) {
            throw Codegen.badTree();
        }
        classFileWriter.addPush(n3);
        classFileWriter.add(189, "java/lang/Object");
        classFileWriter.addALoad(n);
        classFileWriter.addInvoke(184, "sun/org/mozilla/javascript/internal/ScriptRuntime", "checkRegExpProxy", "(Lsun/org/mozilla/javascript/internal/Context;)Lsun/org/mozilla/javascript/internal/RegExpProxy;");
        classFileWriter.add(89);
        classFileWriter.addALoad(n);
        classFileWriter.addInvoke(184, this.mainClassName, REGEXP_INIT_METHOD_NAME, REGEXP_INIT_METHOD_SIGNATURE);
        for (int i = 0; i != n3; ++i) {
            classFileWriter.add(92);
            classFileWriter.addALoad(n);
            classFileWriter.addALoad(n2);
            classFileWriter.add(178, this.mainClassName, this.getCompiledRegexpName(scriptNode, i), "Ljava/lang/Object;");
            classFileWriter.addInvoke(185, "sun/org/mozilla/javascript/internal/RegExpProxy", "wrapRegExp", "(Lsun/org/mozilla/javascript/internal/Context;Lsun/org/mozilla/javascript/internal/Scriptable;Ljava/lang/Object;)Lsun/org/mozilla/javascript/internal/Scriptable;");
            classFileWriter.addPush(i);
            classFileWriter.add(95);
            classFileWriter.add(83);
        }
        classFileWriter.add(87);
    }

    void pushNumberAsObject(ClassFileWriter classFileWriter, double d) {
        if (d == 0.0) {
            if (1.0 / d > 0.0) {
                classFileWriter.add(178, "sun/org/mozilla/javascript/internal/optimizer/OptRuntime", "zeroObj", "Ljava/lang/Double;");
            } else {
                classFileWriter.addPush(d);
                Codegen.addDoubleWrap(classFileWriter);
            }
        } else {
            if (d == 1.0) {
                classFileWriter.add(178, "sun/org/mozilla/javascript/internal/optimizer/OptRuntime", "oneObj", "Ljava/lang/Double;");
                return;
            }
            if (d == -1.0) {
                classFileWriter.add(178, "sun/org/mozilla/javascript/internal/optimizer/OptRuntime", "minusOneObj", "Ljava/lang/Double;");
            } else if (d != d) {
                classFileWriter.add(178, "sun/org/mozilla/javascript/internal/ScriptRuntime", "NaNobj", "Ljava/lang/Double;");
            } else if (this.itsConstantListSize >= 2000) {
                classFileWriter.addPush(d);
                Codegen.addDoubleWrap(classFileWriter);
            } else {
                int n;
                Object object;
                int n2 = this.itsConstantListSize;
                if (n2 == 0) {
                    this.itsConstantList = new double[64];
                } else {
                    object = this.itsConstantList;
                    for (n = 0; n != n2 && object[n] != d; ++n) {
                    }
                    if (n2 == ((double[])object).length) {
                        object = new double[n2 * 2];
                        System.arraycopy(this.itsConstantList, 0, object, 0, n2);
                        this.itsConstantList = object;
                    }
                }
                if (n == n2) {
                    this.itsConstantList[n2] = d;
                    this.itsConstantListSize = n2 + 1;
                }
                object = "_k" + n;
                String string = Codegen.getStaticConstantWrapperType(d);
                classFileWriter.add(178, this.mainClassName, (String)object, string);
            }
        }
    }

    private static void addDoubleWrap(ClassFileWriter classFileWriter) {
        classFileWriter.addInvoke(184, "sun/org/mozilla/javascript/internal/optimizer/OptRuntime", "wrapDouble", "(D)Ljava/lang/Double;");
    }

    private static String getStaticConstantWrapperType(double d) {
        int n = (int)d;
        if ((double)n == d) {
            return "Ljava/lang/Integer;";
        }
        return "Ljava/lang/Double;";
    }

    static void pushUndefined(ClassFileWriter classFileWriter) {
        classFileWriter.add(178, "sun/org/mozilla/javascript/internal/Undefined", "instance", "Ljava/lang/Object;");
    }

    int getIndex(ScriptNode scriptNode) {
        return this.scriptOrFnIndexes.getExisting(scriptNode);
    }

    static String getDirectTargetFieldName(int n) {
        return "_dt" + n;
    }

    String getDirectCtorName(ScriptNode scriptNode) {
        return "_n" + this.getIndex(scriptNode);
    }

    String getBodyMethodName(ScriptNode scriptNode) {
        return "_c_" + this.cleanName(scriptNode) + "_" + this.getIndex(scriptNode);
    }

    String cleanName(ScriptNode scriptNode) {
        Name name;
        String string = "";
        string = scriptNode instanceof FunctionNode ? ((name = ((FunctionNode)scriptNode).getFunctionName()) == null ? "anonymous" : name.getIdentifier()) : "script";
        return string;
    }

    String getBodyMethodSignature(ScriptNode scriptNode) {
        OptFunctionNode optFunctionNode;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('(');
        stringBuffer.append(this.mainClassSignature);
        stringBuffer.append("Lsun/org/mozilla/javascript/internal/Context;Lsun/org/mozilla/javascript/internal/Scriptable;Lsun/org/mozilla/javascript/internal/Scriptable;");
        if (scriptNode.getType() == 109 && (optFunctionNode = OptFunctionNode.get(scriptNode)).isTargetOfDirectCall()) {
            int n = optFunctionNode.fnode.getParamCount();
            for (int i = 0; i != n; ++i) {
                stringBuffer.append("Ljava/lang/Object;D");
            }
        }
        stringBuffer.append("[Ljava/lang/Object;)Ljava/lang/Object;");
        return stringBuffer.toString();
    }

    String getFunctionInitMethodName(OptFunctionNode optFunctionNode) {
        return "_i" + this.getIndex(optFunctionNode.fnode);
    }

    String getCompiledRegexpName(ScriptNode scriptNode, int n) {
        return REGEXP_ARRAY_FIELD_NAME + this.getIndex(scriptNode) + "_" + n;
    }

    static RuntimeException badTree() {
        throw new RuntimeException("Bad tree in codegen");
    }

    void setMainMethodClass(String string) {
        this.mainMethodClass = string;
    }
}

