/*
 * Decompiled with CFR 0.152.
 */
package com.sun.prism.es2;

import com.sun.prism.Texture;
import com.sun.prism.es2.BufferFactory;
import com.sun.prism.es2.ES2Pipeline;
import com.sun.prism.es2.GLDrawable;
import com.sun.prism.paint.Color;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;

abstract class GLContext {
    static final int GL_ZERO = 0;
    static final int GL_ONE = 1;
    static final int GL_SRC_COLOR = 2;
    static final int GL_ONE_MINUS_SRC_COLOR = 3;
    static final int GL_DST_COLOR = 4;
    static final int GL_ONE_MINUS_DST_COLOR = 5;
    static final int GL_SRC_ALPHA = 6;
    static final int GL_ONE_MINUS_SRC_ALPHA = 7;
    static final int GL_DST_ALPHA = 8;
    static final int GL_ONE_MINUS_DST_ALPHA = 9;
    static final int GL_CONSTANT_COLOR = 10;
    static final int GL_ONE_MINUS_CONSTANT_COLOR = 11;
    static final int GL_CONSTANT_ALPHA = 12;
    static final int GL_ONE_MINUS_CONSTANT_ALPHA = 13;
    static final int GL_SRC_ALPHA_SATURATE = 14;
    static final int GL_FLOAT = 20;
    static final int GL_UNSIGNED_BYTE = 21;
    static final int GL_UNSIGNED_INT_8_8_8_8_REV = 22;
    static final int GL_UNSIGNED_INT_8_8_8_8 = 23;
    static final int GL_UNSIGNED_SHORT_8_8_APPLE = 24;
    static final int GL_RGBA = 40;
    static final int GL_BGRA = 41;
    static final int GL_RGB = 42;
    static final int GL_LUMINANCE = 43;
    static final int GL_ALPHA = 44;
    static final int GL_RGBA32F = 45;
    static final int GL_YCBCR_422_APPLE = 46;
    static final int GL_TEXTURE_2D = 50;
    static final int GL_TEXTURE_BINDING_2D = 51;
    static final int GL_LINEAR = 52;
    static final int GL_UNPACK_ALIGNMENT = 60;
    static final int GL_UNPACK_ROW_LENGTH = 61;
    static final int GL_UNPACK_SKIP_PIXELS = 62;
    static final int GL_UNPACK_SKIP_ROWS = 63;
    static final int WRAPMODE_REPEAT = 100;
    static final int WRAPMODE_CLAMP_TO_EDGE = 101;
    static final int WRAPMODE_CLAMP_TO_BORDER = 102;
    long nativeCtxInfo;
    private int maxTextureSize = -1;
    private Boolean nonPowTwoExtAvailable;
    private int activeTexUnit;
    private int[] boundTextures = new int[4];
    private int shaderProgram;

    GLContext() {
    }

    private static native void nActiveTexture(long var0, int var2);

    private static native void nBindFBO(long var0, int var2);

    private static native void nBindTexture(long var0, int var2);

    private static native void nBlendFunc(int var0, int var1);

    private static native void nClearBuffers(long var0, float var2, float var3, float var4, float var5, boolean var6, boolean var7, boolean var8);

    private static native int nCompileShader(long var0, String var2, boolean var3);

    private static native int nCreateDepthBuffer(long var0, int var2, int var3);

    private static native int nCreateFBO(long var0, int var2);

    private static native int nCreateProgram(long var0, int var2, int var3, int var4, String[] var5, int[] var6);

    private static native int nCreateTexture(long var0, int var2, int var3);

    private static native void nDeleteRenderBuffer(long var0, int var2);

    private static native void nDeleteFBO(long var0, int var2);

    private static native void nDeleteShader(long var0, int var2);

    private static native void nDeleteTexture(long var0, int var2);

    private static native void nDisposeShaders(long var0, int var2, int var3, int var4);

    private static native void nDrawTriangleArrays(int var0, int var1);

    private static native void nFinish();

    private static native int nGenAndBindTexture();

    private static native int nGetFBO();

    private static native int nGetMaxTextureSize();

    private static native int nGetUniformLocation(long var0, int var2, String var3);

    private static native int nOneValueGetIntegerv(int var0);

    private static native void nPixelStorei(int var0, int var1);

    private static native boolean nReadPixelsByte(long var0, int var2, Buffer var3, byte[] var4, int var5, int var6, int var7, int var8);

    private static native boolean nReadPixelsInt(long var0, int var2, Buffer var3, int[] var4, int var5, int var6, int var7, int var8);

    private static native void nScissorTest(long var0, boolean var2, int var3, int var4, int var5, int var6);

    private static native void nTexParamsMinMax(int var0);

    private static native void nTexImage2D0(int var0, int var1, int var2, int var3, int var4, int var5, int var6, int var7, Object var8, int var9);

    private static native void nTexImage2D1(int var0, int var1, int var2, int var3, int var4, int var5, int var6, int var7, Object var8, int var9);

    private static native void nTexSubImage2D0(int var0, int var1, int var2, int var3, int var4, int var5, int var6, int var7, Object var8, int var9);

    private static native void nTexSubImage2D1(int var0, int var1, int var2, int var3, int var4, int var5, int var6, int var7, Object var8, int var9);

    private static native void nUpdateViewportAndDepthTest(long var0, int var2, int var3, int var4, int var5, boolean var6);

    private static native void nUniform1f(long var0, int var2, float var3);

    private static native void nUniform2f(long var0, int var2, float var3, float var4);

    private static native void nUniform3f(long var0, int var2, float var3, float var4, float var5);

    private static native void nUniform4f(long var0, int var2, float var3, float var4, float var5, float var6);

    private static native void nUniform4fv0(long var0, int var2, int var3, Object var4, int var5);

    private static native void nUniform4fv1(long var0, int var2, int var3, Object var4, int var5);

    private static native void nUniform1i(long var0, int var2, int var3);

    private static native void nUniform2i(long var0, int var2, int var3, int var4);

    private static native void nUniform3i(long var0, int var2, int var3, int var4, int var5);

    private static native void nUniform4i(long var0, int var2, int var3, int var4, int var5, int var6);

    private static native void nUniform4iv0(long var0, int var2, int var3, Object var4, int var5);

    private static native void nUniform4iv1(long var0, int var2, int var3, Object var4, int var5);

    private static native void nUniformMatrix4fv0(long var0, int var2, int var3, boolean var4, Object var5, int var6);

    private static native void nUniformMatrix4fv1(long var0, int var2, int var3, boolean var4, Object var5, int var6);

    private static native void nUpdateFilterState(long var0, int var2, boolean var3);

    private static native void nUpdateWrapState(long var0, int var2, int var3);

    private static native void nUseProgram(long var0, int var2);

    private static native void nEnableVertexAttributes(long var0);

    private static native void nDrawIndexedQuads(long var0, int var2, float[] var3, byte[] var4);

    private static native void nDrawTriangleList(long var0, int var2, float[] var3, byte[] var4);

    private static native int nCreateIndexBuffer16(long var0, short[] var2, int var3);

    private static native void nSetIndexBuffer(long var0, int var2);

    void activeTexture(int n) {
        GLContext.nActiveTexture(this.nativeCtxInfo, n);
    }

    void bindFBO(long l) {
        GLContext.nBindFBO(this.nativeCtxInfo, (int)l);
    }

    void bindTexture(int n) {
        GLContext.nBindTexture(this.nativeCtxInfo, n);
    }

    void blendFunc(int n, int n2) {
        GLContext.nBlendFunc(n, n2);
    }

    boolean canCreateNonPowTwoTextures() {
        if (this.nonPowTwoExtAvailable == null) {
            this.nonPowTwoExtAvailable = ES2Pipeline.glFactory.isGLExtensionSupported("GL_ARB_texture_non_power_of_two");
        }
        return this.nonPowTwoExtAvailable;
    }

    void clearBuffers(Color color, boolean bl, boolean bl2, boolean bl3) {
        float f = color.getRedPremult();
        float f2 = color.getGreenPremult();
        float f3 = color.getBluePremult();
        float f4 = color.getAlpha();
        GLContext.nClearBuffers(this.nativeCtxInfo, f, f2, f3, f4, bl, bl2, bl3);
    }

    int compileShader(String string, boolean bl) {
        return GLContext.nCompileShader(this.nativeCtxInfo, string, bl);
    }

    int createDepthBuffer(int n, int n2) {
        return GLContext.nCreateDepthBuffer(this.nativeCtxInfo, n, n2);
    }

    int createFBO(int n, int n2, int n3) {
        return GLContext.nCreateFBO(this.nativeCtxInfo, n);
    }

    int createProgram(int n, int n2, String[] stringArray, int[] nArray) {
        if (n == 0 || n2 == 0) {
            System.err.println("Both vertexShader and fragmentShader must be specified");
        }
        if (stringArray.length != nArray.length) {
            System.err.println("attrs.length must be equal to index.length");
        }
        return GLContext.nCreateProgram(this.nativeCtxInfo, n, n2, stringArray.length, stringArray, nArray);
    }

    int createTexture(int n, int n2) {
        return GLContext.nCreateTexture(this.nativeCtxInfo, n, n2);
    }

    void deleteRenderBuffer(int n) {
        GLContext.nDeleteRenderBuffer(this.nativeCtxInfo, n);
    }

    void deleteFBO(int n) {
        GLContext.nDeleteFBO(this.nativeCtxInfo, n);
    }

    void deleteShader(int n) {
        GLContext.nDeleteShader(this.nativeCtxInfo, n);
    }

    void deleteTexture(int n) {
        GLContext.nDeleteTexture(this.nativeCtxInfo, n);
    }

    void disposeShaders(int n, int n2, int n3) {
        GLContext.nDisposeShaders(this.nativeCtxInfo, n, n2, n3);
    }

    void drawTriangleArrays(int n, int n2) {
        GLContext.nDrawTriangleArrays(n, n2);
    }

    void finish() {
        GLContext.nFinish();
    }

    int genAndBindTexture() {
        int n;
        this.boundTextures[this.activeTexUnit] = n = GLContext.nGenAndBindTexture();
        return n;
    }

    int getBoundFBO() {
        return GLContext.nGetFBO();
    }

    int getBoundTextureID() {
        return GLContext.nOneValueGetIntegerv(51);
    }

    long getNativeCtxInfo() {
        return this.nativeCtxInfo;
    }

    abstract long getNativeHandle();

    int getActiveTextureUnit() {
        return this.activeTexUnit;
    }

    void setActiveTextureUnit(int n) {
        this.activeTexture(n);
        this.activeTexUnit = n;
    }

    void updateActiveTextureUnit(int n) {
        if (n != this.getActiveTextureUnit()) {
            this.setActiveTextureUnit(n);
        }
    }

    int getBoundTexture() {
        return this.boundTextures[this.activeTexUnit];
    }

    int getBoundTexture(int n) {
        return this.boundTextures[n];
    }

    int getNumBoundTexture() {
        return this.boundTextures.length;
    }

    void setBoundTexture(int n) {
        this.bindTexture(n);
        this.boundTextures[this.activeTexUnit] = n;
    }

    void updateBoundTexture(int n) {
        if (n != this.getBoundTexture()) {
            this.setBoundTexture(n);
        }
    }

    int getMaxTextureSize() {
        if (this.maxTextureSize > -1) {
            return this.maxTextureSize;
        }
        this.maxTextureSize = GLContext.nGetMaxTextureSize();
        return this.maxTextureSize;
    }

    int getShaderProgram() {
        return this.shaderProgram;
    }

    int getUniformLocation(int n, String string) {
        return GLContext.nGetUniformLocation(this.nativeCtxInfo, n, string);
    }

    boolean isShaderCompilerSupported() {
        return true;
    }

    abstract void makeCurrent(GLDrawable var1);

    void pixelStorei(int n, int n2) {
        GLContext.nPixelStorei(n, n2);
    }

    boolean readPixels(Buffer buffer, int n, int n2, int n3, int n4) {
        boolean bl = false;
        if (buffer instanceof ByteBuffer) {
            ByteBuffer byteBuffer = (ByteBuffer)buffer;
            byte[] byArray = byteBuffer.hasArray() ? byteBuffer.array() : null;
            int n5 = byteBuffer.capacity();
            bl = GLContext.nReadPixelsByte(this.nativeCtxInfo, n5, buffer, byArray, n, n2, n3, n4);
        } else if (buffer instanceof IntBuffer) {
            IntBuffer intBuffer = (IntBuffer)buffer;
            int[] nArray = intBuffer.hasArray() ? intBuffer.array() : null;
            int n6 = intBuffer.capacity() * 4;
            bl = GLContext.nReadPixelsInt(this.nativeCtxInfo, n6, buffer, nArray, n, n2, n3, n4);
        } else {
            throw new IllegalArgumentException("readPixel: pixel's buffer type is not supported: " + buffer);
        }
        return bl;
    }

    void scissorTest(boolean bl, int n, int n2, int n3, int n4) {
        GLContext.nScissorTest(this.nativeCtxInfo, bl, n, n2, n3, n4);
    }

    void setShaderProgram(int n) {
        this.shaderProgram = n;
        GLContext.nUseProgram(this.nativeCtxInfo, n);
    }

    void texParamsMinMax(int n) {
        GLContext.nTexParamsMinMax(n);
    }

    void texImage2D(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, Buffer buffer) {
        boolean bl = BufferFactory.isDirect(buffer);
        if (bl) {
            GLContext.nTexImage2D0(n, n2, n3, n4, n5, n6, n7, n8, buffer, BufferFactory.getDirectBufferByteOffset(buffer));
        } else {
            GLContext.nTexImage2D1(n, n2, n3, n4, n5, n6, n7, n8, BufferFactory.getArray(buffer), BufferFactory.getIndirectBufferByteOffset(buffer));
        }
    }

    void texSubImage2D(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, Buffer buffer) {
        boolean bl = BufferFactory.isDirect(buffer);
        if (bl) {
            GLContext.nTexSubImage2D0(n, n2, n3, n4, n5, n6, n7, n8, buffer, BufferFactory.getDirectBufferByteOffset(buffer));
        } else {
            GLContext.nTexSubImage2D1(n, n2, n3, n4, n5, n6, n7, n8, BufferFactory.getArray(buffer), BufferFactory.getIndirectBufferByteOffset(buffer));
        }
    }

    void updateViewportAndDepthTest(int n, int n2, int n3, int n4, boolean bl) {
        GLContext.nUpdateViewportAndDepthTest(this.nativeCtxInfo, n, n2, n3, n4, bl);
    }

    void updateFilterState(int n, boolean bl) {
        GLContext.nUpdateFilterState(this.nativeCtxInfo, n, bl);
    }

    void updateWrapState(int n, Texture.WrapMode wrapMode) {
        int n2;
        switch (wrapMode) {
            case REPEAT: {
                n2 = 100;
                break;
            }
            case CLAMP_TO_EDGE: {
                n2 = 101;
                break;
            }
            default: {
                n2 = !ES2Pipeline.glFactory.isGL2() ? 101 : 102;
            }
        }
        GLContext.nUpdateWrapState(this.nativeCtxInfo, n, n2);
    }

    void uniform1f(int n, float f) {
        GLContext.nUniform1f(this.nativeCtxInfo, n, f);
    }

    void uniform2f(int n, float f, float f2) {
        GLContext.nUniform2f(this.nativeCtxInfo, n, f, f2);
    }

    void uniform3f(int n, float f, float f2, float f3) {
        GLContext.nUniform3f(this.nativeCtxInfo, n, f, f2, f3);
    }

    void uniform4f(int n, float f, float f2, float f3, float f4) {
        GLContext.nUniform4f(this.nativeCtxInfo, n, f, f2, f3, f4);
    }

    void uniform4fv(int n, int n2, FloatBuffer floatBuffer) {
        boolean bl = BufferFactory.isDirect(floatBuffer);
        if (bl) {
            GLContext.nUniform4fv0(this.nativeCtxInfo, n, n2, floatBuffer, BufferFactory.getDirectBufferByteOffset(floatBuffer));
        } else {
            GLContext.nUniform4fv1(this.nativeCtxInfo, n, n2, BufferFactory.getArray(floatBuffer), BufferFactory.getIndirectBufferByteOffset(floatBuffer));
        }
    }

    void uniform1i(int n, int n2) {
        GLContext.nUniform1i(this.nativeCtxInfo, n, n2);
    }

    void uniform2i(int n, int n2, int n3) {
        GLContext.nUniform2i(this.nativeCtxInfo, n, n2, n3);
    }

    void uniform3i(int n, int n2, int n3, int n4) {
        GLContext.nUniform3i(this.nativeCtxInfo, n, n2, n3, n4);
    }

    void uniform4i(int n, int n2, int n3, int n4, int n5) {
        GLContext.nUniform4i(this.nativeCtxInfo, n, n2, n3, n4, n5);
    }

    void uniform4iv(int n, int n2, IntBuffer intBuffer) {
        boolean bl = BufferFactory.isDirect(intBuffer);
        if (bl) {
            GLContext.nUniform4iv0(this.nativeCtxInfo, n, n2, intBuffer, BufferFactory.getDirectBufferByteOffset(intBuffer));
        } else {
            GLContext.nUniform4iv1(this.nativeCtxInfo, n, n2, BufferFactory.getArray(intBuffer), BufferFactory.getIndirectBufferByteOffset(intBuffer));
        }
    }

    void uniformMatrix4fv(int n, int n2, boolean bl, FloatBuffer floatBuffer) {
        boolean bl2 = BufferFactory.isDirect(floatBuffer);
        if (bl2) {
            GLContext.nUniformMatrix4fv0(this.nativeCtxInfo, n, n2, bl, floatBuffer, BufferFactory.getDirectBufferByteOffset(floatBuffer));
        } else {
            GLContext.nUniformMatrix4fv1(this.nativeCtxInfo, n, n2, bl, BufferFactory.getArray(floatBuffer), BufferFactory.getIndirectBufferByteOffset(floatBuffer));
        }
    }

    void updateShaderProgram(int n) {
        if (n != this.shaderProgram) {
            this.setShaderProgram(n);
        }
    }

    void enableVertexAttributes() {
        GLContext.nEnableVertexAttributes(this.nativeCtxInfo);
    }

    void drawIndexedQuads(float[] fArray, byte[] byArray, int n) {
        GLContext.nDrawIndexedQuads(this.nativeCtxInfo, n, fArray, byArray);
    }

    void drawTriangleList(int n, float[] fArray, byte[] byArray) {
        GLContext.nDrawTriangleList(this.nativeCtxInfo, n, fArray, byArray);
    }

    int createIndexBuffer16(short[] sArray) {
        return GLContext.nCreateIndexBuffer16(this.nativeCtxInfo, sArray, sArray.length);
    }

    void setIndexBuffer(int n) {
        GLContext.nSetIndexBuffer(this.nativeCtxInfo, n);
    }
}

