/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.tk.quantum;

import com.sun.glass.ui.Application;
import com.sun.glass.ui.Cursor;
import com.sun.glass.ui.Pixels;
import com.sun.glass.ui.View;
import com.sun.glass.ui.Window;
import com.sun.javafx.cursor.CursorFrame;
import com.sun.javafx.geom.CameraImpl;
import com.sun.javafx.sg.PGNode;
import com.sun.javafx.sg.prism.NGNode;
import com.sun.javafx.tk.quantum.CursorUtils;
import com.sun.javafx.tk.quantum.GlassScene;
import com.sun.javafx.tk.quantum.GlassStage;
import com.sun.javafx.tk.quantum.GlassViewEventHandler;
import com.sun.javafx.tk.quantum.PresentingPainter;
import com.sun.javafx.tk.quantum.PrismPen;
import com.sun.javafx.tk.quantum.UploadingPainter;
import com.sun.javafx.tk.quantum.ViewPainter;
import com.sun.javafx.tk.quantum.WindowStage;
import java.nio.ByteOrder;
import java.util.concurrent.Future;

public class ViewScene
extends GlassScene {
    private static final String UNSUPPORTED_FORMAT = "Transparent windows only supported for BYTE_BGRA_PRE format on LITTLE_ENDIAN machines";
    private View platformView;
    private PrismPen pen;

    public ViewScene(boolean bl, boolean bl2) {
        super(bl, bl2);
        this.pen = new PrismPen(this, bl2);
        this.platformView = Application.GetApplication().createView(this.pen);
        this.platformView.setEventHandler(new GlassViewEventHandler(this));
    }

    @Override
    protected boolean isSynchronous() {
        ViewPainter viewPainter;
        return this.pen != null && (viewPainter = this.pen.getPainter()) != null && viewPainter instanceof PresentingPainter;
    }

    protected View getPlatformView() {
        return this.platformView;
    }

    protected Future getPenFuture() {
        return this.pen.getFuture();
    }

    public void uploadPixels(Pixels pixels) {
        if (this.platformView != null) {
            this.platformView.uploadPixels(pixels);
        }
    }

    protected PrismPen getPen() {
        return this.pen;
    }

    @Override
    public void setGlassStage(GlassStage glassStage) {
        super.setGlassStage(glassStage);
        if (glassStage != null) {
            WindowStage windowStage = (WindowStage)glassStage;
            ViewPainter viewPainter = null;
            if (windowStage.needsUpdateWindow()) {
                if (Pixels.getNativeFormat() != 1 || ByteOrder.nativeOrder() != ByteOrder.LITTLE_ENDIAN) {
                    throw new UnsupportedOperationException(UNSUPPORTED_FORMAT);
                }
                viewPainter = new UploadingPainter(this, this.pen);
            } else {
                viewPainter = new PresentingPainter(this, this.pen);
            }
            this.pen.setPainter(viewPainter);
            viewPainter.setRoot((NGNode)this.getRoot());
        }
    }

    WindowStage getWindowStage() {
        return (WindowStage)this.glassStage;
    }

    @Override
    public void setScene(Object object) {
        if (object == null && this.platformView != null) {
            this.platformView.close();
            this.platformView = null;
        }
    }

    @Override
    public void setRoot(PGNode pGNode) {
        super.setRoot(pGNode);
        ViewPainter viewPainter = this.pen.getPainter();
        if (viewPainter != null) {
            viewPainter.setRoot((NGNode)pGNode);
        }
    }

    @Override
    public void setCamera(CameraImpl cameraImpl) {
        super.setCamera(cameraImpl);
        this.pen.setCamera(cameraImpl);
    }

    @Override
    public void setFillPaint(Object object) {
        super.setFillPaint(object);
    }

    @Override
    public void setCursor(final Object object) {
        super.setCursor(object);
        Application.postOnEventQueue(new Runnable(){

            @Override
            public void run() {
                Window window;
                CursorFrame cursorFrame = (CursorFrame)object;
                Cursor cursor = CursorUtils.getPlatformCursor(cursorFrame);
                if (ViewScene.this.platformView != null && (window = ViewScene.this.platformView.getWindow()) != null) {
                    window.setCursor(cursor);
                }
            }
        });
    }

    @Override
    void repaint() {
        this.pen.repaint();
    }

    @Override
    public void enableInputMethodEvents(boolean bl) {
        this.platformView.enableInputMethodEvents(bl);
    }

    @Override
    public void sceneChanged() {
        super.sceneChanged();
    }
}

