/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.web.behavior;

import com.sun.javafx.PlatformUtil;
import com.sun.javafx.scene.control.behavior.BehaviorBase;
import com.sun.javafx.scene.control.behavior.KeyBinding;
import com.sun.javafx.scene.web.skin.HTMLEditorSkin;
import java.util.ArrayList;
import java.util.List;
import javafx.scene.input.KeyCode;
import javafx.scene.web.HTMLEditor;

public class HTMLEditorBehavior
extends BehaviorBase<HTMLEditor> {
    protected static final List<KeyBinding> HTMLEDITOR_BINDINGS = new ArrayList<KeyBinding>();

    public HTMLEditorBehavior(HTMLEditor hTMLEditor) {
        super(hTMLEditor);
    }

    @Override
    protected List<KeyBinding> createKeyBindings() {
        return HTMLEDITOR_BINDINGS;
    }

    @Override
    protected void callAction(String string) {
        if ("bold".equals(string) || "italic".equals(string) || "underline".equals(string)) {
            HTMLEditor hTMLEditor = (HTMLEditor)this.getControl();
            HTMLEditorSkin hTMLEditorSkin = (HTMLEditorSkin)hTMLEditor.getSkin();
            hTMLEditorSkin.keyboardShortcuts(string);
        } else if ("F12".equals(string)) {
            HTMLEditor hTMLEditor = (HTMLEditor)this.getControl();
            HTMLEditorSkin hTMLEditorSkin = (HTMLEditorSkin)hTMLEditor.getSkin();
            hTMLEditorSkin.getImpl_traversalEngine().getTopLeftFocusableNode();
        } else {
            super.callAction(string);
        }
    }

    static {
        if (PlatformUtil.isMac()) {
            HTMLEDITOR_BINDINGS.add(new KeyBinding(KeyCode.B, "bold").meta());
            HTMLEDITOR_BINDINGS.add(new KeyBinding(KeyCode.I, "italic").meta());
            HTMLEDITOR_BINDINGS.add(new KeyBinding(KeyCode.U, "underline").meta());
        } else {
            HTMLEDITOR_BINDINGS.add(new KeyBinding(KeyCode.B, "bold").ctrl());
            HTMLEDITOR_BINDINGS.add(new KeyBinding(KeyCode.I, "italic").ctrl());
            HTMLEDITOR_BINDINGS.add(new KeyBinding(KeyCode.U, "underline").ctrl());
        }
        HTMLEDITOR_BINDINGS.add(new KeyBinding(KeyCode.F12, "F12"));
        HTMLEDITOR_BINDINGS.add(new KeyBinding(KeyCode.TAB, "TraverseNext").ctrl());
        HTMLEDITOR_BINDINGS.add(new KeyBinding(KeyCode.TAB, "TraversePrevious").ctrl().shift());
    }
}

